      subroutine kuma(xlogl,xlteff,stmass,xsurf,xmdfic,vinfkm,zstar)   
      implicit double precision (a-h,o-z)                             
!      common/prout/modep,mode, iagnos                                
!      COMMON/etacar/gamma2,captau2,ntau2                             
C **                                                                                              
C *** input: xlogl= log L/Lsun; xlteff= log Teff, stmass=M/Msun, *******                          
C ***        xsurf=surface hydrogen mass fraction                *******                          
C *** output: xmdfic=mass loss rate [Msun/yr], vinfkm=v_infinity *******                          
C +++++ ANALYTICAL APPROXIMATION FOR RADIATION DRIVEN WINDS      +++++++                          
C +++++ PROGRAM WRITTEN BY R.P. KUDRITZKI                        +++++++                          
C +++++ ABBREVIATED VERSION FOR ASTROPHYSICAL USERS              +++++++                          
C +++++ FULL VERSION CONTAINS TEST ROUTINES AND EXACT SOLUTIONS  +++++++                          
C +++++ OF INTEGRALS DISCUSSED IN PAPER VI                       +++++++                          
C                

      modep = 1 ! no printing                                                                        
      teff=10.**xlteff                                              
      stlum=10.**xlogl                                             
      ttt=teff/5780.                                              
      ttt=ttt*ttt*ttt*ttt                                        
      rst=sqrt(stlum/ttt)                                       
C     if (modep.eq.0) write(*,124)stmass,xlogl,stlum,rst,teff                                     
  124 format(1x,'M=',f7.2,' Msun,   log L/Lsun=',f7.3,',   L/Lsun=',    
     &1PD12.3,/,'   R=',0pf6.1,' Rsun,   Teff=',f7.0,' K')              
C                                                                                                 
      call mdote(xlogl,rst,stmass,teff,xdjage,xdlame,xdbaco)            
      yps=(0.98 - xsurf)/(4.*xsurf)                                    
cc    yps=0.1                                                                                     
c     write(*,125)xsurf,yps                                                                       
  125 format(1x,'Xsurface=',f5.3,5x,'N(He)/N(H)=',f5.3)                
c     write(*,*)' +++ Specify No. of e- provided by helium nucleus +++'                           
c     write(*,*)' +++ Type real number between 2.0 (hot gas) '                                    
c     write(*,*)' +++ or 1.0 (intermediate gas) or 0.0 (cool gas)  +++'                           
c     read(*,*)xihe                                                                               
      xihe=2.                                                         
                                                                     
      sig=sigmae(yps,xihe)                                          
      ga=gammma(stlum,stmass,sig)                                  
        ganeu=gamma2                                              
c       print*,'gamma_alt=',ga,'  gamma_neu=',ganeu                                               
        ga=dmax1(ga,ganeu)                                       
      vesckm=stmass*(1.-ga)/rst                                 
      vesckm=617.*sqrt(vesckm)                                 
      vesc=vesckm*1.d05                                       
      vsound=(2.+(1.+xihe)*yps)/(1.+4.*yps)                  
      vsound=vsound*teff                                    
      vsound=9.085d3*sqrt(vsound)                          
      vsquar=vsound/vesc                                             
      vsquar=vsquar*vsquar                                          
      vsoukm=vsound*1.d-5                                          
c     write(*,141)ga,vesckm,vsoukm,vsquar                                                         
  141 format(1x,'Gamma=',f5.3,',   vesc=',f7.0,' km/s,   vsound=',    
     &f7.0,' km/s,   (vsound/vesc)**2=',f9.6)                         
                                                                     
C +++ Now Force Multiplier Parameters +++++++++++++++++++++++++++++++++                           
                                                                    
      beta=1.                                                      
                                                                  
c     xk=0.052                                                                                    
c     alpha=0.695                                                                                 
c     if (teff.gt.35500.) delta=0.070                                                             
c     if (teff.le.35500.) delta=0.030                                                             
C-------------------------------------------------------------                                    
C--Pauldrach et al. 1993 (MPA 740) for Zeta Pup --------------                                    
      xk=0.085                                                                                    
      alpha=0.657                                                                                 
      delta=0.095                                                                                 
C--------   k  alpha   delta  werte  fuer  SMC  -----                                             
cc      if (zstar.lt.0.003d0) then                                                                
C --------- old  values ---------------                                                           
C       xk=0.097                                                                                  
C       alpha=0.580                                                                               
C       delta=0.104                                                                               
C       if (teff.lt.40000.) xk=0.128                                                              
C       if (teff.lt.40000.) alpha=0.552                                                           
C       if (teff.lt.40000.) delta=0.138                                                           
C-------- neue werte: Pauldrach   vom  3.11.89 ---------------                                    
cc      xk=0.075                                                                                  
cc      alpha=0.50                                                                                
cc      delta=0.115                                                                               
cc      if (teff.lt.44000.) xk=0.03                                                               
cc      if (teff.lt.44000.) alpha=0.66                                                            
cc      if (teff.lt.44000.) delta=0.09                                                            
cc      end if                                                                                    
C-------------------------------------------------------------                                    
C-------- Werte fuer Z=0.005, VMS (Kudritzki, 8.8.93) --------                                    
c       xk=0.046                                                                                  
c       alpha=0.66                                                                                
c       delta=0.13                                                                                
C-------------------------------------------------------------                                    
  111 continue                                                                                    
      ucrit=uc(alpha,beta,delta,vsquar)                                                           
                                                                                                  
C +++ Approx. wind integral ++++++++++++++++++++++++++++++++++++++++++++                          
                                                                                                  
      xx=xintap(alpha,beta,delta,ucrit)                                                           
      vc=vaucr(vsound,vesc,alpha)                                                                 
      xx=xx+(1.-alpha)*vc*vc/(alpha*vesc*vesc)                                                    
      vckms=vc*1.d-5                                                                              
c     write(*,143)vckms                                                                           
  143 format(1x,'vcrit acc. to Pauldrach: ',f7.0,' km/s')                                         
 7656 vinfkm=vesckm*sqrt(xx)                                                                      
      vinfkm=vinfkm*sqrt(alpha/(1.-alpha))                                                        
      if (modep.eq.0) write(*,144)vinfkm                                                          
  144 format(/,10x,'V_INFINITY=',f7.0,' KM/S')                                                    
                                                                                                  
C === Approx. Mdot formulae ====                                                                  
      xmdca=xmdcak(xk,alpha,stlum,stmass,yps,teff)                                                
      xmdfic=xmdfc(xk,alpha,beta,delta,xx,ucrit,rst,vesc,yps,xmdca)                               
      if (modep.ne.0) return                                                                      
                                                                                                  
C --- OUTPUT ----------                                                                           
      WRITE(*,121)ucrit,ga                                                                        
  121 FORMAT(10x,'ucrit=',f8.1,'  GAMMA=',f5.3)                                                   
      WRITE(*,122)xk,alpha,delta,beta                                                             
  122 FORMAT(10x,'  k=',f5.3,' alpha=',f5.3,'  delta=',f5.3,'  beta=',                            
     &  f5.3)                                                                                     
      write(*,123)xmdfic,dlog10(xmdfic)                                                           
  123 format(10x,' MDOT FINITE CONE = ',1pd10.2,'   LOG MDOT=',0pf6.2)                            
      write(*,224)xdjage,xdlame,xdbaco,10**xdjage/xmdfic,                                         
     &10**xdlame/xmdfic,10**xdbaco/xmdfic                                                         
  224 format(10x,' DE JAGER: ',f6.2,'  LAMERS: ',f6.2,'  BA&CO: ',f6.2,                           
     &      /,10x,' RATIOS  : ',f6.2,'       ',f6.2,'       ',f6.2,/)                             
 1056 continue                                                                                    
C***********************************************************************                          
C *** PROGRAM FOR MDOT AND VINF AS FUNCTION OF STELLAR PARAMETERS      *                          
C *** STOPS HERE. SUBROUTINES AND FUNCTIONS FOLLOW                     *                          
C***********************************************************************                          
      return                                                                                      
      end                                                                                         
C=======================================================================                          
C=======================================================================                          
      function cf(u,alpha,beta)                                                                   
      implicit double precision (a-h,o-z)                                                         
C +++ cf IS THE FINITE CONE ANGLE CORRECTION FACTOR ++++++++++++++++++                            
                                                                                                  
      xl=(beta+1.)*u-1.                                                                           
      xl=xl*u/beta                                                                                
      absxl=abs(xl)                                                                               
      eps=1.d-3                                                                                   
      if (absxl.gt.eps) goto 1                                                                    
      cf=1.                                                                                       
      goto 2                                                                                      
    1 cf=1.-(1.-xl)**(1.+alpha)                                                                   
      cf=cf/xl                                                                                    
      cf=cf/(1.+alpha)                                                                            
    2 continue                                                                                    
      return                                                                                      
      end                                                                                         
C=======================================================================                          
      function gdel(u,beta,delta)                                                                 
      implicit double precision (a-h,o-z)                                                         
C +++ COMPUTES FUNCTION G(DELTA) ++++++++++++++++++++++++++++++++++++++                           
                                                                                                  
      q=qq(beta,delta)                                                                            
    4 continue                                                                                    
      gdel=q*u*u+1.                                                                               
      return                                                                                      
      end                                                                                         
C=======================================================================                          
      function uc(alpha,beta,delta,vsquar)                                                        
      implicit double precision (a-h,o-z)                                                         
C +++ ESTIMATE OF RECIPROCAL CRITICAL POINT +++++++++++++++++++++++++++                           
                                                                                                  
      sigma=alpha*alpha*(1.-alpha)/vsquar                                                         
      xphi=phicr(vsquar)                                                                          
c     write(*,145)vsquar,xphi                                                                     
  145 format(1x,'vsquar=',1pd10.2,'   phicr=',1pd10.2)                                            
                                                                                                  
      xphi=xphi*xphi                                                                              
      sigma=sigma/xphi                                                                            
      bbb=betcr(alpha,delta)                                                                      
      q=qq(bbb,delta)                                                                             
      xc=-2.*q/(sigma*3.)                                                                         
      hilf=1.46/sigma                                                                             
      hilf=hilf*(alpha+1.)*(alpha**0.6)                                                           
      hilf=hilf**(1./3.)                                                                          
      xc=hilf+xc                                                                                  
      if (xc.ge.1.03) goto 1492                                                                   
      xc=1.03                                                                                     
 1492 continue                                                                                    
      uc=1./xc                                                                                    
      return                                                                                      
      end                                                                                         
C=======================================================================                          
      function phicr(vsquar)                                                                      
      implicit double precision (a-h,o-z)                                                         
C +++ CALCULATES PAULDRACH PHI FUNCTION AT UCRIT ++++++++++++++++++++++                           
                                                                                                  
      vsq=sqrt(vsquar)                                                                            
      xl=dlog10(vsq)                                                                              
      xl=0.36+xl                                                                                  
      xl=0.3*xl                                                                                   
      xl=vsq**xl                                                                                  
      phicr=3.0*xl                                                                                
      return                                                                                      
      end                                                                                         
C=======================================================================                          
      function vaucr(vsound,vesc,alpha)                                                           
      implicit double precision (a-h,o-z)                                                         
C +++ COMPUTES VELOCITY AT CRITICAL POINT ACC. TO PAULDRACH ++++++++++++                          
                                                                                                  
      vsq=vsound*vsound/(vesc*vesc)                                                               
      phi=phicr(vsq)                                                                              
      hilf=sqrt(phi/(1.-alpha))                                                                   
      h=1.-(1.-alpha)**(2./alpha)                                                                 
      hilf=hilf/h                                                                                 
      vaucr=vsound*hilf                                                                           
      return                                                                                      
      end                                                                                         
C======================================================================                           
      function betcr(alpha,delta)                                                                 
      implicit double precision (a-h,o-z)                                                         
C +++ CALCULATES BETA VALUE FOR UCRIT ACC. TO PAULDRACH +++++++++++++++                           
C +++ LVERS=2 MODIFIED BETACRIT ACC. TO SECOND VERSION ++++++++++++++++                           
                                                                                                  
      if (alpha.le.0.7) goto 2                                                                    
      if (delta.ge.0.03) goto 1                                                                   
      betcr=2.                                                                                    
      return                                                                                      
                                                                                                  
    1 if (delta.ge.0.095) goto 20                                                                 
 1871 if (delta.lt.0.055) goto 1872                                                               
      betcr=1.                                                                                    
      return                                                                                      
 1872 betcr=2.                                                                                    
      return                                                                                      
   20 betcr=0.7                                                                                   
      return                                                                                      
    2 if (delta.ge.0.03) goto 3                                                                   
      betcr=2.                                                                                    
      return                                                                                      
    3 if (delta.ge.0.055) goto 4                                                                  
      betcr=1.                                                                                    
      return                                                                                      
    4 if (delta.ge.0.085) goto 5                                                                  
      betcr=0.7                                                                                   
      return                                                                                      
    5 if (delta.ge.0.095) goto 6                                                                  
      betcr=0.5                                                                                   
      return                                                                                      
    6 betcr=0.25                                                                                  
      return                                                                                      
      end                                                                                         
C======================================================================                           
      function qq(beta,delta)                                                                     
      implicit double precision (a-h,o-z)                                                         
C +++ CALCULATES Q AS FUNCTION OF BETA AND DELTA ++++++++++++++++++++++                           
C +++ Q=A(BETA)**DELTA-1.                        ++++++++++++++++++++++                           
C +++ A(BETA) LINEAR BETWEEN A(2)=22.1, A(1)=7.5 ++++++++++++++++++++++                           
C +++   A(0.7)=4.0, A(0.5)=2.5, A(0.25)=1.18     ++++++++++++++++++++++                           
                                                                                                  
      if (beta.lt.0.2) goto 2                                                                     
      if (beta.lt.2.5) goto 1                                                                     
      stop 'beta too large'                                                                       
                                                                                                  
    1 if (beta.lt.1.) goto 11                                                                     
      a=15.*(beta-1.)+7.5                                                                         
      goto 4                                                                                      
   11 if (beta.lt.0.7) goto 12                                                                    
      a=11.66667*(beta-0.7)+4.0                                                                   
      goto 4                                                                                      
    2 stop 'beta too small'                                                                       
                                                                                                  
   12 if (beta.lt.0.5) goto 13                                                                    
      a=7.5*(beta-0.5)+2.5                                                                        
      goto 4                                                                                      
   13 if (beta.lt.0.2) goto 2                                                                     
      a=5.28*(beta-0.25)+1.18                                                                     
                                                                                                  
    4 continue                                                                                    
      qq=a**delta-1.                                                                              
      return                                                                                      
      end                                                                                         
C=======================================================================                          
      function xintap(alpha,beta,delta,ucrit)                                                     
      implicit double precision (a-h,o-z)                                                         
C +++ APPROX> WIND INTEGRAL = EQ. (60) +++++++++++++++++++++++++++++++++                          
                                                                                                  
      q=qq(beta,delta)                                                                            
      call coeff(alpha,beta,a0,a1,b1,b2)                                                          
      bet1=1./(1.+beta)                                                                           
      bet2=bet1*bet1                                                                              
      bet3=bet2*bet1                                                                              
      bet4=bet3*bet1                                                                              
      bet5=bet4*bet1                                                                              
      uc1=ucrit                                                                                   
      uc2=uc1*uc1                                                                                 
      uc3=uc2*uc1                                                                                 
      uc4=uc3*uc1                                                                                 
      hilf=1./(1.-alpha)                                                                          
      x=a0*(uc1-bet1+hilf*q*(uc3-bet3)/3.)                                                        
      x=x-a1*((uc2-bet2)/2.+hilf*q*(uc4-bet4)/4.)                                                 
      x=x+bet1                                                                                    
      x=x+b1*(bet2/2.+hilf*q*bet4/4.)                                                             
      x=x-b2*(bet3/3.+hilf*q*bet5/5.)                                                             
      x=x+hilf*q*bet3/3.                                                                          
      g=1./(a0-a1*uc1)                                                                            
      g=g*((1./(q*uc2+1.))**hilf)                                                                 
      z=1./g                                                                                      
      z=2./alpha*(1.-z)                                                                           
      z=g*(1.+sqrt(z))                                                                            
      xintap=z*x                                                                                  
      return                                                                                      
      end                                                                                         
C=======================================================================                          
      subroutine coeff(alpha,beta,a0,a1,b1,b2)                                                    
      implicit double precision (a-h,o-z)                                                         
C +++ COEFFICIENTS A0 A1 B0 B1 FOR APPROX. TERMINAL VELOCITY +++++++++++                          
                                                                                                  
      hilfex=1.-alpha                                                                             
      hilfex=1./hilfex                                                                            
      alaaf=(1./(1.+alpha))**hilfex                                                               
      a0=(1.+beta-alaaf)/beta                                                                     
      a1=a0-alaaf                                                                                 
      b1=alpha*hilfex/(2.*beta)                                                                   
      b2=b1*(beta+1.)                                                                             
      return                                                                                      
      end                                                                                         
C=======================================================================                          
      function xmdcak(xk,alpha,stlum,stmass,yps,teff)                                             
      implicit double precision (a-h,o-z)                                                         
C +++ MDOT AFTER CAK +++++++++++++++++++++++++++++++++++++++++++++++++++                          
                                                                                                  
      hilfex=1./alpha                                                                             
      hilf=1.2762d23*xk*stlum                                                                     
      hilf=hilf*1.d-10                                                                            
      hilf=hilf**hilfex                                                                           
      hiover=1.d10**hilfex                                                                        
      xmue=1.                                                                                     
      hilf=hilf*alpha/vtherm(teff,xmue)                                                           
      xihe=2.                                                                                     
      sig=sigmae(yps,xihe)                                                                        
      ga=gammma(stlum,stmass,sig)                                                                 
      hilfex=hilfex*(1.-alpha)                                                                    
      hi=sig*(1.-alpha)/(1.6671d27*stmass*(1.-ga))                                                
      hi=hi**hilfex                                                                               
      xmdcak=hilf*hi*hiover                                                                       
      return                                                                                      
      end                                                                                         
C=======================================================================                          
      function sigmae(yps,xihe)                                                                   
      implicit double precision (a-h,o-z)                                                         
C +++ SIGMA = THOMSON ABS. COEFF. DIVIDED BY DENSITY  ++++++++++++++++++                          
C +++ XIHE  = NUMBER OF e- PROVIDIED BY He NUCLEUS    ++++++++++++++++++                          
C +++ YPS   = N(He)/N(H)                              ++++++++++++++++++                          
                                                                                                  
      sigmae=(1.+xihe*yps)/(1.+4.*yps)                                                            
      sigmae=sigmae*0.3978                                                                        
      return                                                                                      
      end                                                                                         
C=======================================================================                          
      function gammma(stlum,stmass,sig)                                                           
      implicit double precision (a-h,o-z)                                                         
C +++ EDDINGTON LIMIT GAMMA, SIG COMPUTED BY SIGMAE ++++++++++++++++++++                          
                                                                                                  
      gammma=7.655d-5*sig*stlum/stmass                                                            
      return                                                                                      
      end                                                                                         
C=======================================================================                          
      function vtherm(t,xmue)                                                                     
      implicit double precision (a-h,o-z)                                                         
C +++ THERMAL VELOCITY OF ATOM WITH ATOMIC WHEIGHT XMUE ++++++++++++++++                          
                                                                                                  
      vtherm=1.2848d4*sqrt(t/xmue)                                                                
      return                                                                                      
      end                                                                                         
C=======================================================================                          
      function xmdfc(xk,alpha,beta,delta,xint,ucrit,rst,vesc,yps,xmdcak)                          
      implicit double precision (a-h,o-z)                                                         
C +++ MDOT FOR FINITE CONE ANGLE [Msun/yr],  EQ. (61) ++++++++++++++++++                          
C +++ XMDCAK = CAK MDOT                               ++++++++++++++++++                          
C +++ XINT   = F.C. VELOCITY INTEGRAL                 ++++++++++++++++++                          
                                                                                                  
      xihe=2.                                                                                     
      d=3.92859d1*(1.+xihe*yps)/(1.+4.*yps)                                                       
      d=d/(rst*rst)                                                                               
      d=d/vesc                                                                                    
      alaaf=(1.-alpha)/alpha                                                                      
      d=d*1.d-11*sqrt(alaaf)                                                                      
      hiexa=1./(alpha-delta)                                                                      
      hiexb=hiexa*delta                                                                           
      hiexc=hiexa*alpha                                                                           
      a=d/sqrt(xint)                                                                              
      a=a**hiexb                                                                                  
      b=cf(ucrit,alpha,beta)                                                                      
      b=b*(1.+qq(beta,delta)*ucrit*ucrit)                                                         
      b=b**hiexa                                                                                  
      c=xmdcak**hiexc                                                                             
                                                                                                  
C +++ NORMALISATION TO [Msun/yr] +++++++++++++++++++++++++++++++++++++++                          
                                                                                                  
      c=c*1.58661d-26                                                                             
      xmdfc=a*b*c                                                                                 
      return                                                                                      
      end                                                                                         
C=======================================================================                          
      subroutine mdote(xlogl,rst,stmass,teff,xdjage,xdlame,xdbaco)                                
      implicit double precision (a-h,o-z)                                                         
C +++ COMPUTE EMPIRICAL MASS LOSS RATES ACCORDING TO:              +++++                          
C +++ 1) DE JAGER ET AL.,                          ---> xdjage     +++++                          
C +++ 2) Lamers, 1981, Ap.J. 245, 593              ---> xdlame     +++++                          
C +++ 3) Barlow & Cohen, 1977, Ap.J. 213, 737      ---> xdbaco     +++++                          
      dimension a(10)                                                                             
      data (a(i),i=1,10)/6.3168,0.1104,-0.4311,3.579,-1.571,-0.0109,                              
     &     -0.2175,-0.8381,-1.2487,1.5822/                                                        
                                                                                                  
       x=dlog10(teff)-4.                                                                          
       y=xlogl-5.                                                                                 
       xdjage=a(1)+a(2)*x+a(3)*x*x+a(4)*x*x*x                                                     
     &      +     a(5)*y+a(6)*y*y+a(7)*y*y*y                                                      
     &      +a(8)*x*y+a(9)*x*x*y+a(10)*x*y*y                                                      
       xdjage=-xdjage                                                                             
                                                                                                  
       xdlame=1.42*xlogl+0.61*dlog10(rst)-0.99*dlog10(stmass)-12.71                               
                                                                                                  
       xdbaco=1.10*xlogl+dlog10(1.35d-12)                                                         
                                                                                                  
       return                                                                                     
       end                                                                                        
