! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module ctrls_io
      
      use const_def
      use star_private_def

      implicit none
      
      include "star_controls.dek"      
      
      logical :: read_extra_controls_inlist1
      character (len=256) :: extra_controls_inlist1_name 
   
      logical :: read_extra_controls_inlist2
      character (len=256) :: extra_controls_inlist2_name 
   
      logical :: read_extra_controls_inlist3
      character (len=256) :: extra_controls_inlist3_name 
   
      logical :: read_extra_controls_inlist4
      character (len=256) :: extra_controls_inlist4_name 
   
      logical :: read_extra_controls_inlist5
      character (len=256) :: extra_controls_inlist5_name 
      

      namelist /controls/ &
         
      ! where to start
         initial_mass, &
         initial_z, &
         initial_y, &
         
      ! when to stop
         max_model_number, &
         max_number_backups, &
         max_backups_in_a_row, &
         relax_max_number_backups, &
         relax_max_number_retries, &
         max_number_retries, &
         max_age, &
         when_to_stop_rtol, &
         when_to_stop_atol, & 
         gamma_center_limit, &
         eta_center_limit, &
         log_center_temp_limit, &
         log_center_temp_lower_limit, &
         log_center_density_limit, &
         min_timestep_limit, &
         logQ_limit, &
         iron_core_infall_limit, &
         v_div_csound_surf_limit, &
         Pgas_div_P_limit, &
         Pgas_div_P_limit_max_q, &
         peak_burn_vconv_div_cs_limit, &
         omega_div_omega_crit_limit, &
         delta_nu_lower_limit, &
         delta_nu_upper_limit, &
         delta_Pg_lower_limit, &
         delta_Pg_upper_limit, &

         surface_accel_div_grav_limit, &
         
         xa_central_lower_limit_species, &
         xa_central_lower_limit, &
         
         xa_central_upper_limit_species, &
         xa_central_upper_limit, &
         
         xa_surface_lower_limit_species, &
         xa_surface_lower_limit, &
         
         xa_surface_upper_limit_species, &
         xa_surface_upper_limit, &
         
         HB_limit, &
         stop_at_TP, &
         TP_he_shell_max, &
         
         star_mass_min_limit, &
         star_mass_max_limit, &
         star_H_mass_min_limit, &
         star_H_mass_max_limit, &
         xmstar_min_limit, &
         xmstar_max_limit, &
         envelope_mass_limit, &
         envelope_fraction_left_limit, &
         h1_boundary_mass_limit, &
         he4_boundary_mass_limit, &
         c12_boundary_mass_limit, &
         he_layer_mass_lower_limit, &
         abs_diff_lg_LH_lg_Ls_limit, &
         Teff_upper_limit, &
         Teff_lower_limit, &
         photosphere_r_upper_limit, &
         photosphere_r_lower_limit, &
         log_Teff_upper_limit, &
         log_Teff_lower_limit, &
         log_Tsurf_upper_limit, &
         log_Tsurf_lower_limit, &
         log_Psurf_upper_limit, &
         log_Psurf_lower_limit, &
         log_L_upper_limit, &
         log_L_lower_limit, &
         log_g_upper_limit, &
         log_g_lower_limit, &
         power_nuc_burn_upper_limit, &
         power_h_burn_upper_limit, &
         power_he_burn_upper_limit, &
         power_c_burn_upper_limit, &
         power_nuc_burn_lower_limit, &
         power_h_burn_lower_limit, &
         power_he_burn_lower_limit, &
         power_c_burn_lower_limit, &
         phase_of_evolution_stop, &
         
      ! timesteps
         max_timestep, &
         max_years_for_timestep, &
         
      ! output of "snapshots" for restarts
         photostep, &
         photo_digits, &
         photo_directory, &
         
      ! output of logs and profiles
         do_log_files, &
         log_cnt, &
         write_header_frequency, &
         terminal_cnt, &
         terminal_show_age_in_years, &
         extra_terminal_output_file, &
         do_profiles, &
         profile_interval, &
         priority_profile_interval, &
         log_directory, &
         star_log_name, &
         star_log_header_name, &
         star_log_dbl_format, &
         star_log_int_format, &
         star_log_txt_format, &
         
         profiles_index_name, &
         log_data_prefix, &
         log_data_suffix, &
         log_data_header_suffix, &
         profile_int_format, &
         profile_txt_format, &
         profile_dbl_format, &
         
         profile_model, &
         max_num_profile_models, &
         mass_loc_for_extra_log_info, &
         
         write_pulse_info_with_profile, &
         pulse_info_format, &
         add_atmosphere_to_pulse_info, &
         write_pulsation_plot_data, &
         
      ! boundary definitions for use in logs and profiles
         h1_boundary_limit, &
         he4_boundary_limit, &
         c12_boundary_limit, &
         
         mixing_D_limit_for_log, &
         trace_mass_location, &
         
      ! burn zone eps definitions for use in logs and profiles
         burn_min1, &
         burn_min2, &
         
         max_conv_vel_div_csound_maxq, &
         
         
      ! for reported surface/center abundances
         surface_avg_abundance_dq, &
         center_avg_value_dq, &
         
      ! mixing parameters
         min_convective_gap, &
         min_thermo_haline_gap, &
         min_semiconvection_gap, &
         min_thermo_haline_dropout, &
         max_dropout_gradL_sub_grada, &
         remove_embedded_semiconvection, &
         remove_mixing_glitches, &
         prune_bad_cz_min_Hp_height, &
         prune_bad_cz_min_log_eps_nuc, &
         alpha_semiconvection, &
         gradL_comp_term_logRho_switch, &
         use_Ledoux_criterion, &
         use_gradmu_alt_for_mlt, &
         use_gradmu_X_for_mlt, &
         gradL_composition_term_factor, &
         clip_D_limit, &
         
         thermo_haline_coeff, &
         thermohaline_option, &
         mixing_length_alpha, &
         alt_scale_height_flag, &
         use_Henyey_MLT, &
         Henyey_MLT_y_param, &
         Henyey_MLT_nu_param, &

         overshoot_f_above_nonburn, &
         overshoot_f_below_nonburn, &
         overshoot_f_above_burn_h, &
         overshoot_f_below_burn_h, &
         overshoot_f_above_burn_he, &
         overshoot_f_below_burn_he, &
         overshoot_f_above_burn_z, &
         overshoot_f_below_burn_z, &
         
         overshoot_below_noburn_factor, &
         max_DUP_counter, &
         
         ovr_below_burn_he_factor, &

         overshoot_f0_above_nonburn, &
         overshoot_f0_below_nonburn, &
         overshoot_f0_above_burn_h, &
         overshoot_f0_below_burn_h, &
         overshoot_f0_above_burn_he, &
         overshoot_f0_below_burn_he, &
         overshoot_f0_above_burn_z, &
         overshoot_f0_below_burn_z, &

         overshoot_f2_above_nonburn, &
         overshoot_f2_below_nonburn, &
         overshoot_f2_above_burn_h, &
         overshoot_f2_below_burn_h, &
         overshoot_f2_above_burn_he, &
         overshoot_f2_below_burn_he, &
         overshoot_f2_above_burn_z, &
         overshoot_f2_below_burn_z, &

         overshoot_D2_above_nonburn, &
         overshoot_D2_below_nonburn, &
         overshoot_D2_above_burn_h, &
         overshoot_D2_below_burn_h, &
         overshoot_D2_above_burn_he, &
         overshoot_D2_below_burn_he, &
         overshoot_D2_above_burn_z, &
         overshoot_D2_below_burn_z, &
         
         mass_for_overshoot_full_on, &
         mass_for_overshoot_full_off, &
         
         overshoot_step_fraction, &
         
         smooth_convective_bdy, &
         max_delta_limit_for_smooth, &
         use_time_dependent_convection, &
         
         nsmooth_gradL_composition_term, &
         
         calculate_Brunt_N2, &
         allow_negative_brunt_B, &
         brunt_N2_coefficient, &
         brunt_H_frac, &
         nsmooth_brunt_dlnY_dlnP, &
         brunt_Brassard_full_on_Zmax, &
         brunt_Brassard_full_off_Zmin, &
         r_div_R_smooth_brunt_dlnY_dlnP, &
         burnt_abs_dlnY_dlnP_cutoff, &

         min_overshoot_q, &
         D_mix_ov_limit, &
         
         radiation_turbulence_coeff, &
         turbulent_diffusion_D0, &
         turbulent_diffusion_rho_max, &
         
         T_mix_limit, &
         conv_dP_term_factor, &

      ! mass gain or loss
         mass_change, &
         mass_change_full_on_dt, &
         mass_change_full_off_dt, &
         min_abs_mdot_for_change_limits, &
         max_abs_mdot_factor, &
         min_abs_mdot_factor, &
         min_wind, &
         mdot_omega_power, &
         max_rotational_mdot_boost, &
         lim_trace_rotational_mdot_boost, &
         rotational_mdot_boost_fac, &
         rotational_mdot_kh_fac, &
         surf_avg_tau, &
         
         supersonic_wind_eta, &
         remove_H_wind_mdot, &
         remove_H_wind_H_mass_limit, &
         eject_supersonic_infall_flag, &
         max_supersonic_wind_mdot, &
         super_eddington_wind_eta, &
         super_eddington_wind_Ledd_factor, &
         
         flash_wind_mdot, &
         flash_wind_starts, &
         flash_wind_declines, &
         flash_wind_full_off, &
            
         min_q_for_special_kap, &
         max_logT_for_special_kap, &
         special_kap_xh, &
         special_kap_xhe, &
         special_kap_xc, &
         special_kap_xn, &
         special_kap_xo, &
         special_kap_xne, &
         special_kap_use_CO_enhanced, &
         special_kap_Z_base, &
         
         rlo_wind_eta, &
         rlo_wind_min_L, &
         rlo_wind_max_Teff, &
         rlo_wind_roche_lobe_radius, &
         rlo_wind_base_mdot, &
         rlo_wind_scale_height, &

         nova_wind_eta, &
         nova_wind_b, &
         nova_wind_max_Teff, &
         nova_wind_min_L, &
         nova_min_Teff_for_accretion, &
         nova_roche_lobe_radius, &
         nova_RLO_mdot, &
         
         RGB_wind_scheme, &
         AGB_wind_scheme, &
         RGB_to_AGB_wind_switch, &
         Reimers_wind_eta, &
         Blocker_wind_eta, &
         de_Jager_wind_eta, &
         Nieuwenhuijzen_wind_eta, &
         Kudritzki_wind_eta, &
         Dutch_wind_eta, &
         wind_envelope_limit, &
         
      ! composition of added mass
         accrete_same_as_surface, &
         
         accrete_given_mass_fractions, &
         num_accretion_species, &
         accretion_species_id, &
         accretion_species_xa, &
         
         accretion_h1, &
         accretion_h2, &
         accretion_he3, &
         accretion_he4, &
         accretion_zfracs, &

         ! special list of z fractions
         z_fraction_li, &
         z_fraction_be, &
         z_fraction_b, &
         z_fraction_c, &
         z_fraction_n, &
         z_fraction_o, &
         z_fraction_f, &
         z_fraction_ne, &
         z_fraction_na, &
         z_fraction_mg, &
         z_fraction_al, &
         z_fraction_si, &
         z_fraction_p, &
         z_fraction_s, &
         z_fraction_cl, &
         z_fraction_ar, &
         z_fraction_k, &
         z_fraction_ca, &
         z_fraction_sc, &
         z_fraction_ti, &
         z_fraction_v, &
         z_fraction_cr, &
         z_fraction_mn, &
         z_fraction_fe, &
         z_fraction_co, &
         z_fraction_ni, &
         z_fraction_cu, &
         z_fraction_zn, &
         
         pure_fe56_limit, &
         
      ! automatic stops for mass loss/gain
         max_star_mass_for_gain, &
         min_star_mass_for_loss, &
         
      ! extra power source
         extra_power_source, &

      ! relaxation parameters
         relax_dlnZ, &
         relax_dY, &
         
      ! mesh adjustment
         remesh_log_L_nuc_burn_min, &
         show_mesh_changes, &
         okay_to_remesh, &
         remesh_cnt, &
         max_allowed_nz, &
         mesh_max_allowed_ratio, &
         max_delta_x_for_merge, &
         mesh_dump_call_number, &
         
         mesh_adjust_use_quadratic, &
         mesh_adjust_get_T_from_E, &
         mesh_interpolate_xa, &

         max_dq, &
         min_dq, &
         mesh_min_dlnR, &
         merge_if_dlnR_too_small, &
         mesh_min_dr_div_cs, &
         merge_if_dr_div_cs_too_small, &

         max_center_cell_dq, &
         min_center_cell_dq, &
         max_surface_cell_dq, &
         max_num_subcells, &
         max_num_merge_cells, &
         
         mesh_delta_coeff, &
         mesh_delta_coeff_pre_ms, &
         mesh_Pgas_div_P_exponent, &
         
         remesh_dt_limit, &

   		P_function_weight, &
         
         xtra_coef_above_xtrans, &
         xtra_coef_below_xtrans, &
         xtra_dist_above_xtrans, &
         xtra_dist_below_xtrans, &
         
         xtra_coef_czb_full_on, &
         xtra_coef_czb_full_off, &
   		   		
         xtra_coef_a_l_nb_czb, &
         xtra_coef_a_l_hb_czb, &
         xtra_coef_a_l_heb_czb, &
         xtra_coef_a_l_zb_czb, &
         
         xtra_coef_b_l_nb_czb, &
         xtra_coef_b_l_hb_czb, &
         xtra_coef_b_l_heb_czb, &
         xtra_coef_b_l_zb_czb, &
         
         xtra_coef_a_u_nb_czb, &
         xtra_coef_a_u_hb_czb, &
         xtra_coef_a_u_heb_czb, &
         xtra_coef_a_u_zb_czb, &
         
         xtra_coef_b_u_nb_czb, &
         xtra_coef_b_u_hb_czb, &
         xtra_coef_b_u_heb_czb, &
         xtra_coef_b_u_zb_czb, &

         xtra_dist_a_l_nb_czb, &
         xtra_dist_a_l_hb_czb, &
         xtra_dist_a_l_heb_czb, &
         xtra_dist_a_l_zb_czb, &
         
         xtra_dist_b_l_nb_czb, &
         xtra_dist_b_l_hb_czb, &
         xtra_dist_b_l_heb_czb, &
         xtra_dist_b_l_zb_czb, &
         
         xtra_dist_a_u_nb_czb, &
         xtra_dist_a_u_hb_czb, &
         xtra_dist_a_u_heb_czb, &
         xtra_dist_a_u_zb_czb, &
         
         xtra_dist_b_u_nb_czb, &
         xtra_dist_b_u_hb_czb, &
         xtra_dist_b_u_heb_czb, &
         xtra_dist_b_u_zb_czb, &
         
         xtra_coef_os_full_on, &
         xtra_coef_os_full_off, &

         xtra_coef_os_above_nonburn, &
         xtra_coef_os_below_nonburn, &
         xtra_coef_os_above_burn_h, &
         xtra_coef_os_below_burn_h, &
         xtra_coef_os_above_burn_he, &
         xtra_coef_os_below_burn_he, &
         xtra_coef_os_above_burn_z, &
         xtra_coef_os_below_burn_z, &
         
         xtra_dist_os_above_nonburn, &
         xtra_dist_os_below_nonburn, &
         xtra_dist_os_above_burn_h, &
         xtra_dist_os_below_burn_h, &
         xtra_dist_os_above_burn_he, &
         xtra_dist_os_below_burn_he, &
         xtra_dist_os_above_burn_z, &
         xtra_dist_os_below_burn_z, &

         mesh_logX_species, &
         mesh_logX_min_for_extra, &
         mesh_dlogX_dlogP_extra, &
         mesh_dlogX_dlogP_full_on, &
         mesh_dlogX_dlogP_full_off, &

         convective_bdy_min_dt_yrs, &
         convective_bdy_dq_limit, &
         convective_bdy_weight, &


         mesh_dlog_eps_min_for_extra, &
         mesh_dlog_eps_dlogP_full_on, &
         mesh_dlog_eps_dlogP_full_off, &

         mesh_dlog_pp_dlogP_extra, &
         mesh_dlog_cno_dlogP_extra, &
         mesh_dlog_3alf_dlogP_extra, &
         
         mesh_dlog_burn_c_dlogP_extra, &
         mesh_dlog_burn_n_dlogP_extra, &
         mesh_dlog_burn_o_dlogP_extra, &
         mesh_dlog_burn_ne_dlogP_extra, &
         mesh_dlog_burn_na_dlogP_extra, &
         mesh_dlog_burn_mg_dlogP_extra, &
         mesh_dlog_burn_si_dlogP_extra, &
         mesh_dlog_burn_s_dlogP_extra, &
         mesh_dlog_burn_ar_dlogP_extra, &
         mesh_dlog_burn_ca_dlogP_extra, &
         mesh_dlog_burn_ti_dlogP_extra, &
         mesh_dlog_burn_cr_dlogP_extra, &
         mesh_dlog_burn_fe_dlogP_extra, &
         
         mesh_dlog_cc_dlogP_extra, &
         mesh_dlog_co_dlogP_extra, &
         mesh_dlog_oo_dlogP_extra, &
         
         mesh_dlog_pnhe4_dlogP_extra, &
         mesh_dlog_photo_dlogP_extra, &
         mesh_dlog_other_dlogP_extra, &
         
   		T_function1_weight, &
   		T_function2_weight, &
   		T_function2_param, &
         
   		R_function_weight, &
   		R_function_param, &
         
   		R_function2_weight, &
   		R_function2_param1, &
   		R_function2_param2, &
         
   		M_function_weight, &
   		M_function_param, &
   		
   		gradT_function_weight, &
   		omega_function_weight, &
         
         xa_function_species, &
   		xa_function_weight, &
   		xa_function_param, &   
   		xa_mesh_delta_coeff, &      

      ! nuclear reaction parameters
         screening_mode, &
         
         net_logTcut_lo, &
         net_logTcut_lim, &
         suppress_dubious_PP_burning, &
         suppress_dubious_N_burning, &
         max_abar_for_burning, &
         
         eps_nuc_factor, &
         net_rate_factor, &
         dxdt_nuc_factor, &
         mix_factor, &
         
         sig_term_limit, &
         am_sig_term_limit, &
         am_D_mix_factor, &
         am_gradmu_factor, &
         am_nu_factor, &

         D_DSI_factor, &
         D_SH_factor, &
         D_SSI_factor, &
         D_ES_factor, &
         D_GSF_factor, &
         D_ST_factor, &
         nu_ST_factor, &
         
         dq_smooth_ST, &
         dq_smooth_SH, &
         dq_smooth_DSI, &
         dq_smooth_ES, &
         dq_smooth_SSI, &
         dq_smooth_GSF, &
         
         set_uniform_am_nu, &
         uniform_am_nu, &
         
         set_min_am_nu, &
         min_am_nu, &
         min_center_Ye_for_min_am_nu, &
         
         set_min_D_mix, &
         min_D_mix, &
         min_center_Ye_for_min_D_mix, &
         
         reaction_neuQs_factor, &
         
         net_pp_rate_factor, &
         net_cno_rate_factor, &
         net_3alf_rate_factor, &
         
         net_burn_c_rate_factor, &        
         net_burn_n_rate_factor, &      
         net_burn_o_rate_factor, &
         net_burn_ne_rate_factor, &
         net_burn_na_rate_factor, &
         net_burn_mg_rate_factor, &
         net_burn_si_rate_factor, &
         net_burn_s_rate_factor, &
         net_burn_ar_rate_factor, &
         net_burn_ca_rate_factor, &
         net_burn_ti_rate_factor, &
         net_burn_cr_rate_factor, &
         net_burn_fe_rate_factor, &
         
         net_cc_rate_factor, &
         net_co_rate_factor, &
         net_oo_rate_factor, &

         net_pnhe4_rate_factor, &
         net_photo_rate_factor, &
         net_other_rate_factor, &
         
         rate_factor_for_fe56ec_to_cr56, &
         max_center_cr56_for_fe56ec, &
         
      ! element diffusion parameters
         do_element_diffusion, &
         diffusion_min_dq_at_surface, &
         diffusion_dt_limit, &
         diffusion_atol, &
         diffusion_rtol, &
         diffusion_maxsteps, &
         diffusion_v_max, &
         diffusion_min_rho_face, &
         diffusion_gamma_full_off, &
         diffusion_gamma_full_on, &
         diffusion_T_full_on, &
         diffusion_T_full_off, &
         diffusion_X_full_on, &
         diffusion_X_full_off, &
         diffusion_Y_full_on, &
         diffusion_Y_full_off, &
         diffusion_D_mix_limit, &
         diffusion_calculates_ionization, &
         diffusion_min_Y_for_fe_in_he, &
         show_diffusion_info, &
         diffusion_num_classes, &
         diffusion_class_representative, &
         diffusion_class_A_max, &
         diffusion_class_typical_charge, &

      ! opacity controls
         base_fC, &
         base_fN, &
         base_fO, &
         base_Z, &
         use_CO_enhanced_opacities, &
         cubic_interpolation_in_X, &
         cubic_interpolation_in_Z, &
         include_electron_conduction, &

      ! hydro_seulex
         trace_seulex, &
         seulex_kmax, &
         seulex_dt_by_err_ratio_avg, &
         seulex_dt_fac1, &
         seulex_dt_fac2, &
         seulex_dt_fac3, &
         seulex_dt_fac4, &
         seulex_dt_safe1, &
         seulex_dt_safe2, &
         seulex_wk_set_vars, &
         seulex_wk_eval_equ, &
         seulex_wk_prep_mtx, &
         seulex_wk_solve_mtx, &
         seulex_step_size_sequence, &

         include_L_in_error_est, &
         include_v_in_error_est, &
         include_lnddot_in_error_est, &
         include_lnTdot_in_error_est, &
         
      ! hydro parameters

         D_norm_kappa, &
         D_norm_alpha, &
         D_norm_atol, &
         D_norm_rtol, &
         D_norm_skip_L, &
         D_norm_skip_v, &
         D_norm_skip_lnddot, &
         D_norm_skip_lnTdot, &

         doing_hydro_newton, &
         use_quad_newton, &
         use_transformed_L, &
         
         min_FL_offset, &
         
         opacity_factor, &
         opacity_max, &
         opacity_max0, &
         opacity_max1, &
         opacity_max_log_r_frac, &
         min_cno_for_kap_limit, &
         
         kap_Pgas_div_P_limit, &
         kap_max_q_for_Pgas_div_P_limit, &
         kap_min_q_for_Pgas_div_P_limit, &
         kap_Pgas_div_P_alt_kap, &

         eps_nuc_factor, &
         non_nuc_neu_factor, &
         accel_factor, &
         surf_bc_offset_factor, &
         use_gr_factors, &
         eps_grav_factor, &
         use_lnE_for_eps_grav, &
         use_artificial_viscosity, &
         l1_coef, &
         l2_coef, &
         use_artificial_v_damping, &
         
         ! hydro solver
         
         operator_coupling_choice, &
         dynamics_coupling_choice, &
         
         op_split_burn_trace, &
         op_split_burn_clip, &
         op_split_burn_atol, &
         op_split_burn_rtol, &
         op_split_burn_maxsteps, &
         op_split_burn_solver1, &
         op_split_burn_solver2, &
         op_split_decsol_switch, &
         op_split_small_mtx_decsol, &
         op_split_large_mtx_decsol, &
         
         op_split_mix_maxsteps, &
         op_split_mix_minsteps, &
         op_split_mix_trace, &
         op_split_mix_atol, &
         op_split_mix_rtol, &
         
         op_split_burn_mix_trace, &
         op_split_trace, &
         op_split_do_predict_struct, &
         op_split_reconverge_hydro, &
         
         split_mtx_solve_rtol, &
         split_mtx_solve_atol, &
         split_mtx_solve_max_iters, &
         
         hydro_err_ratio_rtol, &
         hydro_err_ratio_atol, &
         
         tol_correction_norm, &
         tol_max_correction, &
         tol_correction_norm_alt, &
         tol_max_correction_alt, &
         correction_xa_limit, &
         
         tol_max_residual1, tol_residual_norm1, &
         tol_max_residual2, tol_residual_norm2, &
         tol_max_residual3, tol_residual_norm3, &
         
         min_for_check_D_norm_converging, &
         
         max_iterations_for_jacobian, &
         refine_solution, &
         refine_mtx_solution, &

         small_mtx_decsol, &
         large_mtx_decsol, &
         hydro_decsol_switch, &
         sparse_non_zero_max_factor, &
         thomas_blck_sprs_clip_lim, &

         max_iter_for_resid_tol1, &
         max_iter_for_resid_tol2, &
         max_iter_for_resid_tol3, &
         
         newton_itermin, &
         
         max_xa_err_ratio_hard_limit, &
         max_xa_err_ratio_rtol, &
         max_xa_err_ratio_atol, &
         hydro_solver_name, &
         
         tiny_corr_coeff_limit, &
         target_corr_factor, &
         scale_correction_norm, &
         corr_param_factor, &
         scale_max_correction, &
         
         corr_norm_jump_limit, &
         max_corr_jump_limit, &
         resid_norm_jump_limit, &
         max_resid_jump_limit, &
         
         corr_coeff_limit, &
         slope_alert_level, &
         slope_crisis_level, &
         tiny_corr_factor, &
         matrix_type, &
         
         max_tries1, &
         max_tries, &
         max_tries_for_retry, &
         max_tries_after_backup, &
         max_tries_after_backup2, &
         retry_limit, &
         
         jacobian_clip_limit, &
         min_xa_hard_limit, &
         xa_clip_limit, &
         sum_xa_tolerance, &
         report_hydro_solver_progress, &
         hydro_dump_call_number, &
         hydro_numerical_jacobian, &
         hydro_jacobian_nzlo, &
         hydro_jacobian_nzhi, &
         hydro_check_everything, &
         hydro_inspectB_flag, &
         hydro_show_correction_info, &
         hydro_save_numjac_plot_data, &
         
      ! timestep
         DUP_varcontrol_factor, &
         min_timestep_factor, &
         max_timestep_factor, &
         timestep_factor_for_backups, &
         backup_hold, &
         retry_hold, &     
         timestep_dt_factor, &           
         timestep_limit_factor, &      
         varcontrol_target, &
         varcontrol_target_max, &
         backup_drop_varcontrol_target, &
         backup_drop_vc_target_steps, &
         xa_scale, &
         
         jacobian_limit, &
         jacobian_hard_limit, &
         diffusion_steps_limit, &
         diffusion_steps_hard_limit, &  
         
         dX_mix_dist_limit, &
         
         dH_limit_min_H, & 
         dH_limit, & 
         dH_hard_limit, & 
         dH_div_H_limit_min_H, & 
         dH_div_H_limit, & 
         dH_div_H_hard_limit, &
         dH_decreases_only, &
         
         dHe_limit_min_He, & 
         dHe_limit, & 
         dHe_hard_limit, & 
         dHe_div_He_limit_min_He, & 
         dHe_div_He_limit, & 
         dHe_div_He_hard_limit, & 
         dHe_decreases_only, &
         
         dHe3_limit_min_He3, & 
         dHe3_limit, & 
         dHe3_hard_limit, & 
         dHe3_div_He3_limit_min_He3, & 
         dHe3_div_He3_limit, & 
         dHe3_div_He3_hard_limit, & 
         dHe3_decreases_only, &
         
         dX_limit_min_X, & 
         dX_limit, & 
         dX_hard_limit, & 
         dX_div_X_limit_min_X, & 
         dX_div_X_limit, & 
         dX_div_X_hard_limit, & 
         dX_decreases_only, &
         
         dprctd_dX_nuc_min_X_limit, &
         dprctd_dX_nuc_max_A_limit, &
         dprctd_dX_nuc_limit, &
         dprctd_dX_nuc_hard_limit, &
         dprctd_dX_nuc_factor, &
         dprctd_dX_nuc_X_limit, &
         dprctd_dX_nuc_dX_div_del_limit, &
         dprctd_dX_nuc_min_yrs_for_dt, &
         
         dX_nuc_drop_min_X_limit, &
         dX_nuc_drop_max_A_limit, &
         dX_nuc_drop_limit, &
         dX_nuc_drop_hard_limit, &
         dX_nuc_drop_min_yrs_for_dt, &
         
         dL_div_L_limit_min_L, &
         dL_div_L_limit, &
         dL_div_L_hard_limit, &
         
         delta_lgP_limit, &   
         delta_lgP_hard_limit, &           
         delta_lgRho_limit, &   
         delta_lgRho_hard_limit, &           
         delta_lgT_limit, & 
         delta_lgT_hard_limit, &           
         delta_lgR_limit, &
         delta_lgR_hard_limit, &
         
         d_deltaR_shrink_limit, &
         d_deltaR_shrink_hard_limit, &
         d_deltaR_grow_limit, &
         d_deltaR_grow_hard_limit, &

         delta_lgL_nuc_cat_limit, &
         delta_lgL_nuc_cat_hard_limit, &
         lgL_nuc_cat_burn_min, &
         lgL_nuc_mix_dist_limit, &

         check_delta_lgL_pp, &
         check_delta_lgL_cno, &
         check_delta_lgL_3alf, &
         
         check_delta_lgL_burn_c, &
         check_delta_lgL_burn_n, &
         check_delta_lgL_burn_o, &
         check_delta_lgL_burn_ne, &
         check_delta_lgL_burn_na, &
         check_delta_lgL_burn_mg, &
         check_delta_lgL_burn_si, &
         check_delta_lgL_burn_s, &
         check_delta_lgL_burn_ar, &
         check_delta_lgL_burn_ca, &
         check_delta_lgL_burn_ti, &
         check_delta_lgL_burn_cr, &
         check_delta_lgL_burn_fe, &
         
         check_delta_lgL_cc, &
         check_delta_lgL_co, &
         check_delta_lgL_oo, &

         delta_lgL_H_limit, &
         delta_lgL_H_hard_limit, &
         lgL_H_burn_min, &
         lgL_H_drop_factor, &

         delta_lgL_He_limit, &
         delta_lgL_He_hard_limit, &
         lgL_He_burn_min, &
         lgL_He_drop_factor, &

         delta_lgL_z_limit, &
         delta_lgL_z_hard_limit, &
         lgL_z_burn_min, &
         lgL_z_drop_factor, &

         delta_lgL_nuc_limit, &
         delta_lgL_nuc_hard_limit, &
         lgL_nuc_burn_min, &
         lgL_nuc_drop_factor, &

         delta_lgRho_cntr_limit, &   
         delta_lgRho_cntr_hard_limit, &           
         delta_lgT_cntr_limit, & 
         delta_lgT_cntr_hard_limit, &

         delta_lg_XH_cntr_min, &
         delta_lg_XH_cntr_max, &
         delta_lg_XH_cntr_limit, &
         delta_lg_XH_cntr_hard_limit, &

         delta_lg_XHe_cntr_min, &
         delta_lg_XHe_cntr_max, &
         delta_lg_XHe_cntr_limit, &
         delta_lg_XHe_cntr_hard_limit, &

         delta_lgTeff_limit, & 
         delta_lgTeff_hard_limit, &        
         delta_lgL_limit, & 
         delta_lgL_hard_limit, &         
         
         delta_HR_ds_L, &
         delta_HR_ds_Teff, &  
         delta_HR_limit, &
         delta_HR_hard_limit, &

         delta_lg_star_mass_limit, &
         delta_lg_star_mass_hard_limit, & 
         
         delta_lg_total_J_limit, &
         delta_lg_total_J_hard_limit, &

         delta_op_split_limit, &  
         delta_op_split_hard_limit, &
         delta_op_split_Lnuc_limit, &
         delta_op_split_center_h1_limit, &
         
         L_div_CpTMdot_limit, &
         L_div_CpTMdot_hard_limit, &
                   
         relax_hard_limits_after_backup, &   
         relax_hard_limits_after_retry, &
         report_all_dt_limits, &   
         report_why_dt_limits, &   
         report_hydro_dt_info, &
         report_dX_nuc_drop_dt_limits, &
         write_varcontrol_internals, &
         
         
      ! atmosphere -- surface boundary conditions
         which_atm_option, &
         which_atm_off_table_option, &
         atm_switch_to_grey_as_backup, &
         atm_grey_and_kap_atol, &
         atm_grey_and_kap_rtol, &
         atm_grey_and_kap_max_tries, &
         trace_atm_grey_and_kap, &

         atm_grey_irradiated_atol, &
         atm_grey_irradiated_rtol, &
         atm_grey_irradiated_T_eq, &
         atm_grey_irradiated_kap_v, &
         atm_grey_irr_kap_v_div_kap_th, &
         atm_grey_irradiated_P_surf, &
         atm_grey_irradiated_max_tries, &
         trace_atm_grey_irradiated, &
         
         atm_int_errtol, &
         dump_int_atm_info_model_number, &
         
            
      ! create atmosphere
         create_atm_max_step_size, &
         Paczynski_atm_R_surf_errtol, &
         trace_atm_Paczynski_grey, &

      ! extra heat near surface to model irradiation         
         irradiation_flux, &
         column_depth_for_irradiation, &
         
      ! uniform extra heat
         inject_uniform_extra_heat, &

      ! mass gain or loss
         clip_small_mdots, &
         adjust_mass_const_q, &
         adjust_mass_lnTlim_A, & 
         adjust_mass_lnTlim_B, &
         adjust_mass_qlim_A, & 
         adjust_mass_qlim_B, &
         
      ! opacities
         use_simple_es_for_kap, &

      ! info for debugging
         stop_for_bugs, &
         report_ierr, &
         diffusion_dump_call_number, &
      
      ! controls for the evolve routine
         trace_evolve, &

         
      ! misc
         zams_filename, &
         use_other_atm, &
         use_other_mesh_functions, &
         use_other_diffusion, &
         use_other_kap, & 
         use_other_eos, &
         use_other_mlt, &
         
         factor_for_recently_added, &
         show_info_for_recently_added, &
         
         x_ctrl, &
         x_integer_ctrl, &
         x_logical_ctrl, &
         
         trace_solar_neutrinos, &
         
      ! extra files
         read_extra_controls_inlist1, extra_controls_inlist1_name, &
         read_extra_controls_inlist2, extra_controls_inlist2_name, &
         read_extra_controls_inlist3, extra_controls_inlist3_name, &
         read_extra_controls_inlist4, extra_controls_inlist4_name, &
         read_extra_controls_inlist5, extra_controls_inlist5_name



      contains
      
      
      subroutine do_one_setup(id, inlist, ierr)
         use utils_lib
         character (len=*), intent(in) :: inlist
         integer, intent(in) :: id
         integer, intent(out) :: ierr
         type (star_info), pointer :: s
         include 'formats.dek'
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         call do_init_star_misc(s)
         call set_default_controls
         call read_controls(id, inlist, ierr)
         if (ierr /= 0) return
         s% status_profilename = trim(s% log_directory) // '/status.log'
         if (len_trim(s% extra_terminal_output_file) == 0) return
         s% extra_terminal_iounit = alloc_iounit(ierr)
         if (ierr /= 0) then
            write(*,*) 'failed to allocate io unit for ' // trim(s% extra_terminal_output_file)
            return
         end if
         open(unit=s% extra_terminal_iounit, file=trim(s% extra_terminal_output_file), &
               action='write', status='replace',iostat=ierr)
         if (ierr /= 0) then
            write(*,*) 'failed to open ' // trim(s% extra_terminal_output_file)
            call free_iounit(s% extra_terminal_iounit)
            return
         end if
      end subroutine do_one_setup


      subroutine read_controls(id, filename, ierr)
         use star_private_def
         use alert_lib
         use utils_lib
         character(*), intent(in) :: filename
         integer, intent(in) :: id
         integer, intent(out) :: ierr

         type (star_info), pointer :: s
         ierr = 0
         call get_star_ptr(id, s, ierr)
         if (ierr /= 0) return
         
         call read_controls_file(s, filename, 1, ierr)
         
      end subroutine read_controls
         
         
      recursive subroutine read_controls_file(s, filename, level, ierr)
         use star_private_def
         use alert_lib
         use utils_lib
         character(*), intent(in) :: filename
         type (star_info), pointer :: s
         integer, intent(in) :: level  
         integer, intent(out) :: ierr
         logical :: read_extra1, read_extra2, read_extra3, read_extra4, read_extra5
         character (len=256) :: message, extra1, extra2, extra3, extra4, extra5
         integer :: unit 
         
         ierr = 0        
         
         if (level >= 10) then
            write(*,*) 'ERROR: too many levels of nested extra controls inlist files'
            ierr = -1
            return
         end if

         if (len_trim(filename) > 0) then
            unit=alloc_iounit(ierr); if (ierr /= 0) return
            open(unit=unit, file=trim(filename), action='read', delim='quote', status='old', iostat=ierr)
            if (ierr /= 0) then
               write(message, *) 'Failed to open control namelist file ', trim(filename)
               call alert(ierr, message)
               write(*, '(a)') trim(message)
               return
            end if
            read(unit, nml=controls, iostat=ierr)  
            close(unit)
            if (ierr /= 0) then
               write(*, *) 
               write(*, *) 
               write(*, *) 
               write(*, *) 
               write(message, '(a)') &
                  'Failed while trying to read control namelist file: ' // trim(filename)
               write(*, '(a)') trim(message)
               write(*, '(a)') &
                  'Perhaps the following runtime error message will help you find the problem.'
               write(*, *) 
               open(unit=unit, file=trim(filename), action='read', delim='quote', status='old', iostat=ierr)
               read(unit, nml=controls)
               close(unit)
               call free_iounit(unit)
               call alert(ierr, message)
               return
            end if
            call free_iounit(unit)
         end if
         
         call store_controls(s, ierr)
         
         ! recursive calls to read other inlists
         
         read_extra1 = read_extra_controls_inlist1
         read_extra_controls_inlist1 = .false.
         extra1 = extra_controls_inlist1_name
         extra_controls_inlist1_name = 'undefined'
         
         read_extra2 = read_extra_controls_inlist2
         read_extra_controls_inlist2 = .false.
         extra2 = extra_controls_inlist2_name
         extra_controls_inlist2_name = 'undefined'
         
         read_extra3 = read_extra_controls_inlist3
         read_extra_controls_inlist3 = .false.
         extra3 = extra_controls_inlist3_name
         extra_controls_inlist3_name = 'undefined'
         
         read_extra4 = read_extra_controls_inlist4
         read_extra_controls_inlist4 = .false.
         extra4 = extra_controls_inlist4_name
         extra_controls_inlist4_name = 'undefined'
         
         read_extra5 = read_extra_controls_inlist5
         read_extra_controls_inlist5 = .false.
         extra5 = extra_controls_inlist5_name
         extra_controls_inlist5_name = 'undefined'
         
         if (read_extra1) then
            write(*,*) 'read ' // trim(extra1)
            call read_controls_file(s, extra1, level+1, ierr)
            if (ierr /= 0) return
         end if
         
         if (read_extra2) then
            write(*,*) 'read ' // trim(extra2)
            call read_controls_file(s, extra2, level+1, ierr)
            if (ierr /= 0) return
         end if
         
         if (read_extra3) then
            write(*,*) 'read ' // trim(extra3)
            call read_controls_file(s, extra3, level+1, ierr)
            if (ierr /= 0) return
         end if
         
         if (read_extra4) then
            write(*,*) 'read ' // trim(extra4)
            call read_controls_file(s, extra4, level+1, ierr)
            if (ierr /= 0) return
         end if
         
         if (read_extra5) then
            write(*,*) 'read ' // trim(extra5)
            call read_controls_file(s, extra5, level+1, ierr)
            if (ierr /= 0) return
         end if
         
      end subroutine read_controls_file


      subroutine store_controls(s, ierr)
         use star_private_def
         use chem_def ! categories
         type (star_info), pointer :: s
         integer, intent(out) :: ierr
         
         ierr = 0
         
         ! where to start
         s% initial_mass = initial_mass
         s% initial_z = initial_z
         s% initial_y = initial_y
         ! when to stop
         s% max_model_number = max_model_number
         s% max_backups_in_a_row = max_backups_in_a_row
         s% max_number_backups = max_number_backups
         s% max_number_retries = max_number_retries
         s% relax_max_number_retries = relax_max_number_retries
         s% relax_max_number_backups = relax_max_number_backups
         s% max_age = max_age
         s% when_to_stop_rtol = when_to_stop_rtol
         s% when_to_stop_atol = when_to_stop_atol
         s% gamma_center_limit = gamma_center_limit
         s% eta_center_limit = eta_center_limit
         s% log_center_temp_limit = log_center_temp_limit
         s% log_center_temp_lower_limit = log_center_temp_lower_limit
         s% log_center_density_limit = log_center_density_limit
         s% min_timestep_limit = min_timestep_limit
         s% logQ_limit = logQ_limit
         s% iron_core_infall_limit = iron_core_infall_limit
         s% v_div_csound_surf_limit = v_div_csound_surf_limit
         s% Pgas_div_P_limit = Pgas_div_P_limit
         s% Pgas_div_P_limit_max_q = Pgas_div_P_limit_max_q
         s% peak_burn_vconv_div_cs_limit = peak_burn_vconv_div_cs_limit
         s% omega_div_omega_crit_limit = omega_div_omega_crit_limit
         s% delta_nu_lower_limit = delta_nu_lower_limit
         s% delta_nu_upper_limit = delta_nu_upper_limit
         s% delta_Pg_lower_limit = delta_Pg_lower_limit
         s% delta_Pg_upper_limit = delta_Pg_upper_limit

         s% surface_accel_div_grav_limit = surface_accel_div_grav_limit
         
         s% xa_central_lower_limit_species = xa_central_lower_limit_species
         s% xa_central_lower_limit = xa_central_lower_limit
         
         s% xa_central_upper_limit_species = xa_central_upper_limit_species
         s% xa_central_upper_limit = xa_central_upper_limit
         
         s% xa_surface_lower_limit_species = xa_surface_lower_limit_species
         s% xa_surface_lower_limit = xa_surface_lower_limit
         
         s% xa_surface_upper_limit_species = xa_surface_upper_limit_species
         s% xa_surface_upper_limit = xa_surface_upper_limit
         
         s% xa_average_lower_limit_species = xa_average_lower_limit_species
         s% xa_average_lower_limit = xa_average_lower_limit
         
         s% xa_average_upper_limit_species = xa_average_upper_limit_species
         s% xa_average_upper_limit = xa_average_upper_limit
         
         s% HB_limit = HB_limit
         s% stop_at_TP = stop_at_TP
         s% TP_he_shell_max = TP_he_shell_max
         
         s% star_mass_max_limit = star_mass_max_limit
         s% star_mass_min_limit = star_mass_min_limit
         s% star_H_mass_max_limit = star_H_mass_max_limit
         s% star_H_mass_min_limit = star_H_mass_min_limit
         s% xmstar_min_limit = xmstar_min_limit
         s% xmstar_max_limit = xmstar_max_limit
         s% envelope_mass_limit = envelope_mass_limit
         s% envelope_fraction_left_limit = envelope_fraction_left_limit
         s% h1_boundary_mass_limit = h1_boundary_mass_limit
         s% he4_boundary_mass_limit = he4_boundary_mass_limit
         s% c12_boundary_mass_limit = c12_boundary_mass_limit
         s% he_layer_mass_lower_limit = he_layer_mass_lower_limit
         s% abs_diff_lg_LH_lg_Ls_limit = abs_diff_lg_LH_lg_Ls_limit
         s% Teff_upper_limit = Teff_upper_limit
         s% Teff_lower_limit = Teff_lower_limit
         s% photosphere_r_upper_limit = photosphere_r_upper_limit
         s% photosphere_r_lower_limit = photosphere_r_lower_limit
         s% log_Teff_upper_limit = log_Teff_upper_limit
         s% log_Teff_lower_limit = log_Teff_lower_limit
         s% log_Tsurf_upper_limit = log_Tsurf_upper_limit
         s% log_Tsurf_lower_limit = log_Tsurf_lower_limit
         s% log_Psurf_upper_limit = log_Psurf_upper_limit
         s% log_Psurf_lower_limit = log_Psurf_lower_limit
         s% log_L_upper_limit = log_L_upper_limit
         s% log_L_lower_limit = log_L_lower_limit
         s% log_g_upper_limit = log_g_upper_limit
         s% log_g_lower_limit = log_g_lower_limit
         
         s% power_nuc_burn_upper_limit = power_nuc_burn_upper_limit
         s% power_h_burn_upper_limit = power_h_burn_upper_limit
         s% power_he_burn_upper_limit = power_he_burn_upper_limit 
         s% power_c_burn_upper_limit = power_c_burn_upper_limit 
         s% power_nuc_burn_lower_limit = power_nuc_burn_lower_limit
         s% power_h_burn_lower_limit = power_h_burn_lower_limit
         s% power_he_burn_lower_limit = power_he_burn_lower_limit 
         s% power_c_burn_lower_limit = power_c_burn_lower_limit 
         
         s% phase_of_evolution_stop = phase_of_evolution_stop
         ! timesteps
         s% max_timestep = max_timestep
         s% max_years_for_timestep = max_years_for_timestep
         ! output of "snapshots" for restarts
         s% photostep = photostep
         s% photo_digits = photo_digits
         s% photo_directory = photo_directory
         ! output of log and profiles.
         s% do_log_files = do_log_files
         s% log_cnt = log_cnt
         s% write_header_frequency = write_header_frequency
         s% terminal_cnt = terminal_cnt
         s% terminal_show_age_in_years = terminal_show_age_in_years
         s% extra_terminal_output_file = extra_terminal_output_file
         s% log_directory = log_directory
         s% star_log_name = star_log_name
         s% star_log_header_name = star_log_header_name
         s% star_log_dbl_format = star_log_dbl_format
         s% star_log_int_format = star_log_int_format
         s% star_log_txt_format = star_log_txt_format
         
         s% profiles_index_name = profiles_index_name
         s% log_data_prefix = log_data_prefix
         s% log_data_suffix = log_data_suffix
         s% log_data_header_suffix = log_data_header_suffix
         s% profile_int_format = profile_int_format
         s% profile_txt_format = profile_txt_format
         s% profile_dbl_format = profile_dbl_format
         s% do_profiles = do_profiles
         s% profile_interval = profile_interval
         s% priority_profile_interval = priority_profile_interval
         s% profile_model = profile_model
         s% max_num_profile_models = max_num_profile_models
         s% mass_loc_for_extra_log_info = mass_loc_for_extra_log_info
         
         s% write_pulse_info_with_profile = write_pulse_info_with_profile
         s% pulse_info_format = pulse_info_format
         s% add_atmosphere_to_pulse_info = add_atmosphere_to_pulse_info
         s% write_pulsation_plot_data = write_pulsation_plot_data

         ! core boundary definitions for use in logs and profiles
         s% h1_boundary_limit = h1_boundary_limit
         s% he4_boundary_limit = he4_boundary_limit
         s% c12_boundary_limit = c12_boundary_limit
         
         s% mixing_D_limit_for_log = mixing_D_limit_for_log
         s% trace_mass_location = trace_mass_location
         
         ! burn zone eps definitions for use in logs and profiles
         s% burn_min1 = burn_min1
         s% burn_min2 = burn_min2
         
         s% max_conv_vel_div_csound_maxq = max_conv_vel_div_csound_maxq
         ! for reported average values
         s% surface_avg_abundance_dq = surface_avg_abundance_dq
         s% center_avg_value_dq = center_avg_value_dq
         
         ! mixing parameters
         s% min_convective_gap = min_convective_gap
         s% min_thermo_haline_gap = min_thermo_haline_gap
         s% min_semiconvection_gap = min_semiconvection_gap
         s% min_thermo_haline_dropout = min_thermo_haline_dropout
         s% max_dropout_gradL_sub_grada = max_dropout_gradL_sub_grada
         s% remove_embedded_semiconvection = remove_embedded_semiconvection
         s% remove_mixing_glitches = remove_mixing_glitches
         s% prune_bad_cz_min_Hp_height = prune_bad_cz_min_Hp_height
         s% prune_bad_cz_min_log_eps_nuc = prune_bad_cz_min_log_eps_nuc
         s% alpha_semiconvection = alpha_semiconvection
         s% gradL_comp_term_logRho_switch = gradL_comp_term_logRho_switch
         s% use_Ledoux_criterion = use_Ledoux_criterion
         s% use_gradmu_alt_for_mlt = use_gradmu_alt_for_mlt
         s% use_gradmu_X_for_mlt = use_gradmu_X_for_mlt
         s% gradL_composition_term_factor = gradL_composition_term_factor
         s% clip_D_limit = clip_D_limit
         
         s% thermo_haline_coeff = thermo_haline_coeff
         s% thermohaline_option = thermohaline_option
         s% mixing_length_alpha = mixing_length_alpha
         s% alt_scale_height_flag = alt_scale_height_flag
         s% use_Henyey_MLT = use_Henyey_MLT
         s% Henyey_MLT_y_param = Henyey_MLT_y_param
         s% Henyey_MLT_nu_param = Henyey_MLT_nu_param

         s% overshoot_f_above_nonburn = overshoot_f_above_nonburn
         s% overshoot_f_below_nonburn = overshoot_f_below_nonburn
         s% overshoot_f_above_burn_h = overshoot_f_above_burn_h
         s% overshoot_f_below_burn_h = overshoot_f_below_burn_h
         s% overshoot_f_above_burn_he = overshoot_f_above_burn_he
         s% overshoot_f_below_burn_he = overshoot_f_below_burn_he
         s% overshoot_f_above_burn_z = overshoot_f_above_burn_z
         s% overshoot_f_below_burn_z = overshoot_f_below_burn_z
         
         s% overshoot_below_noburn_factor = overshoot_below_noburn_factor
         s% max_DUP_counter = max_DUP_counter
         
         s% ovr_below_burn_he_factor = ovr_below_burn_he_factor

         s% overshoot_f0_above_nonburn = overshoot_f0_above_nonburn
         s% overshoot_f0_below_nonburn = overshoot_f0_below_nonburn
         s% overshoot_f0_above_burn_h = overshoot_f0_above_burn_h
         s% overshoot_f0_below_burn_h = overshoot_f0_below_burn_h
         s% overshoot_f0_above_burn_he = overshoot_f0_above_burn_he
         s% overshoot_f0_below_burn_he = overshoot_f0_below_burn_he
         s% overshoot_f0_above_burn_z = overshoot_f0_above_burn_z
         s% overshoot_f0_below_burn_z = overshoot_f0_below_burn_z

         s% overshoot_D2_above_nonburn = overshoot_D2_above_nonburn
         s% overshoot_D2_below_nonburn = overshoot_D2_below_nonburn
         s% overshoot_D2_above_burn_h = overshoot_D2_above_burn_h
         s% overshoot_D2_below_burn_h = overshoot_D2_below_burn_h
         s% overshoot_D2_above_burn_he = overshoot_D2_above_burn_he
         s% overshoot_D2_below_burn_he = overshoot_D2_below_burn_he
         s% overshoot_D2_above_burn_z = overshoot_D2_above_burn_z
         s% overshoot_D2_below_burn_z = overshoot_D2_below_burn_z

         s% overshoot_f2_above_nonburn = overshoot_f2_above_nonburn
         s% overshoot_f2_below_nonburn = overshoot_f2_below_nonburn
         s% overshoot_f2_above_burn_h = overshoot_f2_above_burn_h
         s% overshoot_f2_below_burn_h = overshoot_f2_below_burn_h
         s% overshoot_f2_above_burn_he = overshoot_f2_above_burn_he
         s% overshoot_f2_below_burn_he = overshoot_f2_below_burn_he
         s% overshoot_f2_above_burn_z = overshoot_f2_above_burn_z
         s% overshoot_f2_below_burn_z = overshoot_f2_below_burn_z
         
         s% mass_for_overshoot_full_on = mass_for_overshoot_full_on
         s% mass_for_overshoot_full_off = mass_for_overshoot_full_off
         
         s% overshoot_step_fraction = overshoot_step_fraction
         
         s% smooth_convective_bdy = smooth_convective_bdy
         s% max_delta_limit_for_smooth = max_delta_limit_for_smooth
         s% use_time_dependent_convection = use_time_dependent_convection

         s% nsmooth_gradL_composition_term = nsmooth_gradL_composition_term

         s% calculate_Brunt_N2 = calculate_Brunt_N2
         s% allow_negative_brunt_B = allow_negative_brunt_B
         s% brunt_N2_coefficient = brunt_N2_coefficient
         s% brunt_H_frac = brunt_H_frac
         s% r_div_R_smooth_brunt_dlnY_dlnP = r_div_R_smooth_brunt_dlnY_dlnP
         s% nsmooth_brunt_dlnY_dlnP = nsmooth_brunt_dlnY_dlnP
         s% brunt_Brassard_full_on_Zmax = brunt_Brassard_full_on_Zmax
         s% brunt_Brassard_full_off_Zmin = brunt_Brassard_full_off_Zmin
         s% burnt_abs_dlnY_dlnP_cutoff = burnt_abs_dlnY_dlnP_cutoff

         s% min_overshoot_q = min_overshoot_q
         s% D_mix_ov_limit = D_mix_ov_limit
         
         s% radiation_turbulence_coeff = radiation_turbulence_coeff
         s% turbulent_diffusion_D0 = turbulent_diffusion_D0
         s% turbulent_diffusion_rho_max = turbulent_diffusion_rho_max
         
         s% T_mix_limit = T_mix_limit
         s% conv_dP_term_factor = conv_dP_term_factor
         
         ! atmosphere -- surface boundary conditions
         s% which_atm_option = which_atm_option
         s% which_atm_off_table_option = which_atm_off_table_option
         s% atm_switch_to_grey_as_backup = atm_switch_to_grey_as_backup
         
         s% atm_grey_and_kap_atol = atm_grey_and_kap_atol
         s% atm_grey_and_kap_rtol = atm_grey_and_kap_rtol
         s% atm_grey_and_kap_max_tries = atm_grey_and_kap_max_tries
         s% trace_atm_grey_and_kap = trace_atm_grey_and_kap

         s% atm_grey_irradiated_atol = atm_grey_irradiated_atol
         s% atm_grey_irradiated_rtol = atm_grey_irradiated_rtol
         s% atm_grey_irradiated_T_eq = atm_grey_irradiated_T_eq
         s% atm_grey_irradiated_kap_v = atm_grey_irradiated_kap_v
         s% atm_grey_irr_kap_v_div_kap_th = atm_grey_irr_kap_v_div_kap_th
         s% atm_grey_irradiated_P_surf = atm_grey_irradiated_P_surf
         s% atm_grey_irradiated_max_tries = atm_grey_irradiated_max_tries
         s% trace_atm_grey_irradiated = trace_atm_grey_irradiated
         
         s% atm_int_errtol = atm_int_errtol
         s% dump_int_atm_info_model_number = dump_int_atm_info_model_number
         
            
         ! create atmosphere
         s% create_atm_max_step_size = create_atm_max_step_size
         s% Paczynski_atm_R_surf_errtol = Paczynski_atm_R_surf_errtol
         s% trace_atm_Paczynski_grey = trace_atm_Paczynski_grey

         
         ! extra heat near surface to model irradiation         
         s% irradiation_flux = irradiation_flux
         s% column_depth_for_irradiation = column_depth_for_irradiation
         
         ! extra heat
         s% inject_uniform_extra_heat = inject_uniform_extra_heat
         
         ! mass gain or loss
         s% mass_change = mass_change
         s% mass_change_full_off_dt = mass_change_full_off_dt
         s% mass_change_full_on_dt = mass_change_full_on_dt
         s% min_abs_mdot_for_change_limits = min_abs_mdot_for_change_limits
         s% max_abs_mdot_factor = max_abs_mdot_factor
         s% min_abs_mdot_factor = min_abs_mdot_factor
         s% min_wind = min_wind
         s% mdot_omega_power = mdot_omega_power
         s% max_rotational_mdot_boost = max_rotational_mdot_boost
         s% lim_trace_rotational_mdot_boost = lim_trace_rotational_mdot_boost
         s% rotational_mdot_boost_fac = rotational_mdot_boost_fac
         s% rotational_mdot_kh_fac = rotational_mdot_kh_fac
         s% surf_avg_tau = surf_avg_tau
         
         s% supersonic_wind_eta = supersonic_wind_eta
         s% remove_H_wind_mdot = remove_H_wind_mdot
         s% remove_H_wind_H_mass_limit = remove_H_wind_H_mass_limit
         s% eject_supersonic_infall_flag = eject_supersonic_infall_flag
         s% max_supersonic_wind_mdot = max_supersonic_wind_mdot
         s% super_eddington_wind_eta = super_eddington_wind_eta
         s% super_eddington_wind_Ledd_factor = super_eddington_wind_Ledd_factor
         
         s% flash_wind_mdot = flash_wind_mdot
         s% flash_wind_starts = flash_wind_starts
         s% flash_wind_declines = flash_wind_declines
         s% flash_wind_full_off = flash_wind_full_off
            
         s% min_q_for_special_kap = min_q_for_special_kap
         s% max_logT_for_special_kap = max_logT_for_special_kap
         s% special_kap_xh = special_kap_xh
         s% special_kap_xhe = special_kap_xhe
         s% special_kap_xc = special_kap_xc
         s% special_kap_xn = special_kap_xn
         s% special_kap_xo = special_kap_xo
         s% special_kap_xne = special_kap_xne
         s% special_kap_use_CO_enhanced = special_kap_use_CO_enhanced
         s% special_kap_Z_base = special_kap_Z_base

         s% rlo_wind_eta = rlo_wind_eta
         s% rlo_wind_min_L = rlo_wind_min_L
         s% rlo_wind_max_Teff = rlo_wind_max_Teff
         s% rlo_wind_roche_lobe_radius = rlo_wind_roche_lobe_radius
         s% rlo_wind_base_mdot = rlo_wind_base_mdot
         s% rlo_wind_scale_height = rlo_wind_scale_height
         
         s% nova_wind_eta = nova_wind_eta
         s% nova_wind_b = nova_wind_b
         s% nova_wind_max_Teff = nova_wind_max_Teff
         s% nova_wind_min_L = nova_wind_min_L
         s% nova_min_Teff_for_accretion = nova_min_Teff_for_accretion
         s% nova_roche_lobe_radius = nova_roche_lobe_radius
         s% nova_RLO_mdot = nova_RLO_mdot
         
         s% RGB_wind_scheme = RGB_wind_scheme
         s% AGB_wind_scheme = AGB_wind_scheme
         s% RGB_to_AGB_wind_switch = RGB_to_AGB_wind_switch
         s% Reimers_wind_eta = Reimers_wind_eta
         s% Blocker_wind_eta = Blocker_wind_eta
         s% de_Jager_wind_eta = de_Jager_wind_eta
         s% Nieuwenhuijzen_wind_eta = Nieuwenhuijzen_wind_eta
         s% Kudritzki_wind_eta = Kudritzki_wind_eta
         s% Dutch_wind_eta = Dutch_wind_eta
         
         s% wind_envelope_limit = wind_envelope_limit
         s% adjust_mass_const_q = adjust_mass_const_q
         s% clip_small_mdots = clip_small_mdots
         s% adjust_mass_lnTlim_A = adjust_mass_lnTlim_A
         s% adjust_mass_lnTlim_B = adjust_mass_lnTlim_B
         s% adjust_mass_qlim_A = adjust_mass_qlim_A
         s% adjust_mass_qlim_B = adjust_mass_qlim_B
         
         ! composition of added mass
         s% accrete_same_as_surface = accrete_same_as_surface
         
         s% accrete_given_mass_fractions = accrete_given_mass_fractions
         s% num_accretion_species = num_accretion_species
         s% accretion_species_id = accretion_species_id
         s% accretion_species_xa = accretion_species_xa
         
         s% accretion_h1 = accretion_h1
         s% accretion_h2 = accretion_h2
         s% accretion_he3 = accretion_he3
         s% accretion_he4 = accretion_he4
         s% accretion_zfracs = accretion_zfracs
         
         ! special list of z fractions
         s% z_fraction_li = z_fraction_li
         s% z_fraction_be = z_fraction_be
         s% z_fraction_b  = z_fraction_b
         s% z_fraction_c  = z_fraction_c
         s% z_fraction_n  = z_fraction_n
         s% z_fraction_o  = z_fraction_o
         s% z_fraction_f  = z_fraction_f
         s% z_fraction_ne = z_fraction_ne
         s% z_fraction_na = z_fraction_na
         s% z_fraction_mg = z_fraction_mg
         s% z_fraction_al = z_fraction_al
         s% z_fraction_si = z_fraction_si
         s% z_fraction_p  = z_fraction_p
         s% z_fraction_s  = z_fraction_s
         s% z_fraction_cl = z_fraction_cl
         s% z_fraction_ar = z_fraction_ar
         s% z_fraction_k  = z_fraction_k
         s% z_fraction_ca = z_fraction_ca
         s% z_fraction_sc = z_fraction_sc
         s% z_fraction_ti = z_fraction_ti
         s% z_fraction_v  = z_fraction_v
         s% z_fraction_cr = z_fraction_cr
         s% z_fraction_mn = z_fraction_mn
         s% z_fraction_fe = z_fraction_fe
         s% z_fraction_co = z_fraction_co
         s% z_fraction_ni = z_fraction_ni
         s% z_fraction_cu = z_fraction_cu
         s% z_fraction_zn = z_fraction_zn
         
         s% pure_fe56_limit = pure_fe56_limit
   
         ! automatic stops for mass loss/gain
         s% max_star_mass_for_gain = max_star_mass_for_gain
         s% min_star_mass_for_loss = min_star_mass_for_loss
         
         ! extra power source
         s% extra_power_source = extra_power_source
         
         ! relaxation parameters
         s% relax_dlnZ = relax_dlnZ
         s% relax_dY = relax_dY
         
         ! mesh adjustment
         s% remesh_log_L_nuc_burn_min = remesh_log_L_nuc_burn_min
         s% show_mesh_changes = show_mesh_changes
         s% okay_to_remesh = okay_to_remesh
         s% remesh_cnt = remesh_cnt
         s% max_allowed_nz = max_allowed_nz
         s% mesh_max_allowed_ratio = mesh_max_allowed_ratio
         s% max_delta_x_for_merge = max_delta_x_for_merge
         s% mesh_dump_call_number = mesh_dump_call_number
         
         s% mesh_adjust_use_quadratic = mesh_adjust_use_quadratic
         s% mesh_adjust_get_T_from_E = mesh_adjust_get_T_from_E
         s% mesh_interpolate_xa = mesh_interpolate_xa

         s% max_dq = max_dq
         s% min_dq = min_dq
         s% mesh_min_dlnR = mesh_min_dlnR
         s% merge_if_dlnR_too_small = merge_if_dlnR_too_small
         s% mesh_min_dr_div_cs = mesh_min_dr_div_cs
         s% merge_if_dr_div_cs_too_small = merge_if_dr_div_cs_too_small

         s% max_center_cell_dq = max_center_cell_dq
         s% min_center_cell_dq = min_center_cell_dq
         s% max_surface_cell_dq = max_surface_cell_dq
         s% max_num_subcells = max_num_subcells
         s% max_num_merge_cells = max_num_merge_cells

         s% mesh_delta_coeff = mesh_delta_coeff
         s% mesh_delta_coeff_pre_ms = mesh_delta_coeff_pre_ms
         s% mesh_Pgas_div_P_exponent = mesh_Pgas_div_P_exponent
         
         s% remesh_dt_limit = remesh_dt_limit

   		s% P_function_weight = P_function_weight
         
         s% xtra_coef_above_xtrans = xtra_coef_above_xtrans
         s% xtra_coef_below_xtrans = xtra_coef_below_xtrans
         s% xtra_dist_above_xtrans = xtra_dist_above_xtrans
         
         s% xtra_coef_czb_full_on = xtra_coef_czb_full_on
         s% xtra_coef_czb_full_off = xtra_coef_czb_full_off         
   		   		
         s% xtra_coef_a_l_nb_czb = xtra_coef_a_l_nb_czb
         s% xtra_coef_a_l_hb_czb = xtra_coef_a_l_hb_czb
         s% xtra_coef_a_l_heb_czb = xtra_coef_a_l_heb_czb
         s% xtra_coef_a_l_zb_czb = xtra_coef_a_l_zb_czb

         s% xtra_coef_b_l_nb_czb = xtra_coef_b_l_nb_czb
         s% xtra_coef_b_l_hb_czb = xtra_coef_b_l_hb_czb
         s% xtra_coef_b_l_heb_czb = xtra_coef_b_l_heb_czb
         s% xtra_coef_b_l_zb_czb = xtra_coef_b_l_zb_czb

         s% xtra_coef_a_u_nb_czb = xtra_coef_a_u_nb_czb
         s% xtra_coef_a_u_hb_czb = xtra_coef_a_u_hb_czb
         s% xtra_coef_a_u_heb_czb = xtra_coef_a_u_heb_czb
         s% xtra_coef_a_u_zb_czb = xtra_coef_a_u_zb_czb

         s% xtra_coef_b_u_nb_czb = xtra_coef_b_u_nb_czb
         s% xtra_coef_b_u_hb_czb = xtra_coef_b_u_hb_czb
         s% xtra_coef_b_u_heb_czb = xtra_coef_b_u_heb_czb
         s% xtra_coef_b_u_zb_czb = xtra_coef_b_u_zb_czb

         s% xtra_dist_a_l_nb_czb = xtra_dist_a_l_nb_czb
         s% xtra_dist_a_l_hb_czb = xtra_dist_a_l_hb_czb
         s% xtra_dist_a_l_heb_czb = xtra_dist_a_l_heb_czb
         s% xtra_dist_a_l_zb_czb = xtra_dist_a_l_zb_czb

         s% xtra_dist_b_l_nb_czb = xtra_dist_b_l_nb_czb
         s% xtra_dist_b_l_hb_czb = xtra_dist_b_l_hb_czb
         s% xtra_dist_b_l_heb_czb = xtra_dist_b_l_heb_czb
         s% xtra_dist_b_l_zb_czb = xtra_dist_b_l_zb_czb

         s% xtra_dist_a_u_nb_czb = xtra_dist_a_u_nb_czb
         s% xtra_dist_a_u_hb_czb = xtra_dist_a_u_hb_czb
         s% xtra_dist_a_u_heb_czb = xtra_dist_a_u_heb_czb
         s% xtra_dist_a_u_zb_czb = xtra_dist_a_u_zb_czb

         s% xtra_dist_b_u_nb_czb = xtra_dist_b_u_nb_czb
         s% xtra_dist_b_u_hb_czb = xtra_dist_b_u_hb_czb
         s% xtra_dist_b_u_heb_czb = xtra_dist_b_u_heb_czb
         s% xtra_dist_b_u_zb_czb = xtra_dist_b_u_zb_czb
         
         s% xtra_coef_os_full_on = xtra_coef_os_full_on
         s% xtra_coef_os_full_off = xtra_coef_os_full_off

         s% xtra_coef_os_above_nonburn = xtra_coef_os_above_nonburn
         s% xtra_coef_os_below_nonburn = xtra_coef_os_below_nonburn
         s% xtra_coef_os_above_burn_h = xtra_coef_os_above_burn_h
         s% xtra_coef_os_below_burn_h = xtra_coef_os_below_burn_h
         s% xtra_coef_os_above_burn_he = xtra_coef_os_above_burn_he
         s% xtra_coef_os_below_burn_he = xtra_coef_os_below_burn_he
         s% xtra_coef_os_above_burn_z = xtra_coef_os_above_burn_z
         s% xtra_coef_os_below_burn_z = xtra_coef_os_below_burn_z
         
         s% xtra_dist_os_above_nonburn = xtra_dist_os_above_nonburn
         s% xtra_dist_os_below_nonburn = xtra_dist_os_below_nonburn
         s% xtra_dist_os_above_burn_h = xtra_dist_os_above_burn_h
         s% xtra_dist_os_below_burn_h = xtra_dist_os_below_burn_h
         s% xtra_dist_os_above_burn_he = xtra_dist_os_above_burn_he
         s% xtra_dist_os_below_burn_he = xtra_dist_os_below_burn_he
         s% xtra_dist_os_above_burn_z = xtra_dist_os_above_burn_z
         s% xtra_dist_os_below_burn_z = xtra_dist_os_below_burn_z


         s% mesh_logX_species = mesh_logX_species
         s% mesh_logX_min_for_extra = mesh_logX_min_for_extra
         s% mesh_dlogX_dlogP_extra = mesh_dlogX_dlogP_extra
         s% mesh_dlogX_dlogP_full_on = mesh_dlogX_dlogP_full_on
         s% mesh_dlogX_dlogP_full_off = mesh_dlogX_dlogP_full_off

         s% convective_bdy_min_dt_yrs = convective_bdy_min_dt_yrs
         s% convective_bdy_weight = convective_bdy_weight
         s% convective_bdy_dq_limit = convective_bdy_dq_limit
         
         s% mesh_dlog_eps_min_for_extra = mesh_dlog_eps_min_for_extra
         s% mesh_dlog_eps_dlogP_full_on = mesh_dlog_eps_dlogP_full_on
         s% mesh_dlog_eps_dlogP_full_off = mesh_dlog_eps_dlogP_full_off

         s% mesh_dlog_pp_dlogP_extra = mesh_dlog_pp_dlogP_extra
         s% mesh_dlog_cno_dlogP_extra = mesh_dlog_cno_dlogP_extra
         s% mesh_dlog_3alf_dlogP_extra = mesh_dlog_3alf_dlogP_extra
      
         s% mesh_dlog_burn_c_dlogP_extra = mesh_dlog_burn_c_dlogP_extra
         s% mesh_dlog_burn_n_dlogP_extra = mesh_dlog_burn_n_dlogP_extra
         s% mesh_dlog_burn_o_dlogP_extra = mesh_dlog_burn_o_dlogP_extra
         s% mesh_dlog_burn_ne_dlogP_extra = mesh_dlog_burn_ne_dlogP_extra
         s% mesh_dlog_burn_na_dlogP_extra = mesh_dlog_burn_na_dlogP_extra
         s% mesh_dlog_burn_mg_dlogP_extra = mesh_dlog_burn_mg_dlogP_extra
         s% mesh_dlog_burn_si_dlogP_extra = mesh_dlog_burn_si_dlogP_extra
         s% mesh_dlog_burn_s_dlogP_extra = mesh_dlog_burn_s_dlogP_extra
         s% mesh_dlog_burn_ar_dlogP_extra = mesh_dlog_burn_ar_dlogP_extra
         s% mesh_dlog_burn_ca_dlogP_extra = mesh_dlog_burn_ca_dlogP_extra
         s% mesh_dlog_burn_ti_dlogP_extra = mesh_dlog_burn_ti_dlogP_extra
         s% mesh_dlog_burn_cr_dlogP_extra = mesh_dlog_burn_cr_dlogP_extra
         s% mesh_dlog_burn_fe_dlogP_extra = mesh_dlog_burn_fe_dlogP_extra
      
         s% mesh_dlog_cc_dlogP_extra = mesh_dlog_cc_dlogP_extra
         s% mesh_dlog_co_dlogP_extra = mesh_dlog_co_dlogP_extra
         s% mesh_dlog_oo_dlogP_extra = mesh_dlog_oo_dlogP_extra
      
         s% mesh_dlog_pnhe4_dlogP_extra = mesh_dlog_pnhe4_dlogP_extra
         s% mesh_dlog_photo_dlogP_extra = mesh_dlog_photo_dlogP_extra
         s% mesh_dlog_other_dlogP_extra = mesh_dlog_other_dlogP_extra

   		s% T_function1_weight = T_function1_weight
   		s% T_function2_weight = T_function2_weight
   		s% T_function2_param = T_function2_param
      
   		s% R_function_weight = R_function_weight
   		s% R_function_param = R_function_param
      
   		s% R_function2_weight = R_function2_weight
   		s% R_function2_param1 = R_function2_param1
   		s% R_function2_param2 = R_function2_param2
      
   		s% M_function_weight = M_function_weight
   		s% M_function_param = M_function_param
   		
   		s% gradT_function_weight = gradT_function_weight
   		s% omega_function_weight = omega_function_weight
         
   		s% xa_function_species = xa_function_species
   		s% xa_function_weight = xa_function_weight
   		s% xa_function_param = xa_function_param
   		s% xa_mesh_delta_coeff = xa_mesh_delta_coeff


         ! nuclear reaction parameters
         s% screening_mode = screening_mode
         
         s% net_logTcut_lo = net_logTcut_lo
         s% net_logTcut_lim = net_logTcut_lim
         s% suppress_dubious_PP_burning = suppress_dubious_PP_burning
         s% suppress_dubious_N_burning = suppress_dubious_N_burning
         s% max_abar_for_burning = max_abar_for_burning

         s% eps_nuc_factor = eps_nuc_factor
         s% net_rate_factor = net_rate_factor
         s% dxdt_nuc_factor = dxdt_nuc_factor
         
         
         s% mix_factor = mix_factor
         
         s% sig_term_limit = sig_term_limit
         s% am_sig_term_limit = am_sig_term_limit
         s% am_D_mix_factor = am_D_mix_factor
         s% am_gradmu_factor = am_gradmu_factor
         s% am_nu_factor = am_nu_factor

         s% D_DSI_factor = D_DSI_factor
         s% D_SH_factor = D_SH_factor
         s% D_SSI_factor = D_SSI_factor
         s% D_ES_factor = D_ES_factor
         s% D_GSF_factor = D_GSF_factor
         s% D_ST_factor = D_ST_factor
         s% nu_ST_factor = nu_ST_factor
         
         s% dq_smooth_ST = dq_smooth_ST
         s% dq_smooth_DSI = dq_smooth_DSI
         s% dq_smooth_SSI = dq_smooth_SSI
         s% dq_smooth_SH = dq_smooth_SH
         s% dq_smooth_GSF = dq_smooth_GSF
         s% dq_smooth_ES = dq_smooth_ES
         
         s% set_uniform_am_nu = set_uniform_am_nu
         s% uniform_am_nu = uniform_am_nu
         
         s% set_min_am_nu = set_min_am_nu
         s% min_am_nu = min_am_nu
         s% min_center_Ye_for_min_am_nu = min_center_Ye_for_min_am_nu
         
         s% set_min_D_mix = set_min_D_mix
         s% min_D_mix = min_D_mix
         s% min_center_Ye_for_min_D_mix = min_center_Ye_for_min_D_mix
         s% reaction_neuQs_factor = reaction_neuQs_factor

         s% net_pp_rate_factor = net_pp_rate_factor
         s% net_cno_rate_factor = net_cno_rate_factor
         s% net_3alf_rate_factor = net_3alf_rate_factor
         
         s% net_burn_c_rate_factor = net_burn_c_rate_factor
         s% net_burn_n_rate_factor = net_burn_n_rate_factor      
         s% net_burn_o_rate_factor = net_burn_o_rate_factor
         s% net_burn_ne_rate_factor = net_burn_ne_rate_factor
         s% net_burn_na_rate_factor = net_burn_na_rate_factor
         s% net_burn_mg_rate_factor = net_burn_mg_rate_factor
         s% net_burn_si_rate_factor = net_burn_si_rate_factor
         s% net_burn_s_rate_factor = net_burn_s_rate_factor
         s% net_burn_ar_rate_factor = net_burn_ar_rate_factor
         s% net_burn_ca_rate_factor = net_burn_ca_rate_factor
         s% net_burn_ti_rate_factor = net_burn_ti_rate_factor
         s% net_burn_cr_rate_factor = net_burn_cr_rate_factor
         s% net_burn_fe_rate_factor = net_burn_fe_rate_factor
         
         s% net_cc_rate_factor = net_cc_rate_factor
         s% net_co_rate_factor = net_co_rate_factor
         s% net_oo_rate_factor = net_oo_rate_factor

         s% net_pnhe4_rate_factor = net_pnhe4_rate_factor
         s% net_photo_rate_factor = net_photo_rate_factor

         s% net_other_rate_factor = net_other_rate_factor
         
         s% rate_factor_for_fe56ec_to_cr56 = rate_factor_for_fe56ec_to_cr56
         s% max_center_cr56_for_fe56ec = max_center_cr56_for_fe56ec
         
         s% category_factors(:) = 1
         s% category_factors(ipp) = net_pp_rate_factor
         s% category_factors(icno) = net_cno_rate_factor
         s% category_factors(i3alf) = net_3alf_rate_factor
         
         s% category_factors(i_burn_c) = net_burn_c_rate_factor
         s% category_factors(i_burn_n) = net_burn_n_rate_factor      
         s% category_factors(i_burn_o) = net_burn_o_rate_factor
         s% category_factors(i_burn_ne) = net_burn_ne_rate_factor
         s% category_factors(i_burn_na) = net_burn_na_rate_factor
         s% category_factors(i_burn_mg) = net_burn_mg_rate_factor
         s% category_factors(i_burn_si) = net_burn_si_rate_factor
         s% category_factors(i_burn_s) = net_burn_s_rate_factor
         s% category_factors(i_burn_ar) = net_burn_ar_rate_factor
         s% category_factors(i_burn_ca) = net_burn_ca_rate_factor
         s% category_factors(i_burn_ti) = net_burn_ti_rate_factor
         s% category_factors(i_burn_cr) = net_burn_cr_rate_factor
         s% category_factors(i_burn_fe) = net_burn_fe_rate_factor
         
         s% category_factors(icc) = net_cc_rate_factor
         s% category_factors(ico) = net_co_rate_factor
         s% category_factors(ioo) = net_oo_rate_factor

         s% category_factors(ipnhe4) = net_pnhe4_rate_factor
         s% category_factors(iphoto) = net_photo_rate_factor
         s% category_factors(iother) = net_other_rate_factor
            
         ! element diffusion parameters
         s% diffusion_steps_limit = diffusion_steps_limit
         s% do_element_diffusion = do_element_diffusion
         s% diffusion_min_dq_at_surface = diffusion_min_dq_at_surface
         s% diffusion_dt_limit = diffusion_dt_limit
         s% diffusion_atol = diffusion_atol
         s% diffusion_rtol = diffusion_rtol
         s% diffusion_maxsteps = diffusion_maxsteps
         s% diffusion_v_max = diffusion_v_max
         s% diffusion_min_rho_face = diffusion_min_rho_face
         s% diffusion_gamma_full_off = diffusion_gamma_full_off
         s% diffusion_gamma_full_on = diffusion_gamma_full_on
         s% diffusion_T_full_off = diffusion_T_full_off
         s% diffusion_T_full_on = diffusion_T_full_on
         s% diffusion_Y_full_off = diffusion_Y_full_off
         s% diffusion_Y_full_on = diffusion_Y_full_on
         s% diffusion_X_full_off = diffusion_X_full_off
         s% diffusion_X_full_on = diffusion_X_full_on
         s% diffusion_D_mix_limit = diffusion_D_mix_limit
         s% diffusion_calculates_ionization = diffusion_calculates_ionization
         s% diffusion_min_Y_for_fe_in_he = diffusion_min_Y_for_fe_in_he
         s% show_diffusion_info = show_diffusion_info
         s% diffusion_num_classes = diffusion_num_classes
         s% diffusion_class_representative = diffusion_class_representative
         s% diffusion_class_A_max = diffusion_class_A_max
         s% diffusion_class_typical_charge = diffusion_class_typical_charge

         ! opacity controls
         s% base_fC = base_fC
         s% base_fN = base_fN
         s% base_fO = base_fO
         s% base_Z = base_Z
         s% use_CO_enhanced_opacities = use_CO_enhanced_opacities
         s% cubic_interpolation_in_X = cubic_interpolation_in_X
         s% cubic_interpolation_in_Z = cubic_interpolation_in_Z
         s% include_electron_conduction = include_electron_conduction

         ! hydro_seulex
         s% trace_seulex = trace_seulex
         s% seulex_kmax = seulex_kmax
         s% seulex_dt_by_err_ratio_avg = seulex_dt_by_err_ratio_avg
         s% seulex_dt_fac1 = seulex_dt_fac1
         s% seulex_dt_fac2 = seulex_dt_fac2
         s% seulex_dt_fac3 = seulex_dt_fac3
         s% seulex_dt_fac4 = seulex_dt_fac4
         s% seulex_dt_safe1 = seulex_dt_safe1
         s% seulex_dt_safe2 = seulex_dt_safe2
         s% seulex_wk_set_vars = seulex_wk_set_vars
         s% seulex_wk_eval_equ = seulex_wk_eval_equ
         s% seulex_wk_prep_mtx = seulex_wk_prep_mtx
         s% seulex_wk_solve_mtx = seulex_wk_solve_mtx
         s% seulex_step_size_sequence = seulex_step_size_sequence

         s% include_L_in_error_est = include_L_in_error_est
         s% include_v_in_error_est = include_v_in_error_est
         s% include_lnddot_in_error_est = include_lnddot_in_error_est
         s% include_lnTdot_in_error_est = include_lnTdot_in_error_est
                  
         ! hydro parameters

         s% D_norm_kappa = D_norm_kappa
         s% D_norm_alpha = D_norm_alpha
         s% D_norm_atol = D_norm_atol
         s% D_norm_rtol = D_norm_rtol
         s% D_norm_skip_L = D_norm_skip_L
         s% D_norm_skip_v = D_norm_skip_v
         s% D_norm_skip_lnddot = D_norm_skip_lnddot
         s% D_norm_skip_lnTdot = D_norm_skip_lnTdot
         s% doing_hydro_newton = doing_hydro_newton
         s% use_quad_newton = use_quad_newton
         s% use_transformed_L = use_transformed_L
         
         s% min_FL_offset = min_FL_offset
         
         s% opacity_factor = opacity_factor
         s% opacity_max = opacity_max
         s% opacity_max0 = opacity_max0
         s% opacity_max1 = opacity_max1
         s% opacity_max_log_r_frac = opacity_max_log_r_frac
         s% min_cno_for_kap_limit = min_cno_for_kap_limit
         
         s% kap_Pgas_div_P_limit = kap_Pgas_div_P_limit
         s% kap_max_q_for_Pgas_div_P_limit = kap_max_q_for_Pgas_div_P_limit
         s% kap_min_q_for_Pgas_div_P_limit = kap_min_q_for_Pgas_div_P_limit
         s% kap_Pgas_div_P_alt_kap = kap_Pgas_div_P_alt_kap

         s% eps_nuc_factor = eps_nuc_factor
         s% net_rate_factor = net_rate_factor
         s% dxdt_nuc_factor = dxdt_nuc_factor
         s% non_nuc_neu_factor = non_nuc_neu_factor
         s% accel_factor = accel_factor
         s% surf_bc_offset_factor = surf_bc_offset_factor
         s% use_gr_factors = use_gr_factors
         s% eps_grav_factor = eps_grav_factor
         s% use_lnE_for_eps_grav = use_lnE_for_eps_grav
         s% use_artificial_viscosity = use_artificial_viscosity
         s% l1_coef = l1_coef
         s% l2_coef = l2_coef
         s% use_artificial_v_damping = use_artificial_v_damping

         ! solvers
         s% operator_coupling_choice = operator_coupling_choice
         s% dynamics_coupling_choice = dynamics_coupling_choice
         
         s% op_split_burn_trace = op_split_burn_trace
         s% op_split_burn_clip = op_split_burn_clip
         s% op_split_burn_atol = op_split_burn_atol
         s% op_split_burn_rtol = op_split_burn_rtol
         s% op_split_burn_maxsteps = op_split_burn_maxsteps
         s% op_split_burn_solver1 = op_split_burn_solver1
         s% op_split_burn_solver2 = op_split_burn_solver2
         s% op_split_decsol_switch = op_split_decsol_switch
         s% op_split_small_mtx_decsol = op_split_small_mtx_decsol
         s% op_split_large_mtx_decsol = op_split_large_mtx_decsol
         
         s% op_split_mix_maxsteps = op_split_mix_maxsteps
         s% op_split_mix_minsteps = op_split_mix_minsteps
         s% op_split_mix_trace = op_split_mix_trace
         s% op_split_mix_atol = op_split_mix_atol
         s% op_split_mix_rtol = op_split_mix_rtol

         s% op_split_burn_mix_trace = op_split_burn_mix_trace
         s% op_split_trace = op_split_trace
         s% op_split_do_predict_struct = op_split_do_predict_struct
         s% op_split_reconverge_hydro = op_split_reconverge_hydro
         
         s% split_mtx_solve_rtol = split_mtx_solve_rtol
         s% split_mtx_solve_atol = split_mtx_solve_atol
         s% split_mtx_solve_max_iters = split_mtx_solve_max_iters
         
         s% hydro_err_ratio_rtol = hydro_err_ratio_rtol
         s% hydro_err_ratio_atol = hydro_err_ratio_atol

         s% tol_correction_norm = tol_correction_norm
         s% tol_max_correction = tol_max_correction
         s% tol_correction_norm_alt = tol_correction_norm_alt
         s% tol_max_correction_alt = tol_max_correction_alt
         s% correction_xa_limit = correction_xa_limit
         
         s% tol_residual_norm1 = tol_residual_norm1
         s% tol_max_residual1 = tol_max_residual1
         s% tol_residual_norm2 = tol_residual_norm2
         s% tol_max_residual2 = tol_max_residual2
         s% tol_residual_norm3 = tol_residual_norm3
         s% tol_max_residual3 = tol_max_residual3
         
         s% min_for_check_D_norm_converging = min_for_check_D_norm_converging
         
         s% max_iterations_for_jacobian = max_iterations_for_jacobian
         s% refine_solution = refine_solution
         s% refine_mtx_solution = refine_mtx_solution

         s% small_mtx_decsol = small_mtx_decsol
         s% large_mtx_decsol = large_mtx_decsol
         s% hydro_decsol_switch = hydro_decsol_switch
         s% sparse_non_zero_max_factor = sparse_non_zero_max_factor
         s% thomas_blck_sprs_clip_lim = thomas_blck_sprs_clip_lim

         s% max_iter_for_resid_tol1 = max_iter_for_resid_tol1
         s% max_iter_for_resid_tol2 = max_iter_for_resid_tol2
         s% max_iter_for_resid_tol3 = max_iter_for_resid_tol3
         
         s% newton_itermin = newton_itermin
         
         s% max_xa_err_ratio_hard_limit = max_xa_err_ratio_hard_limit
         s% max_xa_err_ratio_rtol = max_xa_err_ratio_rtol
         s% max_xa_err_ratio_atol = max_xa_err_ratio_atol
         s% hydro_solver_name = hydro_solver_name

         s% tiny_corr_coeff_limit = tiny_corr_coeff_limit
         s% target_corr_factor = target_corr_factor
         s% scale_correction_norm = scale_correction_norm
         s% corr_param_factor = corr_param_factor
         s% scale_max_correction = scale_max_correction
         
         s% corr_norm_jump_limit = corr_norm_jump_limit
         s% max_corr_jump_limit = max_corr_jump_limit
         s% resid_norm_jump_limit = resid_norm_jump_limit
         s% max_resid_jump_limit = max_resid_jump_limit
         
         s% corr_coeff_limit = corr_coeff_limit
         s% slope_alert_level = slope_alert_level
         s% slope_crisis_level = slope_crisis_level
         s% tiny_corr_factor = tiny_corr_factor
         s% matrix_type = matrix_type

         s% max_tries = max_tries
         s% max_tries1 = max_tries1
         s% max_tries_for_retry = max_tries_for_retry
         s% max_tries_after_backup = max_tries_after_backup
         s% max_tries_after_backup2 = max_tries_after_backup2
         s% retry_limit = retry_limit
         
         s% jacobian_clip_limit = jacobian_clip_limit
         s% min_xa_hard_limit = min_xa_hard_limit
         s% xa_clip_limit = xa_clip_limit
         s% sum_xa_tolerance = sum_xa_tolerance
         s% report_hydro_solver_progress = report_hydro_solver_progress
         s% hydro_dump_call_number = hydro_dump_call_number
         s% hydro_numerical_jacobian = hydro_numerical_jacobian
         s% hydro_jacobian_nzlo = hydro_jacobian_nzlo
         s% hydro_jacobian_nzhi = hydro_jacobian_nzhi
         s% hydro_check_everything = hydro_check_everything
         s% hydro_inspectB_flag = hydro_inspectB_flag
         s% hydro_show_correction_info = hydro_show_correction_info
         s% hydro_save_numjac_plot_data = hydro_save_numjac_plot_data

         ! timestep
         s% max_timestep = max_timestep
         s% max_years_for_timestep = max_years_for_timestep
         s% min_timestep_factor = min_timestep_factor
         s% max_timestep_factor = max_timestep_factor
         s% timestep_factor_for_backups = timestep_factor_for_backups
         s% backup_hold = backup_hold
         s% retry_hold = retry_hold
         s% DUP_varcontrol_factor = DUP_varcontrol_factor
         s% timestep_dt_factor = timestep_dt_factor
         s% timestep_limit_factor = timestep_limit_factor
         s% varcontrol_target = varcontrol_target
         s% varcontrol_target_max = varcontrol_target_max
         s% backup_drop_varcontrol_target = backup_drop_varcontrol_target
         s% backup_drop_vc_target_steps = backup_drop_vc_target_steps
         s% xa_scale = xa_scale
         
         s% jacobian_limit = jacobian_limit
         s% jacobian_hard_limit = jacobian_hard_limit
         s% diffusion_steps_limit = diffusion_steps_limit
         s% diffusion_steps_hard_limit = diffusion_steps_hard_limit
         
         s% dX_mix_dist_limit = dX_mix_dist_limit
         
         s% dH_limit_min_H = dH_limit_min_H
         s% dH_limit = dH_limit
         s% dH_hard_limit = dH_hard_limit
         s% dH_div_H_limit_min_H = dH_div_H_limit_min_H
         s% dH_div_H_limit = dH_div_H_limit
         s% dH_div_H_hard_limit = dH_div_H_hard_limit
         s% dH_decreases_only = dH_decreases_only

         s% dHe_limit_min_He = dHe_limit_min_He
         s% dHe_limit = dHe_limit
         s% dHe_hard_limit = dHe_hard_limit
         s% dHe_div_He_limit_min_He = dHe_div_He_limit_min_He
         s% dHe_div_He_limit = dHe_div_He_limit
         s% dHe_div_He_hard_limit = dHe_div_He_hard_limit
         s% dHe_decreases_only = dHe_decreases_only

         s% dHe3_limit_min_He3 = dHe3_limit_min_He3
         s% dHe3_limit = dHe3_limit
         s% dHe3_hard_limit = dHe3_hard_limit
         s% dHe3_div_He3_limit_min_He3 = dHe3_div_He3_limit_min_He3
         s% dHe3_div_He3_limit = dHe3_div_He3_limit
         s% dHe3_div_He3_hard_limit = dHe3_div_He3_hard_limit
         s% dHe3_decreases_only = dHe3_decreases_only

         s% dX_limit_min_X = dX_limit_min_X
         s% dX_limit = dX_limit
         s% dX_hard_limit = dX_hard_limit
         s% dX_div_X_limit_min_X = dX_div_X_limit_min_X
         s% dX_div_X_limit = dX_div_X_limit
         s% dX_div_X_hard_limit = dX_div_X_hard_limit
         s% dX_decreases_only = dX_decreases_only
         
         s% dprctd_dX_nuc_min_X_limit = dprctd_dX_nuc_min_X_limit
         s% dprctd_dX_nuc_max_A_limit = dprctd_dX_nuc_max_A_limit
         s% dprctd_dX_nuc_limit = dprctd_dX_nuc_limit
         s% dprctd_dX_nuc_hard_limit = dprctd_dX_nuc_hard_limit
         s% dprctd_dX_nuc_factor = dprctd_dX_nuc_factor
         s% dprctd_dX_nuc_X_limit = dprctd_dX_nuc_X_limit
         s% dprctd_dX_nuc_dX_div_del_limit = dprctd_dX_nuc_dX_div_del_limit
         s% dprctd_dX_nuc_min_yrs_for_dt = dprctd_dX_nuc_min_yrs_for_dt
         
         s% dX_nuc_drop_min_X_limit = dX_nuc_drop_min_X_limit
         s% dX_nuc_drop_max_A_limit = dX_nuc_drop_max_A_limit
         s% dX_nuc_drop_limit = dX_nuc_drop_limit
         s% dX_nuc_drop_hard_limit = dX_nuc_drop_hard_limit
         s% dX_nuc_drop_min_yrs_for_dt = dX_nuc_drop_min_yrs_for_dt
         
         s% dL_div_L_limit_min_L = dL_div_L_limit_min_L
         s% dL_div_L_limit = dL_div_L_limit
         s% dL_div_L_hard_limit = dL_div_L_hard_limit

         s% delta_lgP_limit = delta_lgP_limit
         s% delta_lgP_hard_limit = delta_lgP_hard_limit
         s% delta_lgRho_limit = delta_lgRho_limit
         s% delta_lgRho_hard_limit = delta_lgRho_hard_limit
         s% delta_lgT_limit = delta_lgT_limit
         s% delta_lgT_hard_limit = delta_lgT_hard_limit
         s% delta_lgR_limit = delta_lgR_limit
         s% delta_lgR_hard_limit = delta_lgR_hard_limit
         
         s% d_deltaR_shrink_limit = d_deltaR_shrink_limit
         s% d_deltaR_shrink_hard_limit = d_deltaR_shrink_hard_limit
         s% d_deltaR_grow_limit = d_deltaR_grow_limit
         s% d_deltaR_grow_hard_limit = d_deltaR_grow_hard_limit

         s% delta_lgL_nuc_cat_limit = delta_lgL_nuc_cat_limit
         s% delta_lgL_nuc_cat_hard_limit = delta_lgL_nuc_cat_hard_limit
         s% lgL_nuc_cat_burn_min = lgL_nuc_cat_burn_min
         s% lgL_nuc_mix_dist_limit = lgL_nuc_mix_dist_limit
         
         s% check_delta_lgL_pp = check_delta_lgL_pp
         s% check_delta_lgL_cno = check_delta_lgL_cno
         s% check_delta_lgL_3alf = check_delta_lgL_3alf
            
         s% check_delta_lgL_burn_c = check_delta_lgL_burn_c
         s% check_delta_lgL_burn_n = check_delta_lgL_burn_n
         s% check_delta_lgL_burn_o = check_delta_lgL_burn_o
         s% check_delta_lgL_burn_ne = check_delta_lgL_burn_ne
         s% check_delta_lgL_burn_na = check_delta_lgL_burn_na
         s% check_delta_lgL_burn_mg = check_delta_lgL_burn_mg
         s% check_delta_lgL_burn_si = check_delta_lgL_burn_si
         s% check_delta_lgL_burn_s = check_delta_lgL_burn_s
         s% check_delta_lgL_burn_ar = check_delta_lgL_burn_ar
         s% check_delta_lgL_burn_ca = check_delta_lgL_burn_ca
         s% check_delta_lgL_burn_ti = check_delta_lgL_burn_ti
         s% check_delta_lgL_burn_cr = check_delta_lgL_burn_cr
         s% check_delta_lgL_burn_fe = check_delta_lgL_burn_fe
         
         s% check_delta_lgL_cc = check_delta_lgL_cc
         s% check_delta_lgL_co = check_delta_lgL_co
         s% check_delta_lgL_oo = check_delta_lgL_oo

         s% delta_lgL_H_limit = delta_lgL_H_limit
         s% delta_lgL_H_hard_limit = delta_lgL_H_hard_limit
         s% lgL_H_burn_min = lgL_H_burn_min
         s% lgL_H_drop_factor = lgL_H_drop_factor

         s% delta_lgL_He_limit = delta_lgL_He_limit
         s% delta_lgL_He_hard_limit = delta_lgL_He_hard_limit
         s% lgL_He_burn_min = lgL_He_burn_min
         s% lgL_He_drop_factor = lgL_He_drop_factor

         s% delta_lgL_z_limit = delta_lgL_z_limit
         s% delta_lgL_z_hard_limit = delta_lgL_z_hard_limit
         s% lgL_z_burn_min = lgL_z_burn_min
         s% lgL_z_drop_factor = lgL_z_drop_factor

         s% delta_lgL_nuc_limit = delta_lgL_nuc_limit
         s% delta_lgL_nuc_hard_limit = delta_lgL_nuc_hard_limit
         s% lgL_nuc_burn_min = lgL_nuc_burn_min
         s% lgL_nuc_drop_factor = lgL_nuc_drop_factor
                   
         s% delta_lgRho_cntr_limit = delta_lgRho_cntr_limit
         s% delta_lgRho_cntr_hard_limit = delta_lgRho_cntr_hard_limit
         
         s% delta_lgT_cntr_limit = delta_lgT_cntr_limit
         s% delta_lgT_cntr_hard_limit = delta_lgT_cntr_hard_limit
                   
         s% delta_lg_XH_cntr_min = delta_lg_XH_cntr_min
         s% delta_lg_XH_cntr_max = delta_lg_XH_cntr_max
         s% delta_lg_XH_cntr_limit = delta_lg_XH_cntr_limit
         s% delta_lg_XH_cntr_hard_limit = delta_lg_XH_cntr_hard_limit
                   
         s% delta_lg_XHe_cntr_min = delta_lg_XHe_cntr_min
         s% delta_lg_XHe_cntr_max = delta_lg_XHe_cntr_max
         s% delta_lg_XHe_cntr_limit = delta_lg_XHe_cntr_limit
         s% delta_lg_XHe_cntr_hard_limit = delta_lg_XHe_cntr_hard_limit
      
         s% delta_lgTeff_limit = delta_lgTeff_limit
         s% delta_lgTeff_hard_limit = delta_lgTeff_hard_limit
         
         s% delta_lgL_limit = delta_lgL_limit
         s% delta_lgL_hard_limit = delta_lgL_hard_limit
         
         s% delta_HR_ds_L = delta_HR_ds_L
         s% delta_HR_ds_Teff = delta_HR_ds_Teff
         s% delta_HR_limit = delta_HR_limit
         s% delta_HR_hard_limit = delta_HR_hard_limit
         
         s% delta_lg_total_J_limit = delta_lg_total_J_limit
         s% delta_lg_total_J_hard_limit = delta_lg_total_J_hard_limit

         s% delta_op_split_limit = delta_op_split_limit
         s% delta_op_split_hard_limit = delta_op_split_hard_limit
         
         s% delta_op_split_Lnuc_limit = delta_op_split_Lnuc_limit
         s% delta_op_split_center_h1_limit = delta_op_split_center_h1_limit

         s% delta_lg_star_mass_limit = delta_lg_star_mass_limit
         s% delta_lg_star_mass_hard_limit = delta_lg_star_mass_hard_limit 
         
         s% L_div_CpTMdot_limit = L_div_CpTMdot_limit 
         s% L_div_CpTMdot_hard_limit = L_div_CpTMdot_hard_limit

         s% relax_hard_limits_after_backup = relax_hard_limits_after_backup
         s% relax_hard_limits_after_retry = relax_hard_limits_after_retry
         s% report_all_dt_limits = report_all_dt_limits
         s% report_why_dt_limits = report_why_dt_limits
         s% report_hydro_dt_info = report_hydro_dt_info
         s% report_dX_nuc_drop_dt_limits = report_dX_nuc_drop_dt_limits
         s% write_varcontrol_internals = write_varcontrol_internals
         
         ! controls for the evolve routine
         s% trace_evolve = trace_evolve

         
         ! misc
         s% zams_filename = zams_filename
         s% use_other_atm = use_other_atm
         s% use_other_diffusion = use_other_diffusion
         s% use_other_kap = use_other_kap
         s% use_other_eos = use_other_eos
         s% use_other_mlt = use_other_mlt
         s% use_other_mesh_functions = use_other_mesh_functions
         
         s% factor_for_recently_added = factor_for_recently_added
         s% show_info_for_recently_added = show_info_for_recently_added

         s% trace_solar_neutrinos = trace_solar_neutrinos
         
         s% x_ctrl = x_ctrl
         s% x_integer_ctrl = x_integer_ctrl
         s% x_logical_ctrl = x_logical_ctrl
         
         ! info for debugging
         s% stop_for_bugs = stop_for_bugs
         s% report_ierr = report_ierr

         s% diffusion_dump_call_number = diffusion_dump_call_number
         s% use_simple_es_for_kap = use_simple_es_for_kap

         
      end subroutine store_controls


      subroutine set_default_controls
         include 'star_defaults.dek'
         include 'private_defaults.dek'
      end subroutine set_default_controls


      end module ctrls_io

