
      module mod_bimd
      
      use bimdax
      
      implicit none


      ! jacobian evaluation
      ! if hnew<h the jacobian is not evaluated, if the estimated spectral
      ! radius is less than alfajac.
      real(dp), parameter :: alfajac=.1d0

      ! scaling factor used in the estimate of dj0.
      real(dp), parameter :: scalj0 = 1d-3, tolrhoj0_1 = 1d-1, toldj0 = 1d-8

      integer, parameter :: itmaxj0 = 3, itmaxj0_1 = 6

      real(dp), parameter :: tolrhoj4=5d-3

      ! if deltaj0/j0 > fatdj0 the jacobian must be evaluated.
      real(dp), parameter :: fatdj04 = 2d-2, fatdj04i = 5d-2

      ! factorization
      ! the factorization of theta is not computed if
      ! max(deltah1,deltah1sf)<hnew/h<deltah2
      real(dp), parameter :: deltah2_4 =1.10d0, deltah1_4sf =.90d0

      ! parameter cfat involved in computing deltah1 (see above).
      real(dp), parameter :: cfat4_1=-1.4487d0, cfat4_2=2.3593d0

      ! factors for determining the new stepsize in case of newton
      ! failure and large spectral radius, respectively.
      ! (in both cases, the order is decreased).
      real(dp), parameter :: facnocon=.5d0, faclro=.5d0

      ! max number of consecutive failures, after which a constant
      ! initial guess is used.
      integer, parameter :: flmx=1

      ! max number of consecutive failures, after which integration stops.
      integer, parameter :: flhlt=10

      ! maximum value of the spectral radius, for having failure.
      real(dp), parameter :: rhobad =.99d0

      ! parameters for the stop criterion, when the solution is 'small'.
      real(dp), parameter :: tolminy0=1d-2, tolminf0=1d-4, tolmaxf0=1d-3

      real(dp), parameter :: cscal4=16d0

      ! gamma
      real(dp), parameter :: gamma4 =.7387d0

      ! rhotilde
      real(dp), parameter :: rhot4 =.5021d0

      ! rhotildeinf
      real(dp), parameter :: rhoi4 =  .9201d0

      ! error estimate
      real(dp), parameter :: &
         vmax4_1 = 1d0/15d0, vmax4_2 = 1d0/4d0, vmax4_2_2 = 2d0/3d0


         
      ! set params for 4th order
      real(dp), parameter :: &
         gamma = gamma4, &
         rhot = rhot4, &
         rhoi = rhoi4, &
         fatdj0 = fatdj04, &
         fatdj0i = fatdj04i, &
         tolrhoj0 = tolrhoj4, &
         deltah2= deltah2_4, &
         deltah1sf = deltah1_4sf, &
         cfat1 = cfat4_1, &
         cfat2 = cfat4_2, &
         cscal = cscal4, &
         vmax(1:3) = (/ vmax4_1, gamma4*vmax4_2, gamma4*gamma4*vmax4_2_2 /)
         

      contains


      subroutine bim00( &
            m,fcn,jac,y0,f0,t0,tend, &
              h,rtol,atol,itol, &
              maxstep,itmax,uround,hmax, &
              facnewtv,facnsmall,facnrestr,facl,facr,sfty, &
              rhomuv,rhomlv, &
              nfeval,njeval,nlu,nlinsys,niter,nstep,naccept, &
              nfailerr,nfailnewt, &
              ipvt,t,y,f,theta,err,j0, &
              delj0,delj00,fj0,ej0,scal, &
              dd,tolestrapr,tolestrapa,scalextrap, &
              ijac,mljac,mujac,ldjac,ldlu,jband,ijob, &
              rpar,ipar,iout,solout,idid, &
              mas,mlmas,mumas,ldmas,mband, &
              index1,index2,m0,temp)

      external fcn,jac,mas,solout

      logical, intent(in) :: jband,mband
      
      integer, intent(in) :: &
              m,maxstep,itmax, &
              index1,index2, &
              mljac,mujac,ldjac,ldlu,ijob(2),ijac, &
              iout,itol,mlmas,mumas,ldmas

      integer, intent(inout) :: ipar(*)

      integer, intent(out) :: &
              ipvt(:),nfeval,njeval,nlu,nlinsys,niter,nstep, &
              naccept,nfailerr,nfailnewt,idid

      real(dp), intent(in) ::  &
              tend,rtol,atol(*),uround,hmax, &
              facnewtv,facnsmall,facnrestr,facl,facr, &
              tolestrapr,tolestrapa(:), &
              rhomuv,rhomlv,sfty

      real(dp), intent(inout) :: h,t0,y0(:),rpar(*)

      real(dp), intent(out) :: &
              t(:),f0(:),theta(:,:),j0(:,:),fj0(:),delj0(:), &
              delj00(:),y(:,:),f(:,:),err(:,:), &
              scal(:),dd(:,:),scalextrap(:), &
              ej0(:),m0(:,:),temp(:,:)




      integer :: i,j,it,maxit, &
              nfailconv,nord,info,irtrn,ierr,ierr0,mudif, &
              nfailcons,nsteps,nsing,nerror, &
              nferrcons,it0,indexd,minit
      real(dp) :: nerr,nerrup,nerrup1,nerrdown, &
              nerr0,nerrold,nerrstop,nerrloc,nerrloc0, &
              rho,rho0,rhomu,rhoml, &
              rhoold,hnew,hnup,hndn,h0,h00, &
              rath,ratrho,fi,esp,espup,espdn, &
              facnewt,hgamma,maxdelta,nf0,nf, &
              miny0,fminy0,maxf0, &
              nu, nuup, nu1, nuup1,hnup1,fi1, &
              scalj0_1,nj0,nj00,hj0,rhoj0,dj0,absy0, &
              deltah1,cfat3,rathh,hfatt,alfafatt,rhofatt,discr, &
              delt,ysafe,itnew,rhonew,cscal0, &
              csis,cfact,tnext
      logical :: jvai,last,extrap,extrap0,extraps, &
              caljac,calfact,success,restrict, &
              truejac,stagna,local_err_okay, &
              qinf,qinfj,qinff,nqinf,smallm, &
              nodj0,nodj00,isnan,error,estim,estim1



      call initializations

      call before_start_steps( &
            fcn,m,t0,y0,f0,ierr,rpar,ipar, &
            nfeval,idid,scalj0_1,scalextrap,hfatt,tolminy0,miny0)
      if (ierr /= 0 .or. idid /= 0) return


      do ! step loop      
      
         call do1_step( &
            fcn, jac, mas, solout, iout, m, &
            nord, naccept, nerror, niter, nstep, nlinsys, nlu, nfailerr, &
            nfailnewt, nfailconv, nfailcons, nferrcons, nfeval, njeval, &
            ldlu, ijac, ldjac, mljac, mujac, mudif, ldmas, mlmas, mumas, flmx, flhlt, &
            maxit, it0, it, minit, index1, index2, indexd, & 
            itol, ipvt, ijob, ipar, irtrn, idid, ierr, &
            h, h0, h00, hnew, hmax, t0, t, y0, y, f0, f, fj0, &
            j0, scal, theta, vmax, m0, err, temp, &
            scalextrap, dd, tolestrapa, tolestrapr, gamma, hgamma, &
            nerr, nerrup, nerrold, nerrloc, nerrloc0, nerr0, nerrstop, &
            facr, facl, facnocon, facnewt, facnsmall, facnewtv, facnrestr, hfatt, rathh, &
            rho, rho0, rhobad, rhoold, tolminy0, fminy0, maxf0, miny0, maxdelta, &
            sfty, esp, rpar, uround, rtol, atol, cscal, nj0, nj00, &
            truejac, caljac, success, last, error, restrict, nodj0, nodj00, &
            extrap, extrap0, extraps, jband, mband, jvai, calfact)
         if (ierr /= 0 .or. irtrn.lt.0 .or. last) exit    
              
         nsteps=nsteps+1
         if (.1d0*dabs(t0-tend)/dble(ns) <= dabs(t0)*uround) exit
         
         call prepare_for_next_step( &
            nsteps, maxstep, idid, h, t0, tend, uround, tnext, last)
         if (idid /= 0) return 
         
      end do ! step loop

      do i=1,m
          y0(i)=y(i,ns)
          f0(i)=f(i,ns)
      end do
      t0 = t(ns)

900   format(' exit at t = ',d18.4)



      contains
      
      
      
      subroutine initializations

         ierr = 0
         idid = 0
         nfeval = 0
         njeval = 0
         nlu = 0
         nlinsys= 0
         nsteps = 0
         niter = 0
         nstep = 0
         naccept = 0
         nfailerr = 0
         nfailnewt = 0
         it = 0

         if (index1.eq.m) then
            indexd = 1
         elseif (index1+index2.eq.m) then
            indexd = 2
         else
            indexd = 3
         endif   

         if (jband) then
            csis = dble(2*m*(mljac+mujac))
            cfact = dble(2*m*mljac*mujac)
            mudif = mujac -mumas
         else
            csis = dble(2*m*m)
            cfact = dble(2*m*m*m)/3d0
         end if
         smallm = m.le.5

         ! vector to be used for the estimate of jacobian variation
         nerr = 0.3141592654d0
         nerrup = 0d0
         do i = 1,m
            nerr = 4d0*nerr*(1d0-nerr)
            ej0(i) = nerr
            if (nerr.lt.5d-1) ej0(i)=ej0(i)+5d-1
            nerrup = dmax1(nerrup,ej0(i))
         end do
         do i = 1,m
            ej0(i)=ej0(i)/nerrup
         end do


         nfailconv = 0
         nferrcons = 0
         nfailcons = 0

         h = dmin1(h,hmax)
         ! initial stepsize too small !!!!!
         if (h .lt. 1d1*uround*t0) h = 2d1*uround*t0

         rho =  0d0
         maxdelta =  0d0

         last = .false.
         extrap = .false.
         extrap0 = .false.
         restrict = .false.
         success = .false.
         caljac = .true.
         qinf = .false.
      
         nj0 = 0d0
         nerrloc = 0d0
         h0 = 0d0
         nodj0 = .false.
         do j =1,size(err,dim=2)
           do i = 1,m
             err(i,j) = 0d0
           end do
         end do
      
         esp = 1d0/dble(ns+1)
         maxit = itmax
         rhoml = rhomlv
         rhomu = rhomuv
         rhoold = 0d0
         nord = 0
         nerror = 0
         error = .false.
         minit = indexd

       call mas(m,m0,ldmas,ierr,rpar,ipar)
       if (ierr.ne.0) then
          idid = -6
          return
       end if
         
      end subroutine initializations


      end subroutine  bim00
      
      
      subroutine do1_step( &
            fcn, jac, mas, solout, iout, m, &
            nord, naccept, nerror, niter, nstep, nlinsys, nlu, nfailerr, &
            nfailnewt, nfailconv, nfailcons, nferrcons, nfeval, njeval, &
            ldlu, ijac, ldjac, mljac, mujac, mudif, ldmas, mlmas, mumas, flmx, flhlt, &
            maxit, it0, it, minit, index1, index2, indexd, & 
            itol, ipvt, ijob, ipar, irtrn, idid, ierr, &
            h, h0, h00, hnew, hmax, t0, t, y0, y, f0, f, fj0, &
            j0, scal, theta, vmax, m0, err, temp, &
            scalextrap, dd, tolestrapa, tolestrapr, gamma, hgamma, &
            nerr, nerrup, nerrold, nerrloc, nerrloc0, nerr0, nerrstop, &
            facr, facl, facnocon, facnewt, facnsmall, facnewtv, facnrestr, hfatt, rathh, &
            rho, rho0, rhobad, rhoold, tolminy0, fminy0, maxf0, miny0, maxdelta, &
            sfty, esp, rpar, uround, rtol, atol, cscal, nj0, nj00, &
            truejac, caljac, success, last, error, restrict, nodj0, nodj00, &
            extrap, extrap0, extraps, jband, mband, jvai, calfact)

         external fcn,jac,mas,solout
         
         integer, intent(in) :: &
            m, itol, ldlu, ijac, ldjac, mljac, mujac, mudif, ldmas, mlmas, mumas, &
            iout, maxit, index1, index2, indexd, ijob(:), &
            flmx, flhlt
         integer, intent(inout) :: &
            nord, naccept, nerror, niter, nstep, nlinsys, nlu, nfailerr, &
            nfailnewt, nfailconv, nfailcons, nferrcons, nfeval, njeval, it, it0, minit, &
            ipar(*)
         integer, intent(out) :: &
            ipvt(:), irtrn, idid, ierr

         real(dp) :: &
            h, h0, h00, hnew, hmax, t0, t(:), y0(:), y(:,:), f0(:), f(:,:), fj0(:), &
            j0(:,:), scal(:), theta(:,:), vmax(:), m0(:,:), err(:,:), temp(:,:), &
            scalextrap(:), dd(:,:), tolestrapa(:), tolestrapr, gamma, hgamma, &
            nerr, nerrup, nerrold, nerrloc, nerrloc0, nerr0, nerrstop, &
            facr, facl, facnocon, facnewt, facnsmall, facnewtv, facnrestr, hfatt, rathh, &
            rho, rho0, rhobad, rhoold, tolminy0, fminy0, maxf0, miny0, maxdelta, &
            sfty, esp, rpar(*), uround, rtol, atol(*), cscal, nj0, nj00

         logical :: &
            truejac, caljac, success, last, error, restrict, nodj0, nodj00, &
            extrap, extrap0, extraps, jband, mband, jvai, calfact


         


         logical :: local_err_okay
         logical :: isnan
         integer :: ierr0, i

      
         call jacobian_evaluation( &
            fcn, jac, nj0, nodj0, m, ijac, ldjac, mujac, mljac, &
            njeval, ipar, nj00, nodj00, idid, ierr, h, hfatt, t0, j0, fj0, f0, uround, &
            rpar, y0, rathh, success, jband, caljac, calfact, truejac)
         if (ierr /= 0) return

         if (calfact) then
            call do_calfact( &
               h, gamma, j0, m0, hgamma, theta, m, ldjac, mljac, &
               mudif, mlmas, mumas, ldmas, jband, mband, &
               ldlu, mujac, ipvt, ijob, nlu, t0, uround, idid, ierr)         
            if (ierr /= 0) return
         end if

         call set_scaling(m,h,itol,atol,rtol,scal,cscal,index1,index2,uround,y0)

         do i=1,ns
            t(i)=t0+i*h
         end do

         call set_facnewt( &
            itol, m, index1, y, y0, scal, atol, f0, facnsmall, facnewtv, &
            tolminy0, facnrestr, maxf0, miny0, fminy0, success, restrict, facnewt, h0)

         call solution_initialization( &
            nfailconv, flmx, flhlt, m, y0, t0, h, h0, dd, y, extrap, idid, ierr)
         if (ierr /= 0) return
   
         call newton_iterations( &
            m, fcn, ipvt,ldlu,mljac,mujac,ijob,ldmas,mlmas,mumas,ipar, nfeval, &
            it, ierr0, ierr,t, y0,f0,theta,gamma,h,m0,scal, err,rpar,y,f, &
            rho, nerr0, nerrstop, nerr, nerrup,extrap0, extraps, jvai, &
            niter, nstep, facnewt, indexd, maxit, minit, nerrold, nlinsys, rho0, rtol, uround, temp)
         
         local_err_okay = check_local_error( &
            fcn, m, index1,index2, ipvt, &
            ldlu,mljac,mujac,ijob, ldmas,mlmas,mumas, indexd, it, maxit, &
            nfailerr, nferrcons, nlinsys, nfailnewt, nfailcons, ipar, &
            nfeval, nfailconv, minit, nerrloc0, sfty, esp, facr, facl, &
            f0, f, err, scal, nerr, nerrup, t, y, theta, vmax, m0, nerrstop, &
            facnocon, rho, rhobad, h, rpar, nerrloc, hnew, truejac, caljac, &
            success, last, error, extrap0, extraps, restrict, extrap, ierr)
         if (ierr /= 0) return
         
         if (local_err_okay) &
            call step_accepted( &
               m, it, index1, iout, naccept, nord, nfailcons, &
               nferrcons, it0, scalextrap, y, y0, tolestrapa, tolestrapr, &
               f, rho, t, hmax, facl, facr, h0, h, hnew, err, t0, h00, &
               f0, rhoold, dd, maxdelta, success, extrap0, extrap, restrict, error, &
               ipar, rpar, irtrn, last, nerror)

      end subroutine do1_step



      subroutine jacobian_evaluation( &
            fcn, jac, nj0, nodj0, m, ijac, ldjac, mujac, mljac, &
            njeval, ipar, nj00, nodj00, idid, ierr, h, hfatt, t0, j0, fj0, f0, uround, &
            rpar, y0, rathh, success, jband, caljac, calfact, truejac)
         
         external fcn, jac
         
         integer, intent(in) :: m, ijac, ldjac, mujac, mljac
         integer, intent(inout) :: njeval, ipar(*)
         integer, intent(out) :: idid, ierr

         real(dp), intent(in) :: h, hfatt, t0, f0(:), nj0, uround
         real(dp), intent(inout) :: rpar(*), y0(:)
         real(dp), intent(out) :: j0(:,:), nj00, rathh, fj0(:)
      
         logical, intent(in) :: nodj0, success, jband
         logical, intent(inout) :: caljac
         logical, intent(out) :: calfact, truejac, nodj00
         
         integer :: i, j
         real(dp) :: ysafe, delt
      
         if (success) caljac=.true.
         truejac = caljac .or.(.not.success)
         if (caljac) then
              if (ijac.eq.0) then ! numerical jacobian
                  do i=1,m
                    ysafe=y0(i)
                    delt = dsqrt(uround*dmax1(1.d-5,dabs(ysafe)))
                    y0(i) = ysafe+delt
                    ierr = 0
                    call fcn(m,t0,y0,fj0,ierr,rpar,ipar)
                    if (ierr.ne.0) then
                        return
                     end if
                    if (jband) then
                       do j=max(1,i-mujac),min(m,i+mljac)
                          j0(j-i+mujac+1,i) = (fj0(j)-f0(j))/delt
                       end do
                    else
                       do j=1,m
                          j0(j,i) = (fj0(j)-f0(j))/delt
                       end do
                    end if
                    y0(i)=ysafe
                  end do
           else ! analytical jacobian
              ierr = 0
              call jac(m,t0,y0,j0,ldjac,ierr,rpar,ipar)
              if (ierr.ne.0) then
                 idid = -6
                 return
              end if
           end if

           njeval = njeval + 1
           nj00 = nj0
           nodj00 = nodj0

      end if

      rathh = h/hfatt
      calfact=.true.
      return

900   format(' exit at t = ',d18.4)
1030                format(/,/,'error code ierr = ', i3, /, &
                     'returned by the subroutine fcn during',/, &
                     'the numerical evaluation of the jacobian',/,/)
 1040            format(/,/,'error code ierr = ', i3, /, &
                 'returned by the subroutine jac',/,/)

      end subroutine jacobian_evaluation


      logical function check_local_error( &
            fcn, m, index1,index2, ipvt, &
            ldlu,mljac,mujac,ijob, ldmas,mlmas,mumas, indexd, it, maxit, &
            nfailerr, nferrcons, nlinsys, nfailnewt, nfailcons, ipar, &
            nfeval, nfailconv, minit, nerrloc0, sfty, esp, facr, facl, &
            f0, f, err, scal, nerr, nerrup, t, y, theta, vmax, m0, nerrstop, &
            facnocon, rho, rhobad, h, rpar, nerrloc, hnew, truejac, caljac, &
            success, last, error, extrap0, extraps, restrict, extrap, ierr)
         
         external fcn
         
         integer, intent(in) :: m, index1,index2, ipvt(:), &
            ldlu,mljac,mujac,ijob(:),ldmas,mlmas,mumas, indexd, it, maxit
         integer, intent(inout) :: nfailerr, nferrcons, nlinsys, nfailnewt, &
            nfailconv, nfailcons, nfeval, ipar(*)
         integer, intent(out) :: minit, ierr
         
         real(dp), intent(in) :: sfty, esp, facr, facl, &
            f0(:), f(:,:), scal(:),  t(:), y(:,:), &
            theta(:,:), vmax(:), m0(:,:), nerrstop, facnocon, &
            rho, rhobad
         real(dp), intent(inout) :: err(:,:), nerrup, nerrloc0, h, nerr, rpar(*)
         real(dp), intent(out) :: nerrloc, hnew
         
         logical, intent(inout) :: truejac
         logical, intent(out) :: caljac, success, last, error, &
            extrap0, extraps, restrict, extrap
         
         logical :: isnan
         integer :: ierr0, i
            
         check_local_error = .true.
         if (nerr <= nerrstop) then

            ierr0 = 0
            do i=1,ns
              ierr = 0
              call fcn(m,t(i),y(1,i),f(1,i),ierr,rpar,ipar)
              ierr0 = ierr0 + ierr
            end do

            nfeval = nfeval + ns
            if (ierr0.ne.0)  then
              nerr = 2d0*nerrstop + 1d0
              extrap0 = .false.
              extraps = .false.
            end if
      
         end if

         do ! error estimation loop (only repeat if get nan's)
      
            if (nerr .gt. nerrstop) then ! newton has failed
            
                nfailnewt = nfailnewt + 1
                nfailconv = nfailconv  + 1
                nfailcons = max(nfailcons + 1,2)
                nferrcons = 0

                h = facnocon * h
                success = .false.
                last = .false.

                caljac = .not.truejac
                truejac = .true.

                if (nfailconv.eq.1)  &
                   extraps = extrap0.and.(it.gt.maxit).and.(rho.lt.rhobad)       

                extrap = extraps
                restrict = .false.

                minit = 1
                check_local_error = .false.
                return
                
            end if

            minit = indexd

            ! local error estimation

            nerrloc0 = nerrloc
       
            call localerr4( &
               m,f0,f,h,err,scal,nerr,nerrup,nlinsys, &
               theta,vmax,ipvt,ldlu,mljac,mujac,ijob, &
               ldmas,mlmas,mumas,m0,index1,index2)

            if (isnan(nerr).or.isnan(nerrup)) then
                nerr = 2d0*nerrstop + 1d0
                extrap0 = .false.
                extraps = .false.
                cycle
            end if
            
            exit
         
         end do ! error estimation loop

         nfailconv = 0
         nerrloc = nerr

         if ((nferrcons.gt.3).and. &
             (dabs(nerrloc - nerrloc0).lt.1d-4) &
             .and. (nerr.ge.1d0)) then
   ! write(6,*) 'warning: possible inconsistent initial value'
            nerr = .9d0
         end if

         if (nerr .gt. 0d0) then
             hnew = h*(sfty/nerr)**esp
         else
             hnew = facr*h
         end if

         if (nerr .ge. 1d0) then ! failure due to local error test
             hnew = h*(1d-1/nerr)**esp
             nfailerr = nfailerr + 1
             nfailcons = max(nfailcons + 1,2)
             nferrcons = nferrcons + 1
             caljac = .not. truejac
             truejac = .true.
             success = .false.
             last = .false.
             h = dmax1(hnew,facl*h)
             error = .true.
             check_local_error = .false.
         end if
         
      end function check_local_error


      subroutine step_accepted( &
            m, it, index1, iout, naccept, nord, nfailcons, &
            nferrcons, it0, scalextrap, y, y0, tolestrapa, tolestrapr, &
            f, rho, t, hmax, facl, facr, h0, h, hnew, err, t0, h00, &
            f0, rhoold, dd, maxdelta, success, extrap0, extrap, restrict, error, &
            ipar, rpar, irtrn, last, nerror)
      
         integer, intent(in) :: m, it, index1, iout
         integer, intent(inout) :: naccept, nord, nfailcons, &
            nerror, ipar(*)
         integer, intent(out) :: nferrcons, it0, irtrn
         real(dp), intent(in) :: y(:,:), tolestrapa(:), tolestrapr, &
            f(:,:), rho, t(:), hmax, facl, facr
         real(dp), intent(inout) :: scalextrap(:), h0, h, hnew, err(:,:), y0(:), rpar(*)
         real(dp), intent(out) :: t0, h00, f0(:), rhoold, dd(:,:), maxdelta
         logical, intent(in) :: last
         logical, intent(out) :: success, extrap0, extrap, restrict, error

         naccept = naccept + 1
         nferrcons = 0

         success = .true.
         nord =  nord + 1
         nfailcons = max(nfailcons - 1,0)
         
         call prepare_for_extrap( &
            index1, m, iout, scalextrap, y, y0, tolestrapa, tolestrapr, &
            dd, maxdelta, extrap0, extrap, restrict)

         if (iout.eq.1) then
           call solout(m,ns,4,t0,t,y,f,dd,rpar,ipar,irtrn)
           if (irtrn.lt.0) return
         end if  

         if (last) return

         nerror = 0
         error = .false.
         
         call prepare_after_accepted( &
            m, y, f, rho, t, hmax, facl, facr, h0, h, hnew, err, &
            t0, h00, y0, scalextrap, f0, rhoold, &
            it, nfailcons, it0)
         
      end subroutine step_accepted


      subroutine prepare_for_extrap( &
            index1, m, iout, scalextrap, y, y0, tolestrapa, tolestrapr, &
            dd, maxdelta, extrap0, extrap, restrict)
         
         integer, intent(in) :: index1, m, iout
         real(dp), intent(in) :: scalextrap(:), y(:,:), y0(:), &
            tolestrapa(:), tolestrapr
         real(dp), intent(out) :: dd(:,:), maxdelta
         logical, intent(out) :: extrap0, extrap, restrict
         
         integer :: i
         
         extrap0 = .false.
         do i=1,index1
            maxdelta = dabs(y(i,ns)-y0(i))*scalextrap(i)
            extrap0 = extrap0 .or. &
               ((dabs(y0(i)).le.1d-1).and.(maxdelta.ge.tolestrapa(i))).or. &
               ((dabs(y0(i)).gt.1d-1).and.(maxdelta.ge.tolestrapr))
         end do
         restrict = .not.extrap0
         do i=index1+1,m
            maxdelta = dabs(y(i,ns)-y0(i))*scalextrap(i)
            extrap0 = extrap0 .or. &
               ((dabs(y0(i)).le.1d-1).and.(maxdelta.ge.tolestrapa(i))).or. &
               ((dabs(y0(i)).gt.1d-1).and.(maxdelta.ge.tolestrapr))
         end do
         extrap =  extrap0
         if ((extrap).or.(iout.eq.1)) call diffdiv(m,y0,y,dd)
         
      end subroutine prepare_for_extrap

      
      
      subroutine do_calfact( &
            h, gamma, j0, m0, hgamma, theta, m, ldjac, mljac, &
            mudif, mlmas, mumas, ldmas, jband, mband, &
            ldlu, mujac, ipvt, ijob, nlu, t0, uround, idid, ierr)         
         
         real(dp), intent(in) :: gamma, j0(:,:), m0(:,:), t0, uround
         real(dp), intent(inout) :: h
         real(dp), intent(out) :: hgamma, theta(:,:)
         integer, intent(in) :: m, ldjac, mujac, ldlu, &
            mljac, mudif, ldmas, mlmas, mumas, ijob(:)
         integer, intent(inout) :: nlu
         integer, intent(out) :: ipvt(:), ierr, idid
         logical, intent(in) :: jband, mband
         
         integer :: nsing, info
      
         nsing = 0
         do
         
            call do_caltheta( &
               h, gamma, j0, m0, hgamma, theta, m, ldjac, mljac, &
               mudif, mlmas, mumas, ldmas, jband, mband)
               
            call declu(m,theta,ldlu,mljac,mujac,ipvt,ijob(1),info)
            nlu = nlu + 1
            
            if (info.ne.0) then
               nsing = nsing + 1
               if (nsing.gt.5) then
                  write(*,*) 'matrix is repeatedly singular, ier= ',info
                  write(6,900) t0
                  idid = -4
                  ierr = -1
                  return
               else
                  h = h*.5d0
                  if (.1d0*dabs(h) .le. dabs(t0)*uround) then
                    write(6,*) 'stepsize too small, h=',h
                    write(6,900) t0
                    idid = -3
                    ierr = -1
                    return
                  end if
                  cycle
               end if
            end if
         
            exit
         
         end do
         
900   format(' exit at t = ',d18.4)

      end subroutine do_calfact


      subroutine do_caltheta( &
            h, gamma, j0, m0, hgamma, theta, m, ldjac, mljac, &
            mudif, mlmas, mumas, ldmas, jband, mband)
         
         real(dp), intent(in) :: h, gamma, j0(:,:), m0(:,:)
         real(dp), intent(out) :: hgamma, theta(:,:)
         integer, intent(in) :: m, ldjac, mljac, mudif, ldmas, mlmas, mumas
         logical, intent(in) :: jband, mband
         
         integer :: j, i
         
         hgamma = h*gamma
        if (jband) then
          do j=1,m
            do i=1,ldjac
                theta(i+mljac,j)=-hgamma*j0(i,j)
            end do
            do i=1,ldmas
               theta(i+mljac+mudif,j)=m0(i,j)+theta(i+mljac+mudif,j)
            end do
          end do
        else if (mband) then
          do j=1,m
            do i=1,m
                theta(i,j) = -hgamma*j0(i,j)
            end do
            do i=max(1,j-mumas),min(m,j+mlmas)
                theta(i,j)=theta(i,j)+m0(i-j+mumas+1,j)
            end do
          end do
        else
          do j=1,m
             do i=1,m
                theta(i,j) = m0(i,j)-hgamma*j0(i,j)
             end do
          end do
         end if
      end subroutine do_caltheta


      subroutine prepare_after_accepted( &
            m, y, f, rho, t, hmax, facl, facr, h0, h, hnew, err, &
            t0, h00, y0, scalextrap, f0, rhoold, &
            it, nfailcons, it0)
            
         real(dp), intent(in) :: y(:,:), f(:,:), rho, t(:), hmax, facl, facr
         real(dp), intent(inout) :: h0, h, hnew, err(:,:)
         real(dp), intent(out) :: t0, h00, y0(:), scalextrap(:), f0(:), rhoold
         integer, intent(in) :: m, it, nfailcons
         integer, intent(out) :: it0
         
         integer :: i
         real(dp) :: absy0

         do i=1,m
            y0(i) =y(i,ns)
            absy0 =dabs(y0(i))
            f0(i) =f(i,ns)
            scalextrap(i)=1d0/(1d0+absy0)
         end do

         t0 = t(ns)
         it0 = it

         h00 = h0
         h0 = h
         if (nfailcons.gt.0) hnew = dmin1(h,hnew)
         hnew = dmax1(hnew,facl*h)
         h = dmin1(hnew,facr*h,hmax)

         rhoold = rho
         
      end subroutine prepare_after_accepted
      
         
      subroutine prepare_for_next_step( &
            nsteps, maxstep, idid, h, t0, tend, uround, tnext, last)
         
         integer, intent(in) :: nsteps, maxstep
         integer, intent(out) :: idid
         real(dp), intent(in) :: t0, tend, uround
         real(dp), intent(inout) :: h
         real(dp), intent(out) :: tnext
         logical, intent(out) :: last
      
         if (.1d0*dabs(h) .le. dabs(t0)*uround) then
            write(6,*) 'stepsize too small, h=',h
            write(6,900) t0
            idid = -3
            return
         end if
         if (nsteps .ge. maxstep) then
            write(6,*) 'more than nmax = ',maxstep, ' steps are needed'
            write(6,900) t0
            idid = -2
            return
         end if

         tnext = t0 + dble(ns)*h
         if ( (tnext.lt.tend) .and. &
              ((tend-tnext).lt.(dble(ns)*h)) ) &
         h = (tend-t0)/(2d0*dble(ns))

         if (tnext .ge. tend) then
            h = (tend-t0)/dble(ns)
            last = .true.
         end if
         
900   format(' exit at t = ',d18.4)
      end subroutine prepare_for_next_step

      
      subroutine before_start_steps( &
            fcn,m,t0,y0,f0,ierr,rpar,ipar, &
            nfeval,idid,scalj0_1,scalextrap,hfatt,tolminy0,miny0)
         external fcn
         integer, intent(in) :: m
         real(dp), intent(in) :: t0,y0(:),tolminy0
         integer, intent(inout) :: nfeval,ipar(*),idid
         real(dp), intent(inout) :: rpar(*)
         integer, intent(out) :: ierr
         real(dp), intent(out) :: f0(:),scalj0_1,scalextrap(:),hfatt,miny0
         
         integer :: i
         real(dp) :: absy0

         call fcn(m,t0,y0,f0,ierr,rpar,ipar)
         if (ierr.ne.0) then
             write(6,1020) ierr
 1020        format(/,/,'error code ierr = ', i3, / &
                        'returned by the subroutine fcn',/,/)
             write(6,900) t0
             idid = -6
             return
         end if
         nfeval = nfeval + 1
      
         scalj0_1 = 0d0
         do i=1,m
            absy0 = dabs(y0(i))
            scalextrap(i)=1d0/(1d0+absy0)
            scalj0_1=dmax1(scalj0_1,absy0)
         end do

         hfatt=1d0
         miny0 = tolminy0 + 1d0
      

900   format(' exit at t = ',d18.4)

      end subroutine before_start_steps



      subroutine solution_initialization( &
            nfailconv, flmx, flhlt, m, y0, t0, h, h0, dd, y, extrap, idid, ierr)
         
         integer, intent(in) :: nfailconv, flmx, flhlt, m
         integer, intent(out) :: idid, ierr
         real(dp), intent(in) :: y0(:), t0, h, h0
         real(dp), intent(out) :: dd(:,:), y(:,:)
         logical, intent(in) :: extrap
         
         integer :: j, i
      
         if ( (.not.extrap).or.(nfailconv.gt.flmx) ) then
         ! the solution is initialized with the constant profile
            if (nfailconv.gt.flhlt) then
                write(*,*) 'too many consecutive newton failures'
                write(6,900) t0
                idid = -5
                ierr = -1
                return
            end if
            do j = 1,ns
               do i=1,m
                  y(i,j)=y0(i)
               end do
            end do
         else
            call extrapola(m,h0,h,y,dd)
         end if
900   format(' exit at t = ',d18.4)

      end subroutine solution_initialization
      
      
      subroutine newton_iterations( &
         m, fcn, ipvt,ldlu,mljac,mujac,ijob,ldmas,mlmas,mumas,ipar, nfeval, &
         it, ierr0, ierr,t, y0,f0,theta,gamma,h,m0,scal, err,rpar,y,f, &
         rho, nerr0, nerrstop, nerr, nerrup,extrap0, extraps, jvai, &
         niter, nstep, facnewt, indexd, maxit, minit, nerrold, nlinsys, rho0, rtol, uround, temp)

         integer, intent(in) :: m, ipvt(:),ldlu,mljac,mujac,ijob(2),ldmas,mlmas,mumas, indexd, maxit, minit
         integer, intent(inout) :: ipar(*), nfeval, niter, nstep, nlinsys
         integer, intent(out) :: it, ierr0, ierr
         
         real(dp), intent(in) :: t(:), y0(:),f0(:),theta(:,:),gamma,h,m0(:,:),scal(:), facnewt, rtol, uround
         real(dp), intent(inout) :: rpar(*),y(:,:),f(:,:),temp(:,:),err(:,:)
         real(dp), intent(out) :: rho, nerr0, nerrstop, nerr, nerrup, nerrold, rho0
         
         logical, intent(out) :: extrap0, extraps, jvai

         external fcn

         logical :: isnan
         integer :: i

         it = 0
         rho = 0d0
         nerr0 = 1d0
         nerrstop = dmax1(facnewt,uround/rtol)

         do ! newton loop
   
            ierr0=0
            do i=1,ns
              ierr = 0
              call fcn(m,t(i),y(1,i),f(1,i),ierr,rpar,ipar)
              ierr0 = ierr0+ierr
            end do
            nfeval = nfeval + ns
            if (ierr0.ne.0) then
               nerr = 2d0*nerrstop + 1d0
               extrap0 = .false.
               extraps = .false.
               jvai = .false.
               exit
            end if
   
            call blendstep4(m,y0,f0,y,f,h,theta,ipvt,err, &
                gamma,ldlu,mljac,mujac,ijob, &
                ldmas,mlmas,mumas,m0,temp)         

            it = it + 1
            call norm(m,ns,scal,err,nerr,nerrup)
            ! check for nans
            if (isnan(nerr).or.isnan(nerrup)) then
               nerr = 2d0*nerrstop + 1d0
               extrap0 = .false.
               extraps = .false.
               jvai = .false.
               exit
            end if

            ! spectral radius estimate
            nerrold = nerr0
            nerr0 = nerr
            rho0 = rho
            rho = nerr0/nerrold
            if (it.gt.2) rho = dsqrt(rho0*rho)

            jvai = (nerr .gt. nerrstop) .and. (it .le. maxit) &
                   .and.(it .le. indexd+1 .or. rho .le. rhobad)

            jvai = jvai .or. it.lt.minit
            if (.not. jvai) exit
      
         end do ! newton loop

         nlinsys = nlinsys  + 2*it*ns
         niter = niter + it
         nstep = nstep + 1
         
      end subroutine newton_iterations

      
      
      subroutine set_scaling( &
            m,h,itol,atol,rtol,scal,cscal,index1,index2,uround,y0)
         integer, intent(in) :: m,itol,index1,index2
         real(dp), intent(in) :: h,rtol,atol(*),cscal,uround,y0(:)
         real(dp), intent(out) :: scal(:)
         integer :: i
         real(dp) :: cscal0
         if (itol.eq.0) then
           do i =1,index1
             scal(i) = 1d0/(atol(1)+rtol*dabs(y0(i)))
           end do
           cscal0 = dmin1(1d0,rtol/(uround*1d2*cscal))
           do i =index1+1,index1+index2
             scal(i) = dmin1(1d0,cscal0*h)/(atol(1)+rtol*dabs(y0(i)))
           end do
           cscal0 = dmin1(1d0,rtol/(uround*1d2*cscal*cscal))
           do i =index1+index2+1,m
             scal(i) = dmin1(1d0,cscal0*h*h)/(atol(1)+rtol*dabs(y0(i)))
           end do
         else
           do i =1,index1
             scal(i) = 1d0/(atol(i)+rtol*dabs(y0(i)))
           end do
           cscal0 = dmin1(1d0,rtol/(uround*1d2*cscal))
           do i =index1+1,index1+index2
             scal(i) = dmin1(1d0,cscal0*h)/(atol(i)+rtol*dabs(y0(i)))
           end do
           cscal0 = dmin1(1d0,rtol/(uround*1d2*cscal*cscal))
           do i =index1+index2+1,m
             scal(i) = dmin1(1d0,cscal0*h*h)/(atol(i)+rtol*dabs(y0(i)))
           end do
         end if
      end subroutine set_scaling

      


      subroutine set_facnewt( &
            itol, m, index1, y, y0, scal, atol, f0, facnsmall, facnewtv, &
            tolminy0, facnrestr, maxf0, miny0, fminy0, success, restrict, facnewt, h0)
         
         integer, intent(in) :: itol, m, index1
         real(dp), intent(in) :: y(:,:), y0(:), scal(:), atol(*), f0(:), &
            facnsmall, facnewtv, tolminy0, facnrestr, h0
         real(dp), intent(inout) :: fminy0
         real(dp), intent(out) :: maxf0, miny0, facnewt
         logical, intent(in) :: success, restrict
         
         integer :: i
      
         if (success) then
            if (itol.eq.0) then
                miny0 = dabs(y0(1))
                fminy0 = dabs(y0(1)-y(1,ns-1))/h0*scal(1)*atol(1)
                maxf0 = fminy0
                do i = 2,index1
                  facnewt = dabs(y0(i)-y(i,ns-1))/h0*scal(i)*atol(1)
                  if (dabs(y0(i)).lt.miny0) then
                     miny0 = dabs(y0(i))
                    fminy0 = facnewt
                  end if
                  maxf0 = dmax1(maxf0,facnewt)
                end do
            else
                miny0 = dabs(y0(1))
                fminy0 = dabs(y0(1)-y(1,ns-1))/h0*scal(1)*atol(1)
                maxf0 = fminy0
                do i = 2,index1
                  facnewt = dabs(y0(i)-y(i,ns-1))/h0*scal(i)*atol(i)
                  if (dabs(y0(i)).lt.miny0) then
                     miny0 = dabs(y0(i))
                    fminy0 = facnewt
                  end if
                  maxf0 = dmax1(maxf0,facnewt)
                end do
            end if
         end if

         facnewt = facnewtv
         if (((miny0 .lt. tolminy0).and.(fminy0.lt.1d-1))) then
             facnewt = dmin1(1d-1,facnewt)
             if ((fminy0.lt.1d-5).and.(maxf0.lt.1d-2)) &
                   facnewt=dmin1(facnewt,facnsmall)
         end if
         if (restrict) facnewt=dmin1(facnewt,facnrestr)
         
      end subroutine set_facnewt




      subroutine  bim0(m,fcn,jac,nmeth,kmax,y0,f0,t0,tend, &
                       h,rtol,atol,itol, &
                       maxstep,ordmin,ordmax,itmax,uround,hmax, &
                       facnewtv,facnsmall,facnrestr,facl,facr,sfty, &
                       sftyup,sftydn,rhomuv,rhomlv, &
                       nfeval,njeval,nlu,nlinsys,niter,nstep,naccept, &
                       nfailerr,nfailnewt, &
                       ipvt,step_ord,t,y,f,theta,err,j0, &
                       delj0,delj00,fj0,ej0,scal, &
                       dd,tolestrapr,tolestrapa,scalextrap, &
                       ijac,mljac,mujac,ldjac,ldlu,jband,ijob, &
                       rpar,ipar,iout,solout,idid, &
                       mas,imas,mlmas,mumas,ldmas,mband, &
                       index1,index2,m0,temp)

      external fcn,jac,mas,solout

      logical, intent(in) :: jband,mband
      
      integer, intent(in) :: &
              m,nmeth,kmax,maxstep,ordmin,ordmax,itmax(nmeth), &
              step_ord(nmeth),index1,index2, &
              mljac,mujac,ldjac,ldlu,ijob(2),ijac, &
              iout,itol,imas,mlmas,mumas,ldmas

      integer, intent(inout) :: ipar(*)

      integer, intent(out) :: &
              ipvt(m),nfeval,njeval,nlu,nlinsys,niter(nmeth),nstep(nmeth), &
              naccept(nmeth),nfailerr(nmeth),nfailnewt(nmeth),idid

      real(dp), intent(in) ::  &
              tend,rtol,atol(*),uround,hmax, &
              facnewtv(nmeth),facnsmall,facnrestr,facl,facr, &
              tolestrapr,tolestrapa(m), &
              rhomuv(nmeth),rhomlv(nmeth),sfty,sftyup,sftydn

      real(dp), intent(inout) :: h,t0,y0(m),rpar(*),fj0(m)

      real(dp), intent(out) :: &
              t(kmax),f0(m),theta(ldlu,m),j0(ldjac,m),delj0(m), &
              delj00(m),y(m,kmax),f(m,kmax),err(m,kmax), &
              scal(m),dd(kmax+1,m),scalextrap(m), &
              ej0(m),m0(ldmas,m),temp(m,kmax)
      
      
      if (imas /= 1) stop 'imas'
      if (kmax /= 3) stop 'kmax'
      if (step_ord(1) /= 3) stop 'step_ord(1)'
      call bim00(m,fcn,jac,y0,f0,t0,tend, &
              h,rtol,atol,itol, &
              maxstep,itmax(1),uround,hmax, &
              facnewtv(1),facnsmall,facnrestr,facl,facr,sfty, &
              rhomuv(1),rhomlv(1), &
              nfeval,njeval,nlu,nlinsys,niter(1),nstep(1),naccept(1), &
              nfailerr(1),nfailnewt(1), &
              ipvt,t,y,f,theta,err,j0, &
              delj0,delj00,fj0,ej0,scal, &
              dd,tolestrapr,tolestrapa,scalextrap, &
              ijac,mljac,mujac,ldjac,ldlu,jband,ijob, &
              rpar,ipar,iout,solout,idid, &
              mas,mlmas,mumas,ldmas,mband, &
              index1,index2,m0,temp)
                       
      end subroutine  bim0


      end module mod_bimd
