      module test_rates_support
      
      use rates_def
      use rates_lib
      use chem_lib
      use const_lib
      use const_def, only: missing_value
      use utils_lib, only: is_bad_num
      
      implicit none


      contains


      subroutine setup
         use reaclib_lib, only: reaclib_init
         use weak_lib, only: weak_init
   	   character(len=256) :: data_dir
   	   integer :: ierr   
   	   	   
         data_dir = '../../data'   	
         ierr = 0
         
         call const_init
         
      	call chem_init(data_dir, 'isotopes.data_approx', ierr)
      	if (ierr /= 0) then
      	   write(*,*) 'chem_init failed'
      	   stop 1
      	end if
   	
      	call weak_init(data_dir, ierr)   
      	if (ierr /= 0) then
      	   write(*,*) 'weak_init failed'
      	   stop 1
      	end if
         
         call reaclib_init(data_dir, ierr)   
      	if (ierr /= 0) then
      	   write(*,*) 'reaclib_init failed'
      	   stop 1
      	end if
      	
         call rates_init(data_dir, 'reactions.list', ierr) 
      	if (ierr /= 0) then
      	   write(*,*) 'rates_init failed'
      	   stop 1
      	end if
      	
         call read_raw_rates_records('rate_tables', ierr) 
      	if (ierr /= 0) then
      	   write(*,*) 'read_raw_rates_records failed'
      	   stop 1
      	end if
               
      end subroutine setup


      subroutine do_test_rates(which)
         integer, intent(in) :: which

         integer :: ierr
         type (T_Factors), target :: tf_rec
         type (T_Factors), pointer :: tf
         double precision :: logT, temp, raw_rate
         integer :: i, ir
         integer, parameter :: max_nrates_to_eval = 500
         integer :: 
     >      nrates_to_eval, irs(max_nrates_to_eval), which_rates(rates_reaction_id_max)
         double precision :: raw_rates(max_nrates_to_eval)
         
         
         logical, parameter :: dbg = .false.
         
         include 'formats.dek'
         
         write(*,*)
         write(*,*) 'do_test_rates', which
         
         which_rates(:) = which
         
         tf => tf_rec
         
         if (dbg) then
            logT = 3d0
         else
            logT = 9d0
         end if
         temp = 10**logT
         call eval_tfactors(tf, logT, temp)
         nrates_to_eval = 25
         
         irs(1:nrates_to_eval) = (/
     >      irpp_to_he3,
     >      ir_he3_he3_to_h1_h1_he4, ! 8.3406531711652043E-01
     >      ir34_pp2, ! 2.4491089523269484E-05
     >      ir34_pp3, ! 2.4491089523269484E-05
     >      ir_h1_he3_wk_he4, ! 7.3160836901453303E-18
     >      irc12_to_n14, ! 2.2669946431121827E-05
     >      irn14_to_c12, ! 1.0361246408961919E-06
     >      irn14_to_o16, ! 1.0361246408961919E-06
     >      iro16_to_n14, ! 1.1633328598591632E-07
     >      ir_he4_he4_he4_to_c12, ! 2.4805684557068709E-24
     >      ir_c12_ag_o16, ! 1.7670561942345922E-20
     >      irn14ag_lite, ! 1.6950368441395027E-20
     >      ir_o16_ag_ne20, ! 7.7857289671217829E-27
     >      ir_ne20_ag_mg24, ! 2.5569829828596017E-38
     >      irbe7pg_b8_aux, ! 3.0038527702308548E-04
     >      irn15pg_aux, ! 4.3667111388963307E-05
     >      irn15pa_aux, ! 7.1616082976034598E-02
     >      ir1212_to_ne20, 
     >      ir_ne20_ag_mg24, ! 2.5569829828596017E-38
     >      irne20ap_to_mg24, ! 5.2672905720682040-127
     >      ir_mg24_ag_si28, ! 7.9287095075690262E-31
     >      irmg24ap_to_si28, ! 1.9060699579921347E-88
     >      ir_si28_ag_s32, ! 7.8903193908869158E-35
     >      ir_c12_to_he4_he4_he4,     
     >      ir_ne20_ga_o16   
     >      /)
         
         write(*,1) 'logT', logT         
         write(*,1) 'temp', temp
         write(*,*)
         
         raw_rates = missing_value
                   
         call get_raw_rates(nrates_to_eval, irs, which_rates, temp, tf, raw_rates, ierr)
         if (ierr /= 0) stop 1
         
         do i=1,nrates_to_eval
            if (raw_rates(i) == missing_value) then
               write(*,*) 'missing value for ' // trim(reaction_Name(irs(i)))
               stop 1
            end if
            write(*,1) trim(reaction_Name(irs(i))), raw_rates(i)
         end do
         write(*,*)

         write(*,*) 'done'
         write(*,*)
         
      end subroutine do_test_rates 
      
      
      integer function enter_rate(handle)
         character (*), intent(in) :: handle
         integer :: ierr
         call add_reaclib_reaction(handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in enter_rate for ' // trim(handle)
            stop 1
         end if
         enter_rate = rates_reaction_id(handle)
      end function enter_rate
      

      subroutine test1
         integer :: ierr
         type (T_Factors), target :: tf_rec
         type (T_Factors), pointer :: tf
         double precision :: logT, temp, raw_rate
         integer :: i, ir, which_rate
         logical, parameter :: dbg = .false.
         
         include 'formats.dek'
         
         
         write(*,*)
         write(*,*) 'test1'
         
         tf => tf_rec
         
         temp = 1d9
         logT = log10(temp)
         call eval_tfactors(tf, logT, temp)
         
         write(*,1) 'logT', logT         
         write(*,1) 'temp', temp
         write(*,*)
         
         ir = rates_reaction_id('rne20ap_to_mg24')
         which_rate = rates_JR_if_available
         call run1   

         write(*,*) 'done'
         write(*,*)
         
         contains
         
         subroutine run1
            include 'formats.dek'
            call get_raw_rate(ir, which_rate, temp, tf, raw_rate, ierr)
            if (ierr /= 0) stop 1
            write(*,1) trim(reaction_Name(ir)), raw_rate
            write(*,*)
         end subroutine run1
         
      end subroutine test1 
      
      
      subroutine do_test_FL_epsnuc_3alf
         double precision :: T ! temperature
         double precision :: Rho ! density
         double precision :: Y ! helium mass fraction
         double precision :: UE ! electron molecular weight
         double precision :: eps_nuc ! eps_nuc in ergs/g/sec
         double precision :: deps_nuc_dT ! partial wrt temperature
         double precision :: deps_nuc_dRho ! partial wrt density
         include 'formats.dek'
         T = 1d7
         Rho = 1d10
         Y = 1
         UE = 2
         call eval_FL_epsnuc_3alf(T, Rho, Y, UE, eps_nuc, deps_nuc_dT, deps_nuc_dRho)
         write(*,1) 'FL_epsnuc_3alf', eps_nuc
         write(*,*)
      end subroutine do_test_FL_epsnuc_3alf
      
      
      subroutine do_test_rate_table
         integer :: ierr
         type (T_Factors), target :: tf_rec
         type (T_Factors), pointer :: tf
         double precision :: logT, temp, raw_rate
         integer :: i, ir, which_rate
         logical, parameter :: dbg = .false.
         
         include 'formats.dek'
         
         
         write(*,*)
         write(*,*) 'do_test_rate_table'
         
         tf => tf_rec
         
         temp = 9.0e8
         logT = log10(temp)
         call eval_tfactors(tf, logT, temp)
         
         write(*,1) 'logT', logT         
         write(*,1) 'temp', temp
         write(*,*)
         
         ir = rates_reaction_id('r3')
         which_rate = rates_JR_if_available
         call run1   

         write(*,*) 'done'
         write(*,*)
         
         contains
         
         subroutine run1
            include 'formats.dek'
            call get_raw_rate(ir, which_rate, temp, tf, raw_rate, ierr)
            if (ierr /= 0) stop 1
            write(*,1) trim(reaction_Name(ir)), raw_rate
            write(*,*)
         end subroutine run1
      
      end subroutine do_test_rate_table
      
      
      subroutine do_test2_FL_epsnuc_3alf
         double precision :: T ! temperature
         double precision :: Rho ! density
         double precision :: Y ! helium mass fraction
         double precision :: UE ! electron molecular weight
         double precision :: eps_nuc1, eps_nuc2 ! eps_nuc in ergs/g/sec
         double precision :: deps_nuc_dT ! partial wrt temperature
         double precision :: deps_nuc_dRho ! partial wrt density
         double precision :: dT, dRho
         include 'formats.dek'
         T = 7.9432823472428218d+07
         dT = T*1d-8
         Rho = 3.1622776601683793d+09
         dRho = Rho*1d-8
         Y = 1
         UE = 2
         call eval_FL_epsnuc_3alf(T, Rho+dRho, Y, UE, eps_nuc1, deps_nuc_dT, deps_nuc_dRho)
         write(*,1) 'FL_epsnuc_3alf 1', eps_nuc1
         write(*,*)
         call eval_FL_epsnuc_3alf(T, Rho, Y, UE, eps_nuc2, deps_nuc_dT, deps_nuc_dRho)
         write(*,1) 'FL_epsnuc_3alf 2', eps_nuc2
         write(*,*)
         write(*,1) 'analytic deps_nuc_dRho', deps_nuc_dRho
         write(*,1) 'numerical deps_nuc_dRho', (eps_nuc1 - eps_nuc2)/dRho
         write(*,*)
         write(*,1) 'analytic dlneps_nuc_dlnRho', deps_nuc_dRho*Rho/eps_nuc2
         write(*,1) 'numerical dlneps_nuc_dlnRho', (eps_nuc1 - eps_nuc2)/dRho*Rho/eps_nuc2
         write(*,*)
      end subroutine do_test2_FL_epsnuc_3alf


      end module test_rates_support




      program test_rates
      
      use test_rates_support
      
      implicit none
      
      
      call setup
      
      !call do_test2_FL_epsnuc_3alf; stop
      !call test1; stop
      
      call do_test_rates(rates_NACRE_if_available)
      call do_test_rates(rates_JR_if_available)
      call do_test_FL_epsnuc_3alf
      call do_test_rate_table


      end program
