! ***********************************************************************
!
!   Copyright (C) 2011  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************


      program show_rates
      use rates_lib
      use const_lib
      
      implicit none
      
      character (len=256) :: cache_filename
      integer :: ierr, n
      
      n = iargc()
      if (n /= 1) then
         write(*,*) 'please give full path name of cache file on command line'
         stop 1
      end if
      call getarg(1, cache_filename)
      write(*,'(a)') '# rates from ' // trim(cache_filename)
      
      call const_init
      
      ierr = 0
      call show_reaction_rates_from_cache(cache_filename, ierr) 
      if (ierr /= 0) stop 1
      
      end program show_rates