      module test_vdpol_x
      use num_def
      use num_lib
      use alert_lib
      use test_int_support,only:i_nfcn,i_njac
      implicit none

      contains


      subroutine vdpol_x_derivs(n, x, vars, dvars_dx, lrpar,rpar,lipar,ipar, ierr)
         integer, intent(in) :: n, lrpar, lipar
         double precision, intent(in) :: x
         double precision, intent(inout) :: vars(n)
         double precision, intent(out) :: dvars_dx(n)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(inout), target :: ipar(lipar)
         double precision :: yprime(n)
         integer, intent(out) :: ierr
         ierr = 0
         ipar(i_nfcn) = ipar(i_nfcn) + 1
         call vdpol_x_feval(n,x,vars,yprime,dvars_dx,ierr,rpar,ipar)
      end subroutine vdpol_x_derivs


      subroutine vdpol_x_jacob(n,x,y,f,dfdy,ld_dfdy,lrpar,rpar,lipar,ipar,ierr)
         integer, intent(in) :: n, ld_dfdy, lrpar, lipar
         double precision, intent(in) :: x
         double precision, intent(inout) :: y(n)
         double precision, intent(out) :: dfdy(ld_dfdy,n), f(n)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(inout), target :: ipar(lipar)
         double precision :: yprime(n)
         integer, intent(out) :: ierr
         integer :: nz, i, j
         ierr = 0
         ipar(i_njac) = ipar(i_njac) + 1
         call vdpol_x_jeval(ld_dfdy,n,x,y,yprime,dfdy,ierr,rpar,ipar)
         if (ierr == 0) call vdpol_x_derivs(n, x, y, f, lrpar,rpar,lipar,ipar, ierr)
      end subroutine vdpol_x_jacob


      subroutine vdpol_x_sjac(n,x,y,f,nzmax,ia,ja,values,lrpar,rpar,lipar,ipar,ierr)  
         ! sparse jacobian. format either compressed row or compressed column.
         use mtx_lib,only:dense_to_row_sparse_with_diag,dense_to_col_sparse_with_diag
         use test_int_support,only:ipar_sparse_format
         integer, intent(in) :: n, nzmax, lrpar, lipar
         double precision, intent(in) :: x
         double precision, intent(inout) :: y(n)
         integer, intent(out) :: ia(n+1), ja(nzmax)
         double precision, intent(out) :: values(nzmax), f(n)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(inout), target :: ipar(lipar)
         integer, intent(out) :: ierr ! nonzero means terminate integration
         double precision :: dfdy(n,n)
         integer :: ld_dfdy, nz
         ld_dfdy = n
         ierr = 0
         call vdpol_x_jacob(n,x,y,f,dfdy,ld_dfdy,lrpar,rpar,lipar,ipar,ierr)
         if (ierr /= 0) return
         if (ipar(ipar_sparse_format) == 0) then
            call dense_to_row_sparse_with_diag(n,n,dfdy,nzmax,nz,ia,ja,values,ierr)
         else
            call dense_to_col_sparse_with_diag(n,n,dfdy,nzmax,nz,ia,ja,values,ierr)
         end if
      end subroutine vdpol_x_sjac


      subroutine vdpol_x_mas(n,am,lmas,lrpar,rpar,lipar,ipar)
         integer, intent(in) :: n, lmas, lrpar, lipar
         double precision, intent(out) :: am(lmas,n)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(inout), target :: ipar(lipar)
         am = 0
      end subroutine vdpol_x_mas


      subroutine vdpol_x_solout(nr,xold,x,n,y,rwork,iwork,interp_y,lrpar,rpar,lipar,ipar,irtrn)
         ! nr is the step number.
         ! x is the current x value; xold is the previous x value.
         ! y is the current y value.
         ! irtrn negative means terminate integration.
         ! rwork and iwork hold info for 
         integer, intent(in) :: nr, n, lrpar, lipar
         double precision, intent(in) :: xold, x
         double precision, intent(inout) :: y(n)
         double precision, intent(inout), target :: rpar(lrpar), rwork(*)
         integer, intent(inout), target :: ipar(lipar), iwork(*)
         interface
            ! this subroutine can be called from your solout routine.
            ! it computes interpolated values for y components during the just completed step.
            double precision function interp_y(i,s,rwork,iwork,ierr)
               integer, intent(in) :: i ! result is interpolated approximation of y(i) at x=s.
               double precision, intent(in) :: s ! interpolation x value (between xold and x).
               double precision, intent(inout), target :: rwork(*)
               integer, intent(inout), target :: iwork(*)
               integer, intent(out) :: ierr
            end function interp_y
         end interface
         integer, intent(out) :: irtrn
         double precision :: xout, y1, y2
         integer :: ierr
         ierr = 0
         irtrn = 0
         xout = rpar(1)
         if (nr.eq.1) then
            write (6,99) x,y(1),y(2),nr-1
            xout=0.2d0
         else
            do
               if (x.ge.xout) then
                  ! --- continuous output for radau5
                  y1 = interp_y(1,xout,rwork,iwork,ierr)
                  if (ierr /= 0) exit
                  y2 = interp_y(2,xout,rwork,iwork,ierr)
                  write (6,99) xout,y1,y2,nr-1
                  if (ierr /= 0) exit
                  xout=xout+0.2d0
                  cycle
               end if
               exit
            end do
         end if
         if (ierr /= 0) then
            write(*,*) 'problem with interp_y in vdpol_x_solout'
            irtrn = -1
         end if
         rpar(1) = xout
  99     format(1x,'x =',f5.2,'    y =',2e18.10,'    nstep =',i7)
      end subroutine vdpol_x_solout
      
      
      subroutine do_test_vdpol_x(which_solver,which_decsol,m_band,numerical_jacobian,show_all,quiet)
         use test_support,only:show_results,show_statistics,check_results
         use test_int_support,only:do_test_stiff_int
         integer, intent(in) :: which_solver,which_decsol
         logical, intent(in) :: m_band,numerical_jacobian,show_all,quiet

         integer, parameter :: n = 4 ! the number of variables in the "vdpol" system of ODEs
         double precision :: y(n), yprime(n), yexact(n)
         integer, parameter :: lrpar = 1, lipar = 3
         double precision :: rpar(lrpar)
         integer :: ipar(lipar)
         logical :: consis
         integer, parameter :: ndisc = 0, n_soln=2
         double precision :: result(n_soln), soln(n_soln), h0, t(0:ndisc+1), atol(n), rtol(n)
         integer :: i, mujac, mljac, matrix_type_spec, ierr, imas, mlmas, mumas, m1, m2, itol, iout, nstep
            
         if (.not. quiet) write(*,*) 'vdpol_x'
         
         t(0) = 0
         t(1) = 2d0
         
         itol = 1 ! vector tolerances
         rtol(1:2) = 1d-4;  rtol(3:4) = 1d-2
         atol(1:2) = 1d-4;  atol(3:4) = 1d-2
         h0 = 1d-4 ! initial step size
                  
         m1 = n/2
         m2 = m1     
         
         matrix_type_spec = square_matrix_type
         mljac = n
         mujac = n
         
         imas = 1
         if (m_band) then
            write(*,*) 'M band'
            mlmas = 0
            mumas = 0
         else
            write(*,*) 'M full'
            mlmas = n-m1
            mumas = n-m1
         end if
         
         if (show_all .and. which_solver /= sodex_solver) then
            iout = 1
         else
            iout = 0
         end if
         
         call vdpol_x_init(n,t,y,yprime,consis)
         nstep=0    
         call do_test_stiff_int(which_solver,which_decsol,numerical_jacobian, &
               vdpol_x_derivs,vdpol_x_jacob,vdpol_x_sjac,vdpol_x_solout,iout, &
               n,ndisc,mljac,mujac,matrix_type_spec,vdpol_x_mas,imas,mlmas,mumas,m1,m2, &
               t,rtol,atol,itol,h0,y,nstep,lrpar,rpar,lipar,ipar,quiet,ierr)
         if (ierr /= 0) then
            write(*,*) 'test_vdpol_x ierr', ierr
            stop 1
         end if
         
         call vdpol_x_solut(n,0d0,yexact)
         result(1:2) = y(1:2)
         soln(1:2) = yexact(1:2)
         call check_results(n,y,yexact,rtol(1)*10,ierr)
         if (ierr /= 0) then
            write(*,*) 'check results ierr', ierr
            stop 1 ! do_test_vdpol
         end if
         
         if (quiet) return
         
         call show_results(n_soln,result,soln,show_all)
         call show_statistics(ipar(i_nfcn),ipar(i_njac),nstep,show_all)
         
      end subroutine do_test_vdpol_x
            
      
      end module test_vdpol_x
