      module test_transamp
      use num_def
      use num_lib
      use alert_lib
      use test_int_support,only:i_nfcn,i_njac
      implicit none

      integer :: mljac,mujac
      double precision :: UE, UB, UF, ALPHA, BETA, R0, R1, R2, R3, R4, R5, R6, R7, R8, R9

      contains


      subroutine transamp_derivs(n, x, Y, F, lrpar,rpar,lipar,ipar, ierr)
        IMPLICIT REAL*8 (A-H,O-Z)
         integer, intent(in) :: n, lrpar, lipar
         double precision, intent(in) :: x
         double precision, intent(inout) :: Y(n)
         double precision, intent(out) :: F(n)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(inout), target :: ipar(lipar)
         double precision :: yprime(n)
         integer, intent(out) :: ierr
         integer :: i
         ierr = 0
         ipar(i_nfcn) = ipar(i_nfcn) + 1
         W=2.D0*3.141592654D0*100.D0
         UET=UE*DSIN(W*X)
         FAC1=BETA*(DEXP((Y(4)-Y(3))/UF)-1.D0)
         FAC2=BETA*(DEXP((Y(7)-Y(6))/UF)-1.D0)
         F(1)=Y(1)/R9
         F(2)=(Y(2)-UB)/R8+ALPHA*FAC1
         F(3)=Y(3)/R7-FAC1
         F(4)=Y(4)/R5+(Y(4)-UB)/R6+(1.D0-ALPHA)*FAC1
         F(5)=(Y(5)-UB)/R4+ALPHA*FAC2
         F(6)=Y(6)/R3-FAC2
         F(7)=Y(7)/R1+(Y(7)-UB)/R2+(1.D0-ALPHA)*FAC2
         F(8)=(Y(8)-UET)/R0
      end subroutine transamp_derivs


      subroutine transamp_jacob(n,x,y,f,dfy,ldfy,lrpar,rpar,lipar,ipar,ierr)
        IMPLICIT REAL*8 (A-H,O-Z)
         integer, intent(in) :: n, ldfy, lrpar, lipar
         double precision, intent(in) :: x
         double precision, intent(inout) :: y(n)
         double precision, intent(out) :: f(n), dfy(ldfy,n)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(inout), target :: ipar(lipar)
         double precision :: yprime(n)
         integer, intent(out) :: ierr
         integer :: nz, i, j
         ierr = 0
         ipar(i_njac) = ipar(i_njac) + 1
         FAC14=BETA*DEXP((Y(4)-Y(3))/UF)/UF
         FAC27=BETA*DEXP((Y(7)-Y(6))/UF)/UF
         DO J=1,8
            DFY(1,J)=0.D0
            DFY(2,J)=0.D0
            DFY(4,J)=0.D0
         end do 
         DFY(3,1)=1.D0/R9
         DFY(3,2)=1.D0/R8
         DFY(2,3)=-ALPHA*FAC14
         DFY(1,4)=ALPHA*FAC14
         DFY(3,3)=1.D0/R7+FAC14
         DFY(2,4)=-FAC14
         DFY(3,4)=1.D0/R5+1.D0/R6+(1.D0-ALPHA)*FAC14
         DFY(4,3)=-(1.D0-ALPHA)*FAC14
         DFY(3,5)=1.D0/R4
         DFY(2,6)=-ALPHA*FAC27
         DFY(1,7)=ALPHA*FAC27
         DFY(3,6)=1.D0/R3+FAC27
         DFY(2,7)=-FAC27
         DFY(3,7)=1.D0/R1+1.D0/R2+(1.D0-ALPHA)*FAC27
         DFY(4,6)=-(1.D0-ALPHA)*FAC27
         DFY(3,8)=1.D0/R0
         call transamp_derivs(n, x, Y, F, lrpar,rpar,lipar,ipar, ierr)
      end subroutine transamp_jacob


      subroutine transamp_mas(n,am,lmas,lrpar,rpar,lipar,ipar)
         integer, intent(in) :: n, lmas, lrpar, lipar
         double precision, intent(out) :: am(lmas,n)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(inout), target :: ipar(lipar)
         double precision, parameter :: c1=1d-6,c2=2d-6,c3=3d-6,c4=4d-6,c5=5d-6
         am = 0
         am(2,1)=-C5
         am(1,2)=C5
         am(3,1)=C5
         am(2,2)=-C5
         am(2,3)=-C4
         am(2,4)=-C3
         am(1,5)=C3
         am(3,4)=C3
         am(2,5)=-C3
         am(2,6)=-C2
         am(2,7)=-C1
         am(1,8)=C1
         am(3,7)=C1
         am(2,8)=-C1
      end subroutine transamp_mas


      subroutine transamp_sjac(n,x,y,f,nzmax,ia,ja,values,lrpar,rpar,lipar,ipar,ierr)  
         ! sparse jacobian. format either compressed row or compressed column.
         use mtx_lib!,only:band_to_row_sparse_with_diag,band_to_col_sparse_with_diag
         use test_int_support,only:ipar_sparse_format
         integer, intent(in) :: n, nzmax, lrpar, lipar
         double precision, intent(in) :: x
         double precision, intent(inout) :: y(n)
         integer, intent(out) :: ia(n+1), ja(nzmax)
         double precision, intent(out) :: f(n), values(nzmax)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(inout), target :: ipar(lipar)
         integer, intent(out) :: ierr ! nonzero means terminate integration
         double precision :: dfdy(mljac+mujac+1,n), dns(n,n), filler
         integer :: ld_dfdy, nz, i, j
         ld_dfdy = mljac+mujac+1
         ierr = 0
         call transamp_jacob(n,x,y,f,dfdy,ld_dfdy,lrpar,rpar,lipar,ipar,ierr)
         call band_to_dense(n,mljac,mujac,dfdy,ld_dfdy,n,dns,ierr)
         filler = 9d-99
         do i=1,n
            do j=1,n
               if (abs(i-j) <= 1 .and. dns(i,j) == 0) dns(i,j) = filler
            end do
         end do
         if (ipar(ipar_sparse_format) == 0) then
            call dense_to_row_sparse(n,n,dns,nzmax,nz,ia,ja,values,ierr)
         else
            call dense_to_column_sparse(n,n,dns,nzmax,nz,ia,ja,values,ierr)
         end if
         do i=1,nz
            if (values(i) == filler) values(i) = 0d0 
         end do
      end subroutine transamp_sjac


      subroutine transamp_solout(nr,xold,x,n,y,rwork,iwork,interp_y,lrpar,rpar,lipar,ipar,irtrn)
         ! nr is the step number.
         ! x is the current x value; xold is the previous x value.
         ! y is the current y value.
         ! irtrn negative means terminate integration.
         ! rwork and iwork hold info for 
         integer, intent(in) :: nr, n, lrpar, lipar
         double precision, intent(in) :: xold, x
         double precision, intent(inout) :: y(n)
         double precision, intent(inout), target :: rpar(lrpar), rwork(*)
         integer, intent(inout), target :: ipar(lipar), iwork(*)
         interface
            ! this subroutine can be called from your solout routine.
            ! it computes interpolated values for y components during the just completed step.
            double precision function interp_y(i,s,rwork,iwork,ierr)
               integer, intent(in) :: i ! result is interpolated approximation of y(i) at x=s.
               double precision, intent(in) :: s ! interpolation x value (between xold and x).
               double precision, intent(inout), target :: rwork(*)
               integer, intent(inout), target :: iwork(*)
               integer, intent(out) :: ierr
            end function interp_y
         end interface
         integer, intent(out) :: irtrn
         integer :: i
         irtrn = 0
      end subroutine transamp_solout
      
      
      subroutine do_test_transamp(which_solver,which_decsol,numerical_jacobian,show_all,quiet)
         use test_support,only:show_results,show_statistics,check_results
         use test_int_support,only:do_test_stiff_int
         integer, intent(in) :: which_solver,which_decsol
         logical, intent(in) :: numerical_jacobian,show_all,quiet

         integer, parameter :: n = 8 ! the number of variables in the "transamp" system of ODEs
         double precision :: y(n), yprime(n), yexact(n)
         integer, parameter :: lrpar = 1, lipar = 3, iout=1
         double precision :: rpar(lrpar)
         integer :: ipar(lipar)
         logical :: consis
         integer, parameter :: ndisc = 0
         double precision :: h0, t(0:ndisc+1), atol(1), rtol(1)
         integer :: i, matrix_type_spec, ierr, imas, mlmas, mumas, m1, m2, itol, nstep
            
         if (.not. quiet) write(*,*) 'transamp'
         
         UE=0.1D0
         UB=6.0D0
         UF=0.026D0
         ALPHA=0.99D0
         BETA=1.0D-6
         R0=1000.0D0
         R1=9000.0D0
         R2=9000.0D0
         R3=9000.0D0
         R4=9000.0D0
         R5=9000.0D0
         R6=9000.0D0
         R7=9000.0D0
         R8=9000.0D0
         R9=9000.0D0
         
         t(0)   = 0
         t(1)   = 0.05d0
         
         itol = 0 ! scalar tolerances
         rtol(1) = 1d-3
         atol(1) = 1d-3
         h0 = 1d-6 ! initial step size
         
         matrix_type_spec = banded_matrix_type
         mljac = 1
         mujac = 2
         
         ! mass matrix is banded
         imas = 1
         mlmas = 1
         mumas = 1
         
         m1 = 0
         m2 = 0     
         
         ! initial values
         Y(1)=0.D0
         Y(2)=UB-Y(1)*R8/R9
         Y(3)=UB/(R6/R5+1.D0)
         Y(4)=UB/(R6/R5+1.D0)
         Y(5)=UB
         Y(6)=UB/(R2/R1+1.D0)
         Y(7)=UB/(R2/R1+1.D0)
         Y(8)=0.D0
         
         nstep=0  
         call do_test_stiff_int(which_solver,which_decsol,numerical_jacobian, &
               transamp_derivs,transamp_jacob,transamp_sjac,transamp_solout,iout, &
               n,ndisc,mljac,mujac,matrix_type_spec,transamp_mas,imas,mlmas,mumas,m1,m2, &
               t,rtol,atol,itol,h0,y,nstep,lrpar,rpar,lipar,ipar,quiet,ierr)
         if (ierr /= 0) then
            write(*,*) 'test_transamp ierr', ierr
            stop 1
         end if
         
         yexact(1:8) = (/  &
            4.7269434581942693d-01, &
            5.5353553779092932d+00, &
            2.4949640519478082d+00, &
            2.4341844775823946d+00, &
            3.4672884627046883d+00, &
            2.8499578320369832d+00, &
            3.0065215303610415d+00, &
            -5.5619377536061318d-03 /)

         call check_results(n,y,yexact,rtol(1)*2,ierr)
         if (ierr /= 0) then
            write(*,*) 'check results ierr', ierr
            stop 1 ! do_test_vdpol
         end if
         
         if (quiet) return
         
         call show_results(n,y,yexact,show_all)
         call show_statistics(ipar(i_nfcn),ipar(i_njac),nstep,show_all)

      end subroutine do_test_transamp
            
      
      end module test_transamp
