      module test_radau5_support
      use num_def
      use num_lib
      use alert_lib
      implicit none
            
      integer, parameter :: ipar_sparse_format = 1
         ! =0 means compressed row format; else, compressed column format.
      integer, parameter :: i_nfcn=2
      integer, parameter :: i_njac=3

      contains
            
      
      
      
      subroutine do_test_radau5(which_decsol, numerical_jacobian, &
            fcn,jac,sjac,solout,iout_input,n,ndisc,mljac,mujac,matrix_type_spec, &
            mas,imas,mlmas,mumas,m1,m2,t,rtol,atol,itol,&
            h0,y,nstep,nfcn,njac,naccpt,nrejct,ndec,nsol,lrpar,rpar,lipar,ipar,quiet,ierr)
         use test_support,only:show_results,show_statistics
         use mtx_lib
         use mtx_def
         integer, intent(in) :: which_decsol
         interface
            include 'num_fcn.dek'
            include 'num_jac.dek'
            include 'num_sjac.dek'
            include 'num_solout.dek'
            include 'num_mas.dek'
         end interface
         integer, intent(in) :: imas, mlmas, mumas, m1, m2, iout_input
         integer, intent(in) :: n, ndisc, mljac, mujac, matrix_type_spec, lrpar, lipar, itol
         logical, intent(in) :: numerical_jacobian, quiet
         double precision, intent(inout) :: t(0:ndisc+1), rtol(*), atol(*), h0, y(n)
         integer, intent(inout) :: nstep,nfcn,njac,naccpt,nrejct, ndec, nsol
         integer, intent(inout), target :: ipar(lipar)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(out) :: ierr
         

         integer ::  i, k, nsteps, lout, iout, idid, ijac, &
            max_steps, xnstp, naccept, nreject, nrdens, lcd, lrd, lid, lrdc, lidc, &
            nzmax, nrow, ncol, ndns, ndim, lfil, maxits, isparse, liwork, lwork
         double precision :: h, droptol, eps, max_step_size

         integer, pointer :: iwork(:) !(liwork)
         double precision, pointer :: work(:) !(lwork)
         integer, pointer :: ipar_decsol(:) !(lid)
         double precision, pointer :: rpar_decsol(:) !(lrd)
         complex*16, pointer :: cpar_decsol(:) !(lcd)
         double precision, pointer :: rpar_decsolc(:) !(lrdc)
         integer, pointer :: ipar_decsolc(:) !(lidc)
         
         iout = iout_input
         if (quiet) iout = 0
         max_steps = 500000
         max_step_size = 0 
         isparse = 0
         lout = 0
         !lout = 6
         
         if (numerical_jacobian) then
            ijac = 0
         else
            ijac = 1
         end if

         ipar = 0
         rpar = 0         

         nrdens = n

         lid = 0; lrd = 0; lcd = 0; lrdc = 0; lidc = 0
         if (which_decsol == lapack) then
            nzmax = 0
            call lapack_work_sizes(n,lrd,lid)
            call lapack_zwork_sizes(n,mujac,mljac,lcd,lrdc,lidc)
         else


               write(*,*) 'test_radau5_support: bad which_decsol', which_decsol
               stop 1 ! test_int_support


            if (mljac == n) then
               nzmax = n*n
            else
               nzmax = n*(mljac + mujac + 1)
            end if
            if (which_decsol == mkl_pardiso) then
               stop 'mkl_pardiso does not do complex matrices'
            else
               write(*,*) 'test_radau5_support: bad which_decsol', which_decsol
               stop 1 ! test_int_support
            end if
         end if

         call radau5_work_sizes(n,nzmax,mljac,mujac,mlmas,mumas,liwork,lwork)
         
         allocate(iwork(liwork),work(lwork), &
            ipar_decsol(lid),rpar_decsol(lrd),cpar_decsol(lcd), &
            rpar_decsolc(lrdc),ipar_decsolc(lidc), stat=ierr)
         if (ierr /= 0) then
            write(*,*) 'allocate ierr', ierr
            stop 1 ! test_int_support
         end if
      
         iwork = 0
         work = 0
      
         iwork(9) = m1
         iwork(10) = m2

         nstep = 0; nfcn = 0; njac = 0; naccpt = 0; nrejct = 0; ndec = 0; nsol = 0
         eps = rtol(1)
         do i=0,ndisc
            ierr = 0             
            h = h0
            
            if (which_decsol == lapack) then
               if (i==0 .and. .not. quiet) write(*,*) 'lapack'
               call do_radau5(lapack_decsol, null_decsols, lapack_decsolc, null_decsolcs)
            !else if (which_decsol == superLU_DIST) then
            !   if (i==0 .and. .not. quiet) write(*,*) 'superLU_DIST'
            !   call do_radau5(null_decsol, superLU_DIST_decsols, null_decsolc, superLU_decsolcs)
            else
               write(*,*) 'unknown value for which_decsol', which_decsol
               stop 1
            end if

            if (idid /= 1) ierr = -1
            if (ierr /= 0) then
               write(*,*) 'alert message: ' // trim(alert_message)
               stop 1
            end if
            nfcn = nfcn + iwork(14)
            njac = njac + iwork(15)
            nstep = nstep + iwork(16)
            naccpt = naccpt + iwork(17)
            nrejct = nrejct + iwork(18)
            ndec = ndec + iwork(19)
            nsol = nsol + iwork(20)
         end do

         deallocate( &
            iwork,work,ipar_decsol,rpar_decsol,cpar_decsol,rpar_decsolc,ipar_decsolc)
         
         
         contains
         
         
         subroutine do_radau5(decsol, decsols, decsolc, decsolcs)
            interface
               include "mtx_decsol.dek"
               include "mtx_decsols.dek"
               include "mtx_decsolc.dek"
               include "mtx_decsolcs.dek"
            end interface
            integer :: j, idebug
            logical, parameter :: call_debug_routine = .false.
            include 'formats.dek'
            idebug = 0
            call radau5( &
               n, fcn, t(i), y, t(i+1), & 
               h, max_step_size, max_steps, & 
               rtol, atol, itol, & 
               jac, ijac, sjac, nzmax, isparse, mljac, mujac, & 
               mas, imas, mlmas, mumas, & 
               solout, iout, & 
               null_radau5_debug_routine, call_debug_routine, &
               decsol, decsols, &   
               lrd, rpar_decsol, lid, ipar_decsol, &  
               decsolc, decsolcs, &  
               lcd, cpar_decsol, lrdc, rpar_decsolc, lidc, ipar_decsolc, &  
               work, lwork, iwork, liwork, & 
               lrpar, rpar, lipar, ipar, & 
               lout, idid)
         end subroutine do_radau5


      end subroutine do_test_radau5


      end module test_radau5_support
