      module test_hires
      use num_def
      use num_lib
      use alert_lib
      use test_int_support,only:i_nfcn,i_njac
      implicit none

      contains


      subroutine hires_derivs(n, x, vars, dvars_dx, lrpar,rpar,lipar,ipar, ierr)
         integer, intent(in) :: n, lrpar, lipar
         double precision, intent(in) :: x
         double precision, intent(inout) :: vars(n)
         double precision, intent(out) :: dvars_dx(n)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(inout), target :: ipar(lipar)
         double precision :: yprime(n)
         integer, intent(out) :: ierr
         ierr = 0
         ipar(i_nfcn) = ipar(i_nfcn) + 1
         call hires_feval(n,x,vars,yprime,dvars_dx,ierr,rpar,ipar)
      end subroutine hires_derivs


      subroutine hires_jacob(n,x,y,f,dfdy,ld_dfdy,lrpar,rpar,lipar,ipar,ierr)
         integer, intent(in) :: n, ld_dfdy, lrpar, lipar
         double precision, intent(in) :: x
         double precision, intent(inout) :: y(n)
         double precision, intent(out) :: f(n), dfdy(ld_dfdy,n)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(inout), target :: ipar(lipar)
         integer, intent(out) :: ierr
         integer :: nzo, i, j
         double precision :: yprime(n)
         ierr = 0
         ipar(i_njac) = ipar(i_njac) + 1
         call hires_jeval(ld_dfdy,n,x,y,yprime,dfdy,ierr,rpar,ipar)
         if (ierr == 0) call hires_derivs(n, x, y, f, lrpar,rpar,lipar,ipar, ierr)
      end subroutine hires_jacob


      subroutine hires_sjac(n,x,y,f,nzmax,ia,ja,values,lrpar,rpar,lipar,ipar,ierr)  
         ! sparse jacobian. format either compressed row or compressed column.
         use mtx_lib,only:dense_to_row_sparse_with_diag,dense_to_col_sparse_with_diag
         use test_int_support,only:ipar_sparse_format
         integer, intent(in) :: n, nzmax, lrpar, lipar
         double precision, intent(in) :: x
         double precision, intent(inout) :: y(n)
         integer, intent(out) :: ia(n+1), ja(nzmax)
         double precision, intent(out) :: f(n), values(nzmax)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(inout), target :: ipar(lipar)
         integer, intent(out) :: ierr ! nonzero means terminate integration
         double precision :: dfdy(n,n)
         integer :: ld_dfdy, nz, i, j
         ld_dfdy = n
         ierr = 0
         call hires_jacob(n,x,y,f,dfdy,ld_dfdy,lrpar,rpar,lipar,ipar,ierr)
         if (ierr /= 0) return
         if (ipar(ipar_sparse_format) == 0) then
            call dense_to_row_sparse_with_diag(n,n,dfdy,nzmax,nz,ia,ja,values,ierr)
         else
            call dense_to_col_sparse_with_diag(n,n,dfdy,nzmax,nz,ia,ja,values,ierr)
         end if
      end subroutine hires_sjac
      
      
      subroutine do_test_hires(which_solver,which_decsol,numerical_jacobian,quiet,show_all)
         use test_support,only:show_results,show_statistics,check_results
         use test_int_support,only:do_test_stiff_int
         integer, intent(in) :: which_solver,which_decsol
         logical, intent(in) :: numerical_jacobian,show_all,quiet

         integer, parameter :: n = 8 ! the number of variables in the "hires" system of ODEs
         integer, parameter :: ndisc = 0, nzo = 25
         double precision :: y(n), yprime(n), yexact(n)
         integer, parameter :: lrpar = 1, lipar = 3, iout=1
         double precision :: rpar(lrpar)
         integer :: ipar(lipar)
         logical :: consis
         integer, parameter :: licn = 5*nzo, lirn = 3*nzo
         double precision :: h0, t(0:ndisc+1), atol(1), rtol(1)
         integer :: i, mujac, mljac, matrix_type_spec, ierr, imas, mlmas, mumas, m1, m2, itol, nstep
         integer :: ivect(nzo), jvect(nzo)

         if (.not. quiet) write(*,*) 'hires'

         t(0)   = 0
         t(1)   = 321.8122d0
         
         itol = 0 ! scalar tolerances
         rtol(1) = 1d-7
         atol(1) = 1d-7
         h0 = 1d-9 ! initial step size
         
         call hires_init(n,t,y,yprime,consis)
         nstep=0   
         mljac = n ! square matrix
         mujac = n
         matrix_type_spec = square_matrix_type

         imas = 0
         mlmas = 0
         mumas = 0        
         
         m1 = 0
         m2 = 0     

         call do_test_stiff_int(which_solver,which_decsol,numerical_jacobian, &
            hires_derivs,hires_jacob,hires_sjac,null_solout,iout,n,ndisc, &
            mljac,mujac,matrix_type_spec,null_mas,imas,mlmas,mumas,m1,m2, &
            t,rtol,atol,itol,h0,y,nstep,lrpar,rpar,lipar,ipar,quiet,ierr)
         if (ierr /= 0) then
            write(*,*) 'test_hires ierr', ierr
            stop 1
         end if
         
         call hires_solut(n,0d0,yexact)
         call check_results(n,y,yexact,rtol(1)*2,ierr)
         if (ierr /= 0) then
            write(*,*) 'check results ierr', ierr
            stop 1 ! do_test_vdpol
         end if
         
         if (quiet) return
         
         call show_results(n,y,yexact,show_all)
         call show_statistics(ipar(i_nfcn),ipar(i_njac),nstep,show_all)

      end subroutine do_test_hires
      
      
      end module test_hires
