      module test_emep
      use num_def
      use num_lib
      use alert_lib
      use test_int_support,only:i_nfcn,i_njac
      implicit none

      contains


      subroutine emep_derivs(n, x, vars, dvars_dx, lrpar,rpar,lipar,ipar, ierr)
         integer, intent(in) :: n, lrpar, lipar
         double precision, intent(in) :: x
         double precision, intent(inout) :: vars(n)
         double precision, intent(out) :: dvars_dx(n)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(inout), target :: ipar(lipar)
         double precision :: yprime(n)
         integer, intent(out) :: ierr
         ierr = 0
         ipar(i_nfcn) = ipar(i_nfcn) + 1
         call emep_feval(n,x,vars,yprime,dvars_dx,ierr,rpar,ipar)
      end subroutine emep_derivs


      subroutine emep_jacob(n,x,y,f,dfdy,ld_dfdy,lrpar,rpar,lipar,ipar,ierr)
         integer, intent(in) :: n, ld_dfdy, lrpar, lipar
         double precision, intent(in) :: x
         double precision, intent(inout) :: y(n)
         double precision, intent(out) :: f(n), dfdy(ld_dfdy,n)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(inout), target :: ipar(lipar)
         integer, intent(out) :: ierr
         integer :: nzo, i, j
         double precision :: yprime(n)
         ierr = 0
         ipar(i_njac) = ipar(i_njac) + 1
         call emep_jeval(ld_dfdy,n,x,y,yprime,dfdy,ierr,rpar,ipar)  
         if (ierr == 0) call emep_derivs(n, x, y, f, lrpar,rpar,lipar,ipar, ierr)       
      end subroutine emep_jacob


      subroutine emep_sjac(n,x,y,f,nzmax,ia,ja,values,lrpar,rpar,lipar,ipar,ierr)  
         ! sparse jacobian. format either compressed row or compressed column.
         use mtx_lib,only:dense_to_row_sparse_with_diag,dense_to_col_sparse_with_diag
         use test_int_support,only:ipar_sparse_format
         integer, intent(in) :: n, nzmax, lrpar, lipar
         double precision, intent(in) :: x
         double precision, intent(inout) :: y(n)
         integer, intent(out) :: ia(n+1), ja(nzmax)
         double precision, intent(out) :: f(n), values(nzmax)
         double precision, intent(inout), target :: rpar(lrpar)
         integer, intent(inout), target :: ipar(lipar)
         integer, intent(out) :: ierr ! nonzero means terminate integration
         double precision :: dfdy(n,n)
         integer :: ld_dfdy, nz
         ld_dfdy = n
         ierr = 0
         call emep_jacob(n,x,y,f,dfdy,ld_dfdy,lrpar,rpar,lipar,ipar,ierr)
         if (ierr /= 0) return
         if (ipar(ipar_sparse_format) == 0) then
            call dense_to_row_sparse_with_diag(n,n,dfdy,nzmax,nz,ia,ja,values,ierr)
         else
            call dense_to_col_sparse_with_diag(n,n,dfdy,nzmax,nz,ia,ja,values,ierr)
         end if
      end subroutine emep_sjac
      
      
      subroutine do_test_emep(which_solver,which_decsol,numerical_jacobian,show_all,quiet)
         use test_support,only:show_results,show_statistics,check_results
         use test_int_support,only:do_test_stiff_int
         integer, intent(in) :: which_solver,which_decsol
         logical, intent(in) :: numerical_jacobian,show_all,quiet

         integer, parameter :: n = 66 ! the number of variables in the "emep" system of ODEs
         integer, parameter :: ndisc = 8, nzo = 496
         double precision :: y(n), yprime(n), yexact(n)
         integer, parameter :: lrpar = 1, lipar = 3, iout=1
         double precision :: rpar(lrpar)
         integer :: ipar(lipar)
         logical :: consis
         integer, parameter :: licn = 5*nzo, lirn = 3*nzo
         double precision :: yc(6), yr(6), h0, t(0:ndisc+1), atol(1), rtol(1)
         integer :: i, mujac, mljac, matrix_type_spec, ierr
         integer :: ivect(nzo), jvect(nzo), imas, mlmas, mumas, m1, m2, itol, nstep

         if (.not. quiet) write(*,*) 'emep'

         t(0)   =  4d0*3600d0
         t(1)   = 20d0*3600d0
         do i=1,4
            t(2*i)   = t(0) + 24d0*3600d0*dble(i)
            t(2*i+1) = t(1) + 24d0*3600d0*dble(i)
         end do
         
         itol = 0 ! scalar tolerances
         rtol(1) = 1d-2
         atol(1) = 1d0
         h0 = 1d-7 ! initial step size
         
         call emep_init(n,t,y,yprime,consis)
         nstep=0      
         mljac = n ! square matrix
         mujac = n
         matrix_type_spec = square_matrix_type

         imas = 0
         mlmas = 0
         mumas = 0        
         
         m1 = 0
         m2 = 0     
         
         call do_test_stiff_int(which_solver,which_decsol,numerical_jacobian, &
            emep_derivs,emep_jacob,emep_sjac,null_solout,iout,n,ndisc, &
            mljac,mujac,matrix_type_spec,null_mas,imas,mlmas,mumas,m1,m2, &
            t,rtol,atol,itol,h0,y,nstep,lrpar,rpar,lipar,ipar,quiet,ierr)
         if (ierr /= 0) then
            write(*,*) 'test emep ierr', ierr
            stop 1
         end if
         
         call emep_solut(n,0d0,yexact)
         yc(1) = y(1);  yr(1) = yexact(1)  ! N0
         yc(2) = y(2);  yr(2) = yexact(2)  ! NO2
         yc(3) = y(3);  yr(3) = yexact(3)  ! SO2
         yc(4) = y(5);  yr(4) = yexact(5)  ! CH4
         yc(5) = y(14); yr(5) = yexact(14) ! O3
         yc(6) = y(40); yr(6) = yexact(40) ! N2O5
         call check_results(n,y,yexact,rtol(1)*2,ierr)
         if (ierr /= 0) then
            write(*,*) 'check results ierr', ierr
            stop 1 ! do_test_vdpol
         end if
         
         if (quiet) return
         
         call show_results(6,yc,yr,show_all)
         call show_statistics(ipar(i_nfcn),ipar(i_njac),nstep,show_all)

      end subroutine do_test_emep


      end module test_emep
