      module test_bobyqa
      
      use num_def
      use num_lib

      contains
      
      subroutine do_test_bobyqa      
!
!     Test problem for BOBYQA, the objective function being the sum of
!     the reciprocals of all pairwise distances between the points P_I,
!     I=1,2,...,M in two dimensions, where M=N/2 and where the components
!     of P_I are X(2*I-1) and X(2*I). Thus each vector X of N variables
!     defines the M points P_I. The initial X gives equally spaced points
!     on a circle. Four different choices of the pairs (N,NPT) are tried,
!     namely (10,16), (10,21), (20,26) and (20,41). Convergence to a local
!     minimum that is not global occurs in both the N=10 cases. The details
!     of the results are highly sensitive to computer rounding errors. The
!     choice IPRINT=2 provides the current X and optimal F so far whenever
!     RHO is reduced. The bound constraints of the problem require every
!     component of X to be in the interval [-1,1].
!
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(100),XL(100),XU(100),W(500000)
      real*8, parameter :: max_valid_value = 1d99
      TWOPI=8.0D0*DATAN(1.0D0)
      BDL=-1.0D0
      BDU=1.0D0
      IPRINT=0
      MAXFUN=500000
      RHOBEG=1.0D-1
      RHOEND=1.0D-6
      M=10
   10 N=2*M
      DO 20 I=1,N
      XL(I)=BDL
   20 XU(I)=BDU
      DO 50 JCASE=1,1
      NPT=N+6
      IF (JCASE .EQ. 2) NPT=2*N+1
      DO 40 J=1,M
      TEMP=DFLOAT(J)*TWOPI/DFLOAT(M)
      X(2*J-1)=DCOS(TEMP)
   40 X(2*J)=DSIN(TEMP)
      CALL BOBYQA (N,NPT,X,XL,XU,RHOBEG,RHOEND,IPRINT,MAXFUN,W,CALFUN,max_valid_value)
   50 CONTINUE
      M=M+M
      !IF (M .LE. 10) GOTO 10
      call calfun(n,x,f)
      write(*,*) 'test bobyqa: min f', f
      write(*,*)
      END subroutine do_test_bobyqa


      SUBROUTINE CALFUN (N,X,F)
      implicit none
      integer, intent(in) :: n
      double precision, intent(in) :: x(*)
      double precision, intent(out) :: f
      integer :: i, j
      double precision :: temp
      F=0.0D0
      DO 10 I=4,N,2
      DO 10 J=2,I-2,2
      TEMP=(X(I-1)-X(J-1))**2+(X(I)-X(J))**2
      TEMP=DMAX1(TEMP,1.0D-6)
   10 F=F+1.0D0/DSQRT(TEMP)
      RETURN
      END SUBROUTINE CALFUN
      
      
      end module test_bobyqa
