      module test_rodas5
      
      logical, parameter :: dbg = .true.
      
      contains

  
 
      subroutine vdp_fcn(neqn,t,y,f)
      integer neqn
      double precision t,y(neqn),f(neqn)

      f(1) = y(2)
      f(2) = ((1-y(1)**2)*y(2)-y(1))/1.0d-3
      
      !write(*,*) 'func y(1)', y(1)
      !write(*,*) 'func y(2)', y(2)
      !write(*,*) 'func f(1)', f(1)
      !write(*,*) 'func f(2)', f(2)
      !write(*,*)
      
      return
      end subroutine vdp_fcn

      subroutine vdp_jac(neqn,t,y,dfdy)
      integer ldim,neqn
      double precision t,y(neqn),dfdy(neqn,neqn)

      integer i,j

      dfdy(1,1) = 0d0
      dfdy(1,2) = 1d0
      dfdy(2,1) = (-2.0d0*y(1)*y(2)-1d0)/1.0d-3
      dfdy(2,2) = (1d0-y(1)**2)/1.0d-3
      
      !write(*,*) 'jac_fcn y(1)', y(1)
      !write(*,*) 'jac_fcn y(2)', y(2)
      !write(*,*) 'jac_fcn dfdy(1,1)', dfdy(1,1)
      !write(*,*) 'jac_fcn dfdy(1,2)', dfdy(1,2)
      !write(*,*) 'jac_fcn dfdy(2,1)', dfdy(2,1)
      !write(*,*) 'jac_fcn dfdy(2,2)', dfdy(2,2)
      !write(*,*)

      return
      end subroutine vdp_jac
   
      
      

      subroutine rod54(n,fcn,ifcn,x,y,xend,h,
     &                  rtol,atol,itol,
     &                  jac ,ijac,mljac,mujac,dfx,idfx,
     &                  mas ,imas,mlmas,mumas,
     &                  solout,iout,
     &                  work,lwork,iwork,liwork,lrcont,
     &                  idid)
c ----------------------------------------------------------
c     numerical solution of a stiff (or differential algebraic)
c     system of first 0rder ordinary differential equations  my'=f(x,y).
c     this is an embedded rosenbrock method of order (4)5  
c     (with step size control).
c     c.f. sections iv.7  and vi.3
c
c     authors: e. hairer and g. wanner
c              universite de geneve, dept. de mathematiques
c              ch-1211 geneve 24, switzerland 
c              e-mail:  hairer@cgeuge51.bitnet,  wanner@cgeuge51.bitnet
c     
c     this code is part of the book:
c         e. hairer and g. wanner, solving ordinary differential
c         equations ii. stiff and differential-algebraic problems.
c         springer series in computational mathematics,
c         springer-verlag (1990)   
c     modified by di marzo giovanna <dimarzo@cui.unige.ch>            
c      
c     version of march 22, 1993
c
c     input parameters  
c     ----------------  
c     n           dimension of the system 
c
c     fcn         name (external) of subroutine computing the
c                 value of f(x,y):
c                    subroutine fcn(n,x,y,f)
c                    real*8 x,y(n),f(n)
c                    f(1)=...   etc.
c
c     ifcn        gives information on fcn:
c                    ifcn=0: f(x,y) independent of x (autonomous)
c                    ifcn=1: f(x,y) may depend on x (non-autonomous)
c
c     x           initial x-value
c
c     y(n)        initial values for y
c
c     xend        final x-value (xend-x may be positive or negative)
c
c     h           initial step size guess;
c                 for stiff equations with initial transient, 
c                 h=1.d0/(norm of f'), usually 1.d-2 or 1.d-3, is good.
c                 this choice is not very important, the code quickly
c                 adapts its step size. study the chosen values for a few
c                 steps in subroutine "solout", when you are not sure.
c                 (if h=0.d0, the code puts h=1.d-6).
c
c     rtol,atol   relative and absolute error tolerances. they
c                 can be both scalars or else both vectors of length n.
c
c     itol        switch for rtol and atol:
c                   itol=0: both rtol and atol are scalars.
c                     the code keeps, roughly, the local error of
c                     y(i) below rtol*abs(y(i))+atol
c                   itol=1: both rtol and atol are vectors.
c                     the code keeps the local error of y(i) below
c                     rtol(i)*abs(y(i))+atol(i).
c
c     jac         name (external) of the subroutine which computes
c                 the partial derivatives of f(x,y) with respect to y
c                 (this routine is only called if ijac=1; supply
c                 a dummy subroutine in the case ijac=0).
c                 for ijac=1, this subroutine must have the form
c                    subroutine jac(n,x,y,dfy,ldfy)
c                    real*8 x,y(n),dfy(ldfy,n)
c                    dfy(1,1)= ...
c                 ldfy, the colomn-length of the array, is
c                 furnished by the calling program.
c                 if (mljac.eq.n) the jacobian is supposed to
c                    be full and the partial derivatives are
c                    stored in dfy as
c                       dfy(i,j) = partial f(i) / partial y(j)
c                 else, the jacobian is taken as banded and
c                    the partial derivatives are stored
c                    diagonal-wise as
c                       dfy(i-j+mujac+1,j) = partial f(i) / partial y(j).
c
c     ijac        switch for the computation of the jacobian:
c                    ijac=0: jacobian is computed internally by finite
c                       differences, subroutine "jac" is never called.
c                    ijac=1: jacobian is supplied by subroutine jac.
c
c     mljac       switch for the banded structure of the jacobian:
c                    mljac=n: jacobian is a full matrix. the linear
c                       algebra is done by full-matrix gauss-elimination.
c                    0<=mljac<n: mljac is the lower bandwith of jacobian 
c                       matrix (>= number of non-zero diagonals below
c                       the main diagonal).
c
c     mujac       upper bandwith of jacobian  matrix (>= number of non-
c                 zero diagonals above the main diagonal).
c                 need not be defined if mljac=n.
c
c     dfx         name (external) of the subroutine which computes
c                 the partial derivatives of f(x,y) with respect to x
c                 (this routine is only called if idfx=1 and ifcn=1;
c                 supply a dummy subroutine in the case idfx=0 or ifcn=0).
c                 otherwise, this subroutine must have the form
c                    subroutine dfx(n,x,y,fx)
c                    real*8 x,y(n),fx(n)
c                    fx(1)= ...
c                
c     idfx        switch for the computation of the df/dx:
c                    idfx=0: df/dx is computed internally by finite
c                       differences, subroutine "dfx" is never called.
c                    idfx=1: df/dx is supplied by subroutine dfx.
c
c     ----   mas,imas,mlmas, and mumas have analog meanings      -----
c     ----   for the "mass matrix" (the matrix "m" of section iv.8): -
c
c     mas         name (external) of subroutine computing the mass-
c                 matrix m.
c                 if imas=0, this matrix is assumed to be the identity
c                 matrix and needs not to be defined;
c                 supply a dummy subroutine in this case.
c                 if imas=1, the subroutine mas is of the form
c                    subroutine mas(n,am,lmas)
c                    real*8 am(lmas,n)
c                    am(1,1)= ....
c                    if (mlmas.eq.n) the mass-matrix is stored
c                    as full matrix like
c                         am(i,j) = m(i,j)
c                    else, the matrix is taken as banded and stored
c                    diagonal-wise as
c                         am(i-j+mumas+1,j) = m(i,j).
c
c     imas       gives information on the mass-matrix:
c                    imas=0: m is supposed to be the identity
c                       matrix, mas is never called.
c                    imas=1: mass-matrix  is supplied.
c
c     mlmas       switch for the banded structure of the mass-matrix:
c                    mlmas=n: the full matrix case. the linear
c                       algebra is done by full-matrix gauss-elimination.
c                    0<=mlmas<n: mlmas is the lower bandwith of the
c                       matrix (>= number of non-zero diagonals below
c                       the main diagonal).
c                 mlmas is supposed to be .le. mljac.
c
c     mumas       upper bandwith of mass-matrix (>= number of non-
c                 zero diagonals above the main diagonal).
c                 need not be defined if mlmas=n.
c                 mumas is supposed to be .le. mujac.
c
c     solout      name (external) of subroutine providing the
c                 numerical solution during integration. 
c                 if iout=1, it is called after every successful step.
c                 supply a dummy subroutine if iout=0. 
c                 it must have the form
c                    subroutine solout (nr,xold,x,y,n,irtrn)
c                    real*8 x,y(n)
c                    ....  
c                 solout furnishes the solution "y" at the nr-th
c                    grid-point "x" (thereby the initial value is
c                    the first grid-point).
c                 "xold" is the preceeding grid-point.
c                 "irtrn" serves to interrupt the integration. if irtrn
c                    is set <0, rodas returns to the calling program.
c           
c          -----  continuous output: -----
c                 during calls to "solout", a continuous solution
c                 for the interval [xold,x] is available through
c                 the function
c                        >>>   corod5(i,s)   <<<
c                 which provides an approximation to the i-th
c                 component of the solution at the point s. the value
c                 s should lie in the interval [xold,x].
c           
c     iout        gives information on the subroutine solout:
c                    iout=0: subroutine is never called
c                    iout=1: subroutine is used for output
c
c     work        array of working space of length "lwork".
c                 serves as working space for all vectors and matrices.
c                 "lwork" must be at least
c                             n*(ljac+lmas+le1+(s+5))+4
c                 where
c                    ljac=n              if mljac=n (full jacobian)
c                    ljac=mljac+mujac+1  if mljac<n (banded jac.)
c                 and                  
c                    lmas=0              if imas=0
c                    lmas=n              if imas=1 and mlmas=n (full)
c                    lmas=mlmas+mumas+1  if mlmas<n (banded mass-m.)
c                 and
c                    le1=n               if mljac=n (full jacobian)
c                    le1=2*mljac+mujac+1 if mljac<n (banded jac.).
c                 and 
c                    s = number of stages (s=8)
c                 in the usual case where the jacobian is full and the
c                 mass-matrix is the indentity (imas=0), the minimum
c                 storage requirement is 
c                             lwork = 2*n*n+(s+5)*n+4.
c
c     lwork       declared lenght of array "work".
c
c     iwork       integer working space of lenght "liwork".
c                 "liwork" must be at least n+2.
c
c     liwork      declared lenght of array "iwork".
c
c     lrcont      declared length of common block
c                  >>>  common /conros/icont(4),rcont(lrcont)  <<<
c                 which must be declared in the calling program.
c                 "lrcont" must be at least
c                             5*n+2 .
c                 this is used for storing the coefficients of the
c                 continuous solution and makes the calling list for the
c                 function "contd5" as simple as possible.
c
c ----------------------------------------------------------------------
c 
c     sophisticated setting of parameters
c     -----------------------------------
c              several parameters of the code are tuned to make it work 
c              well. they may be defined by setting work(1),..,work(4)
c              as well as iwork(1),iwork(2) different from zero.
c              for zero input, the code chooses default values:
c
c    iwork(1)  this is the maximal number of allowed steps.
c              the default value (for iwork(1)=0) is 100000.
c
c    iwork(2)  switch for the choice of the coefficients
c              if iwork(2).eq.1  method with parameters of schneider
c              if iwork(2).eq.2  method rod5_1
c              if iwork(2).eq.3  method rod5_2
c              the default value (for iwork(2)=0) is iwork(2)=2.
c
c    work(1)   uround, the rounding unit, default 1.d-16.
c
c    work(2)   maximal step size, default xend-x.
c
c    work(3), work(4)   parameters for step size selection
c              the new step size is chosen subject to the restriction
c                 work(3) <= hnew(j)/hold <= work(4)
c              default values: work(3)=0.2d0, work(4)=6.d0
c
c-----------------------------------------------------------------------
c
c     output parameters 
c     ----------------- 
c     x           x-value where the solution is computed
c                 (after successful return x=xend)
c
c     y(n)        solution at x
c  
c     h           predicted step size of the last accepted step
c
c     idid        reports on successfulness upon return:
c                   idid=1  computation successful,
c                   idid=-1 computation unsuccessful.
c
c --------------------------------------------------------- 
c *** *** *** *** *** *** *** *** *** *** *** *** ***
c          declarations 
c *** *** *** *** *** *** *** *** *** *** *** *** ***
      implicit real*8 (a-h,o-z)
      dimension y(n),atol(1),rtol(1),work(lwork),
     &          iwork(liwork)
      logical autnms,implct,jband,arret
      external fcn,jac,dfx,mas,solout
      common/stat/nfcn,njac,nstep,naccpt,nrejct,ndec,nsol
c -----------------------------------------------------
c --- common stat can be used for statistics
c ---    nfcn      number of function evaluations (those for numerical
c                  evaluation of the jacobian are not counted)  
c ---    njac      number of jacobian evaluations (either analytically
c                  or numerically)
c ---    nstep     number of computed steps
c ---    naccpt    number of accepted steps
c ---    nrejct    number of rejected steps (after at least one step
c                  has been accepted)
c ---    ndec      number of lu-decompositions (n-dimensional matrix)
c ---    nsol      number of forward-backward substitutions
c -----------------------------------------------------------
c *** *** *** *** *** *** ***
c        setting the parameters 
c *** *** *** *** *** *** ***
      nfcn=0
      naccpt=0
      nrejct=0
      nstep=0
      njac=0
      ndec=0
      nsol=0
      arret=.false.
c -------- nmax , the maximal number of steps -----
      if(iwork(1).eq.0)then
         nmax=100000
      else
         nmax=iwork(1)
         if(nmax.le.0)then
            write(6,*)' wrong input iwork(1)=',iwork(1)
            arret=.true.
         end if
      end if
c -------- meth   coefficients of the method
      if(iwork(2).eq.0)then
         meth=2
      else
         meth=iwork(2)
         if(meth.le.0.or.meth.ge.4)then
            write(6,*)' curious input iwork(2)=',iwork(2)
            arret=.true.
         end if
      end if
c -------- uround   smallest number satisfying 1.d0+uround>1.d0  
      if(work(1).eq.0.d0)then
         uround=1.d-16
      else
         uround=work(1)
         if(uround.le.1.d-16.or.uround.ge.1.d0)then
            write(6,*)' coefficients have 16 digits, uround=',work(1)
            arret=.true.
         end if
      end if
c -------- maximal step size
      if(work(2).eq.0.d0)then
         hmax=xend-x
      else
         hmax=work(2)
      end if
c -------  fac1,fac2     parameters for step size selection
      if(work(3).eq.0.d0)then
         fac1=5.d0
      else
         fac1=1.d0/work(3)
      end if
      if(work(4).eq.0.d0)then
         fac2=1.d0/6.0d0
      else
         fac2=1.d0/work(4)
      end if
c --------- check if tolerances are o.k.
      if (itol.eq.0) then
          if (atol(1).le.0.d0.or.
     &        rtol(1).le.10.d0*uround) then
              write (6,*) ' tolerances are too small'
              arret=.true.
          end if
      else
          do 15 i=1,n
          if (atol(i).le.0.d0.or.
     &        rtol(i).le.10.d0*uround) then
              write (6,*) ' tolerances(',i,') are too small'
              arret=.true.
          end if
  15      continue
      end if
c *** *** *** *** *** *** *** *** *** *** *** *** ***
c         computation of array entries
c *** *** *** *** *** *** *** *** *** *** *** *** ***
c ---- autonomous, implicit, banded or not ?
      autnms=ifcn.eq.0
      implct=imas.ne.0
      jband=mljac.ne.n
      arret=.false.
c -------- computation of the row-dimensions of the 2-arrays ---
c -- jacobian and matrix e
      if(jband)then
         ldjac=mljac+mujac+1
         lde=mljac+ldjac
      else
         ldjac=n
         lde=n
      end if
c -- mass matrix
      if (implct) then
          if (mlmas.ne.n) then
              ldmas=mlmas+mumas+1
          else
              ldmas=n
          end if
c ------ bandwith of "mas" not larger than bandwith of "jac"
          if (mlmas.gt.mljac.or.mumas.gt.mujac) then
              write (6,*) 'bandwith of "mas" not larger than bandwith of
     & "jac"'
            arret=.true.
          end if
      else
          ldmas=0
      end if
      ldmas2=max(1,ldmas)
c ------- prepare the entry-points for the arrays in work -----
      ieynew=5
      iedy1=ieynew+n
      iedy=iedy1+n
      ieak1=iedy+n
      ieak2=ieak1+n
      ieak3=ieak2+n
      ieak4=ieak3+n
      ieak5=ieak4+n
      ieak6=ieak5+n
      ieak7=ieak6+n
      ieak8=ieak7+n
      ieak9=ieak8+n
      iefx =ieak9+n
      iejac=iefx +n
      iemas=iejac+n*ldjac
      iee  =iemas+n*ldmas
c ------ total storage requirement -----------
      istore=iee+n*lde-1
      if(istore.gt.lwork)then
         write(6,*)' insufficient storage for work, min. lwork=',istore
         arret=.true.
      end if
c ------- entry points for integer workspace -----
      ieip=3
      istore=ieip+n-1
      if(istore.gt.liwork)then
         write(6,*)' insuff. storage for iwork, min. liwork=',istore
         arret=.true.
      end if
c --------- requirement for rcont ---------------
      if(5*n+2.gt.lrcont)then
         write(6,*)' insuff. storage for rcont, min. lrcont=',5*n+2
         arret=.true.
      end if
c ------ when a fail has occured, we return with idid=-1
      if (arret) then
         idid=-1
         return
      end if
c -------- call to core integrator ------------
      call rocor5(n,fcn,x,y,xend,hmax,h,rtol,atol,itol,
     &   jac,ijac,mljac,mujac,dfx,idfx,mas,mlmas,mumas,
     &   solout,iout,idid,nmax,uround,meth,fac1,fac2,
     &   autnms,implct,jband,ldjac,lde,ldmas2,
     &   work(ieynew),work(iedy1),work(iedy),work(ieak1),
     &   work(ieak2),work(ieak3),work(ieak4),work(ieak5),
     &   work(ieak6),work(ieak7),work(ieak8),work(ieak9),
     &   work(iefx),work(iejac),work(iee),work(iemas),
     &   iwork(ieip))
c ----------- return -----------
      return
      end subroutine rod54
c
c
c
c  ----- ... and here is the core integrator  ----------
c
      subroutine rocor5(n,fcn,x,y,xend,hmax,h,rtol,atol,itol,
     &  jac,ijac,mljac,mujac,dfx,idfx,mas,mlmas,mumas,solout,
     &  iout,idid,nmax,uround,meth,fac1,fac2,autnms,implct,
     &  banded,ldjac,lde,ldmas,ynew,dy1,dy,ak1,ak2,ak3,ak4,
     &  ak5,ak6,ak7,ak8,ak9,fx,fjac,e,fmas,ip)
c ----------------------------------------------------------
c     core integrator for rodas
c     parameters same as in rodas with workspace added 
c ---------------------------------------------------------- 
c         declarations 
c ---------------------------------------------------------- 
      implicit real*8 (a-h,o-z)
      real*8 y(n),ynew(n),dy1(n),dy(n),ak1(n),
     *  ak2(n),ak3(n),ak4(n),ak5(n),ak6(n),ak7(n),ak8(n),
     *  ak9(n),fx(n),fjac(ldjac,n),e(lde,n),fmas(ldmas,n),
     *  atol(1),rtol(1)
      integer ip(n)
      logical reject,autnms,implct,banded
      common/stat/nfcn,njac,nstep,naccpt,nrejct,ndec,nsol
      common /conros/nn,nn2,nn3,nn4,xold,hout,cont(1)
c *** *** *** *** *** *** ***
c  initialisations
c *** *** *** *** *** *** ***    
      nn=n 
      nn2=2*n
      nn3=3*n
      nn4=4*n
c ------- compute mass matrix for implicit case ----------
      if(implct)call mas(n,fmas,ldmas)
c ------- forwaed or backward integration ---- 
      posneg=dsign(1.d0,xend-x)
c ------ set the parameters of the method -----
      call rod5(meth,a21,a31,a32,a41,a42,a43,a51,a52,a53,a54,
     &              a61,a62,a63,a64,a65,
     &              c21,c31,c32,c41,c42,c43,c51,c52,c53,c54,
     &              c61,c62,c63,c64,c65,c71,c72,c73,c74,c75,
     &              c76,c81,c82,c83,c84,c85,c86,c87,gamma,
     &              c2,c3,c4,c5,d1,d2,d3,d4,d5,
     &              d21,d22,d23,d24,d25,d26,d27,d28,
     &              d31,d32,d33,d34,d35,d36,d37,d38,
     &              d41,d42,d43,d44,d45,d46,d47,d48)

c --- initial preparations
      hmaxn=dmin1(dabs(hmax),dabs(xend-x))
      h=dmin1(dmax1(1.d-10,dabs(h)),hmaxn) 
      h=dsign(h,posneg) 
      reject=.false.
      nsing=0
      irtrn=1
c -------- prepare band-widths --------
      mbdiag=mumas+1
      if (banded) then
          mle=mljac
          mue=mujac
          mbjac=mljac+mujac+1
          mbb=mlmas+mumas+1
          mdiag=mle+mue+1
          mdiff=mle+mue-mumas
      end if
      if (iout.ne.0) then 
          xold=x
          irtrn=1
          hout=h
          call solout(naccpt+1,xold,x,y,n,irtrn)
          if (irtrn.lt.0) goto 79
      end if
c --- basic integration step  
   1  if (nstep.gt.nmax.or.
     &    x+.1d0*h.eq.x.or.dabs(h).le.uround) then
         write(*,*)
         goto 79
      endif
      if ((x-xend)*posneg+uround.gt.0.d0) then
          h=hopt
          idid=1
          return
      end if
      hopt=h
      if ((x+h-xend)*posneg.gt.0.d0) h=xend-x
c *** *** *** *** *** *** ***
c  computation of the jacobian
c *** *** *** *** *** *** ***
      call fcn(n,x,y,dy1)
      nfcn=nfcn+1
      njac=njac+1
      if (ijac.eq.0) then
c --- compute jacobian matrix numerically
          if (banded) then
c --- jacobian is banded
              mujacp=mujac+1
              md=min(mbjac,n)
              do 16 k=1,md
              j=k
 12           ak2(j)=y(j)
              ak3(j)=dsqrt(uround*max(1.d-5,abs(y(j))))
              y(j)=y(j)+ak3(j)
              j=j+md
              if (j.le.n) goto 12 
              call fcn(n,x,y,ak1)
              j=k
              lbeg=max(1,j-mujac)
 14           lend=min(n,j+mljac)
              y(j)=ak2(j)
              mujacj=mujacp-j
              do 15 l=lbeg,lend
 15           fjac(l+mujacj,j)=(ak1(l)-dy1(l))/ak3(j) 
              j=j+md
              lbeg=lend+1
              if (j.le.n) goto 14
 16           continue
          else
c --- jacobian is full
              do 18 i=1,n
              ysafe=y(i)
              delt=dsqrt(uround*max(1.d-5,abs(ysafe)))
              y(i)=ysafe+delt
              call fcn(n,x,y,ak1)
              do 17 j=1,n
  17          fjac(j,i)=(ak1(j)-dy1(j))/delt
  18          y(i)=ysafe
              mljac=n
          end if
      else
c --- compute jacobian matrix analytically
          call jac(n,x,y,fjac,ldjac)
      end if
      if (.not.autnms) then
          if (idfx.eq.0) then
c --- compute numerically the derivative with respect to x
              delt=dsqrt(uround*max(1.d-5,abs(x)))
              xdelt=x+delt
              call fcn(n,xdelt,y,ak1)
              do 19 j=1,n
  19          fx(j)=(ak1(j)-dy1(j))/delt
          else
c --- compute analytically the derivative with respect to x
              call dfx(n,x,y,fx)
          end if
      end if
   2  continue
c *** *** *** *** *** *** ***
c  compute the stages
c *** *** *** *** *** *** ***
      ndec=ndec+1
c --- prepare for the computation of the 8 stages
      hc21=c21/h
      hc31=c31/h
      hc32=c32/h
      hc41=c41/h
      hc42=c42/h
      hc43=c43/h
      hc51=c51/h
      hc52=c52/h
      hc53=c53/h
      hc54=c54/h
      hc61=c61/h
      hc62=c62/h
      hc63=c63/h
      hc64=c64/h
      hc65=c65/h
      hc71=c71/h
      hc72=c72/h
      hc73=c73/h
      hc74=c74/h
      hc75=c75/h
      hc76=c76/h
      hc81=c81/h
      hc82=c82/h
      hc83=c83/h
      hc84=c84/h
      hc85=c85/h
      hc86=c86/h
      hc87=c87/h
      fac=1.d0/(h*gamma)
      
      write(*,*) 'TRUTH VERSION'
      write(*,*)
      
      if (implct) then
          if (banded) then
c + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
c --- this part computes the stages in the case where
c ---   1) the differential equation is in implicit form
c ---   2) the matrix b and the jacobian of f are banded
c + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
c --- the matrix e (b is a banded matrix, jacobian a banded matrix)
              do 101 j=1,n
              i1=max0(1,mujac+2-j)
              i2=min0(mbjac,n+mujac+1-j)
              do 101 i=i1,i2
  101         e(i+mle,j)=-fjac(i,j)
              do 102 j=1,n
              i1=max0(1,mumas+2-j)
              i2=min0(mbb,n+mumas+1-j)
              do 102 i=i1,i2
              ib=i+mdiff
  102         e(ib,j)=e(ib,j)+fac*fmas(i,j)
              call decb(n,lde,e,mle,mue,ip,info)
              if (info.ne.0) goto 80
              if (autnms) then
c --- the differential equation is autonomous
                  do 110 i=1,n
  110             ak1(i)=dy1(i)
                      call solb(n,lde,e,mle,mue,ak1,ip)
                  do 120 i=1,n
  120             ynew(i)=y(i)+a21*ak1(i) 
                      call fcn(n,x,ynew,dy)
                  do 121 i=1,n
  121             ynew(i)=hc21*ak1(i)
                  do 124 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 123 j=j1,j2
  123             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  124             ak2(i)=sum+dy(i)
                      call solb(n,lde,e,mle,mue,ak2,ip)
                  do 130 i=1,n
  130             ynew(i)=y(i)+a31*ak1(i)+a32*ak2(i)  
                      call fcn(n,x,ynew,dy)
                  do 131 i=1,n
  131             ynew(i)=hc31*ak1(i)+hc32*ak2(i)
                  do 134 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 133 j=j1,j2
  133             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  134             ak3(i)=sum+dy(i)
                      call solb(n,lde,e,mle,mue,ak3,ip)
                  do 140 i=1,n
  140             ynew(i)=y(i)+a41*ak1(i)+a42*ak2(i)+
     &                         a43*ak3(i)  
                      call fcn(n,x,ynew,dy)
                  do 141 i=1,n
  141             ynew(i)=hc41*ak1(i)+hc42*ak2(i)+
     &                    hc43*ak3(i) 
                  do 144 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 143 j=j1,j2
  143             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  144             ak4(i)=sum+dy(i)
                      call solb(n,lde,e,mle,mue,ak4,ip)
                  do 150 i=1,n
  150             ynew(i)=y(i)+a51*ak1(i)+a52*ak2(i)+
     &                    a53*ak3(i)+a54*ak4(i)  
                      call fcn(n,x,ynew,dy)
                  do 151 i=1,n
  151             ynew(i)=hc51*ak1(i)+hc52*ak2(i) 
     &                   +hc53*ak3(i)+hc54*ak4(i)
                  do 154 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 153 j=j1,j2
  153             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  154             ak5(i)=sum+dy(i)
             else
c --- the differential equation is non-autonomous
                  hd1=h*d1
                  hd2=h*d2
                  hd3=h*d3
                  hd4=h*d4
                  hd5=h*d5
                  do 210 i=1,n
  210             ak1(i)=dy1(i)+hd1*fx(i)
                      call solb(n,lde,e,mle,mue,ak1,ip)
                 do 220 i=1,n
  220             ynew(i)=y(i)+a21*ak1(i) 
                      call fcn(n,x+c2*h,ynew,dy)
                  do 221 i=1,n
  221             ynew(i)=hc21*ak1(i)
                  do 224 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 223 j=j1,j2
  223             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  224             ak2(i)=sum+dy(i)+hd2*fx(i)
                      call solb(n,lde,e,mle,mue,ak2,ip)
                  do 230 i=1,n
  230             ynew(i)=y(i)+a31*ak1(i)+a32*ak2(i)  
                      call fcn(n,x+c3*h,ynew,dy)
                  do 231 i=1,n
  231             ynew(i)=hc31*ak1(i)+hc32*ak2(i)
                  do 234 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 233 j=j1,j2
  233             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  234             ak3(i)=sum+dy(i)+hd3*fx(i)
                      call solb(n,lde,e,mle,mue,ak3,ip)
                  do 240 i=1,n
  240             ynew(i)=y(i)+a41*ak1(i)+a42*ak2(i)+
     &                         a43*ak3(i)  
                      call fcn(n,x+c4*h,ynew,dy)
                  do 241 i=1,n
  241             ynew(i)=hc41*ak1(i)+hc42*ak2(i)+
     &                    hc43*ak3(i) 
                  do 244 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 243 j=j1,j2
  243             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  244             ak4(i)=sum+dy(i)+hd4*fx(i)
                      call solb(n,lde,e,mle,mue,ak4,ip)
                  do 250 i=1,n
  250             ynew(i)=y(i)+a51*ak1(i)+a52*ak2(i)+ 
     &                   a53*ak3(i)+a54*ak4(i) 
                      call fcn(n,x+c5*h,ynew,dy)
                  do 251 i=1,n
  251             ynew(i)=hc51*ak1(i)+hc52*ak2(i)+
     &                   hc53*ak3(i)+hc54*ak4(i) 
                  do 254 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 253 j=j1,j2
  253             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  254             ak5(i)=sum+dy(i)+hd5*fx(i)
              end if
c --- the differential equation is autonomous or non-autonomous
                  call solb(n,lde,e,mle,mue,ak5,ip)
              do 260 i=1,n
  260         ynew(i)=y(i)+a61*ak1(i)+a62*ak2(i)
     &                +a63*ak3(i)+a64*ak4(i)+a65*ak5(i)
              call fcn(n,x+h,ynew,dy)
              do 261 i=1,n
  261         ak9(i)=hc61*ak1(i)+hc62*ak2(i)+hc63*ak3(i) 
     &              +hc64*ak4(i)+hc65*ak5(i)
              do 264 i=1,n
              sum=0.d0
              j1=max0(1,i-mlmas)
              j2=min0(n,i+mumas)
              do 263 j=j1,j2
  263         sum=sum+fmas(i-j+mbdiag,j)*ak9(j)
  264         ak6(i)=sum+dy(i)
                  call solb(n,lde,e,mle,mue,ak6,ip)
              do 270 i=1,n
  270         ynew(i)=ynew(i)+ak6(i)
              call fcn(n,x+h,ynew,dy)
              do 271 i=1,n
  271         ak9(i)=hc71*ak1(i)+hc72*ak2(i)+hc73*ak3(i) 
     &              +hc74*ak4(i)+hc75*ak5(i)+hc76*ak6(i)
              do 274 i=1,n
              sum=0.d0
              j1=max0(1,i-mlmas)
              j2=min0(n,i+mumas)
              do 273 j=j1,j2
  273         sum=sum+fmas(i-j+mbdiag,j)*ak9(j)
  274         ak7(i)=sum+dy(i)
                  call solb(n,lde,e,mle,mue,ak7,ip)

c ------------ embedded solution ---------------
              do 280 i=1,n
  280         ynew(i)=ynew(i)+ak7(i)  
              call fcn(n,x+h,ynew,dy)
              do 281 i=1,n
  281         ak9(i)=hc81*ak1(i)+hc82*ak2(i)+hc83*ak3(i)
     &              +hc84*ak4(i)+hc85*ak5(i)+hc86*ak6(i)
     &              +hc87*ak7(i) 
              do 284 i=1,n
              sum=0.d0
              j1=max0(1,i-mlmas)
              j2=min0(n,i+mumas)
              do 283 j=j1,j2
  283         sum=sum+fmas(i-j+mbdiag,j)*ak9(j)
  284         ak8(i)=sum+dy(i)
                  call solb(n,lde,e,mle,mue,ak8,ip)
c ------------ new solution ---------------
              do 285 i=1,n
  285         ynew(i)=ynew(i)+ak8(i)  
          else
              if (mlmas.ne.n) then
c + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
c --- this part computes the stages in the case where
c ---   1) the differential equation is in implicit form
c ---   2) the matrix b is banded but the jacobian of f is not
c + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
c --- the matrix e (b is a banded matrix, jacobian a full matrix)
                  do 301 j=1,n
                  do 301 i=1,n
  301             e(i,j)=-fjac(i,j)
                  do 302 j=1,n
                  i1=max0(1,j-mumas)
                  i2=min0(n,j+mlmas)
                  do 302 i=i1,i2
  302             e(i,j)=e(i,j)+fac*fmas(i-j+mbdiag,j)
                  call dec(n,lde,e,ip,info)
                  if (info.ne.0) goto 80
                  if (autnms) then
c --- the differential equation is autonomous
                  do 310 i=1,n
  310             ak1(i)=dy1(i)
                      call sol(n,lde,e,ak1,ip)
                  do 320 i=1,n
  320             ynew(i)=y(i)+a21*ak1(i) 
                      call fcn(n,x,ynew,dy)
                  do 321 i=1,n
  321             ynew(i)=hc21*ak1(i)
                  do 324 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 323 j=j1,j2
  323             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  324             ak2(i)=sum+dy(i)
                      call sol(n,lde,e,ak2,ip)
                  do 330 i=1,n
  330             ynew(i)=y(i)+a31*ak1(i)+a32*ak2(i)  
                      call fcn(n,x,ynew,dy)
                  do 331 i=1,n
  331             ynew(i)=hc31*ak1(i)+hc32*ak2(i)
                  do 334 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 333 j=j1,j2
  333             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  334             ak3(i)=sum+dy(i)
                      call sol(n,lde,e,ak3,ip)
                  do 340 i=1,n
  340             ynew(i)=y(i)+a41*ak1(i)+a42*ak2(i)+
     &                    a43*ak3(i)  
                      call fcn(n,x,ynew,dy)
                  do 341 i=1,n
  341             ynew(i)=hc41*ak1(i)+hc42*ak2(i)+
     &                    hc43*ak3(i) 
                  do 344 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 343 j=j1,j2
  343             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  344             ak4(i)=sum+dy(i)
                      call sol(n,lde,e,ak4,ip)
                  do 350 i=1,n
  350             ynew(i)=y(i)+a51*ak1(i)+a52*ak2(i)+
     &                    a53*ak3(i)+a54*ak4(i) 
                      call fcn(n,x,ynew,dy)
                  do 351 i=1,n
  351             ynew(i)=hc51*ak1(i)+hc52*ak2(i)+
     &                   hc53*ak3(i)+hc54*ak4(i) 
                  do 354 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 353 j=j1,j2
  353             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  354             ak5(i)=sum+dy(i)
                else
c --- the differential equation is non-autonomous
                  hd1=h*d1
                  hd2=h*d2
                  hd3=h*d3
                  hd4=h*d4
                  hd5=h*d5
                  do 410 i=1,n
  410             ak1(i)=dy1(i)+hd1*fx(i)
                      call sol(n,lde,e,ak1,ip)
                  do 420 i=1,n
  420             ynew(i)=y(i)+a21*ak1(i) 
                      call fcn(n,x+c2*h,ynew,dy)
                  do 421 i=1,n
  421             ynew(i)=hc21*ak1(i)
                  do 424 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 423 j=j1,j2
  423             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  424             ak2(i)=sum+dy(i)+hd2*fx(i)
                      call sol(n,lde,e,ak2,ip)
                  do 430 i=1,n
  430             ynew(i)=y(i)+a31*ak1(i)+a32*ak2(i)  
                      call fcn(n,x+c3*h,ynew,dy)
                  do 431 i=1,n
  431             ynew(i)=hc31*ak1(i)+hc32*ak2(i)
                  do 434 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 433 j=j1,j2
  433             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  434             ak3(i)=sum+dy(i)+hd3*fx(i)
                      call sol(n,lde,e,ak3,ip)
                  do 440 i=1,n
  440             ynew(i)=y(i)+a41*ak1(i)+a42*ak2(i)+
     &                         a43*ak3(i)  
                      call fcn(n,x+c4*h,ynew,dy)
                  do 441 i=1,n
  441             ynew(i)=hc41*ak1(i)+hc42*ak2(i)+
     &                    hc43*ak3(i) 
                  do 444 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 443 j=j1,j2
  443             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  444             ak4(i)=sum+dy(i)+hd4*fx(i)
                      call sol(n,lde,e,ak4,ip)
                  do 450 i=1,n
  450             ynew(i)=y(i)+a51*ak1(i)+a52*ak2(i)+
     &                   a53*ak3(i) +a54*ak4(i) 
                      call fcn(n,x+c5*h,ynew,dy)
                  do 451 i=1,n
  451             ynew(i)=hc51*ak1(i)+hc52*ak2(i)+
     &                   hc53*ak3(i)+hc54*ak4(i) 
                  do 454 i=1,n
                  sum=0.d0
                  j1=max0(1,i-mlmas)
                  j2=min0(n,i+mumas)
                  do 453 j=j1,j2
  453             sum=sum+fmas(i-j+mbdiag,j)*ynew(j)
  454             ak5(i)=sum+dy(i)+hd5*fx(i)
                end if
c --- the differential equation is autonomous or non-autonomous
                    call sol(n,lde,e,ak5,ip)
                do 460 i=1,n
  460           ynew(i)=y(i)+a61*ak1(i)+a62*ak2(i)
     &               +a63*ak3(i)+a64*ak4(i)+a65*ak5(i)  
                call fcn(n,x+h,ynew,dy)
                do 461 i=1,n
  461           ak9(i)=hc61*ak1(i)+hc62*ak2(i)+
     &                hc63*ak3(i) +hc64*ak4(i)
     &                +hc65*ak5(i) 
                do 464 i=1,n
                sum=0.d0
                j1=max0(1,i-mlmas)
                j2=min0(n,i+mumas)
                do 463 j=j1,j2
  463           sum=sum+fmas(i-j+mbdiag,j)*ak9(j)
  464           ak6(i)=sum+dy(i)
                    call sol(n,lde,e,ak6,ip)  
                do 470 i=1,n
  470           ynew(i)=ynew(i)+ak6(i)
                call fcn(n,x+h,ynew,dy)
                do 471 i=1,n
  471           ak9(i)=hc71*ak1(i)+hc72*ak2(i)+ 
     &                hc73*ak3(i)+hc74*ak4(i)
     &               +hc75*ak5(i)+hc76*ak6(i) 
                do 474 i=1,n
                sum=0.d0
                j1=max0(1,i-mlmas)
                j2=min0(n,i+mumas)
                do 473 j=j1,j2
  473           sum=sum+fmas(i-j+mbdiag,j)*ak9(j)
  474           ak7(i)=sum+dy(i)
                    call sol(n,lde,e,ak7,ip)

c ------------ embedded solution ---------------
                do 480 i=1,n
  480           ynew(i)=ynew(i)+ak7(i)  
                call fcn(n,x+h,ynew,dy)
                do 481 i=1,n
  481           ak9(i)=hc81*ak1(i)+hc82*ak2(i)+hc83*ak3(i)
     &                +hc84*ak4(i)+hc85*ak5(i)+hc86*ak6(i)
     &                +hc87*ak7(i) 
                do 484 i=1,n
                sum=0.d0
                j1=max0(1,i-mlmas)
                j2=min0(n,i+mumas)
                do 483 j=j1,j2
  483           sum=sum+fmas(i-j+mbdiag,j)*ak9(j)
  484           ak8(i)=sum+dy(i)
                    call sol(n,lde,e,ak8,ip)
c ------------ new solution ---------------
              do 485 i=1,n
  485         ynew(i)=ynew(i)+ak8(i)  
               else
c + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
c --- this part computes the stages in the case where
c ---   1) the differential equation is in implicit form
c ---   2) the matrix b is not banded 
c + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
c --- the matrix e (b is a full matrix, jacobian a full or banded matrix)
                  if (mljac.eq.n) then
                      do 501 j=1,n
                      do 501 i=1,n
  501                 e(i,j)=fmas(i,j)*fac-fjac(i,j)
                  else
                      madd=mujac+1
                      do 505 j=1,n
                      do 505 i=1,n
  505                 e(i,j)=fmas(i,j)*fac
                      do 506 j=1,n
                      i1=max0(1,j-mujac)
                      i2=min0(n,j+mljac)
                      do 506 i=i1,i2
  506                 e(i,j)=e(i,j)-fjac(i-j+madd,j)
                  end if
                  call dec(n,lde,e,ip,info)
                  if (info.ne.0) goto 80
                  if (autnms) then
c --- the differential equation is autonomous
                      do 510 i=1,n
  510                 ak1(i)=dy1(i)
                          call sol(n,lde,e,ak1,ip)
                      do 520 i=1,n
  520                 ynew(i)=y(i)+a21*ak1(i) 
                          call fcn(n,x,ynew,dy)
                      do 521 i=1,n
  521                 ynew(i)=hc21*ak1(i)
                      do 524 i=1,n
                      sum=0.d0
                      do 523 j=1,n
  523                 sum=sum+fmas(i,j)*ynew(j)
  524                 ak2(i)=sum+dy(i)
                      call sol(n,lde,e,ak2,ip)
                      do 530 i=1,n
  530                 ynew(i)=y(i)+a31*ak1(i)+a32*ak2(i)  
                          call fcn(n,x,ynew,dy)
                      do 531 i=1,n
  531                 ynew(i)=hc31*ak1(i)+hc32*ak2(i)
                      do 534 i=1,n
                      sum=0.d0
                      do 533 j=1,n
  533                 sum=sum+fmas(i,j)*ynew(j)
  534                 ak3(i)=sum+dy(i)
                          call sol(n,lde,e,ak3,ip)
                      do 540 i=1,n
  540                 ynew(i)=y(i)+a41*ak1(i)+a42*ak2(i)
     &                            +a43*ak3(i)  
                          call fcn(n,x,ynew,dy)
                      do 541 i=1,n
  541                 ynew(i)=hc41*ak1(i)+hc42*ak2(i)
     &                        +hc43*ak3(i) 
                      do 544 i=1,n
                      sum=0.d0
                      do 543 j=1,n
  543                 sum=sum+fmas(i,j)*ynew(j)
  544                 ak4(i)=sum+dy(i)
                          call sol(n,lde,e,ak4,ip)
                      do 550 i=1,n
  550                 ynew(i)=y(i)+a51*ak1(i)+a52*ak2(i)
     &                       +a53*ak3(i)+a54*ak4(i)
                          call fcn(n,x,ynew,dy)
                      do 551 i=1,n
  551                 ynew(i)=hc51*ak1(i)+hc52*ak2(i)
     &                       +hc53*ak3(i)+hc54*ak4(i) 
                      do 554 i=1,n
                      sum=0.d0
                      do 553 j=1,n
  553                 sum=sum+fmas(i,j)*ynew(j)
  554                 ak5(i)=sum+dy(i)

                  else
c --- the differential equation is non-autonomous
                      hd1=h*d1
                      hd2=h*d2
                      hd3=h*d3
                      hd4=h*d4
                      hd5=h*d5
                      do 610 i=1,n
  610                 ak1(i)=dy1(i)+hd1*fx(i)
                          call sol(n,lde,e,ak1,ip)
                      do 620 i=1,n
  620                 ynew(i)=y(i)+a21*ak1(i) 
                          call fcn(n,x+c2*h,ynew,dy)
                      do 621 i=1,n
  621                 ynew(i)=hc21*ak1(i)
                      do 624 i=1,n
                      sum=0.d0
                      do 623 j=1,n
  623                 sum=sum+fmas(i,j)*ynew(j)
  624                 ak2(i)=sum+dy(i)+hd2*fx(i)
                      call sol(n,lde,e,ak2,ip)
                      do 630 i=1,n
  630                 ynew(i)=y(i)+a31*ak1(i)+a32*ak2(i)  
                          call fcn(n,x+c3*h,ynew,dy)
                      do 631 i=1,n
  631                 ynew(i)=hc31*ak1(i)+hc32*ak2(i)
                      do 634 i=1,n
                      sum=0.d0
                      do 633 j=1,n
  633                 sum=sum+fmas(i,j)*ynew(j)
  634                 ak3(i)=sum+dy(i)+hd3*fx(i)
                          call sol(n,lde,e,ak3,ip)
                      do 640 i=1,n
  640                 ynew(i)=y(i)+a41*ak1(i)+a42*ak2(i)
     &                            +a43*ak3(i)  
                          call fcn(n,x+c4*h,ynew,dy)
                      do 641 i=1,n
  641                 ynew(i)=hc41*ak1(i)+hc42*ak2(i)
     &                       +hc43*ak3(i) 
                      do 644 i=1,n
                      sum=0.d0
                      do 643 j=1,n
  643                 sum=sum+fmas(i,j)*ynew(j)
  644                 ak4(i)=sum+dy(i)+hd4*fx(i)
                          call sol(n,lde,e,ak4,ip)
                      do 650 i=1,n
  650                 ynew(i)=y(i)+a51*ak1(i)+a52*ak2(i)
     &                       +a53*ak3(i)
     &                       +a54*ak4(i)  
                          call fcn(n,x+c5*h,ynew,dy)
                      do 651 i=1,n
  651                 ynew(i)=hc51*ak1(i)+hc52*ak2(i)
     &                       +hc53*ak3(i)+hc54*ak4(i) 
                      do 654 i=1,n
                      sum=0.d0
                      do 653 j=1,n
  653                 sum=sum+fmas(i,j)*ynew(j)
  654                 ak5(i)=sum+dy(i)+hd5*fx(i)
                  end if
c --- the differential equation is autonomous or non-autonomous
                      call sol(n,lde,e,ak5,ip)
                  do 660 i=1,n
  660             ynew(i)=y(i)+a61*ak1(i)+a62*ak2(i)
     &                  +a63*ak3(i)+a64*ak4(i)+a65*ak5(i) 
                  call fcn(n,x+h,ynew,dy)
                  do 661 i=1,n
  661             ak9(i)=hc61*ak1(i)+hc62*ak2(i) 
     &                  +hc63*ak3(i)+hc64*ak4(i)
     &                  +hc65*ak5(i) 
                  do 664 i=1,n
                  sum=0.d0
                  do 663 j=1,n
  663             sum=sum+fmas(i,j)*ak9(j)
  664             ak6(i)=sum+dy(i)
                      call sol(n,lde,e,ak6,ip)
                  do 670 i=1,n
  670             ynew(i)=ynew(i)+ak6(i)
                  call fcn(n,x+h,ynew,dy)
                  do 671 i=1,n
  671             ak9(i)=hc71*ak1(i)+hc72*ak2(i)
     &                  +hc73*ak3(i) +hc74*ak4(i)
     &                  +hc75*ak5(i)+hc76*ak6(i) 
                  do 674 i=1,n
                  sum=0.d0
                  do 673 j=1,n
  673             sum=sum+fmas(i,j)*ak9(j)
  674             ak7(i)=sum+dy(i)
                      call sol(n,lde,e,ak7,ip)

c ------------ embedded solution ---------------
                  do 680 i=1,n
  680             ynew(i)=ynew(i)+ak7(i)  
                  call fcn(n,x+h,ynew,dy)
                  do 681 i=1,n
  681             ak9(i)=hc81*ak1(i)+hc82*ak2(i)
     &                  +hc83*ak3(i)+hc84*ak4(i)
     &                  +hc85*ak5(i)+hc86*ak6(i)
     &                  +hc87*ak7(i)
                  do 684 i=1,n
                  sum=0.d0
                  do 683 j=1,n
  683             sum=sum+fmas(i,j)*ak9(j)
  684             ak8(i)=sum+dy(i)
                      call sol(n,lde,e,ak8,ip)
c ------------ new solution ---------------
                  do 685 i=1,n
  685             ynew(i)=ynew(i)+ak8(i)  
              end if
          end if
      else
          if (banded) then
c + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
c --- this part computes the stages in the case where
c ---   1) the differential equation is in explicit form
c ---   2) the jacobian of the problem is a banded matrix
c + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
c --- the matrix e (b=identity, jacobian a banded matrix)
              mle=mljac
              mue=mujac
              mbjac=mljac+mujac+1
              mdiag=mle+mue+1
              do 701 j=1,n
              i1=max0(1,mujac+2-j)
              i2=min0(mbjac,n+mujac+1-j)
              do 700 i=i1,i2
  700         e(i+mle,j)=-fjac(i,j)
  701         e(mdiag,j)=e(mdiag,j)+fac
              call decb(n,lde,e,mle,mue,ip,info)
              if (info.ne.0) goto 80
              if (autnms) then
c --- the differential equation is autonomous
                  do 710 i=1,n
  710             ak1(i)=dy1(i)
                      call solb(n,lde,e,mle,mue,ak1,ip)
                  do 720 i=1,n
  720             ynew(i)=y(i)+a21*ak1(i) 
                  call fcn(n,x,ynew,dy)
                  do 721 i=1,n
  721             ak2(i)=dy(i)+hc21*ak1(i)
                      call solb(n,lde,e,mle,mue,ak2,ip)
                  do 730 i=1,n
  730             ynew(i)=y(i)+a31*ak1(i)+a32*ak2(i)  
                  call fcn(n,x,ynew,dy)
                  do 731 i=1,n
  731             ak3(i)=dy(i)+hc31*ak1(i)+hc32*ak2(i)
                      call solb(n,lde,e,mle,mue,ak3,ip)
                  do 740 i=1,n
  740             ynew(i)=y(i)+a41*ak1(i)+a42*ak2(i)
     &                        +a43*ak3(i)  
                  call fcn(n,x,ynew,dy)
                  do 741 i=1,n
  741             ak4(i)=dy(i)+hc41*ak1(i)+hc42*ak2(i)
     &                        +hc43*ak3(i)
                      call solb(n,lde,e,mle,mue,ak4,ip)
                  do 750 i=1,n
  750             ynew(i)=y(i)+a51*ak1(i)+a52*ak2(i)
     &                        +a53*ak3(i)+a54*ak4(i)  
                  call fcn(n,x,ynew,dy)
                  do 751 i=1,n
  751             ak5(i)=dy(i)+hc51*ak1(i)+hc52*ak2(i)
     &                  +hc53*ak3(i)+hc54*ak4(i)
 
              else
c --- the differential equation is non-autonomous
                  hd1=h*d1
                  hd2=h*d2
                  hd3=h*d3
                  hd4=h*d4
                  hd4=h*d4
                  do 810 i=1,n
  810             ak1(i)=dy1(i)+hd1*fx(i)
                      call solb(n,lde,e,mle,mue,ak1,ip)
                  do 820 i=1,n
  820             ynew(i)=y(i)+a21*ak1(i) 
                  call fcn(n,x+c2*h,ynew,dy)
                  do 821 i=1,n
  821             ak2(i)=dy(i)+hd2*fx(i)+hc21*ak1(i)
                      call solb(n,lde,e,mle,mue,ak2,ip)
                  do 830 i=1,n
  830             ynew(i)=y(i)+a31*ak1(i)+a32*ak2(i)  
                  call fcn(n,x+c3*h,ynew,dy)
                  do 831 i=1,n
  831             ak3(i)=dy(i)+hd3*fx(i)+hc31*ak1(i)
     &                        +hc32*ak2(i)
                      call solb(n,lde,e,mle,mue,ak3,ip)
                  do 840 i=1,n
  840             ynew(i)=y(i)+a41*ak1(i)+a42*ak2(i)
     &                        +a43*ak3(i)  
                  call fcn(n,x+c4*h,ynew,dy)
                  do 841 i=1,n
  841             ak4(i)=dy(i)+hd4*fx(i)+hc41*ak1(i)
     &                  +hc42*ak2(i)+hc43*ak3(i) 
                      call solb(n,lde,e,mle,mue,ak4,ip)
                  do 850 i=1,n
  850             ynew(i)=y(i)+a51*ak1(i)+a52*ak2(i)
     &                   +a53*ak3(i)+a54*ak4(i)  
                  call fcn(n,x+c5*h,ynew,dy)
                  do 851 i=1,n
  851             ak5(i)=dy(i)+hd5*fx(i)+hc51*ak1(i)
     &                  +hc52*ak2(i)+hc53*ak3(i)
     &                  +hc54*ak4(i)

              end if
c --- the differential equation is autonomous or non-autonomous
                  call solb(n,lde,e,mle,mue,ak5,ip)
              do 860 i=1,n
  860         ynew(i)=y(i)+a61*ak1(i)+a62*ak2(i)+a63*ak3(i)
     &                +a64*ak4(i)+a65*ak5(i)
              call fcn(n,x+h,ynew,dy)
              do 861 i=1,n
  861         ak6(i)=dy(i)+hc61*ak1(i)+hc62*ak2(i)
     &              +hc63*ak3(i) +hc64*ak4(i)+hc65*ak5(i) 
                  call solb(n,lde,e,mle,mue,ak6,ip)
              do 870 i=1,n
  870         ynew(i)=ynew(i)+ak6(i) 
              call fcn(n,x+h,ynew,dy)
              do 871 i=1,n
  871         ak7(i)=dy(i)+hc71*ak1(i)+hc72*ak2(i) 
     &              +hc73*ak3(i)+hc74*ak4(i)+hc75*ak5(i)
     &              +hc76*ak6(i) 
                  call solb(n,lde,e,mle,mue,ak7,ip)

c ------------ embedded solution ---------------
              do 880 i=1,n
  880         ynew(i)=ynew(i)+ak7(i)  
              call fcn(n,x+h,ynew,dy)
              do 881 i=1,n
  881         ak8(i)=dy(i)+hc81*ak1(i)+hc82*ak2(i)
     &              +hc83*ak3(i)+hc84*ak4(i)+hc85*ak5(i)
     &              +hc86*ak6(i)+hc87*ak7(i) 
                  call solb(n,lde,e,mle,mue,ak8,ip)
c ------------ new solution ---------------
              do 882 i=1,n
  882         ynew(i)=ynew(i)+ak8(i)  
          else
c + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
c --- this part computes the stages in the case where
c ---   1) the differential equation is in explicit form
c ---   2) the jacobian of the problem is a full matrix
c + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
c --- the matrix e (b=identity, jacobian a full matrix)
              do 901 j=1,n
              do 900 i=1,n
  900         e(i,j)=-fjac(i,j)
  901         e(j,j)=e(j,j)+fac
              call dec(n,lde,e,ip,info)
              if (info.ne.0) goto 80
              
              write(*,*) 'autnms', autnms
              if (autnms) then
c --- the differential equation is autonomous
                  do 910 i=1,n
  910             ak1(i)=dy1(i)
  
 11    format(a20,2x,2f26.18)
                  if (dbg) write(*,*) 1
                  if (dbg) write(*,11) 'rhs(:)', ak1(1), ak1(2)
                  call sol(n,lde,e,ak1,ip)
                  if (dbg) write(*,11) 'k(:)', ak1(1), ak1(2)
                  if (dbg) write(*,*)
                  
                  do 920 i=1,n
  920             ynew(i)=y(i)+a21*ak1(i) 
                  call fcn(n,x,ynew,dy)
                  do 921 i=1,n
  921             ak2(i)=dy(i)+hc21*ak1(i)
  
                  if (dbg) write(*,*) 2
                  if (dbg) write(*,11) 'rhs(:)', ak2(1), ak2(2)
                  call sol(n,lde,e,ak2,ip)
                  if (dbg) write(*,11) 'k(:)', ak2(1), ak2(2)
                  if (dbg) write(*,*)

                  do 930 i=1,n
  930             ynew(i)=y(i)+a31*ak1(i)+a32*ak2(i)  
                  call fcn(n,x,ynew,dy)
                  do 931 i=1,n
  931             ak3(i)=dy(i)+hc31*ak1(i)+hc32*ak2(i)
  
                  if (dbg) write(*,*) 3
                  if (dbg) write(*,11) 'rhs(:)', ak3(1), ak3(2)
                  call sol(n,lde,e,ak3,ip)
                  if (dbg) write(*,11) 'k(:)', ak3(1), ak3(2)
                  if (dbg) write(*,*)

                  do 940 i=1,n
  940             ynew(i)=y(i)+a41*ak1(i)+a42*ak2(i)
     &                        +a43*ak3(i)  
                  call fcn(n,x,ynew,dy)
                  do 941 i=1,n
  941             ak4(i)=dy(i)+hc41*ak1(i)+hc42*ak2(i)
     &                        +hc43*ak3(i)
     
                  if (dbg) write(*,*) 4
                  if (dbg) write(*,11) 'rhs(:)', ak4(1), ak4(2)
                  call sol(n,lde,e,ak4,ip)
                  if (dbg) write(*,11) 'k(:)', ak4(1), ak4(2)
                  if (dbg) write(*,*)

                  do 950 i=1,n
  950             ynew(i)=y(i)+a51*ak1(i)+a52*ak2(i)
     &                   +a53*ak3(i)+a54*ak4(i) 
                  call fcn(n,x,ynew,dy)
                  do 951 i=1,n
  951             ak5(i)=dy(i)+hc51*ak1(i)+hc52*ak2(i)
     &                  +hc53*ak3(i)+hc54*ak4(i)
 
              else
c --- the differential equation is non-autonomous
                  hd1=h*d1
                  hd2=h*d2
                  hd3=h*d3
                  hd4=h*d4
                  hd5=h*d5
                  do 1010 i=1,n
 1010             ak1(i)=dy1(i)+hd1*fx(i)
                      call sol(n,lde,e,ak1,ip)
                  do 1020 i=1,n
 1020             ynew(i)=y(i)+a21*ak1(i) 
                  call fcn(n,x+c2*h,ynew,dy)
                  do 1021 i=1,n
 1021             ak2(i)=dy(i)+hd2*fx(i)+hc21*ak1(i)
                      call sol(n,lde,e,ak2,ip)
                  do 1030 i=1,n
 1030             ynew(i)=y(i)+a31*ak1(i)+a32*ak2(i)  
                  call fcn(n,x+c3*h,ynew,dy)
                  do 1031 i=1,n
 1031             ak3(i)=dy(i)+hd3*fx(i)+hc31*ak1(i)
     &                        +hc32*ak2(i)
                      call sol(n,lde,e,ak3,ip)
                  do 1040 i=1,n
 1040             ynew(i)=y(i)+a41*ak1(i)+a42*ak2(i)
     &                    +a43*ak3(i)  
                  call fcn(n,x+c4*h,ynew,dy)
                  do 1041 i=1,n
 1041             ak4(i)=dy(i)+hd4*fx(i)+hc41*ak1(i)
     &                  +hc42*ak2(i)+hc43*ak3(i) 
                      call sol(n,lde,e,ak4,ip)
                  do 1050 i=1,n
 1050             ynew(i)=y(i)+a51*ak1(i)+a52*ak2(i)
     &                   +a53*ak3(i)+a54*ak4(i)  
                  call fcn(n,x+c5*h,ynew,dy)
                  do 1051 i=1,n
 1051             ak5(i)=dy(i)+hd5*fx(i)+hc51*ak1(i)
     &                  +hc52*ak2(i)+hc53*ak3(i)
     &                  +hc54*ak4(i) 
              end if
              
              
              
c --- the differential equation is autonomous or non-autonomous
               if (dbg) write(*,*) 5
               if (dbg) write(*,11) 'rhs(:)', ak5(1), ak5(2)
               call sol(n,lde,e,ak5,ip)
               if (dbg) write(*,11) 'k(:)', ak5(1), ak5(2)
               if (dbg) write(*,*)
                  
              do 1060 i=1,n
 1060         ynew(i)=y(i)+a61*ak1(i)+a62*ak2(i)
     &              +a63*ak3(i)+a64*ak4(i)+a65*ak5(i)  
              call fcn(n,x+h,ynew,dy)
              do 1061 i=1,n
 1061         ak6(i)=dy(i)+hc61*ak1(i)+hc62*ak2(i)
     &              +hc63*ak3(i)+hc64*ak4(i)+hc65*ak5(i)
     
               if (dbg) write(*,*) 6
               if (dbg) write(*,11) 'rhs(:)', ak6(1), ak6(2)
               call sol(n,lde,e,ak6,ip)
               if (dbg) write(*,11) 'k(:)', ak6(1), ak6(2)
               if (dbg) write(*,*)
                  
              do 1070 i=1,n
 1070         ynew(i)=ynew(i)+ak6(i)  
              call fcn(n,x+h,ynew,dy)
              do 1071 i=1,n
 1071         ak7(i)=dy(i)+hc71*ak1(i)+hc72*ak2(i)
     &             +hc73*ak3(i) +hc74*ak4(i)
     &             +hc75*ak5(i)+hc76*ak6(i)
               
               
               if (dbg) write(*,*) 7
               if (dbg) write(*,11) 'h', h
               if (dbg) write(*,11) 'hc71', hc71
               if (dbg) write(*,11) 'hc72', hc72
               if (dbg) write(*,11) 'hc73', hc73
               if (dbg) write(*,11) 'hc74', hc74
               if (dbg) write(*,11) 'hc75', hc75
               if (dbg) write(*,11) 'hc76', hc76
               if (dbg) write(*,11) 'dy(:)', dy(1), dy(2)
               if (dbg) write(*,11) 'rhs(:)', ak7(1), ak7(2)
               call sol(n,lde,e,ak7,ip)
               if (dbg) write(*,11) 'k(:)', ak7(1), ak7(2)
               if (dbg) write(*,*)

c ------------ embedded solution ---------------
              do 1080 i=1,n
 1080         ynew(i)=ynew(i)+ak7(i)  
              call fcn(n,x+h,ynew,dy)
              do 1081 i=1,n
 1081         ak8(i)=dy(i)+hc81*ak1(i)+hc82*ak2(i)
     &              +hc83*ak3(i)
     &              +hc84*ak4(i)+hc85*ak5(i)+
     &               hc86*ak6(i)+hc87*ak7(i)
     
               if (dbg) write(*,*) 8
               if (dbg) write(*,11) 'hc81', hc81
               if (dbg) write(*,11) 'hc82', hc82
               if (dbg) write(*,11) 'hc83', hc83
               if (dbg) write(*,11) 'hc84', hc84
               if (dbg) write(*,11) 'hc85', hc85
               if (dbg) write(*,11) 'hc86', hc86
               if (dbg) write(*,11) 'hc87', hc87
               if (dbg) write(*,11) 'dy(:)', dy(1), dy(2)
               if (dbg) write(*,11) 'rhs(:)', ak8(1), ak8(2)
               call sol(n,lde,e,ak8,ip)
               if (dbg) write(*,11) 'k(:)', ak8(1), ak8(2)
               if (dbg) write(*,*)
                  
c ------------ new solution ---------------
              do 1082 i=1,n
 1082         ynew(i)=ynew(i)+ak8(i)  
          end if
      end if
      nsol=nsol+8
      nfcn=nfcn+7 
c ------------ dense output ----------
c a voir !!!!!!
      if (iout.ne.0) then
          do 63 i=1,n 
          cont(i)=y(i)
          cont(i+nn2)=d21*ak1(i)+d22*ak2(i)
     &               +d23*ak3(i)+d24*ak4(i)
     &               +d25*ak5(i)+d26*ak6(i)
     &               +d27*ak7(i)+d28*ak8(i)
          cont(i+nn3)=d31*ak1(i)+d32*ak2(i)
     &               +d33*ak3(i)+d34*ak4(i)
     &               +d35*ak5(i)+d36*ak6(i)
     &               +d37*ak7(i)+d38*ak8(i)
          cont(i+nn4)=d41*ak1(i)+d42*ak2(i)
     &               +d43*ak3(i)+d44*ak4(i)
     &               +d45*ak5(i)+d46*ak6(i)
     &               +d47*ak7(i)+d48*ak8(i)
  63      continue 
      end if
c *** *** *** *** *** *** ***
c  error estimation  
c *** *** *** *** *** *** ***
      nstep=nstep+1
c ------------ compute error estimation ----------------
      err=0.d0
      do 300 i=1,n
      if (itol.eq.0) then
         sk=atol(1)+rtol(1)*dmax1(dabs(y(i)),
     &                        dabs(ynew(i)))
      else
         sk=atol(i)+rtol(i)*dmax1(dabs(y(i)),
     &                        dabs(ynew(i)))
      end if
  300 err=err+(ak8(i)/sk)**2
      err=dsqrt(err/n)


 
      if (dbg) then
      
      write(*,11) 'y(:)', y(1), y(2)
      write(*,11) 'ynew(:)', ynew(1), ynew(2)
      write(*,*)
      write(*,11) 'err(:)', ak8(1), ak8(2)
      write(*,11) 'err=', err
      
      if (nstep > 1) stop
      
      
      end if
      



c --- computation of hnew
c --- we require .2<=hnew/h<=6.
      fac=dmax1(fac2,dmin1(fac1,(err)**.20d0/0.9d0))
      hnew=h/fac  
c *** *** *** *** *** *** ***
c  is the error small enough ?
c *** *** *** *** *** *** ***
      if (err.le.1.d0) then
c --- step is accepted  
         naccpt=naccpt+1
         do 44 i=1,n 
  44     y(i)=ynew(i) 
         xold=x 
         x=x+h
         if (iout.ne.0) then 
            do 73 i=1,n 
  73        cont(nn+i)=y(i)
            irtrn=1
            hout=h
            call solout(naccpt+1,xold,x,y,n,irtrn)
            if (irtrn.lt.0) goto 79
         end if
         if (dabs(hnew).gt.hmaxn) hnew=posneg*hmaxn
         if (reject) hnew=posneg*dmin1(dabs(hnew),
     &                              dabs(h)) 
         reject=.false.
         h=hnew
         goto 1
      else
c --- step is rejected  
         reject=.true.
         h=hnew
         if (naccpt.ge.1) nrejct=nrejct+1
         goto 2
      end if
c --- exit
  80  write (6,*) ' matrix e is singular, info = ',info
      nsing=nsing+1
      if (nsing.ge.5) goto 79
      h=h*0.5d0
      reject=.true.
      goto 2
  79  write(6,979)x,h
 979  format(' exit of rodas at x=',d16.7,'   h=',d16.7)
      idid=-1
      return
      end subroutine rocor5
c
      function corod5(i,x)
c ----------------------------------------------------------
c     this function can be used for coninuous output in conection
c     with the output-subroutine for dopri5. it provides an
c     approximation to the i-th component of the solution at x.
c ----------------------------------------------------------
      implicit real*8 (a-h,o-z)
      common /conros/n,n2,n3,n4,xold,h,cont(1)
      s=(x-xold)/h 
      corod5=cont(i)*(1-s)+s*(cont(i+n)+
     &                        (s-1)*(cont(i+n2)+cont(i+n4) +
     &                               (s+1)*(cont(i+n3) + 
     &                                      s*cont(i+n4))))
      return
      end function corod5
c
c
c
c
c

      subroutine rod5(meth,a21,a31,a32,a41,a42,a43,a51,
     &                   a52,a53,a54,a61,a62,a63,a64,a65,
     &                   c21,c31,c32,c41,c42,c43,c51,c52,
     &                   c53,c54,c61,c62,c63,c64,c65,c71,
     &                   c72,c73,c74,c75,c76,c81,c82,c83,
     &                   c84,c85,c86,c87,gamma,
     &                   c2,c3,c4,c5,d1,d2,d3,d4,d5,
     &                   d21,d22,d23,d24,d25,d26,d27,d28,
     &                   d31,d32,d33,d34,d35,d36,d37,d38,
     &                   d41,d42,d43,d44,d45,d46,d47,d48)
      implicit real*8 (a-h,o-z)
     
      if (meth.eq.1) go to 1
      if (meth.eq.2) go to 2
      if (meth.eq.3) go to 3



1        continue
c  g   =    0.2500000000000000e+00
c  a3  =    0.5000000000000000e+00
c  a4  =    0.5000000000000000e+00
c  a5  =    0.7500000000000000e+00
c  b3  =    0.8333333333333333e-01
c  b4  =    0.2430555555555556e+00
c  b5  =    0.1000000000000000e+01
c  a64 =   -0.2207201086956522e+01
        gamma =    0.2500000000000000e+00
c   --------------------------
c  ci = somme(alpha(i,j)) j=1,i-1
        c2 =        0.5000000000000000e+00
        c3 =        0.5000000000000000e+00
        c4 =        0.5000000000000000e+00
        c5 =        0.7500000000000000e+00
c   --------------------------
c  di = somme(gamma(i,j)) j=1,i
        d1 =        0.2500000000000000e+00
        d2 =       -0.2500000000000000e+00
        d3 =       -0.4166666666666667e+00
        d4 =       -0.2569444444444444e+00
        d5 =        0.2500000000000000e+00
c   --------------------------
c  - gamma inverse
        c21 =       -0.8000000000000000e+01
        c31 =       -0.1600000000000000e+02
        c32 =       -0.5333333333333333e+01
        c41 =       -0.9611111111111109e+01
        c42 =       -0.4694444444444444e+01
        c43 =        0.1916666666666667e+01
        c51 =        0.1865624999999999e+02
        c52 =       -0.5578125000000000e+01
        c53 =        0.2865692934782609e+02
        c54 =       -0.2289130434782610e+02
        c61 =        0.2321990740740739e+02
        c62 =       -0.8000000000000001e+01
        c63 =        0.2039492753623193e+02
        c64 =       -0.1422826086956531e+02
        c65 =       -0.1585185185185186e+02
        c71 =        0.2377962962962961e+02
        c72 =       -0.7999999999999999e+01
        c73 =        0.2194492753623193e+02
        c74 =       -0.1887826086956533e+02
        c75 =       -0.1860740740740741e+02
        c76 =       -0.6399999999999999e+01
        c81 =        0.2292138888888887e+02
        c82 =       -0.8000000000000002e+01
        c83 =        0.1956826086956525e+02
        c84 =       -0.1174826086956529e+02
        c85 =       -0.1438222222222222e+02
        c86 =       -0.2719999999999993e+01
        c87 =        0.2133333333333346e+01
c   --------------------------
c  a*(gamma inverse)
        a21 =        0.2000000000000000e+01
        a31 =        0.3000000000000000e+01
        a32 =        0.1000000000000000e+01
        a41 =        0.3000000000000000e+01
        a42 =        0.1000000000000000e+01
        a43 =        0.0000000000000000e+00
        a51 =        0.2625000000000001e+01
        a52 =        0.2250000000000000e+01
        a53 =       -0.5918478260869566e+01
        a54 =        0.7043478260869569e+01
        a61 =       -0.1987847222222218e+01
        a62 =        0.4000000000000000e+01
        a63 =       -0.9986413043478267e+01
        a64 =        0.9611413043478277e+01
        a65 =        0.3222222222222223e+01
c   --------------------------
c dij dense output
        d21 =        0.0000000000000000e+00
        d22 =        0.0000000000000000e+00
        d23 =        0.0000000000000000e+00
        d24 =        0.0000000000000000e+00
        d25 =        0.0000000000000000e+00
        d26 =        0.0000000000000000e+00
        d27 =        0.0000000000000000e+00
        d28 =        0.0000000000000000e+00
        d31 =        0.0000000000000000e+00
        d32 =        0.0000000000000000e+00
        d33 =        0.0000000000000000e+00
        d34 =        0.0000000000000000e+00
        d35 =        0.0000000000000000e+00
        d36 =        0.0000000000000000e+00
        d37 =        0.0000000000000000e+00
        d38 =        0.0000000000000000e+00
        d41 =        0.0000000000000000e+00
        d42 =        0.0000000000000000e+00
        d43 =        0.0000000000000000e+00
        d44 =        0.0000000000000000e+00
        d45 =        0.0000000000000000e+00
        d46 =        0.0000000000000000e+00
        d47 =        0.0000000000000000e+00
        d48 =        0.0000000000000000e+00
        return


2        continue
c  g   =    0.1900000000000000e+00
c  a3  =    0.3878509998321533e+00
c  a4  =    0.4839718937873840e+00
c  a5  =    0.4570477008819580e+00
c  b3  =    0.6861916764527839e-01
c  b4  =    0.8289547562599182e+00
c  b5  =    0.7963013648986816e-01
c  a64 =   -0.2076823626400282e+00
        gamma =    0.1900000000000000e+00
c   --------------------------
c  ci = somme(alpha(i,j)) j=1,i-1
        c2 =        0.3800000000000000e+00
        c3 =        0.3878509998321533e+00
        c4 =        0.4839718937873840e+00
        c5 =        0.4570477008819580e+00
c   --------------------------
c  di = somme(gamma(i,j)) j=1,i
        d1 =        0.1900000000000000e+00
        d2 =       -0.1823079225333715e+00
        d3 =       -0.3192318321868749e+00
        d4 =        0.3449828624725342e+00
        d5 =       -0.3774175643920899e+00
c   --------------------------
c  - gamma inverse
        c21 =       -0.1031323885133993e+02
        c31 =       -0.2104823117650003e+02
        c32 =       -0.7234992135176717e+01
        c41 =        0.3222751541853324e+02
        c42 =       -0.4943732386540188e+01
        c43 =        0.1944922031041879e+02
        c51 =       -0.2069865579590063e+02
        c52 =       -0.8816374604402769e+01
        c53 =        0.1260436877740897e+01
        c54 =       -0.7495647613787146e+00
        c61 =       -0.4622004352711273e+02
        c62 =       -0.1749534862857483e+02
        c63 =       -0.2896389582892057e+03
        c64 =        0.9360855400400905e+02
        c65 =        0.3183822534212147e+03
        c71 =        0.3420013733472944e+02
        c72 =       -0.1415535402717689e+02
        c73 =        0.5782335640988401e+02
        c74 =        0.2583362985412365e+02
        c75 =        0.1408950972071631e+01
        c76 =       -0.6551835421242162e+01
        c81 =        0.4257076742291112e+02
        c82 =       -0.1380770672017995e+02
        c83 =        0.9398938432427125e+02
        c84 =        0.1877919633714503e+02
        c85 =       -0.3158359187223369e+02
        c86 =       -0.6685968952921985e+01
        c87 =       -0.5810979938412932e+01
c   --------------------------
c  a*(gamma inverse)
        a21 =        0.2000000000000000e+01
        a31 =        0.3040894194418782e+01
        a32 =        0.1041747909077569e+01
        a41 =        0.2576417536461462e+01
        a42 =        0.1622083060776640e+01
        a43 =       -0.9089668560264530e+00
        a51 =        0.2760842080225597e+01
        a52 =        0.1446624659844071e+01
        a53 =       -0.3036980084553738e+00
        a54 =        0.2877498600325443e+00
        a61 =       -0.1409640773051262e+02
        a62 =        0.6925207756232692e+01
        a63 =       -0.4147510893210728e+02
        a64 =        0.2343771018586405e+01
        a65 =        0.2413215229196061e+02
c   --------------------------
c dij dense output
        d21 =       -0.9782741530802001e+01
        d22 =        0.6925207756232651e+01
        d23 =        0.6712122437203827e+02
        d24 =       -0.1729021144594603e+01
        d25 =       -0.6662370170597188e+02
        d26 =        0.4973604298914114e+00
        d27 =        0.2031296751338173e+01
        d28 =        0.4858633348205966e+00
        d31 =       -0.3875458112361526e+02
        d32 =        0.1646460745519107e-12
        d33 =       -0.1805901252757448e+03
        d34 =        0.2854192067349601e+02
        d35 =        0.1593280899483578e+03
        d36 =       -0.2489611538044086e+01
        d37 =       -0.1016795773324178e+02
        d38 =       -0.2239034031195779e+01
        d41 =        0.1760807991446404e+02
        d42 =        0.1136868377216160e-12
        d43 =        0.7237544558438414e+02
        d44 =       -0.2275656806151786e+02
        d45 =       -0.7315408584621875e+02
        d46 =        0.2986769127453222e+01
        d47 =        0.1219842605274663e+02
        d48 =        0.2972263615595282e+01
        return

3        continue
c  g   =    0.1900000000000000e+00
c  a3  =    0.3761963248252869e+00
c  a4  =    0.5076580643653870e+00
c  a5  =    0.4356034398078918e+00
c  b3  =    0.6081049513228261e-01
c  b4  =    0.6966214179992676e+00
c  b5  =    0.9460867047309875e+00
c  a64 =    0.4636356700988413e+01
        gamma =    0.1900000000000000e+00
c   --------------------------
c  ci = somme(alpha(i,j)) j=1,i-1
        c2 =        0.3800000000000000e+00
        c3 =        0.3761963248252869e+00
        c4 =        0.5076580643653870e+00
        c5 =        0.4356034398078918e+00
c   --------------------------
c  di = somme(gamma(i,j)) j=1,i
        d1 =        0.1900000000000000e+00
        d2 =       -0.1938421336706632e+00
        d3 =       -0.3153858296930043e+00
        d4 =        0.1889633536338806e+00
        d5 =        0.5104832649230957e+00
c   --------------------------
c  - gamma inverse
        c21 =       -0.1063274608505992e+02
        c31 =       -0.2105156635338901e+02
        c32 =       -0.6912182415322990e+01
        c41 =        0.2638321436999748e+02
        c42 =       -0.6328590066328406e+01
        c43 =        0.1980118818739686e+02
        c51 =        0.4595382700819456e+02
        c52 =       -0.3476688592818137e+01
        c53 =        0.2476077259030112e+02
        c54 =        0.4804898140280394e+00
        c61 =        0.2445051447876698e+02
        c62 =       -0.1311017056466540e+02
        c63 =        0.4582508337857628e+02
        c64 =        0.3724958804781703e+02
        c65 =       -0.1514498860243549e+01
        c71 =        0.5267981688189534e+02
        c72 =       -0.1398312926262549e+02
        c73 =        0.1016248731275928e+03
        c74 =       -0.8594180354107104e+02
        c75 =        0.6772251687671892e+02
        c76 =       -0.6726558577774656e+01
        c81 =        0.5293589860317176e+02
        c82 =       -0.1399104829522447e+02
        c83 =        0.1021310601385834e+03
        c84 =       -0.8705933252404099e+02
        c85 =        0.6835059949501269e+02
        c86 =       -0.6739833796569573e+01
        c87 =       -0.5310902557845640e+01
c   --------------------------
c  a*(gamma inverse)
        a21 =        0.2000000000000000e+01
        a31 =        0.2979880463451408e+01
        a32 =        0.9800808504989805e+00
        a41 =        0.2120685457840225e+01
        a42 =        0.1784741761185675e+01
        a43 =       -0.1428998819806867e+01
        a51 =        0.2959356498503713e+01
        a52 =        0.1314060642468612e+01
        a53 =       -0.7708274699064309e+00
        a54 =       -0.6089119140454550e+00
        a61 =       -0.1534688155312264e+02
        a62 =        0.6925207756232701e+01
        a63 =       -0.2805069537988574e+02
        a64 =        0.2591954354031733e+02
        a65 =       -0.1662411238200557e+02
c   --------------------------
c dij dense output
        d21 =       -0.1860327672622088e+02
        d22 =        0.6925207756233334e+01
        d23 =        0.1196860468097907e+02
        d24 =       -0.5091498676737569e+02
        d25 =        0.3579512953413223e+02
        d26 =        0.7494440071948105e+00
        d27 =        0.2695394493696369e+01
        d28 =        0.4383195304707551e+03
        d31 =       -0.2777461321110809e+02
        d32 =       -0.4433786671143025e-11
        d33 =       -0.5261332383681884e+02
        d34 =        0.1172633547851897e+03
        d35 =       -0.6557471979945149e+02
        d36 =       -0.3191575119621717e+01
        d37 =       -0.1147858134972114e+02
        d38 =       -0.1594277163798099e+04
        d41 =        0.1274448344729262e+02
        d42 =        0.3467448550509289e-11
        d43 =        0.8731768541672409e+01
        d44 =       -0.4411860392021254e+02
        d45 =        0.1698238544006290e+02
        d46 =        0.3452717366769235e+01
        d47 =        0.1241778610454625e+02
        d48 =        0.1368881142220323e+04
        return
        end subroutine rod5

        subroutine dfx(n,x,y,fx)
        end subroutine dfx

        subroutine mas(n,am,lmas)
        end subroutine mas

        subroutine solout (nr,xold,x,y,n,irtrn)
        end subroutine solout


      subroutine do_test_rodas5
         use test_support,only:show_results,show_statistics
         integer, parameter :: n = 2, liwork = n+2, lwork = 2*n*n+13*n+4, lrcont = 5*n+2
         integer :: iwork(liwork),nfcn,njac,nstep,naccpt,nrejct,ndec,nsol,ijac,mljac,mujac,idid,iout
         double precision :: x, xend, h, atol(1), rtol(1), work(lwork), cont(lrcont)
         double precision :: y(n), yexact(n)
         logical :: show_all
         common/stat/nfcn,njac,nstep,naccpt,nrejct,ndec,nsol
         common /conros/nn,nn2,nn3,nn4,xold,hout,cont
         show_all = .true.
         
         y(1) = 2d0
         y(2) = 0d0
         
         x = 0
         xend = 2d0
         
         rtol = 1d-4
         atol = 1d-4
         itol = 0
         
         h = 1d-4 ! initial step size
         
         iwork = 0
         work = 0
         iout = 0
         idfx = 0
         ifcn = 0
         imas = 0
         mljac = n
         mujac = n
         ijac = 1
         
         call rod54(n,vdp_fcn,ifcn,x,y,xend,h,
     &                  rtol,atol,itol,
     &                  vdp_jac ,ijac,mljac,mujac,dfx,idfx,
     &                  mas ,imas,mlmas,mumas,
     &                  solout,iout,
     &                  work,lwork,iwork,liwork,lrcont,
     &                  idid)
     
         write(*,*) 'idid', idid
         
         yexact(1) =  1.7632345401889102d+00           
         yexact(2) = -8.3568868191466206d-01
         call show_results(n,y,yexact,show_all)
         call show_statistics(nfcn,njac,nstep,show_all)
         
      
      end subroutine do_test_rodas5
      
      
      end module test_rodas5
