      module test_rodas3
      
      contains

  
 
      subroutine func(neqn,t,y,f)
      integer neqn
      double precision t,y(neqn),f(neqn)

      f(1) = y(2)
      f(2) = ((1-y(1)**2)*y(2)-y(1))/1.0d-3
      
      !write(*,*) 'func y(1)', y(1)
      !write(*,*) 'func y(2)', y(2)
      !write(*,*) 'func f(1)', f(1)
      !write(*,*) 'func f(2)', f(2)
      !write(*,*)
      
      return
      end subroutine func

      subroutine jac_fcn(neqn,t,y,dfdy)
      integer ldim,neqn
      double precision t,y(neqn),dfdy(neqn,neqn)

      integer i,j

      dfdy(1,1) = 0d0
      dfdy(1,2) = 1d0
      dfdy(2,1) = (-2.0d0*y(1)*y(2)-1d0)/1.0d-3
      dfdy(2,2) = (1d0-y(1)**2)/1.0d-3
      
      !write(*,*) 'jac_fcn y(1)', y(1)
      !write(*,*) 'jac_fcn y(2)', y(2)
      !write(*,*) 'jac_fcn dfdy(1,1)', dfdy(1,1)
      !write(*,*) 'jac_fcn dfdy(1,2)', dfdy(1,2)
      !write(*,*) 'jac_fcn dfdy(2,1)', dfdy(2,1)
      !write(*,*) 'jac_fcn dfdy(2,2)', dfdy(2,2)
      !write(*,*)

      return
      end subroutine jac_fcn
   
      
      
      
      SUBROUTINE RODAS3(NVAR,T,Tnext,Hmin,Hmax,Hstart,y,AbsTol,RelTol,Info)
      IMPLICIT NONE

!     Stiffly accurate Rosenbrock 3(2), with 
!     stiffly accurate embedded formula for error control.  
!
!     All the arguments aggree with the KPP syntax.
!
!  INPUT ARGUMENTS:
!     y = Vector of (NVAR) concentrations, contains the
!         initial values on input
!     [T, Tnext] = the integration interval
!     Hmin, Hmax = lower and upper bounds for the selected step-size.
!          Note that for Step = Hmin the current computed
!          solution is unconditionally accepted by the error
!          control mechanism.
!     AbsTol, RelTol = (NVAR) dimensional vectors of 
!          componentwise absolute and relative tolerances.
!     func = name of routine of derivatives. KPP syntax.
!          See the header below.
!     jac_fcn = name of routine that computes the Jacobian, in
!          sparse format. KPP syntax. See the header below.
!     Info(1) = 1  for  autonomous   system
!             = 0  for nonautonomous system 
!
!  OUTPUT ARGUMENTS:
!     y = the values of concentrations at Tend.
!     T = equals Tend on output.
!     Info(2) = # of func calls.
!     Info(3) = # of jac_fcn calls.
!     Info(4) = # of accepted steps.
!     Info(5) = # of rejected steps.
!    
!     Adrian Sandu, March 1996
!     The Center for Global and Regional Environmental Research
      integer :: NVAR, Info(5)
      double precision ::   T, Tnext, Hmin, Hmax, Hstart, AbsTol(NVAR), RelTol(NVAR)
      double precision ::   y(NVAR)

      double precision ::   K1(NVAR), K2(NVAR), K3(NVAR), K4(NVAR)
      double precision ::   F1(NVAR), JAC(NVAR,NVAR)
      double precision ::   ghinv,uround
      double precision ::   ynew(NVAR)
      double precision ::   H, Hold, Tplus, Hnew
      double precision ::   ERR, factor, facmax
      double precision ::   c43, tau, x1, x2, ytol, elo
      
      INTEGER    n,nfcn,njac,Naccept,Nreject,i,j,ier, ip(NVAR)
      LOGICAL    IsReject,Autonomous

!     Initialization of counters, etc.
      Autonomous = .true. !Info(1) .EQ. 1
      uround = 1.d-15
      c43 = - 8.d0/3.d0 
      H = DMAX1(1.d-8, Hstart)
      Hmin = DMAX1(Hmin,uround*(Tnext-T))
      Hmax = DMIN1(Hmax,Tnext-T)
      Tplus = T
      IsReject = .false.
      Naccept  = 0
      Nreject  = 0
      Nfcn     = 0
      Njac     = 0

       ier = 0

! === Starting the time loop ===      
 10    continue  
       Tplus = T + H
       if ( Tplus .gt. Tnext ) then
          H = Tnext - T
          Tplus = Tnext
       end if
       
       CALL func(NVAR, T, y, F1)

       CALL jac_fcn(NVAR, T, y, JAC)
       Njac = Njac+1
       gHinv = -2.0d0/H
       
       do i=1,nvar
         jac(i,i) = jac(i,i) + gHinv
       end do
      
      !write(*,*)
      !write(*,*) 'fac1', ghinv
      !write(*,*) 'jac(1,1)', jac(1,1)
      !write(*,*) 'jac(1,2)', jac(1,2)
      !write(*,*) 'jac(2,1)', jac(2,1)
      !write(*,*) 'jac(2,2)', jac(2,2)
      !write(*,*)
       
       !CALL KppDecomp (JAC, ier)
       call dgetrf(nvar, nvar, JAC, nvar, ip, ier)

       if (ier.ne.0) then
         if ( H.gt.Hmin) then
            H = 5.0d-1*H
            go to 10
         else
            print *,'IER <> 0, H=',H
            stop
         end if      
       end if  

! ====== NONAUTONOMOUS CASE ===============
       IF (.not. Autonomous) THEN
         tau = DSQRT( uround*DMAX1( 1.0d-5, DABS(T) ) )
         CALL func(NVAR, T+tau, y, K2)
         nfcn=nfcn+1
         do 30 j = 1,NVAR
           K3(j) = ( K2(j)-F1(j) )/tau
 30      continue
 
! ==--- STAGE 1 (NONAUTONOMOUS) -----
         x1 = 0.5*H
         do 40 j = 1,NVAR
           K1(j) =  F1(j) + x1*K3(j) 
 40      continue
         !CALL KppSolve (JAC, K1)
         call dgetrs('N', nvar, 1, JAC, nvar, ip, K1, nvar, ier)

! ==--- STAGE 2 (NONAUTONOMOUS) -----
         x1 = 4.d0/H
         x2 = 1.5d0*H
         do 50 j = 1,NVAR
           K2(j) = F1(j) - x1*K1(j) + x2*K3(j)
 50      continue
         !CALL KppSolve (JAC, K2)
         call dgetrs('N', nvar, 1, JAC, nvar, ip, K2, nvar, ier)

! ====== AUTONOMOUS CASE ===============
       ELSE
! ==--- STAGE 1 (AUTONOMOUS) -----
         do 60 j = 1,NVAR
           K1(j) =  F1(j) 
 60      continue
         !CALL KppSolve (JAC, K1)
         !write(*,*) 'rhs(1)', K1(1)
         !write(*,*) 'rhs(2)', K1(2)
         call dgetrs('N', nvar, 1, JAC, nvar, ip, K1, nvar, ier)
         !write(*,*) 'ak(1)', K1(1)
         !write(*,*) 'ak(2)', K1(2)
         !write(*,*)
         
! ==--- STAGE 2 (AUTONOMOUS) -----
         x1 = 4.d0/H
         do 70 j = 1,NVAR
           K2(j) = F1(j) - x1*K1(j) 
 70      continue
         !CALL KppSolve (JAC, K2)
         !write(*,*) 'rhs(1)', K2(1)
         !write(*,*) 'rhs(2)', K2(2)
         call dgetrs('N', nvar, 1, JAC, nvar, ip, K2, nvar, ier)
         !write(*,*) 'ak(1)', K2(1)
         !write(*,*) 'ak(2)', K2(2)
         !write(*,*)
         
       END IF
       
! ==--- STAGE 3 -----
       do 80 j = 1,NVAR
         ynew(j) = y(j) - 2.0d0*K1(j) 
 80    continue
       CALL func(NVAR, T+H, ynew, F1)
       nfcn=nfcn+1
       do 90 j = 1,NVAR
         K3(j) = F1(j) + ( -K1(j) + K2(j) )/H
 90    continue
       !CALL KppSolve (JAC, K3)
         !write(*,*) 'rhs(1)', K3(1)
         !write(*,*) 'rhs(2)', K3(2)
       call dgetrs('N', nvar, 1, JAC, nvar, ip, K3, nvar, ier)
         !write(*,*) 'ak(1)', K3(1)
         !write(*,*) 'ak(2)', K3(2)
         !write(*,*)

! ==--- STAGE 4 -----
       do 100 j = 1,NVAR
         ynew(j) = y(j) - 2.0d0*K1(j) - K3(j)
 100   continue
       CALL func(NVAR, T+H, ynew, F1)
       nfcn=nfcn+1
       do 110 j = 1,NVAR
         K4(j) = F1(j) + ( -K1(j) + K2(j) - C43*K3(j)  )/H
 110   continue
       !CALL KppSolve (JAC, K4)
         !write(*,*) 'rhs(1)', K4(1)
         !write(*,*) 'rhs(2)', K4(2)
       call dgetrs('N', nvar, 1, JAC, nvar, ip, K4, nvar, ier)
         !write(*,*) 'ak(1)', K4(1)
         !write(*,*) 'ak(2)', K4(2)
         !write(*,*)

! ==-- The Solution ---

       do 120 j = 1,NVAR
         ynew(j) = y(j) - 2.0d0*K1(j) - K3(j) - K4(j) 
 120   continue

         !write(*,*) 'ynew(1)', ynew(1)
         !write(*,*) 'ynew(2)', ynew(2)
         !write(*,*)

! ====== Error estimation ========

        ERR=0.d0
        do 130 i=1,NVAR
           ytol = AbsTol(i) + RelTol(i)*DABS(ynew(i))
           ERR = ERR + ( K4(i)/ytol )**2
 130    continue      
        ERR = DMAX1( uround, DSQRT( ERR/NVAR ) )

         !write(*,*) 'ERR', ERR
         !return

! ======= Choose the stepsize ===============================
        elo    = 3.0D0 ! estimator local order
        factor = DMAX1(2.0D-1,DMIN1(6.0D0,ERR**(1.0D0/elo)/.9D0))
        Hnew   = DMIN1(Hmax,DMAX1(Hmin, H/factor))
 
! ======= Rejected/Accepted Step ============================
 
        IF ( (ERR.gt.1).and.(H.gt.Hmin) ) THEN
          IsReject = .true.
	  H = DMIN1(H/10,Hnew)
          Nreject  = Nreject+1
        ELSE
          DO 140 i=1,NVAR
             y(i)  = ynew(i)
 140      CONTINUE
          T = Tplus
	  IF (.NOT.IsReject) THEN
	      H = Hnew   ! Do not increase stepsize if previos step was rejected
	  END IF    
          IsReject = .false.
          Naccept = Naccept+1
        END IF


! ======= End of the time loop ===============================      
      if ( T .lt. Tnext ) go to 10
 
     
      
! ======= Output Information =================================
      Info(2) = Nfcn
      Info(3) = Njac
      Info(4) = Naccept
      Info(5) = Nreject
      Hstart  = H
      
      RETURN 
      END SUBROUTINE RODAS3       


      subroutine do_test_rodas3
         use test_support,only:show_results,show_statistics
         integer, parameter :: nvar = 2
         integer :: Info(5),nfcn,njac,nstep
         double precision ::   T, Tnext, Hmin, Hmax, Hstart, AbsTol(NVAR), RelTol(NVAR)
         double precision ::   y(NVAR), yexact(NVAR)
         logical :: show_all
         show_all = .true.
         
         y(1) = 2d0
         y(2) = 0d0
         
         T = 0
         Tnext = 2d0
         
         RelTol = 1d-4
         AbsTol = 1d-4
         Hstart = 1d-4 ! initial step size
         Hmax = 1d0
         Hmin = 0d0
         
         Info = 0
         
         call RODAS3(NVAR,T,Tnext,Hmin,Hmax,Hstart,y,AbsTol,RelTol,Info)
         
         nfcn = Info(2)
         njac = Info(3)
         nstep = Info(4)
         
         yexact(1) =  1.7632345401889102d+00           
         yexact(2) = -8.3568868191466206d-01
         call show_results(NVAR,y,yexact,show_all)
         call show_statistics(nfcn,njac,nstep,show_all)
         
      
      end subroutine do_test_rodas3
      
      
      end module test_rodas3
