! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************


      module mebdfi_solver_def
      use const_def, only: dp

      integer, parameter :: i_maxord = 1
      integer, parameter :: i_sum_nq = 2
      integer, parameter :: i_sum_nq2 = 3
      integer, parameter :: i_nqused = 4
      integer, parameter :: i_nstep = 5
      integer, parameter :: i_nfail = 6
      integer, parameter :: i_nre = 7
      integer, parameter :: i_nje = 8
      integer, parameter :: i_ndec = 9
      integer, parameter :: i_nbsol = 10
      integer, parameter :: i_npset = 11
      integer, parameter :: i_ncoset = 12
      integer, parameter :: i_nsteps_prevJ = 13
      integer, parameter :: i_nbsols_prevJ = 14
      integer, parameter :: i_step_J = 15
      integer, parameter :: i_sol_J = 16
         
      integer, parameter :: num_idata = 16

         
      integer, parameter :: r_hused = 1
      integer, parameter :: r_lte = 2
      integer, parameter :: r_rcond = 3
      integer, parameter :: r_con = 4
         
      integer, parameter :: num_rdata = 4


      integer, parameter :: n_iwork_basic = 5 ! reserved for communication with caller
      integer, parameter :: n_dwork_basic = 5 ! reserved for communication with caller

      integer, parameter :: n_isaves_main = 17 ! save equed and i1,i2,...,i15,i16 in main routine
      integer, parameter :: n_dsaves_main = 28 ! save hstpsz(2,14) in main routine

      integer, parameter :: n_isaves_ovdriv = 3 ! size of ovdriv_integer_saves
      integer, parameter :: n_dsaves_ovdriv = 4 ! size of ovdriv_double_saves

      integer, parameter :: n_isaves_stiff = 25 ! size of stiff_integer_saves
      integer, parameter :: n_dsaves_stiff = 52 ! size of stiff_double_saves


      integer, parameter :: first_isaves_stiff = n_iwork_basic + n_isaves_main + 1

      integer, parameter :: first_isaves_ovdriv = first_isaves_stiff + n_isaves_stiff

      integer, parameter :: n_iwork_ttl =  
     >     n_iwork_basic + n_isaves_main + n_isaves_stiff + n_isaves_ovdriv

      
      integer, parameter :: first_dsaves_stiff = n_dwork_basic + n_dsaves_main + 1

      integer, parameter :: first_dsaves_ovdriv = first_dsaves_stiff + n_dsaves_stiff

      integer, parameter :: n_dwork_ttl =   
     >      n_dwork_basic + n_dsaves_main + n_dsaves_stiff + n_dsaves_ovdriv


      !  definitions related to the sizes of the arrays work and iwork
      
      ! for square jacobian matrix of size n by n, mbnd(3) and mbnd(4) both = n
      ! for banded jacobian with ml diagonals below the main diagonal and mu diagonals above
      !     mbnd(1) = ml
      !     mbnd(2) = mu
      !     mbnd(3) = mbnd(1) + mbnd(2) + 1
      !     mbnd(4) = mbnd(3) + mbnd(1)

      ! lwork   The size of the real(dp) work array.
      ! lwork  >= (n_dwork_alpha + n_dwork_beta3*mbnd(3) + n_dwork_beta4*mbnd(4))*n + n_dwork_gamma
      integer, parameter :: n_dwork_alpha = 34
      integer, parameter :: n_dwork_beta3 = 1
      integer, parameter :: n_dwork_beta4 = 1
      integer, parameter :: n_dwork_gamma = n_dwork_ttl + 1
      
      !
      ! liwork  The size of the integer work array.
      ! liwork  >= (n_iwork_alpha + n_iwork_beta3*mbnd(3) + n_iwork_beta4*mbnd(4))*n + n_iwork_gamma
      
      integer, parameter :: n_iwork_alpha = 1
      integer, parameter :: n_iwork_beta3 = 0
      integer, parameter :: n_iwork_beta4 = 0
      integer, parameter :: n_iwork_gamma = n_iwork_ttl
      

      end module mebdfi_solver_def
