! ***********************************************************************
!
!   Copyright (C) 2011  Bill Paxton

!   This file is part of MESA.
!
!   MESA is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      program sample_net

      implicit none
      
      call test
      
      
      contains
      
      
      
      subroutine test
         use rates_def, only: rates_NACRE_if_available
         use chem_def, only: num_categories
         
         integer :: ierr, handle, which_rates_choice, species, &
            num_reactions, lwork
         integer, pointer :: which_rates(:), chem_id(:), net_iso(:)
         character (len=100) :: data_dir, net_file
      	
         data_dir = '../../data'   	
         net_file = 'basic.net'
         which_rates_choice = rates_NACRE_if_available

      	ierr = 0
      	call initialize(data_dir, ierr)
         if (ierr /= 0) stop 1
         
         call setup_net( &
            net_file, handle, which_rates, which_rates_choice, &
            species, chem_id, net_iso, num_reactions, lwork, ierr)
         if (ierr /= 0) stop 1
         
         call do1_net_eval( &
            handle, species, num_reactions, &
            chem_id, net_iso, lwork, ierr)
         if (ierr /= 0) stop 1         
         
      end subroutine test
      
      
      subroutine initialize(data_dir, ierr)
         use const_lib, only: const_init
         use chem_lib, only: chem_init
         use reaclib_lib, only: reaclib_init
         use weak_lib, only: weak_init
         use rates_lib, only: rates_init
         use net_lib, only : net_init
         character (len=*), intent(in) :: data_dir
         integer, intent(out) :: ierr
         ierr = 0
      	call const_init
      	call chem_init(data_dir, 'isotopes.data_approx', ierr)
      	if (ierr /= 0) then
      	   write(*,*) 'chem_init failed'
      	   return
      	end if
         call reaclib_init(data_dir, ierr)   
      	if (ierr /= 0) then
      	   write(*,*) 'reaclib_init failed'
      	   return
      	end if
      	call weak_init(data_dir, ierr)   
      	if (ierr /= 0) then
      	   write(*,*) 'weak_init failed'
      	   return
      	end if
         call rates_init(data_dir, 'reactions.list', ierr)
      	if (ierr /= 0) then
      	   write(*,*) 'rates_init failed'
      	   return
      	end if
         call net_init(data_dir, ierr)
      	if (ierr /= 0) then
      	   write(*,*) 'net_init failed'
      	   return
      	end if         
      end subroutine initialize
      
      
      subroutine setup_net( &
            net_file, handle, which_rates, which_rates_choice, &
            species, chem_id, net_iso, num_reactions, lwork, ierr)
         use net_lib
         use rates_def, only: rates_reaction_id_max
         
         character (len=*), intent(in) :: net_file
         integer, intent(in) :: which_rates_choice
         integer, pointer :: which_rates(:) ! will be allocated
         integer, pointer :: chem_id(:), net_iso(:) ! set, but not allocated
         integer, intent(out) :: handle, species, num_reactions, lwork, ierr
         
         ierr = 0
         handle = alloc_net_handle(ierr)
         if (ierr /= 0) then
            write(*,*) 'alloc_net_handle failed'
            return
         end if
         
         call net_start_def(handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'net_start_def failed'
            return
         end if
         
         write(*,*) 'load ' // trim(net_file)
         call read_net_file(net_file, handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'read_net_file failed ', trim(net_file)
            return
         end if
         
         call net_finish_def(handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'net_finish_def failed'
            return
         end if
   	
      	allocate(which_rates(rates_reaction_id_max))
         which_rates(:) = which_rates_choice

         call net_set_which_rates(handle, which_rates, ierr)
         if (ierr /= 0) then
            write(*,*) 'net_set_which_rate_f17pg failed'
            return
         end if
         
         call net_setup_tables(handle, 'rate_tables', '', ierr)
         if (ierr /= 0) then
            write(*,*) 'net_setup_tables failed'
            return
         end if
         
         species = net_num_isos(handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in net_num_isos'
            return
         end if
         
         call get_chem_id_table_ptr(handle, chem_id, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in get_chem_id_table_ptr'
            return
         end if
         
         call get_net_iso_table_ptr(handle, net_iso, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in get_net_iso_table_ptr'
            return
         end if
         
         num_reactions = net_num_reactions(handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in net_num_reactions'
            return
         end if

         lwork = net_work_size(handle, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in net_work_size'
            return
         end if
         
      end subroutine setup_net
      
      
      subroutine do1_net_eval( &
            handle, species, num_reactions, chem_id, net_iso, lwork, ierr)
            
         use rates_def
         use screen_def
         use chem_def
         use net_lib
         use chem_lib
         
         integer, intent(in) :: handle, species, num_reactions, &
            chem_id(:), net_iso(:), lwork
         integer, intent(out) :: ierr
         
         integer :: screening_mode
         logical :: reuse_given_rates
         real*8 :: xa(species), T, logT, Rho, logRho, eta, &
            d_eps_nuc_dx(species), dabar_dx(species), dzbar_dx(species), &
            rate_factors(num_reactions), category_factors(num_categories), &
            rate_screened(num_rvs,num_reactions), reaction_eps_nuc(num_rvs,num_reactions), &
            rate_raw(num_rvs, num_reactions), work(lwork), &
            xh, xhe, abar, zbar, z2bar, ye, approx_abar, approx_zbar, xsum, &
            eps_nuc, d_eps_nuc_dRho, d_eps_nuc_dT, theta_e_for_graboske_et_al, &
            eps_nuc_categories(num_rvs, num_categories), eps_neu_total, &
            dxdt(species), d_dxdt_dRho(species), d_dxdt_dT(species), &
            d_dxdt_dx(species,species)
         
         include "formats.dek"
         
         ierr = 0
         
         ! set mass fractions -- must add to 1.0
         xa = 0
         xa(net_iso(ih1)) = 7.5876644280605066d-01
         xa(net_iso(ihe4)) = 2.3952230737160904d-01
         xa(net_iso(img24)) = 1 - sum(xa(:))
         
         call composition_info( &
            species, chem_id, xa, xh, xhe, abar, zbar, z2bar, &
            ye, approx_abar, approx_zbar, xsum, dabar_dx, dzbar_dx)
            
         logT = 8
         T = 10**logT
         logRho = 6
         Rho = 10**logRho
         
         eta = 0
         rate_factors(:) = 1
         category_factors(:) = 1

         theta_e_for_graboske_et_al =  1 ! for nondegenerate
         screening_mode = extended_screening
         reuse_given_rates = .false.
         
         call net_get( &
            handle, species, num_reactions, &
            xa, T, logT, Rho, logRho, & 
            abar, zbar, z2bar, ye, eta, rate_factors, category_factors, & 
            std_reaction_Qs, std_reaction_neuQs, &
            eps_nuc, d_eps_nuc_dRho, d_eps_nuc_dT, d_eps_nuc_dx, & 
            dxdt, d_dxdt_dRho, d_dxdt_dT, d_dxdt_dx, & 
            screening_mode, theta_e_for_graboske_et_al, &     
            rate_screened, rate_raw, reuse_given_rates, & 
            reaction_eps_nuc, eps_nuc_categories, eps_neu_total, & 
            lwork, work, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in net_get'
            return
         end if
         
         write(*,1) 'logT', logT
         write(*,1) 'logRho', logRho
         write(*,1) 'eps_nuc', eps_nuc
         write(*,*)

      end subroutine do1_net_eval
      
      
      
      end program sample_net




