# net.rb

load "../../../utils/image_plot.rb"
    
class Net_data < Image_data
    
    attr_accessor :log_net_eps, :log_sneut, :log_sdot, :d_lneps_dlnRho, :d_lneps_dlnT
    attr_accessor :d_eps_nuc_dxh1, :d_eps_nuc_dxhe4
    attr_accessor :log_abs_dh1dt,:log_dh1dt, :dh1dt
    attr_accessor :log_abs_dhe3dt, :dhe3dt
    attr_accessor :log_abs_dhe4dt, :dhe4dt
    attr_accessor :log_abs_dc12dt, :dc12dt
    attr_accessor :log_abs_dn14dt, :dn14dt
    attr_accessor :log_abs_do16dt, :do16dt
    attr_accessor :log_abs_dne20dt, :dne20dt
    attr_accessor :log_abs_dmg24dt, :dmg24dt
    attr_accessor :sum_dxdt_div_max_dxdt, :extra1, :extra2
    attr_accessor :xh1, :xhe4, :xc12, :xn14, :xo16
    
    def initialize(data_dir)
      
        read_image_Xs(data_dir, 'rho.data', 'log $\\rho$')
        read_image_Ys(data_dir, 'tmp.data', 'log T')  
             
        @log_net_eps = read_image_data(data_dir, 'log_net_eps')
        @sum_dxdt_div_max_dxdt = read_image_data(data_dir, 'sum_dxdt_div_max_dxdt')
        @d_lneps_dlnRho = read_image_data(data_dir, 'd_lneps_dlnRho')
        @d_lneps_dlnT = read_image_data(data_dir, 'd_lneps_dlnT')
         @log_sneut = read_image_data(data_dir, 'log_sneut')
         @log_sdot = read_image_data(data_dir, 'log_sdot')
         @d_eps_nuc_dxh1 = read_image_data(data_dir, 'd_eps_nuc_dxh1')
         @d_eps_nuc_dxhe4 = read_image_data(data_dir, 'd_eps_nuc_dxhe4')
        
        if false
            @dh1dt = read_image_data(data_dir, 'dh1dt')
            @log_dh1dt = @dh1dt.safe_log10
            @log_abs_dh1dt = @dh1dt.abs.safe_log10
            @dhe3dt = read_image_data(data_dir, 'dhe3dt')
            @log_abs_dhe3dt = @dhe3dt.abs.safe_log10
            @dhe4dt = read_image_data(data_dir, 'dhe4dt')
            @log_abs_dhe4dt = @dhe4dt.abs.safe_log10
            @dc12dt = read_image_data(data_dir, 'dc12dt')
            @log_abs_dc12dt = @dc12dt.abs.safe_log10
            @dn14dt = read_image_data(data_dir, 'dn14dt')
            @log_abs_dn14dt = @dn14dt.abs.safe_log10
            @do16dt = read_image_data(data_dir, 'do16dt')
            @log_abs_do16dt = @do16dt.abs.safe_log10
            @dne20dt = read_image_data(data_dir, 'dne20dt')
            @log_abs_dne20dt = @dne20dt.abs.safe_log10
            @dmg24dt = read_image_data(data_dir, 'dmg24dt')
            @log_abs_dmg24dt = @dmg24dt.abs.safe_log10
        end
        read_params(data_dir)
    end

    
    def read_params(data_dir)
        data = Dvector.read_row(data_dir + '/params.data')
        @xh1 = data[0]
        @xhe4 = data[1]
        @xc12 = data[2]
        @xn14 = data[3]
        @xo16 = data[4]
    end

end # class Net_data


class Net_plot

    include Math
    include FigureConstants
    include Image_plot
    
    def initialize(data_dir)
    
        @figure_maker = FigureMaker.default
        t.def_eval_function { |str| eval(str) }
        t.save_dir = 'plot_out'
        
        t.def_figure('log_net_eps') { log_net_eps }
        
        t.def_figure('d_lneps_dlnT') { d_lneps_dlnT }
        t.def_figure('d_lneps_dlnRho') { d_lneps_dlnRho }

        t.def_figure('log neutrino loss') { log_sneut }
        t.def_figure('log nuclear burn') { log_sdot }

        t.def_figure('d_eps_nuc_dxh1') { d_eps_nuc_dxh1 }
        t.def_figure('d_eps_nuc_dxhe4') { d_eps_nuc_dxhe4 }

        if false

            t.def_figure('dh1dt') { dh1dt }
            t.def_figure('log_dh1dt') { log_dh1dt }
            t.def_figure('log_abs_dh1dt') { log_abs_dh1dt }
            t.def_figure('log_abs_dhe3dt') { log_abs_dhe3dt }
            t.def_figure('log_abs_dhe4dt') { log_abs_dhe4dt }
            t.def_figure('log_abs_dc12dt') { log_abs_dc12dt }
            t.def_figure('log_abs_dn14dt') { log_abs_dn14dt }
            t.def_figure('log_abs_do16dt') { log_abs_do16dt }
            t.def_figure('log_abs_dne20dt') { log_abs_dne20dt }
            t.def_figure('log_abs_dmg24dt') { log_abs_dmg24dt }
            
        end
        
        t.def_figure('sum_dxdt_div_max_dxdt') { sum_dxdt_div_max_dxdt }

        @net_data = Net_data.new(data_dir)
        
        @write_contour0 = true
        
        t.def_enter_page_function { enter_page }

    end
    
    def enter_page
        t.page_setup(11*72/2,8.5*72/2)
        t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords        
    end
    
    def t
        @figure_maker
    end
    
    def d
        @net_data
    end

    # plot routines
    
    def do_decorations(title)
        footer = sprintf('By mass: H %.4f, He %.4f, C %.4f, N %.4f, O %.4f', d.xh1, d.xhe4, d.xc12, d.xn14, d.xo16)
        t.show_text('text'=> footer, 'side'=> BOTTOM, 'scale'=>0.55, 'shift'=>6)
    end
    
    def log_net_eps
        image_plot('d' => d, 'zs' => d.log_net_eps, 'title' => 'log nuclear energy out in photons', 
                    'z_lower' => -10, 'z_upper' => 10, 'contours' => [0])
    end
    
    def d_lneps_dlnT
        image_plot('d' => d, 'zs' => d.d_lneps_dlnT, 'title' => 'd_lneps_dlnT', 'z_lower' => -10, 'z_upper' => 30)
    end
    
    def d_lneps_dlnRho
        image_plot('d' => d, 'zs' => d.d_lneps_dlnRho, 'title' => 'd_lneps_dlnRho')#, 'z_lower' => -0.1, 'z_upper' => 10)
    end

    def log_sdot
        image_plot('d' => d, 'zs' => d.log_sdot, 'title' => 'log total nuclear energy', 'z_lower' => 0, 'z_upper' => 18)
    end
    
    def log_sneut
        image_plot('d' => d, 'zs' => d.log_sneut, 'title' => 'log nuclear energy out in neutrinos', 
         'z_lower' => -6, 'z_upper' => 18)
    end
    
    def d_eps_nuc_dxh1
        image_plot('d' => d, 'zs' => d.d_eps_nuc_dxh1, 'title' => 'log abs d_eps_nuc_dxh1', 'z_lower' => 0)
    end
    
    def d_eps_nuc_dxhe4
        image_plot('d' => d, 'zs' => d.d_eps_nuc_dxhe4, 'title' => 'log abs d_eps_nuc_dxhe4', 'z_lower' => 0)
    end
    
    def extra1
        image_plot('d' => d, 'zs' => d.extra1, 'title' => 'theta_e', 'z_lower' => 0, 'z_upper' => 2)
    end

    def extra2
        image_plot('d' => d, 'zs' => d.extra2, 'title' => 'log eps', 
                    'z_lower' => 0, 'z_upper' => 18, 'contours' => [0, 3, 6, 9, 12, 15, 18])
    end

    def extra3
        image_plot('d' => d, 'zs' => d.extra2, 'title' => 'nothing')
    end

    def sum_dxdt_div_max_dxdt
        image_plot('d' => d, 'zs' => d.sum_dxdt_div_max_dxdt, 'title' => 'sum_dxdt_div_max_dxdt')
    end

end
