! ***********************************************************************
!
!   Copyright (C) 2011  Bill Paxton
!
!   This file is part of MESA.
!
!   MESA is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,or
!   (at your option) any later version.
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not,write to the Free Software
!   Foundation,Inc.,59 Temple Place,Suite 330,Boston,MA 02111-1307 USA
!
! ***********************************************************************


      module test_mtx_support
      
      use mtx_lib
      use mtx_def
      
      implicit none


      
      contains
      
      
      
      subroutine test_format_conversion
         use mtx_def
         integer,parameter :: n=6
         integer,parameter :: nzmax = n*n,nrow = n,ncol = n,ndns = n,ndim = n
         integer,parameter :: iwk = nzmax,im = 10
         
         real(dp) :: a(ndim,n),a2(ndim,n),values(nzmax)
         integer,parameter :: ml = 1,mu = 2, ldbb = 2*ml+mu+1
         real(dp) :: b(ndim,n),b2(ndim,n),bb(ldbb,n),bb2(ldbb,n)
         integer :: ierr,nz,iptr(n+1),jind(nzmax),i,j,k,kk,hint
         
         write(*,*) 'test_format_conversion'
         
         a(1,1:n) = (/ 10d0, 0d0, 0d0, 0d0,  0d0, 0d0 /)
         a(2,1:n) = (/  0d0,12d0,-3d0,-1d0,  0d0, 0d0 /)
         a(3,1:n) = (/  0d0, 0d0,15d0, 0d0,  0d0, 0d0 /)
         a(4,1:n) = (/ -2d0, 0d0, 0d0,10d0, -1d0, 0d0 /)
         a(5,1:n) = (/ -1d0, 0d0, 0d0,-5d0,  1d0,-1d0 /)
         a(6,1:n) = (/ -1d0,-2d0, 0d0, 0d0,  0d0, 6d0 /)
         
         b(1,1:n) = (/ 10d0, 0d0, 0d0, 0d0,  0d0, 0d0 /)
         b(2,1:n) = (/ -2d0,12d0,-3d0,-1d0,  0d0, 0d0 /)
         b(3,1:n) = (/  0d0, 1d0,15d0, 0d0,  0d0, 0d0 /)
         b(4,1:n) = (/  0d0, 0d0, 0d0,10d0, -1d0, 0d0 /)
         b(5,1:n) = (/  0d0, 0d0, 0d0,-5d0,  1d0,-1d0 /)
         b(6,1:n) = (/  0d0, 0d0, 0d0, 0d0,  0d0, 6d0 /)
         
         ierr = 0
         
         write(*,*) 'dense_to_row_sparse'
         call dense_to_row_sparse(n,ndim,a,nzmax,nz,iptr,jind,values,ierr)
         if (ierr /= 0) stop 1
         a2 = -1
         call row_sparse_to_dense(n,ndim,a2,nz,iptr,jind,values,ierr)
         if (ierr /= 0) stop 2
         if (any(a /= a2)) stop 3
         write(*,*) 'find_loc_in_row_sparse'
         do i=1,n
            hint = 0
            do k=iptr(i),iptr(i+1)-1
               j = jind(k)
               call find_loc_in_sparse(compressed_row_sparse,n,nzmax,iptr,jind,i,j,hint,kk,ierr)
               if (kk /= k .or. ierr /= 0) then
                  write(*,*) 'failure in find_loc_in_row_sparse', i, j, k, kk
                  stop 1
               end if
               hint = k
            end do
         end do
               
         
         write(*,*) 'dense_to_column_sparse'
         call dense_to_column_sparse(n,ndim,a,nzmax,nz,iptr,jind,values,ierr)
         if (ierr /= 0) stop 4
         a2 = -1
         call column_sparse_to_dense(n,ndim,a2,nz,iptr,jind,values,ierr)
         if (ierr /= 0) stop 5
         if (any(a /= a2)) stop 6
         write(*,*) 'find_loc_in_column_sparse'
         do j=1,n
            hint = 0
            do k=iptr(j),iptr(j+1)-1
               i = jind(k)
               call find_loc_in_sparse(compressed_column_sparse,n,nzmax,iptr,jind,i,j,hint,kk,ierr)
               if (kk /= k .or. ierr /= 0) then
                  write(*,*) 'failure in find_loc_in_column_sparse', i, j, k, kk
                  stop 1
               end if
               hint = k
            end do
         end do



         write(*,*) 'dense_to_band'
         call dense_to_band(n,ndim,b,ml,mu,bb,ldbb,ierr)
         if (ierr /= 0) stop 1

         write(*,*) 'band_to_dense'
         a2 = -1
         call band_to_dense(n,ml,mu,bb,ldbb,ndim,a2,ierr)
         if (ierr /= 0) stop 2
         if (any(b /= a2)) stop 3
         
         write(*,*) 'band_to_column_sparse'
         call band_to_column_sparse(n,ml,mu,bb,ldbb,nzmax,nz,iptr,jind,values,ierr)
         if (ierr /= 0) stop 4
         
         write(*,*) 'column_sparse_to_band'
         bb2 = -1
         call column_sparse_to_band(n,ml,mu,bb2,ldbb,nz,iptr,jind,values,ierr)
         if (ierr /= 0) stop 5
         if (any(bb /= bb2)) stop 6
         
         write(*,*) 'band_to_row_sparse'
         call band_to_row_sparse(n,ml,mu,bb,ldbb,nzmax,nz,iptr,jind,values,ierr)
         if (ierr /= 0) stop 4

         write(*,*) 'row_sparse_to_band'
         bb2 = -1
         call row_sparse_to_band(n,ml,mu,bb2,ldbb,nz,iptr,jind,values,ierr)
         if (ierr /= 0) stop 5
         if (any(bb /= bb2)) stop 6

         write(*,*) 'okay'
         write(*,*)
      
      end subroutine test_format_conversion
      
      
      subroutine test_tri_solve
         integer, parameter :: n = 5
         real(dp), dimension(n) :: a, b, c, r, x, beta, rho
         integer :: i, ierr
         write(*,*) 'test_tri_solve'
         ! solves the tri-diagonal linear system a(k)*x(k-1) + b(k)*x(k) + c(k)*x(k+1) = r(k)
         a = -1
         b = 3
         c = -2
         do i=1,n
            r(i) = i-1
         end do
         call tri_solve(n, a, b, c, r, x, beta, rho, ierr)
         if (ierr /= 0) stop 1
         do i=1,n
            write(*,*) i, x(i)
         end do
         write(*,*)
      end subroutine test_tri_solve
      
      
      subroutine test_tridiag
         integer, parameter :: n = 5
         integer :: lrd, lid
         call tridiag_work_sizes(n,lrd,lid)
         call do_test
         write(*,*)
         
         contains
         
         subroutine do_test
            real(dp), target :: rpar_decsol(lrd)
            integer, target :: ipar_decsol(lid)
            integer, parameter :: ndim = 4, ml=1, mu=1
            real(dp) :: a(ndim,n), b(n), r(n), a2(ndim,n)
            integer :: ip(n), i, ierr
            
            write(*,*) 'test_tridiag'
            ! solves the tri-diagonal linear system am1(k)*x(k-1) + a00(k)*x(k) + ap1(k)*x(k+1) = r(k)
            a(2,1:n) = -2  ! am1 -- subdiagonal
            a(3,1:n) =  3  ! a00 -- diagonal
            a(4,1:n) = -1  ! ap1 -- superdiagonal
            
            a2(:,:) = a(:,:)

            do i=1,n
               b(i) = i-1
            end do
            r(:) = b(:)
            
            ierr = 0
            call tridiag_decsol(0,n,ndim,a,ml,mu,b,ip,lrd,rpar_decsol,lid,ipar_decsol,ierr)
            if (ierr /= 0) then
               write(*,*) 'failed in first call to tridiag_decsol', ierr
               stop 1
            end if
            
            ierr = 0
            call tridiag_decsol(1,n,ndim,a,ml,mu,b,ip,lrd,rpar_decsol,lid,ipar_decsol,ierr)
            if (ierr /= 0) then
               write(*,*) 'failed in second call to tridiag_decsol', ierr
               stop 1
            end if
         
            do i=1,n
               write(*,*) i, b(i)
            end do
            write(*,*)
         
            do i=2,n-1
               write(*,*) i, 'lhs', a2(2,i)*b(i-1) + a2(3,i)*b(i) + a2(4,i)*b(i+1)
               write(*,*) i, 'rhs', r(i)
               !write(*,*) i, 'err', a2(2,i)*b(i-1) + a2(3,i)*b(i) + a2(4,i)*b(i+1) - r(i)
               write(*,*)
            end do
            
         end subroutine do_test

      end subroutine test_tridiag
      
      
      subroutine test_quad_tridiag
         integer, parameter :: n = 5
         real(16), dimension(n) :: DL, D, DU, DU2, B
         integer, dimension(n) :: ip
         integer :: ierr, i
         
         write(*,*) 'test_quad_tridiag'

         DL = -2  ! subdiagonal
         D =   3  ! diagonal
         DU = -1  ! superdiagonal

         do i=1,n
            b(i) = i-1
         end do
         
         ierr = 0
         ! factor
         call qgttrf(n, DL, D, DU, DU2, ip, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in factoring'
            stop 1
         end if
         
         ierr = 0
         ! solve
         call qgttrs( 'N', n, 1, DL, D, DU, DU2, ip, B, n, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in solving'
            stop 1
         end if
      
         do i=1,n
            write(*,*) i, b(i)
         end do
         write(*,*)
         write(*,*)
         
      end subroutine test_quad_tridiag
      
      
      


   end module test_mtx_support
