      module test_klu
      use mtx_lib
      use const_def, only: dp
      use utils_lib, only: set_pointer_1, set_int_pointer_1
      
      implicit none
      
      contains


      subroutine test_klu_solver(do_timing)
         use alert_lib
         
         use mod_klu ! TESTING

         use omp_lib
         
         logical, intent(in) :: do_timing
               
         integer, parameter :: maxn = 10000, maxnz = 100000, nreps = 12, nrhs = 1
         
         real*8 :: x, dx
         real*8 :: result
         integer, pointer, dimension(:) :: rowind_in, colptr_in
         real*8, pointer, dimension(:) :: values_in
         integer, pointer, dimension(:,:) :: rowind, colptr
         real*8, pointer, dimension(:,:) :: values, b

         integer :: nz, ierr, rep, time0, time1, clock_rate, lid, lrd
         integer :: debug, i, j, k, m, cnt, nprocs, iounit, n, nnz, omp_num_threads
         character (len=256) :: filename
      
         real(dp), pointer :: rhs(:) ! (nz)
         integer, pointer :: ipar_decsol(:,:), i1(:)
         real(dp), pointer :: rpar_decsol(:,:), p1(:)

         include 'formats.dek'

         write(*,*) 'test klu'
         write(*,*)

         iounit = 33
         filename = 'sparse_data/g10'
         !filename = 'sparse_data/nnc1374.rua'
         ierr = 0
         open(unit=iounit, file=trim(filename), action='read', status='old', iostat=ierr)
         if (ierr /= 0) then
            write(*,*) 'failed to open ' // trim(filename)
            stop 1
         end if
         call mtx_read_hbcode1(iounit, n, nnz, values_in, rowind_in, colptr_in, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed to read ' // trim(filename)
            stop 1
         end if
         close(iounit)
         
         allocate( &
            rowind(nnz,nreps), colptr(n+1,nreps), values(nnz,nreps), b(n,nreps), rhs(n))

         
         call klu_work_sizes(n,nnz,lrd,lid)
         allocate(rpar_decsol(lrd,nreps), ipar_decsol(lid,nreps))
         
         do rep=1,nreps
            values(1:nnz,rep) = values_in(1:nnz)
            rowind(1:nnz,rep) = rowind_in(1:nnz)
            colptr(1:n+1,rep) = colptr_in(1:n+1)
         end do
         
         debug = 0
         ierr = 0
         
         rhs(:) = 1

         if (do_timing) call system_clock(time0,clock_rate)
         
!x$OMP PARALLEL DO PRIVATE(rep, result, i, ierr)
         do rep = 1, nreps
            call set_pointer_1(p1, rpar_decsol(:,rep), lrd)
            call set_int_pointer_1(i1, ipar_decsol(:,rep), lid)
            call klu_decsols( &
               0, n, nnz, colptr(:,rep), rowind(:,rep), values(:,rep), &
               b(:,rep), lrd, p1, lid, i1, ierr)
            if (ierr /= 0) then
               write(*,*) 'ierr from c_fortran_klu factor', ierr
               stop 1
            endif
            b(1:n,rep) = rhs(1:n)
            call klu_decsols( &
               1, n, nnz, colptr(:,rep), rowind(:,rep), values(:,rep), &
               b(:,rep), lrd, p1, lid, i1, ierr)
               
            if (ierr == 0) then
               if (rep == 1) then
                  do i=1,10
                     write(*,2) 'b(i)', i, b(i,rep)
                  end do
                  write(*,*)
               end if
            else
               write(*,*) 'ierr from c_fortran_klu ', ierr
               stop 1
            endif

            do i=1,10
               call klu_decsols( &
                  3, n, nnz, colptr(:,rep), rowind(:,rep), values(:,rep), &
                  b(:,rep), lrd, p1, lid, i1, ierr)
               if (ierr /= 0) then
                  write(*,*) 'ierr from c_fortran_klu refactor', ierr
                  stop 1
               endif
               b(1:n,rep) = rhs(1:n)
               call klu_decsols( &
                  1, n, nnz, colptr(:,rep), rowind(:,rep), values(:,rep), &
                  b(:,rep), lrd, p1, lid, i1, ierr)
               if (ierr /= 0) then
                  write(*,*) 'ierr from c_fortran_klu solve 2nd time', ierr
                  stop 1
               endif
            end do
            call klu_decsols( &
               2, n, nnz, colptr(:,rep), rowind(:,rep), values(:,rep), &
               b(:,rep), lrd, p1, lid, i1, ierr)
            if (ierr /= 0) then
               write(*,*) 'ierr from c_fortran_klu dealloc', ierr
               stop 1
            endif
            !write(*,2) 'sum', rep, sum(b(1:n,rep))
         end do
!x$OMP END PARALLEL DO
         
         if (do_timing) then
            call system_clock(time1,clock_rate)
            omp_num_threads = omp_get_max_threads()
            write(*,'(a20,2i4,f14.7)') 'threads, reps, time', &
               omp_num_threads, nreps, dble(time1-time0)/clock_rate
         end if

         write(*,*) ''
         
         deallocate(rhs, rowind, colptr, values, b)

      end subroutine test_klu_solver


      end module

