! ***********************************************************************
!
!   Copyright (C) 2006, 2007, 2008  Bill Paxton
!
!   This file is part of MESA.
!
!   MESA is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************


      module mod_superlu_mt
      
      use alert_lib,only:alert
      implicit none
      
      
      ! handle is in ipar_decsol(1:2)
      integer, parameter :: num_ipar_decsol = 2
      integer, parameter :: num_rpar_decsol = 0
      
      logical :: have_omp_num_threads = .false.
      integer :: mtx_omp_num_threads = 0
      
      
      contains
      
      
      logical function use_superlu_mt()
         use_superlu_mt = .true.
      end function use_superlu_mt


      subroutine do_superlu_mt_work_sizes(n,nzmax,lrd,lid)
         integer, intent(in) :: n,nzmax
         integer, intent(out) :: lrd, lid
         lid = num_ipar_decsol
         lrd = num_rpar_decsol
      end subroutine do_superlu_mt_work_sizes
      
      
      subroutine do_superlu_mt_decsols(iopt,n,nz,colptr,rowind,values,b,
     >         lrd,rpar_decsol,lid,ipar_decsol,ierr)

         use omp_lib

         ! compressed sparse column format, double real
         integer, intent(in) :: iopt, n, nz, lrd, lid
         integer, intent(in) :: colptr(n+1), rowind(nz)
         double precision, intent(in) :: values(nz)
         double precision, intent(inout) :: b(n)
         double precision, intent(inout), target :: rpar_decsol(lrd)
         integer, intent(inout), target :: ipar_decsol(lid)
         integer, intent(out) :: ierr
         integer :: nrhs, ldb, nprocs, i
         integer :: time0, clock_rate, time1
         include 'formats.dek'
         
         ierr = 0
         if (iopt == 1) then ! factor
            return ! pdgssv factors along with solving
         else if (iopt == 2) then ! solve
         else if (iopt == 3) then ! deallocate
            return ! pdgssv dealloctes after solving
         else
            ierr = -1
            write(*,2) 'superlu_mt_decsols: iop', iopt
            call alert(ierr,'superlu_mt_decsols: iop bad')
         end if
         
         if (.not. have_omp_num_threads) then
            mtx_omp_num_threads = omp_get_max_threads()
            have_omp_num_threads = .true.
            !write(*,*) 'mtx_omp_num_threads', mtx_omp_num_threads
         end if
         ldb = n
         nrhs = 1
         nprocs = max(1,mtx_omp_num_threads)
         
         !write(*,*) 'call c_bridge_pdgssv'
         !call system_clock(time0,clock_rate)
         call c_bridge_pdgssv(iopt, nprocs, n, nz, nrhs, values, rowind, colptr, 
     >                     b, ldb, ipar_decsol(1:2), ierr)
         !call system_clock(time1,clock_rate)
         !write(*,*) 'done c_bridge_pdgssv', dble(time1-time0)/clock_rate
         !write(*,*)
     
      end subroutine do_superlu_mt_decsols


      end module mod_superlu_mt


