      module mod_superlu_dist
      implicit none
      
      contains
      
      
      logical function use_superlu_dist()
         use_superlu_dist = .false.
      end function use_superlu_dist
      
      
      subroutine do_superlu_dist_before(iam, nprocs, nprow, npcol, ierr)
         integer, intent(out) :: iam, nprocs, nprow, npcol, ierr
         iam = 0; nprocs = 1; nprow = 1; npcol = 1; ierr = 0
      end subroutine do_superlu_dist_before
      
      
      subroutine do_superlu_dist_after(ierr)
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine do_superlu_dist_after
      
      
      subroutine do_superlu_dist_mpi_init(ierr)
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine do_superlu_dist_mpi_init
      
      
      subroutine do_superlu_dist_mpi_finalize(ierr)
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine do_superlu_dist_mpi_finalize


      subroutine do_superlu_dist_work_sizes(n,nzmax,lrd,lid)
         integer, intent(in) :: n,nzmax
         integer, intent(out) :: lrd, lid
         lid = 0
         lrd = 0
      end subroutine do_superlu_dist_work_sizes
      
      
      subroutine do_superlu_dist_size(size, ierr)
         integer, intent(out) :: size, ierr
         ierr = 0; size = 1
      end subroutine do_superlu_dist_size

      
      subroutine do_superlu_dist_decsols(iopt,n,nz,colptr,rowind,values,b,
     >         lrd,rpar_decsol,lid,ipar_decsol,ierr)
         integer, intent(in) :: iopt, n, nz, lrd, lid
         integer, intent(in) :: colptr(n+1), rowind(nz)
         double precision, intent(in) :: values(nz)
         double precision, intent(inout) :: b(n)
         double precision, intent(inout), target :: rpar_decsol(lrd)
         integer, intent(inout), target :: ipar_decsol(lid)
         integer, intent(out) :: ierr
         ierr = -1
         write(*,*) 'superlu_dist_decsols: superlu_dist not loaded -- must edit makefile_header'
      end subroutine do_superlu_dist_decsols

      
      subroutine do_superlu_dist_quit_work(ierr)
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine do_superlu_dist_quit_work
      
      
      subroutine do_superlu_dist_release_and_destroy(ierr)
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine do_superlu_dist_release_and_destroy
      
      
      subroutine do_superlu_dist_create_and_init(nprow_in, npcol_in, iam, ierr)
         integer, intent(in) :: nprow_in, npcol_in
         integer, intent(out) :: iam, ierr
         ierr = 0; iam = 0
      end subroutine do_superlu_dist_create_and_init
      
      
      subroutine do_superlu_dist_start_work(ierr)
         integer, intent(out) :: ierr
         ierr = 0
      end subroutine do_superlu_dist_start_work


      end module mod_superlu_dist


