   ! ***********************************************************************
!
!   copyright (c) 2012  bill paxton
!
!   mesa is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the mesa manifesto
!   and the gnu general library public license as published
!   by the free software foundation; either version 2 of the license,
!   or (at your option) any later version.
!
!   you should have received a copy of the mesa manifesto along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   mesa is distributed in the hope that it will be useful,
!   but without any warranty; without even the implied warranty of
!   merchantability or fitness for a particular purpose.
!   see the gnu library general public license for more details.
!
!   you should have received a copy of the gnu library general public license
!   along with this software; if not, write to the free software
!   foundation, inc., 59 temple place, suite 330, boston, ma 02111-1307 usa
!
! ***********************************************************************

#ifdef DBLE
      module my_lapack95_dble
      use const_def, only: dp
      implicit none
      integer, parameter :: fltp = dp
#else
      module my_lapack95_quad
      use const_def, only: qp
      implicit none
      integer, parameter :: fltp = qp
#endif


      contains


      subroutine my_gemv(m,n,a,lda,x,y) ! y := alpha*a*x + beta*y
         integer lda,m,n
         real(fltp) :: a(:,:) ! (lda,*)
         real(fltp) :: x(:), y(:)
         real(fltp) :: tmp
         real(fltp), parameter :: one=1, zero=0
         ! trans = 'n'
         ! alpha = -1
         ! beta = 1
         ! incx = 1
         ! incy = 1
         integer :: j, i
         do j = 1,n
            tmp = x(j)
            if (tmp.ne.zero) then
               do i = 1,m
                  y(i) = y(i) - tmp*a(i,j)
               end do
            end if
         end do
      end subroutine my_gemv
      
      
      subroutine my_gemm(m,n,k,a,lda,b,ldb,c,ldc) ! c := c - a*b
         integer, intent(in) :: k,lda,ldb,ldc,m,n
         real(fltp), dimension(:,:) :: a, b, c ! a(lda,*),b(ldb,*),c(ldc,*)
         real(fltp) :: tmp
         real(fltp), parameter :: one=1, zero=0
         integer :: j, i, l
         ! transa = 'n'
         ! transb = 'n'
         ! alpha = -1
         ! beta = 1
         ! assumes other args are valid
         do j = 1,n
            do l = 1,k
               tmp = b(l,j)
               if (tmp .ne. zero) then
                  do i = 1,m
                     c(i,j) = c(i,j) - tmp*a(i,l)
                  end do
               end if
            end do
         end do      
      end subroutine my_gemm
      
      
      subroutine my_gemm0(m,n,k,a,lda,b,ldb,c,ldc)
         ! c := -a*b
         integer, intent(in) :: k,lda,ldb,ldc,m,n
         real(fltp), dimension(:,:) :: a, b, c ! a(lda,*),b(ldb,*),c(ldc,*)
         integer :: j, i
         real(fltp), parameter :: zero=0
         include 'formats.dek'
         ! transa = 'n'
         ! transb = 'n'
         ! alpha = -1
         ! beta = 0
         ! assumes other args are valid
         do j=1,n
            do i=1,m
               c(i,j) = zero
            end do
         end do
         call my_gemm(m,n,k,a,lda,b,ldb,c,ldc)
      end subroutine my_gemm0

      
      subroutine my_getf2(m, a, lda, ipiv, sfmin, info)
         integer :: info, lda, m
         integer :: ipiv(:)
         real(fltp) :: a(:,:), sfmin ! a( lda, * )
         real(fltp), parameter :: one=1, zero=0
         integer :: i, j, jp, ii, jj
         real(fltp) :: tmp
         do j = 1, m
            info = 0
            jp = j - 1 + maxloc(abs(a(j:lda,j)),dim=1)
            ipiv( j ) = jp
            if( a( jp, j ).ne.zero ) then
               if( jp.ne.j ) then ! swap a(j,:) and a(jp,:)
                  do i=1,m
                     tmp = a(j,i)
                     a(j,i) = a(jp,i)
                     a(jp,i) = tmp
                  end do
               end if
               if( j.lt.m ) then 
                  if( abs(a( j, j )) .ge. sfmin ) then 
                     !call dscal( m-j, one / a( j, j ), a( j+1, j ), 1 ) 
                     call my_scal( m-j, one / a( j, j ), a( j+1:lda, j ) )                   
                  else ! no scale
                    do i = 1, m-j 
                       a( j+i, j ) = a( j+i, j ) / a( j, j ) 
                    end do 
                  end if 
               end if 
            else if( info.eq.0 ) then
               info = j
            end if
            if( j.lt.m ) then
               !call dger( m-j, m-j, -one, a( j+1, j ), 1, a( j, j+1 ), lda, a( j+1, j+1 ), lda )
               do jj = j+1, m
                  do ii = j+1, m
                     a(ii,jj) = a(ii,jj) - a(ii,j)*a(j,jj)
                  end do
               end do
            end if
         end do
      end subroutine my_getf2


      subroutine my_scal(n,da,dx)
         real(fltp) :: da
         integer :: n
         real(fltp) :: dx(:)
         integer :: i,m,mp1,nincx
         m = mod(n,5)
         if (m /= 0) then
            do i = 1,m
               dx(i) = da*dx(i)
            end do
            if (n < 5) return
         end if
         mp1 = m + 1
         do i = mp1,n,5
            dx(i) = da*dx(i)
            dx(i+1) = da*dx(i+1)
            dx(i+2) = da*dx(i+2)
            dx(i+3) = da*dx(i+3)
            dx(i+4) = da*dx(i+4)
         end do
      end subroutine my_scal
      
      
      subroutine my_laswp( n,   a, lda,  k1, k2, ipiv,  incx )
         integer :: incx, k1, k2, lda, n
         integer :: ipiv(:)
         real(fltp) :: a(:,:) ! a( lda, * )
         integer :: i, i1, i2, inc, ip, ix, ix0, j, k, n32
         real(fltp) :: temp
         ! interchange row i with row ipiv(i) for each of rows k1 through k2.
         if( incx.gt.0 ) then
            ix0 = k1
            i1 = k1
            i2 = k2
            inc = 1
         else if( incx.lt.0 ) then
            ix0 = 1 + ( 1-k2 )*incx
            i1 = k2
            i2 = k1
            inc = -1
         else
            return
         end if
         n32 = ( n / 32 )*32
         if( n32.ne.0 ) then
            do j = 1, n32, 32
               ix = ix0
               do i = i1, i2, inc
                  ip = ipiv( ix )
                  if( ip.ne.i ) then
                     do k = j, j + 31
                        temp = a( i, k )
                        a( i, k ) = a( ip, k )
                        a( ip, k ) = temp
                     end do
                  end if
                  ix = ix + incx
               end do
            end do
         end if
         if( n32.ne.n ) then
            n32 = n32 + 1
            ix = ix0
            do i = i1, i2, inc
               ip = ipiv( ix )
               if( ip.ne.i ) then
                  do k = n32, n
                     temp = a( i, k )
                     a( i, k ) = a( ip, k )
                     a( ip, k ) = temp
                  end do
               end if
               ix = ix + incx
            end do
         end if      
      end subroutine my_laswp
      
      
      subroutine my_getrs( n, nrhs, a, lda, ipiv, b, ldb, info )
         integer :: info, lda, ldb, n, nrhs
         integer :: ipiv(:)
         real(fltp) :: a(:,:), b(:,:) ! a( lda, * ), b( ldb, * )
         real(fltp), parameter :: one=1, zero=0
         real(fltp) :: temp
         integer :: i,j,k, n32, ix, ip
         info = 0
         call my_laswp(nrhs, b, ldb, 1, n, ipiv, 1 )
         !call dtrsm( 'left', 'lower', 'no transpose', 'unit', n, nrhs, one, a, lda, b, ldb )
         do j = 1,nrhs
            do k = 1,n
               if (b(k,j).ne.zero) then
                  do i = k + 1,n
                     b(i,j) = b(i,j) - b(k,j)*a(i,k)
                  end do
               end if
            end do
         end do
         !call dtrsm( 'left', 'upper', 'no transpose', 'non-unit', n, nrhs, one, a, lda, b, ldb )
         do j = 1,nrhs
            do k = n,1,-1
               if (b(k,j).ne.zero) then
                  b(k,j) = b(k,j)/a(k,k)
                  do i = 1,k - 1
                     b(i,j) = b(i,j) - b(k,j)*a(i,k)
                  end do
               end if
            end do
         end do
      end subroutine my_getrs


#ifdef DBLE
      end module my_lapack95_dble
#else
      end module my_lapack95_quad
#endif
