! ***********************************************************************
!
!   Copyright (C) 2006, 2007, 2008  Bill Paxton
!
!   This file is part of MESA.
!
!   MESA is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************


      module mod_klu
      
      use alert_lib,only:alert
      use const_def, only: dp
      
      implicit none
      
      
      ! handle is in ipar_decsol(1:2)
      integer, parameter :: num_klu_ipar_decsol = 2
      integer, parameter :: num_klu_rpar_decsol = 1
      
      
      contains


      subroutine do_klu_work_sizes(n,nzmax,lrd,lid)
         integer, intent(in) :: n,nzmax
         integer, intent(out) :: lrd, lid
         lid = num_klu_ipar_decsol
         lrd = num_klu_rpar_decsol
      end subroutine do_klu_work_sizes
      
      
      subroutine do_klu_decsols(
     >         iopt,n,nz,colptr,rowind,values,b,
     >         lrd,rpar_decsol,lid,ipar_decsol,ierr)
         integer, intent(in) :: iopt, n, nz, lrd, lid
         integer, intent(inout) :: colptr(n+1), rowind(nz)
         real(dp), intent(inout) :: values(nz)
         real(dp), intent(inout) :: b(n)
         real(dp), intent(inout), target :: rpar_decsol(lrd)
         integer, intent(inout), target :: ipar_decsol(lid)
         integer, intent(out) :: ierr
         integer :: i
         ierr = 0
         ! convert to 0 based
         do i=1,n+1
            colptr(i) = colptr(i)-1
         end do
         do i=1,nz
            rowind(i) = rowind(i)-1
         end do
         call c_fortran_klu( iopt+1, n, 1, values, rowind, colptr, 
     >            b, n, rpar_decsol(1), ipar_decsol(1:2), ierr )
         ! convert back
         do i=1,n+1
            colptr(i) = colptr(i)+1
         end do
         do i=1,nz
            rowind(i) = rowind(i)+1
         end do
      end subroutine do_klu_decsols
      
      
      subroutine do_klu_decsols_nrhs(
     >         iopt,nrhs,n,nz,colptr,rowind,values,b,
     >         lrd,rpar_decsol,lid,ipar_decsol,ierr)
         integer, intent(in) :: iopt, nrhs, n, nz, lrd, lid
         integer, intent(inout) :: colptr(n+1), rowind(nz)
         real(dp), intent(inout) :: values(nz)
         real(dp), intent(inout) :: b(n)
         real(dp), intent(inout), target :: rpar_decsol(lrd)
         integer, intent(inout), target :: ipar_decsol(lid)
         integer, intent(out) :: ierr
         integer :: i
         ierr = 0
         ! convert to 0 based
         do i=1,n+1
            colptr(i) = colptr(i)-1
         end do
         do i=1,nz
            rowind(i) = rowind(i)-1
         end do
         call c_fortran_klu( iopt+1, n, nrhs, values, rowind, colptr, 
     >            b, n, rpar_decsol(1), ipar_decsol(1:2), ierr )
         ! convert back
         do i=1,n+1
            colptr(i) = colptr(i)+1
         end do
         do i=1,nz
            rowind(i) = rowind(i)+1
         end do
      end subroutine do_klu_decsols_nrhs
      
      
      subroutine do_klu_decsols_nrhs_0_based(
     >         iopt,nrhs,n,nz,colptr,rowind,values,b,
     >         lrd,rpar_decsol,lid,ipar_decsol,ierr)
         integer, intent(in) :: iopt, nrhs, n, nz, lrd, lid
         integer, intent(inout) :: colptr(n+1), rowind(nz)
         real(dp), intent(inout) :: values(nz)
         real(dp), intent(inout) :: b(n)
         real(dp), intent(inout), target :: rpar_decsol(lrd)
         integer, intent(inout), target :: ipar_decsol(lid)
         integer, intent(out) :: ierr
         ierr = 0
         call c_fortran_klu( iopt+1, n, nrhs, values, rowind, colptr, 
     >            b, n, rpar_decsol(1), ipar_decsol(1:2), ierr )
      end subroutine do_klu_decsols_nrhs_0_based


      end module mod_klu


