
#include <stdio.h>
#include "klu.h"

#define HANDLE_SIZE  8
/* kind of integer to hold a pointer. */
typedef long long fptr;  /* 64-bit by default */

typedef struct {
   klu_symbolic *Symbolic ;
   klu_numeric *Numeric ;
   klu_common Common ;
} factors_t;

   
void
c_fortran_klu_(int *iopt, int *n, int *nrhs, 
                 double Ax [ ], int Ai [ ], int Ap [ ],
                 double B [ ], int *ldb, double *result,
		 fptr *f_factors, /* a handle containing the address
				     pointing to the factored matrices */
		 int *info)
{
/* 
 * This routine can be called from Fortran.
 *
 * iopt (input) int
 *      Specifies the operation:
 *      = 1, klu_analyze and klu_factor
 *      = 2, klu_solve
 *      = 3, klu_free_symbolic and klu_free_numeric
 *      = 4, klu_refactor
 *      = 5, result = klu_rcond
 *      = 6, result = klu_rgrowth
 *      = 7, result = klu_condest
 *
 * f_factors (input/output) fptr* 
 *      If iopt == 1, it is an output and contains the pointer pointing to
 *                    the structure of the factored matrices.
 *      Otherwise, it it an input.
 *
 */
 
    factors_t *klu;
	 klu = (factors_t*) *f_factors;
    *info = 0;
    *result = 0.0;

    if ( *iopt == 1 ) { /* analyze and factor */

	    klu = (factors_t*) malloc(sizeof(factors_t));
	    *f_factors = (fptr) klu;
       klu_defaults (&klu->Common) ;
       
       //klu->Common.tol = 0.0; 
       //klu->Common.btf = 0; 
       //klu->Common.scale = 0; 
       //klu->Common.ordering = 2; 
       
       klu->Symbolic = klu_analyze (*n, Ap, Ai, &klu->Common) ;
       if (klu->Common.status == 0) {
          klu->Numeric = klu_factor (Ap, Ai, Ax, klu->Symbolic, &klu->Common) ;
       }
       *info = klu->Common.status;

    } else if ( *iopt == 2 ) { /* solve */
       
       klu_solve (klu->Symbolic, klu->Numeric, *ldb, *nrhs, B, &klu->Common) ;
       *info = klu->Common.status;

    } else if ( *iopt == 3 ) { /* free storage */

       klu_free_symbolic (&klu->Symbolic, &klu->Common) ;
       klu_free_numeric (&klu->Numeric, &klu->Common) ;
       free(klu);

    } else if ( *iopt == 4 ) { /* refactor */

       klu_refactor (Ap, Ai, Ax, klu->Symbolic, klu->Numeric, &klu->Common) ;
       *info = klu->Common.status;

    } else if ( *iopt == 5 ) { /* result = rcond */

       klu_rcond (klu->Symbolic, klu->Numeric, &klu->Common) ;
       *result = klu->Common.rcond;
       *info = klu->Common.status;

    } else if ( *iopt == 6 ) { /* result = rgrowth */

       klu_rgrowth (Ap, Ai, Ax, klu->Symbolic, klu->Numeric, &klu->Common) ;
       *result = klu->Common.rgrowth;
       *info = klu->Common.status;

    } else if ( *iopt == 7 ) { /* result = condest */
       klu_condest (Ap, Ax, klu->Symbolic, klu->Numeric, &klu->Common) ;
       *result = klu->Common.condest;
       *info = klu->Common.status;

    } else {
	    printf("Invalid iopt=%d passed to c_fortran_klu\n",*iopt);
	    exit(-1);
    }
}

/*
void c_fortran_test128_(__float128 *x128) {
   long double x;
   x = *x128;
   printf("x %Lg\n", x);
}
*/

void c_fortran_test_(int *num) {
   int    n = 5 ;
   int    Ap [ ] = {0, 2, 5, 9, 10, 12} ;
   int    Ai [ ] = { 0,  1,  0,   2,  4,  1,  2,  3,   4,  2,  1,  4} ;
   double Ax [ ] = {2., 3., 3., -1., 4., 4., -3., 1., 2., 2., 6., 1.} ;
   double B1 [ ] = {8., 45., -3., 3., 19.} ;
   double B2 [ ] = {8., 45., -3., 3., 19.} ;
   double err1, err2, err, result, rcond, rgrowth, condest;
   fptr klu_info;
   fptr *klu = &klu_info;
   int i, nrhs, ldb, info, iopt ;
   
   nrhs = 1;
   ldb = n;
   
   iopt = 1; // factor
   c_fortran_klu_(&iopt, &n, &nrhs, Ax, Ai, Ap, B1, &ldb, &result, klu, &info);
   if (info < 0) {
      printf("error in factoring\n");
      exit(1);
   }
   
   iopt = 5; // rcond
   c_fortran_klu_(&iopt, &n, &nrhs, Ax, Ai, Ap, B1, &ldb, &rcond, klu, &info);
   if (info < 0) {
      printf("error in solve\n");
      exit(1);
   }
   
   iopt = 6; // rgrowth
   c_fortran_klu_(&iopt, &n, &nrhs, Ax, Ai, Ap, B1, &ldb, &rgrowth, klu, &info);
   if (info < 0) {
      printf("error in solve\n");
      exit(1);
   }
   
   iopt = 7; // condest
   c_fortran_klu_(&iopt, &n, &nrhs, Ax, Ai, Ap, B1, &ldb, &condest, klu, &info);
   if (info < 0) {
      printf("error in solve\n");
      exit(1);
   }
   
   iopt = 2; // solve
   c_fortran_klu_(&iopt, &n, &nrhs, Ax, Ai, Ap, B1, &ldb, &result, klu, &info);
   if (info < 0) {
      printf("error in solve\n");
      exit(1);
   }
   
   err1 = 0.0;
   for (i = 0 ; i < n ; i++) {
      err = i + 1.0 - B1[i];
      err1 = err1 + err*err;
   }
   
   iopt = 4; // refactor
   c_fortran_klu_(&iopt, &n, &nrhs, Ax, Ai, Ap, B2, &ldb, &result, klu, &info);
   if (info < 0) {
      printf("error in solve\n");
      exit(1);
   }
   
   iopt = 2; // solve
   c_fortran_klu_(&iopt, &n, &nrhs, Ax, Ai, Ap, B2, &ldb, &result, klu, &info);
   if (info < 0) {
      printf("error in solve\n");
      exit(1);
   }

   iopt = 3; // dealloc
   c_fortran_klu_(&iopt, &n, &nrhs, Ax, Ai, Ap, B2, &ldb, &result, klu, &info);
   if (info < 0) {
      printf("error in solve\n");
      exit(1);
   }
   
   err2 = 0.0;
   for (i = 0 ; i < n ; i++) {
      err = i + 1.0 - B2[i];
      err2 = err2 + err*err;
   }
   printf ("%d:       err1 %g       err2 %g       rcond %g       rgrowth %g       condest %g\n", 
      *num, err1, err2, rcond, rgrowth, condest) ;
}

