! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module mlt_def
      implicit none

      
      ! mixing types
      ! NOTE: other packages may depend on the order
      integer, parameter :: no_mixing = 0
      integer, parameter :: convective_mixing = 1
      integer, parameter :: overshoot_mixing = 2
      integer, parameter :: semiconvective_mixing = 3
      integer, parameter :: thermo_haline_mixing = 4
      integer, parameter :: rotation_mixing = 5
      integer, parameter :: anonymous_mixing = 6
      
      
      
      ! Basic MLT results
      
      integer, parameter :: mlt_gradT = 1 ! actual temperature gradient dlnT/dlnP
      
      integer, parameter :: mlt_gradr = 2 ! radiative temperature gradient
            ! dlnT/dlnP required for purely radiative transport
      
      integer, parameter :: mlt_gradL = 3 ! Ledoux criterion temperature gradient
            ! Ledoux stable if gradL > gradr
      
      integer, parameter :: mlt_scale_height = 4 ! [cm]
            ! if alt_scale_height is false, then the usual P/(grav*rho)
            ! otherwise, min of the usual and sound speed * hydro time scale, sqrt(P/G)/rho
      
      integer, parameter :: mlt_Lambda = 5 ! mixing_length [cm]
            ! mixing_length_alpha * scale_height
      
      integer, parameter :: mlt_convection_velocity = 6 ! [cm/sec]
            ! note that where the convective efficiency is small, the velocity becomes large
            ! and MLT can actually return supersonic convection velocities in some cases
      
      integer, parameter :: mlt_D = 7 ! diffusion coefficient in units of cm^2/second
            ! D = convection_velocity*mixing_length/3
      
      integer, parameter :: mlt_Gamma = 8 ! convective efficiency
      
      integer, parameter :: mlt_conv_dP_term = 9 ! pressure gradient from turbulence
         ! e.g., replace dP/dr = -rho*grav
         ! by dP/dr*(1 + conv_dP_term) = -rho*grav
            
      integer, parameter :: num_mlt_results = 9
      
      
      ! partials

      integer, parameter :: mlt_dlnm = 1
      integer, parameter :: mlt_dlnR = 2
      integer, parameter :: mlt_dlnT = 3
      integer, parameter :: mlt_dlnd = 4
      integer, parameter :: mlt_dL = 5       
      integer, parameter :: mlt_dP = 6
      integer, parameter :: mlt_dchiRho = 7
      integer, parameter :: mlt_dchiT = 8
      integer, parameter :: mlt_dCp = 9
      integer, parameter :: mlt_dopacity = 10
      integer, parameter :: mlt_dgrada = 11
      
      integer, parameter :: num_mlt_partials = 11


      end module mlt_def
      
      
      
      
