! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module mod_tables

      implicit none
      
      logical :: ionization_tables_okay = .false.
      
      real*8 :: ip(30,30) ! ionization_potentials

      contains
      
      
      subroutine set_ionization_potentials ! data from
         ! Allen, C.W., 1973, "Astrophysical Quantities", 3rd edition, pg 37-38.
         
         ! 1 h
         ip(1,1) = 13.598
         
         ! 2 he
         ip(2,1:2) = (/ &
            24.587, &
            54.416 /)
         
         ! 3 Li
         ip(3,1:3) = (/ &
            5.392, &
            75.638, &
            122.451 /)
         
         ! 4 Be
         ip(4,1:4) = (/ &
            9.322, &
            18.211, &
            153.893, &
            217.713 /)
         
         ! 5 B
         ip(5,1:5) = (/ &
            8.298, &
            21.155, &
            37.930, &
            259.366, &
            340.22 /)
         
         ! 6 C
         ip(6,1:6) = (/ &
            11.260, &
            21.383, &
            47.887, &
            64.492, &
            392.08, &
            489.98 /)
         
         ! 7 N
         ip(7,1:7) = (/ &
            14.543, &
            29.601, &
            47.448, &
            77.472, &
            97.89, &
            552.06, &
            667.03 /)
         
         ! 8 O
         ip(8,1:8) = (/ &
            13.618, &
            35.117, &
            54.934, &
            77.413, &
            113.90, &
            138.12, &
            739.32, &
            871.39 /)
         
         ! 9 F
         ip(9,1:9) = (/ &
            17.422, &
            34.970, &
            62.707, &
            87.138, &
            114.24, &
            157.16, &
            185.18, &
            953.89, &
            1103.1 /)
         
         ! 10 Ne
         ip(10,1:10) = (/ &
            21.564, &
            40.962, &
            63.45, &
            97.11, &
            126.21, &
            157.93, &
            207.26, &
            239.09, &
            1195.8, &
            1362.2 /)
         
         ! 11 Na
         ip(11,1:11) = (/ &
            5.139, &
            47.286, &
            71.64, &
            98.91, &
            138.40, &
            172.15, &
            208.48, &
            264.19, &
            299.9, &
            1465.1, &
            1648.7 /)
         
         ! 12 Mg
         ip(12,1:12) = (/ &
            7.646, &
            15.035, &
            80.143, &
            109.31, &
            141.27, &
            186.51, &
            224.95, &
            265.92, &
            328.0, &
            367.5, &
            1761.8, &
            1963.0 /)
         
         ! 13 Al
         ip(13,1:13) = (/ &
            5.986, &
            18.826, &
            28.448, &
            119.99, &
            153.75, &
            190.47, &
            241.44, &
            284.59, &
            330.2, &
            398.6, &
            442.0, &
            2086.0, &
            2304.0 /)
         
         ! 14 Si
         ip(14,1:14) = (/ &
            8.151, &
            16.345, &
            33.492, &
            45.141, &
            166.77, &
            205.08, &
            246.49, &
            303.16, &
            351.1, &
            401.4, &
            476.1, &
            523.0, &
            2438.0, &
            2304.0 /)
         
         ! 15 P
         ip(15,1:15) = (/ &
            10.486, &
            19.725, &
            30.18, &
            51.42, &
            65.02, &
            220.45, &
            263.28, &
            309.37, &
            371.7, &
            424.4, &
            479.5, &
            561.0, &
            612.0, &
            2817.0, &
            3070.0 /)
         
         ! 16 S
         ip(16,1:16) = (/ &
            10.360, &
            23.33, &
            34.83, &
            47.30, &
            72.68, &
            88.05, &
            280.01, &
            328.33, &
            400.4, &
            455.6, &
            529.3, &
            592.0, &
            657.0, &
            750.0, &
            3224.0, &
            3494.0 /)
         
         ! 17 Cl
         ip(17,1:17) = (/ &
            12.967, &
            23.81, &
            39.61, &
            53.46, &
            67.7, &
            97.03, &
            114.19, &
            348.37, &
            400.4, &
            455.6, &
            529.3, &
            592.0, &
            657.0, &
            750.0, &
            809.0, &
            3658.0, &
            3946.0 /)
         
         ! 18 Ar
         ip(18,1:18) = (/ &
            15.759, &
            27.629, &
            40.74, &
            59.81, &
            75.04, &
            91.01, &
            124.4, &
            143.45, &
            422.6, &
            478.9, &
            539.0, &
            618.0, &
            686.0, &
            756.0, &
            855.0, &
            918.0, &
            4121.0, &
            4426.0 /)
         
         ! 19 K
         ip(19,1:19) = (/ &
            4.341, &
            31.63, &
            45.72, &
            60.92, &
            82.66, &
            99.9, &
            117.7, &
            154.98, &
            175.8, &
            503.6, &
            564.4, &
            629.0, &
            714.0, &
            787.0, &
            862.0, &
            968.0, &
            1034.0, &
            4611.0, &
            4934.0 /)
         
         ! 20 Ca
         ip(20,1:20) = (/ &
            6.113, &
            11.871, &
            50.91, &
            67.15, &
            84.43, &
            108.78, &
            127.7, &
            147.4, &
            188.7, &
            211.3, &
            591.6, &
            657.0, &
            726.0, &
            817.0, &
            895.0, &
            974.0, &
            1087.0, &
            1157.0, &
            5129.0, &
            5470.0 /)
         
         ! 21 Sc
         ip(21,1:21) = (/ &
            6.54, &
            12.80, &
            24.76, &
            73.7, &
            91.7, &
            111.1, &
            138.0, &
            158.7, &
            180.2, &
            225.4, &
            249.8, &
            686.0, &
            756.0, &
            830.0, &
            927.0, &
            1009.0, &
            1094.0, &
            1213.0, &
            1288.0, &
            5675.0, &
            6034.0 /)
         
         ! 22 Ti
         ip(22,1:22) = (/ &
            6.82, &
            13.58, &
            27.49, &
            43.26, &
            99.4, &
            119.36, &
            140.8, &
            169.4, &
            193.0, &
            216.2, &
            265.3, &
            292.0, &
            788.0, &
            862.0, &
            941.0, &
            1044.0, &
            1131.0, &
            1221.0, &
            1346.0, &
            1425.0, &
            6249.0, &
            6626.0 /)
         
         ! 23 V
         ip(23,1:23) = (/ &
            6.74, &
            14.65, &
            29.31, &
            46.71, &
            65.23, &
            128.6, &
            150.3, &
            173.6, &
            205.8, &
            230.5, &
            255.1, &
            308.0, &
            336.0, &
            896.0, &
            975.0, &
            1060.0, &
            1168.0, &
            1260.0, &
            1355.0, &
            1486.0, &
            1569.0, &
            6851.0, &
            7246.0 /)
         
         ! 24 Cr
         ip(24,1:24) = (/ &
            6.766, &
            16.50, &
            30.96, &
            49.1, &
            70.2, &
            90.57, &
            161.1, &
            184.6, &
            209.3, &
            244.4, &
            270.7, &
            298.0, &
            355.0, &
            384.0, &
            1011.0, &
            1097.0, &
            1185.0, &
            1299.0, &
            1396.0, &
            1496.0, &
            1634.0, &
            1721.0, &
            7482.0, &
            7895.0 /)
         
         ! 25 Mn
         ip(25,1:25) = (/ &
            7.435, &
            15.640, &
            33.67, &
            51.4, &
            73.0, &
            97.0, &
            119.27, &
            196.47, &
            221.8, &
            248.3, &
            286.0, &
            314.0, &
            344.0, &
            404.0, &
            435.0, &
            1136.0, &
            1224.0, &
            1317.0, &
            1437.0, &
            1539.0, &
            1644.0, &
            1788.0, &
            1879.0, &
            8141.0, &
            8572.0 /)
         
         ! 26 Fe
         ip(26,1:26) = (/ &
            7.870, &
            16.16, &
            30.651, &
            54.8, &
            75.5, &
            100.0, &
            128.3, &
            151.12, &
            235.0, &
            262.1, &
            290.4, &
            331.0, &
            361.0, &
            392.0, &
            457.0, &
            489.0, &
            1266.0, &
            1358.0, &
            1456.0, &
            1582.0, &
            1689.0, &
            1799.0, &
            1950.0, &
            2045.0, &
            8828.0, &
            9278.0 /)
         
         ! 27 Co
         ip(27,1:27) = (/ &
            7.86, &
            17.06, &
            33.50, &
            51.3, &
            79.5, &
            103.0, &
            131.0, &
            160.0, &
            186.2, &
            176.2, &
            305.0, &
            336.0, &
            379.0, &
            411.0, &
            444.0, &
            512.0, &
            547.0, &
            1402.0, &
            1500.0, &
            1602.0, &
            1734.0, &
            1846.0, &
            1962.0, &
            2119.0, &
            2218.0, &
            9544.0, &
            10030.0 /)
         
         ! 28 Ni
         ip(30,1:28) = (/ &
            7.635, &
            18.168, &
            35.17, &
            54.9, &
            75.5, &
            108.0, &
            134.0, &
            164.0, &
            193.0, &
            224.6, &
            321.0, &
            352.0, &
            384.0, &
            430.0, &
            464.0, &
            499.0, &
            571.0, &
            607.0, &
            1546.0, &
            1648.0, &
            1756.0, &
            1894.0, &
            2010.0, &
            2131.0, &
            2295.0, &
            2398.0, &
            10280.0, &
            10790.0 /)
         
         ! 29 Cu
         ip(29,1:29) = (/ &
            7.726, &
            20.292, &
            36.83, &
            55.2, &
            79.9, &
            103.0, &
            139.0, &
            167.0, &
            199.0, &
            232.0, &
            266.0, &
            369.0, &
            401.0, &
            435.0, &
            484.0, &
            520.0, &
            557.0, &
            633.0, &
            671.0, &
            1698.0, &
            1804.0, &
            1919.0, &
            2060.0, &
            2182.0, &
            2310.0, &
            2478.0, &
            2560.0, &
            11050.0, &
            1e35 /)
         
         ! 30 Zn
         ip(30,1:30) = (/ &
            9.394, &
            17.964, &
            39.72, &
            59.4, &
            82.6, &
            108.0, &
            136.0, &
            175.0, &
            203.0, &
            238.0, &
            274.0, &
            311.0, &
            412.0, &
            454.0, &
            490.0, &
            542.0, &
            579.0, &
            619.0, &
            698.0, &
            738.0, &
            1856.0, &
            1970.0, &
            2088.0, &
            2234.0, &
            2363.0, &
            2495.0, &
            2660.0, &
            2730.0, &
            1e35, &
            1e35 /)
      
      end subroutine set_ionization_potentials


      end module mod_tables

