      program test_interp
      use const_lib
      use interp_2d_lib_db
      use interp_2d_lib_sg
      use interp_2d_support
      implicit none

      call const_init

      write(*,*)      
      call TEST_RENKA790_DB
      
      !write(*,*)      
      !call TEST_RENKA790_SG

      write(*,*)      
      call TEST_AKIMA_DB
      
      !write(*,*)      
      !call TEST_AKIMA_SG
      
      write(*,*)      
      call test2D_db(.true.)
      
      write(*,*)      
      call test2D_db(.false.)
      
      write(*,*)      
      call test2D_sg(.true.)
      
      write(*,*)      
      call test2D_sg(.false.)

      write(*,*)

      contains

      subroutine test2D_db(bicub_flag)
         logical, intent(in) :: bicub_flag
         
         integer :: x_points, y_points, i, j
         double precision :: x_max, x_min, y_max, y_min, dx, dy, x, y, z, dz_dx, dz_dy, tmp(4)
         
         write(*,*) 'bicub_flag', bicub_flag
         
         x_points = 2
         y_points = 3
         x_max = 0.8*PI; x_min = 0.1
         y_max = 0.6*PI; y_min = 0.2
         dx = (x_max - x_min) / (x_points - 1)
         dy = (y_max - y_min) / (y_points - 1)

         call get_2D_test_values_db
         call setup_to_interp_2D_db(bicub_flag)
         

  1      format(5a24)
  2      format(5(1pe24.16))

         write(*,*)
         write(*,*) 'interpolant coefficients at midpoint'
         tmp(1:4) = f_db(1:4,num_xpts/2,num_ypts/2)
         write(*,'(4(1pe24.16))') tmp
         if (bicub_flag) then
            write(*,1) 'x', 'y', 'z', 'dz/dx', 'dz/dy'
         else
            write(*,1) 'x', 'y', 'z'
         end if
         
         
         do j = 1, y_points
            y = y_min + (j-1) * dy
            do i = 1, x_points
               x = x_min + (i-1) * dx
               call eval_2D_interp_db(bicub_flag,x,y,z,dz_dx,dz_dy)
               if (bicub_flag) then
                  write(*,2) x,y,z,dz_dx,dz_dy
               else
                  write(*,2) x,y,z
               end if
            end do
         end do
         
         write(*,*)

      end subroutine test2D_db
      

      subroutine test2D_sg(bicub_flag)
         logical, intent(in) :: bicub_flag
         
         integer :: x_points, y_points, i, j
         real :: x_max, x_min, y_max, y_min, dx, dy, x, y, z, dz_dx, dz_dy
         
         x_points = 2
         y_points = 3
         x_max = 0.8*pi_sg; x_min = 0.1
         y_max = 0.6*pi_sg; y_min = 0.2
         dx = (x_max - x_min) / (x_points - 1)
         dy = (y_max - y_min) / (y_points - 1)

         call get_2D_test_values_sg
         call setup_to_interp_2D_sg(bicub_flag)

  1      format(5a24)
  2      format(5(1pe24.16))        
         if (bicub_flag) then
            write(*,1) 'x', 'y', 'z', 'dz/dx', 'dz/dy'
         else
            write(*,1) 'x', 'y', 'z'
         end if
         
         do j = 1, y_points
            y = y_min + (j-1) * dy
            do i = 1, x_points
               x = x_min + (i-1) * dx
               call eval_2D_interp_sg(bicub_flag,x,y,z,dz_dx,dz_dy)
               if (bicub_flag) then
                  write(*,2) x,y,z,dz_dx,dz_dy
               else
                  write(*,2) x,y,z
               end if
            end do
         end do
         
         write(*,*)

      end subroutine test2D_sg



      end program




