! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   This file is part of MESA.
!
!   MESA is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module bipm_db

      implicit none

      contains

      
      subroutine do_mkbipm_db(x,nx,y,ny,f,nf2,ierr)
         use interp_1d_def
         use interp_1d_lib
         integer, intent(in) :: nx                        ! length of x vector
         integer, intent(in) :: ny                        ! length of y vector
         double precision, intent(in) :: x(nx)            ! x vector, strict ascending
         double precision, intent(in) :: y(ny)            ! y vector, strict ascending
         integer, intent(in) :: nf2                       ! 2nd dimension of f, nf2.ge.nx
         double precision, intent(inout) :: f(4,nf2,ny)   ! data & interpolant coefficients
         integer, intent(out) :: ierr                      ! =0 on exit if there is no error.   
         integer, parameter :: nwork = pm_work_size
         double precision :: work(nx,nwork)
         integer :: i
         ierr = 0
         do i=1,ny
            call interp_pm(x, nx, f(:,:,i), nwork, work, ierr)
            if (ierr /= 0) exit
         end do
      end subroutine do_mkbipm_db


      subroutine do_evbipm_db(xget,yget,x,nx,y,ny,fin,nf2,f,ierr)
         use num_lib, only: binary_search
         use interp_1d_def
         use interp_1d_lib
         integer, intent(in) :: nx,ny
         double precision, intent(in) :: xget,yget        ! target of this interpolation
         double precision, intent(in) :: x(nx)            ! ordered x grid
         double precision, intent(in) :: y(ny)            ! ordered y grid
         integer, intent(in) :: nf2
         double precision, intent(in) :: fin(4,nf2,ny)      ! function data
         double precision, intent(out) :: f
         integer, intent(out) :: ierr                      ! error code =0 ==> no error

         integer, parameter :: nwork = pm_work_size
         double precision :: work(4,nwork), x0,x1,dx,y0,y1,dy,alfa,beta,ddx,f1,f2
         double precision :: ys(4), ff(4,4), ynew(1), val(1)
         integer :: j, jlo, jhi, i, ix, jy, ii
         
         ierr = 0
         
         ix = binary_search(nx, 0, x, xget) ! x(ix) <= xget < x(ix+1)         
         jy = binary_search(ny, 0, y, yget) ! y(jy) <= yget < y(jy+1)

         x0 = x(ix); x1 = x(ix+1)
         y0 = y(jy); y1 = y(jy+1)
         dx = xget - x0
         dy = yget - y0
         beta = dy / (y1 - y0) ! fraction of y1 result
         alfa = 1-beta ! fraction of y0 result            
         
         ynew(1) = yget
         if (jy == 1) then
            jlo = 1;; ii = 1
         else if (jy >= ny-1) then
            jlo = jy-2; ii = 3
         else
            jlo = jy-1; ii = 2
         end if
            
         do i=1,4
            j = jlo+i-1
            ys(i) = y(j)
            ff(1,i) = fin(1,ix,j) + dx*(fin(2,ix,j) + dx*(fin(3,ix,j) + dx*fin(4,ix,j)))
         end do
      
         call interp_pm(ys, 4, ff, nwork, work, ierr) 
         if (ierr /= 0) return
      
         call interp_values(ys, 4, ff, 1, ynew, val, ierr)
         if (ierr /= 0) return

         f = val(1)

         
      end subroutine do_evbipm_db





      end module bipm_db
