      program plot_interp
      use const_lib
      use interp_1d_def
      use interp_1d_lib
      use interp_1d_support
      implicit none

      write(*, *)
      call const_init
      call Build_1d_Plots

      contains
      
      

      subroutine eval_1d_interp(nx, x, xs, f, z, dz_dx)
         integer, intent(in) :: nx
         double precision, intent(in) :: x, xs(nx), f(4, nx)
         double precision, intent(out) :: z, dz_dx
         
         double precision :: dx, ai, bi, ci, di
         integer :: ix, i
         
         ix = nx
         do i = 1, nx-1
            if (x < xs(i+1)) then
               ix = i; exit
            end if
         end do
         
         dx = x - xs(ix)
         ai = f(4, ix)
         bi = f(3, ix)
         ci = f(2, ix)
         di = f(1, ix)
         z = di + dx*(ci + dx*(bi + dx*ai))
         dz_dx = ci + 2d0*dx*(bi + 1.5d0*dx*ai)
      
      end subroutine eval_1d_interp
      
      
      subroutine write_points(nx, xpts, f, ix, dir)
         integer, intent(in) :: nx, ix
         double precision, intent(in) :: xpts(nx), f(4, nx)
         character (len=256), intent(in) :: dir
         character (len=256) :: fname
         integer, parameter :: io = 40
         integer :: i
         write(fname, '(2a, i1, a)') trim(dir), '/pts', ix, '.data'
         open(unit=io, file=trim(fname))
         do i = 1, nx
            write(io, *) xpts(i), f(1, i)
         end do
         close(io)
      end subroutine write_points
      
      
      subroutine set_widths(n, xs, w)
         integer, intent(in) :: n
         double precision, intent(in) :: xs(n)
         double precision, intent(out) :: w(n)
         integer :: k
         do k=1, n-1
            w(k) = xs(k+1)-xs(k)
         end do
         w(n) = 1
      end subroutine set_widths


      subroutine Build_1d_Plots

         integer :: io_first, io_last, io_xs, io, x_points, i, ierr
         double precision :: x_max, x_min, dx, x, z1, dz1_dx, z2, dz2_dx
         double precision :: z3, dz3_dx, z4, dz4_dx, z5, dz5_dx, z6, dz6_dx
         character (len=256) :: dir
         
         integer, parameter :: nx = 11
         double precision :: xpts1(nx), f1_mp(4, nx), f1_pm(4, nx), widths(nx)
         double precision :: xpts2(nx), f2_mp(4, nx), f2_pm(4, nx)
         double precision :: xpts3(nx), f3_mp(4, nx), f3_pm(4, nx)
         double precision :: xpts4(nx), f4_mp(4, nx), f4_pm(4, nx)
         double precision :: xpts5(nx), f5_mp(4, nx), f5_pm(4, nx)
         double precision :: xpts6(nx), f6_mp(4, nx), f6_pm(4, nx)
         integer, parameter :: nwork = max(pm_work_size, mp_work_size)
         double precision :: work(nx, nwork)
         
         xpts1(1:nx) = (/ 0e0,  1e0,  2e0,   3e0,   4e0,   5e0,   6e0,    7e0,    8e0,    9e0,   10e0 /)
         f1_mp(1, 1:nx) = (/ 4e0,   3.7e0,  1e0,   1e0,   3e0,   2.8e0,   5e0,   5e0,    5e0,    1e0,    3.5e0 /)
         
         xpts2(1:nx) = (/    0d0, 1d0, 3d0, 4d0, 5d0, 6d0, 7d0, 8d0, 8.5d0, 9d0, 10d0 /)
         f2_mp(1, 1:nx) = (/  0d0, 4d0, 5d0, 3.5d0,  5d0,   0d0,   0d0, -2d0, -3d0, 4d0,  3d0 /)
         
         xpts3(1:nx) = (/    0e0, 1e0,   2.5e0,  3e0, 4e0, 5.5e0,  6e0, 7e0, 8.5e0,  9e0, 10e0 /)
         f3_mp(1, 1:nx) = (/  -1e0, 2e0,   7e0,   -1e0, 2e0,   7e0, -1e0, 2e0,   7e0, -1e0, 2e0 /)
         
         xpts4(1:nx) = (/    0e0,  1e0,  2e0,   3e0,   4e0,   5e0,  6e0, 7e0,  8e0, 9e0,   10e0 /)
         f4_mp(1, 1:nx) = (/  0d0, 1d0, 9d0, 16d0, 21d0, 24d0, 21d0, 16d0, 9d0, 1d0, 0d0 /)
         
         xpts6(1:nx) = (/    0e0,  1e0,  2e0,   3e0,   4e0,   5e0,  6e0, 7e0,  8e0, 9e0,   10e0 /)
         f6_mp(1, 1:nx) = (/  0.26, 0.25, 0.23, 0.17, 0.11, 0.09, 0.11, 0.24, 0.36, 0.37, 0.29 /)

         do i = 1, nx
            xpts5(i) = i-1
            f5_mp(1, i) = exp(-(-4.55+DBLE(i-1))**2)
         end do
         
         f1_pm(1, 1:nx) = f1_mp(1, 1:nx)
         f2_pm(1, 1:nx) = f2_mp(1, 1:nx)
         f3_pm(1, 1:nx) = f3_mp(1, 1:nx)
         f4_pm(1, 1:nx) = f4_mp(1, 1:nx)
         f5_pm(1, 1:nx) = f5_mp(1, 1:nx)
         f6_pm(1, 1:nx) = f6_mp(1, 1:nx)

         call interp_m3q_on_uniform_grid(1d0, nx, f1_mp, nwork, work, ierr)
         !call interp_m3q(xpts1, nx, f1_mp, nwork, work, ierr)
         
         call interp_m3q(xpts2, nx, f2_mp, nwork, work, ierr)
         call interp_m3q(xpts3, nx, f3_mp, nwork, work, ierr)
         
         call interp_m3q_on_uniform_grid(1d0, nx, f4_mp, nwork, work, ierr)
         !call interp_m3q(xpts4, nx, f4_mp, nwork, work, ierr)
         
         call interp_m3q(xpts5, nx, f5_mp, nwork, work, ierr)

         call interp_pm_on_uniform_grid(1d0, nx, f1_pm, nwork, work, ierr)
         !call interp_pm(xpts1, nx, f1_pm, nwork, work, ierr)
         call interp_pm(xpts2, nx, f2_pm, nwork, work, ierr)
         call interp_pm(xpts3, nx, f3_pm, nwork, work, ierr)
         call interp_pm_on_uniform_grid(1d0, nx, f4_pm, nwork, work, ierr)
         !call interp_pm(xpts4, nx, f4_pm, nwork, work, ierr)
         call interp_pm(xpts5, nx, f5_pm, nwork, work, ierr)
         call interp_pm(xpts6, nx, f6_pm, nwork, work, ierr)

         
         x_max = 10; x_min = 0
         x_points = 1001
         dx = (x_max - x_min) / (x_points - 1)
         
         dir = 'plot_data'
         
         call write_points(nx, xpts1, f1_mp, 1, dir)
         call write_points(nx, xpts2, f2_mp, 2, dir)
         call write_points(nx, xpts3, f3_mp, 3, dir)
         call write_points(nx, xpts4, f4_mp, 4, dir)
         call write_points(nx, xpts5, f5_mp, 5, dir)
         call write_points(nx, xpts6, f6_mp, 6, dir)
         
         io_xs = 40
         io_first = io_xs + 1
         call Open_1d_Outfiles(io_first, io_last, io_xs, dir)
         
         do i = 1, x_points
            x = x_min + (i-1) * dx
            write(io_xs, *) x
            
            call eval_1d_interp(nx, x, xpts1, f1_mp, z1, dz1_dx)
            call eval_1d_interp(nx, x, xpts2, f2_mp, z2, dz2_dx)
            call eval_1d_interp(nx, x, xpts3, f3_mp, z3, dz3_dx)
            call eval_1d_interp(nx, x, xpts4, f4_mp, z4, dz4_dx)
            call eval_1d_interp(nx, x, xpts5, f5_mp, z5, dz5_dx)
            call eval_1d_interp(nx, x, xpts6, f6_mp, z6, dz6_dx)
            
            io = io_first
            write(io, *) z1; io = io + 1
            write(io, *) dz1_dx; io = io + 1
            write(io, *) z2; io = io + 1
            write(io, *) dz2_dx; io = io + 1
            write(io, *) z3; io = io + 1
            write(io, *) dz3_dx; io = io + 1
            write(io, *) z4; io = io + 1
            write(io, *) dz4_dx; io = io + 1
            write(io, *) z5; io = io + 1
            write(io, *) dz5_dx; io = io + 1
            write(io, *) z6; io = io + 1
            write(io, *) dz6_dx; io = io + 1
            
            call eval_1d_interp(nx, x, xpts1, f1_pm, z1, dz1_dx)
            call eval_1d_interp(nx, x, xpts2, f2_pm, z2, dz2_dx)
            call eval_1d_interp(nx, x, xpts3, f3_pm, z3, dz3_dx)
            call eval_1d_interp(nx, x, xpts4, f4_pm, z4, dz4_dx)
            call eval_1d_interp(nx, x, xpts5, f5_pm, z5, dz5_dx)
            call eval_1d_interp(nx, x, xpts6, f6_pm, z6, dz6_dx)

            write(io, *) z1; io = io + 1
            write(io, *) dz1_dx; io = io + 1
            write(io, *) z2; io = io + 1
            write(io, *) dz2_dx; io = io + 1
            write(io, *) z3; io = io + 1
            write(io, *) dz3_dx; io = io + 1
            write(io, *) z4; io = io + 1
            write(io, *) dz4_dx; io = io + 1
            write(io, *) z5; io = io + 1
            write(io, *) dz5_dx; io = io + 1
            write(io, *) z6; io = io + 1
            write(io, *) dz6_dx; io = io + 1
            
         end do
         
         close(io_xs)
         do io = io_first, io_last
            close(io)
         end do
         
         write(*, *) 'done creating 1D plot data files -- in plot_data'

         
      end subroutine Build_1d_Plots 
      
      
      subroutine Open_1d_Outfiles(io_first, io_last, io_xs, dir)
         integer, intent(in) :: io_first, io_xs
         integer, intent(out) :: io_last
         character (len=256), intent(in) :: dir
         character (len=256) :: fname
         integer :: io
         
         fname = trim(dir) // '/arg.data'
         open(unit=io_xs, file=trim(fname))
         
         io = io_first-1

         fname = trim(dir) // '/f1.mp_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/df1_dx.mp_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/f2.mp_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/df2_dx.mp_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/f3.mp_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/df3_dx.mp_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/f4.mp_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/df4_dx.mp_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/f5.mp_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/df5_dx.mp_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/f6.mp_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/df6_dx.mp_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/f1.pm_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/df1_dx.pm_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/f2.pm_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/df2_dx.pm_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/f3.pm_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/df3_dx.pm_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/f4.pm_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/df4_dx.pm_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/f5.pm_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/df5_dx.pm_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/f6.pm_data'
         io = io+1; open(unit=io, file=trim(fname))

         fname = trim(dir) // '/df6_dx.pm_data'
         io = io+1; open(unit=io, file=trim(fname))
            
         io_last = io
      
      end subroutine Open_1d_Outfiles
      

      end program




