      module plot_eosPT
      
      use eos_def
      use eos_lib
      use const_def
      use chem_def
      use num_lib,only:safe_log10
      use utils_lib, only: is_bad_num
      use eos_support
      
      implicit none

      
      contains
      
      
      subroutine Build_PT_Plots

         character (len=256) :: dir
      
         double precision logT_min, logT_max, logPgas_min, logPgas_max, dlogT,
     >      dlogPgas, logPgas, logT, Pgas, T
      
         integer logT_points, logPgas_points
         integer i,j,k,info, io,io_first,io_last,io_params, io_pgas, io_tmp, num_vals

         integer, parameter :: io_unit0 = 40
      
         double precision :: X, Zinit, dXC, dXO, Y, Z

         double precision, allocatable :: output_values(:,:,:)
         
         include 'formats.dek'

   !..composition

         ! Carbon
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.0d0
         dXC = 1.00d0

         ! Oxygen
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 1.0d0
         dXC = 0.00d0

         ! 3:1 H:He
         Zinit = 0.04d0
         dXO = 0.0d0
         dXC = 0.00d0
         X = 0.75d0*(1 - (Zinit+dXO+dXC))

         ! C/O even
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.50d0
         dXC = 0.50d0

         ! opal data
         X = 0.60d0
         Zinit = 0.02d0
         dXO = 0.00d0
         dXC = 0.00d0

         ! Hydrogen
         Zinit = 0.00d0
         dXO = 0.0d0
         dXC = 0.00d0
         X = 1.00d0

         ! Helium
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.0d0
         dXC = 0.00d0

         ! solar
         X = 0.70d0
         Zinit = 0.02d0
         dXO = 0.00d0
         dXC = 0.00d0

         ! test
         X = 0.00d0
         Zinit = 1.0d0
         dXO = 0.00d0
         dXC = 0.00d0

         ! test
         X = 0.50d0
         Zinit = 0.00d0
         dXO = 0.00d0
         dXC = 0.00d0

   !..set the sample size
         logT_points = 200
         logPgas_points = 200
            
   !..set the ranges

	      logT_max = 5.5
	      logT_min = 2.5
	      logPgas_min = -5
	      logPgas_max = 2.0
            
   !..open the output files
         io_params = io_unit0
         io_pgas = io_unit0+1
         io_tmp = io_unit0+2
         io_first = io_unit0+3

         dir = 'plot_data_PT'
         call Open_Plot_Outfiles(io_first, io_last, io_params, io_pgas, io_tmp, dir)
         write(io_params, '(4(f10.6),2(i7))') Zinit, X, dXC, dXO, logPgas_points, logT_points
         close(io_params)
         num_vals  = io_last - io_first + 1
         allocate(output_values(logPgas_points,logT_points,num_vals))
   
         Z = Zinit + dXC + dXO
         call Init_Composition(X, Zinit, dXC, dXO)
         
         write(*,1) 'X', X
         write(*,1) 'Z', Z
         write(*,1) 'abar', abar
         write(*,1) 'zbar', zbar
         
   !..get the results

         dlogT = (logT_max - logT_min)/(logT_points-1)
         dlogPgas = (logPgas_max - logPgas_min)/(logPgas_points-1)
   
         eos_ht% with_coulomb_corrections = .true.

         do j=1, logT_points
            logT = logT_min + dlogT*(j-1)
            T = 10 ** logT
            do i=1,logPgas_points
               logPgas = logPgas_min + dlogPgas*(i-1)
               Pgas = 10**logPgas
               call Plot_one(i, j, 
     >            logT, T, logPgas, Pgas, output_values, Z, X, abar, zbar, 
     >            num_vals, logPgas_points, logT_points, info)
            end do
         end do
   
         write(*,*) 'write PT files'
         do k = 1, num_vals
            write(*,*) k
            write(io_first+k-1,'(e24.16)') output_values(1:logPgas_points,1:logT_points,k)
         end do

         do i = 1, logT_points
            logT = logT_min + dlogT*(i-1)
            write(io_tmp,*) logT
         end do
         close(io_tmp)
      
         do j=1,logPgas_points
            logPgas = logPgas_min + dlogPgas*(j-1)
            write(io_pgas,*) logPgas
         end do
         close(io_pgas)
   
         do io=io_first,io_last
            close(io)
         end do
   
         deallocate(output_values)

         call Shutdown_eos

      end subroutine Build_PT_Plots


      subroutine Plot_one(i, j, 
     >      logT, T, logPgas, Pgas, output_values, Z, X, abar, zbar, 
     >      num_vals, lgPgas_points, logT_points, info)
         integer, intent(in) :: i, j, num_vals, lgPgas_points, logT_points
         double precision, intent(in) :: logT, T, logPgas, Pgas, Z, X, abar, zbar
         double precision, intent(out) :: output_values(lgPgas_points,logT_points,num_vals)
         integer, intent(out) :: info

         double precision :: plasg, lg_OpalR, time0, time1, energy, S, Prad, P
         double precision :: theta_e, d_theta_e_deta, Rho, logRho, dlnRho_dlnPgas, dlnRho_dlnT
         double precision, dimension(num_eos_basic_results) :: res, d_dlnd, d_dlnT
         double precision, dimension(num_helm_results) :: helm_res
         integer :: k, ierr
         
         include 'formats.dek'
                     
         ierr = 0
          
         call eosPT_get(
     >         handle, Z, X, abar, zbar, 
     >         species, chem_id, net_iso, xa,
     >         Pgas, logPgas, T, logT, 
     >         Rho, logRho, dlnRho_dlnPgas, dlnRho_dlnT, 
     >         res, d_dlnd, d_dlnT, ierr)
         if (ierr /= 0) then
            write(*,1) 'eosPT_get failed logPgas, logT', logPgas, logT
            stop 1
         end if
         
         plasg = Plasma_Coupling_Parameter(T, Rho, abar, zbar)

         if (ierr == 0) then

            k = 0
            k = k+1; output_values(i,j,k) = logRho

            Prad = crad*T**4/3
            P = Pgas + Prad
            
            k = k+1; output_values(i,j,k) = log10(P)
            k = k+1; output_values(i,j,k) = res(i_lnE)/ln10
            k = k+1; output_values(i,j,k) = res(i_lnS)/ln10

            k = k+1; output_values(i,j,k) = res(i_grad_ad)
            k = k+1; output_values(i,j,k) = d_dlnT(i_grad_ad)
            k = k+1; output_values(i,j,k) = d_dlnd(i_grad_ad)

            k = k+1; output_values(i,j,k) = safe_log10(res(i_cv))
            k = k+1; output_values(i,j,k) = safe_log10(res(i_cp))
            k = k+1; output_values(i,j,k) = res(i_chiRho)
            k = k+1; output_values(i,j,k) = res(i_chiT)

            k = k+1; output_values(i,j,k) = res(i_gamma1)
            k = k+1; output_values(i,j,k) = res(i_gamma3)
            k = k+1; output_values(i,j,k) = res(i_eta)
            k = k+1; output_values(i,j,k) = plasg
            
            energy = exp(res(i_lnE))
            S = exp(res(i_lnS))
            
            if (is_bad_num(S) .or. S <= 0 .or. is_bad_num(energy) .or. energy <= 0) then
               write(*,1) 'Z', Z
               write(*,1) 'X', X
               write(*,1) 'abar', abar
               write(*,1) 'zbar', zbar
               write(*,1) 'logRho', logPgas
               write(*,1) 'logT', logT
               write(*,1) 'S', S
               write(*,1) 'energy', energy
               write(*,*)
               stop 'plotter'
            end if
            
            k = k+1; output_values(i,j,k) = res(i_Cv) * T / energy
            k = k+1; output_values(i,j,k) = res(i_dE_dRho) * Rho / energy
            k = k+1; output_values(i,j,k) = res(i_dS_dT) * T / S
            k = k+1; output_values(i,j,k) = res(i_dS_dRho) * Rho / S
            k = k+1; output_values(i,j,k) = res(i_lnfree_e)/ln10
         
         end if
         
         info = ierr

      end subroutine Plot_one
      
      
      subroutine Open_Plot_Outfiles(io_first, io_last, io_params, io_pgas, io_tmp, dir)
         integer, intent(IN) :: io_first, io_params, io_pgas, io_tmp
         integer, intent(OUT) :: io_last
         character (len=256), intent(IN) :: dir
         character (len=256) :: fname
         integer :: io
         
         fname = trim(dir) // '/params.data'
         open(unit=io_params,file=trim(fname))
         
         fname = trim(dir) // '/logPgas.data'
         open(unit=io_pgas,file=trim(fname))
         
         fname = trim(dir) // '/logT.data'
         open(unit=io_tmp,file=trim(fname))
         
         io = io_first-1
         
         fname = trim(dir) // '/logRho.data'
         io = io+1; open(unit=io,file=trim(fname))  
         fname = trim(dir) // '/logP.data'
         io = io+1; open(unit=io,file=trim(fname))  
         fname = trim(dir) // '/logE.data'
         io = io+1; open(unit=io,file=trim(fname))          
         fname = trim(dir) // '/logS.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/grad_ad.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/d_grad_ad_dlnT.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/d_grad_ad_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/log_cv.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/log_cp.data'
         io = io+1; open(unit=io,file=trim(fname))
                    
         fname = trim(dir) // '/chiRho.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/chiT.data'
         io = io+1; open(unit=io,file=trim(fname))            

         fname = trim(dir) // '/gamma1.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/gamma3.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         fname = trim(dir) // '/eta.data'
         io = io+1; open(unit=io,file=trim(fname))            
         fname = trim(dir) // '/plasg.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dlnE_dlnT.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/dlnE_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))
                     
         fname = trim(dir) // '/dlnS_dlnT.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/dlnS_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         fname = trim(dir) // '/log_free_e.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         io_last = io
      
      end subroutine Open_Plot_Outfiles


         
      
      end module plot_eosPT

