      module plot_eosDT
      use eos_def
      use eos_lib
      use const_def
      use chem_def
      use num_lib,only:safe_log10
      use utils_lib, only: is_bad_num
      use eos_support
      
      implicit none

      
      contains
      
      
      subroutine Build_DT_Plots

         character (len=256) :: dir
      
         double precision lgT_min,lgT_max,lgRho_min,lgRho_max,dlgT,
     >      dlgRho,lgRho,lgT,Rho,T
      
         integer lgT_points, lgRho_points, time0, time1, clock_rate
         integer i,j,k,info, io,io_first,io_last,io_params,io_rho,io_tmp,num_vals

         integer, parameter :: io_unit0 = 40
      
         double precision :: X, Zinit, dXC, dXO, Y, Z, Z_all_HELM,
     >      logRho1_OPAL_SCVH_limit, logRho2_OPAL_SCVH_limit

         double precision, allocatable :: output_values(:,:,:)
         
         include 'formats.dek'
         
   !..composition

         ! Carbon
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.0d0
         dXC = 1.00d0

         ! 3:1 H:He
         Zinit = 0.04d0
         dXO = 0.0d0
         dXC = 0.00d0
         X = 0.75d0*(1 - (Zinit+dXO+dXC))

         ! opal data
         X = 0.60d0
         Zinit = 0.02d0
         dXO = 0.00d0
         dXC = 0.00d0

         ! 1:2 C/O 
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.670d0
         dXC = 0.33d0

         ! Oxygen
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 1.0d0
         dXC = 0.00d0

         ! C/O even
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.50d0
         dXC = 0.50d0

         ! test for he accretion
         X = 0.00d0
         Zinit = 4.6592940035459218d-02
         dXO = 0.00d0
         dXC = 0.00d0

         ! Hydrogen
         Zinit = 0.00d0
         dXO = 0.0d0
         dXC = 0.00d0
         X = 1.00d0

         ! Helium
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.0d0
         dXC = 0.00d0

         ! He/C/O
         X = 0.00d0
         Zinit = 0.00d0
         dXO = 0.10d0
         dXC = 0.05d0

         ! solar
         X = 0.70d0
         Zinit = 0.02d0
         dXO = 0.00d0
         dXC = 0.00d0

         ! test
         X = 0.0d0
         Zinit = 1d0
         dXO = 0.00d0
         dXC = 0.00d0


   !..set the sample size
            lgT_points = 300
            lgRho_points = 300
            
            lgT_points = 100
            lgRho_points = 100
            
            !lgT_points = 2
            !lgRho_points = 2
            
   !..set the ranges

         ! almost-full range for helm
         lgT_max = 10d0
         lgT_min = 3.5d0
         lgRho_min = -11d0
         lgRho_max = 14d0

	      ! check free_e
	      lgT_max = 7.9
	      lgT_min = 2.1
	      lgRho_min = -10.5d0
	      lgRho_max = 8d0

         ! for profile plots
         lgT_max = 10.1d0
         lgT_min = 1.9d0
         lgRho_min = -11.5d0
         lgRho_max = 11.5d0

         ! almost-full range for helm
         lgT_max = 10d0
         lgT_min = 3.5d0
         lgRho_min = -11d0
         lgRho_max = 14d0
	      	      
         ! mesa table full range plus some
	      lgT_max = 10.1
	      lgT_min = 2.0
	      lgRho_min = -14.1d0
	      lgRho_max = 11.1d0

         ! full range for helm
         lgT_max = 13d0
         lgT_min = 3d0
         lgRho_min = -11d0
         lgRho_max = 14d0

	      	      
         ! mesa table for instrument paper
	      lgT_max = 10.3
	      lgT_min = 2.3
	      lgRho_min = -10.1d0
	      lgRho_max = 11.1d0
	      	      
	      ! check opal/scvh
	      lgT_max = 7.7d0
	      lgT_min = 2.0d0
	      lgRho_min = -5d0
	      lgRho_max = 5.5d0

			! subtest -- for opal-scvh problem area
	      lgT_max = 3.9d0
	      lgT_min = 3.5d0
	      lgRho_min = -7d0
	      lgRho_max = -4d0
	      
	      
	      ! test
	      lgT_max = 9.8d0
	      lgT_min = 8.5d0
	      lgRho_max = 7d0
	      lgRho_min = -4d0
	      
   
      write(*,*) lgRho_min, lgRho_max
            
   !..open the output files
         io_params = io_unit0
         io_rho = io_unit0+1
         io_tmp = io_unit0+2
         io_first = io_unit0+3

         dir = 'plot_data_DT'
         call Open_Plot_Outfiles(io_first, io_last, io_params, io_rho, io_tmp, dir)
         write(io_params, '(4(f10.6),2(i7))') Zinit, X, dXC, dXO, lgRho_points, lgT_points
         close(io_params)
         num_vals  = io_last - io_first + 1
         allocate(output_values(lgRho_points,lgT_points,num_vals))
   
         Z = Zinit + dXC + dXO
         call Init_Composition(X, Zinit, dXC, dXO)
         !write(*,*) 'change abar and zbar for plots'
         !abar = 13.334
         !zbar = 6.667

         write(*,*) 'Z', Z
         write(*,*) 'X', X
         write(*,*) 'abar', abar
         write(*,*) 'zbar', zbar
         
         if (.false.) then
            logRho1_OPAL_SCVH_limit = 3.1d0 ! don't use OPAL_SCVH for logRho > this
            logRho2_OPAL_SCVH_limit = 3.0d0 ! full OPAL_SCVH okay for logRho < this
            call eos_set_logRhos_OPAL_SCVH(handle, logRho1_OPAL_SCVH_limit, logRho2_OPAL_SCVH_limit, info)
            write(*,1) 'logRho1_OPAL_SCVH_limit', logRho1_OPAL_SCVH_limit
            write(*,1) 'logRho2_OPAL_SCVH_limit', logRho2_OPAL_SCVH_limit 
            if (info /= 0) stop 'call eos_set_logRhos_OPAL_SCVH'
         end if
         
         Z_all_HELM = 1.0001
         write(*,1) 'Z_all_HELM', Z_all_HELM
         call eos_set_Z_all_HELM(handle, Z_all_HELM, info)
         if (info /= 0) stop 'call eos_set_Z_all_HELM'
         
   !..get the results

         dlgT = (lgT_max - lgT_min)/(lgT_points-1)
         dlgRho = (lgRho_max - lgRho_min)/(lgRho_points-1)
   
         eos_ht% with_coulomb_corrections = .true.

         call system_clock(time0,clock_rate)     
!x $OMP PARALLEL DO PRIVATE(i,j,lgT,T,lgRho,Rho)
         do j=1, lgT_points
            lgT = lgT_min + dlgT*(j-1)
            T = 10 ** lgT
            do i=1,lgRho_points
               lgRho = lgRho_min + dlgRho*(i-1)
               Rho = 10 ** lgRho
               call Plot_one(i, j, lgT, T, lgRho, Rho, output_values, Z, X, abar, zbar, 
     >            num_vals, lgRho_points, lgT_points, info)
            end do
         end do
!x $OMP END PARALLEL DO
         call system_clock(time1,clock_rate)
         write(*,'(a,f10.6)') ' seconds creating plot data', dble(time1 - time0) / clock_rate
   
         write(*,*) 'write DT files'
!x $OMP PARALLEL DO PRIVATE(k)
         do k = 1, num_vals
            write(*,*) k
            
            write(io_first+k-1,'(e24.16)') output_values(1:lgRho_points,1:lgT_points,k)
         end do
!x $OMP END PARALLEL DO

         do i = 1, lgT_points
            lgT = lgT_min + dlgT*(i-1)
            write(io_tmp,*) lgT
         end do
         close(io_tmp)
      
         do j=1,lgRho_points
            lgRho = lgRho_min + dlgRho*(j-1)
            write(io_rho,*) lgRho
         end do
         close(io_rho)
   
         do io=io_first,io_last
            close(io)
         end do
   
         deallocate(output_values)

         call Shutdown_eos

      end subroutine Build_DT_Plots


      subroutine Plot_one(i, j, lgT, T, lgRho, Rho, output_values, Z, X, abar, zbar, 
     >      num_vals, lgRho_points, lgT_points, info)
         integer, intent(in) :: i, j, num_vals, lgRho_points, lgT_points
         double precision, intent(in) :: lgT, T, lgRho, Rho, Z, X, abar, zbar
         double precision, intent(out) :: output_values(lgRho_points,lgT_points,num_vals)
         integer, intent(out) :: info

         double precision :: plasg, lg_OpalR, time0, time1, energy, S, Prad, P, dse, dpe, dsp
         double precision :: dlgT_dlgRho, theta_e, d_theta_e_deta, Pgas, rho_guess_error, rho_guess
         double precision, dimension(num_eos_basic_results) :: res, d_dlnd, d_dlnT
         double precision, dimension(num_eos_basic_results) :: res_pc, d_dlnd_pc, d_dlnT_pc
         double precision, dimension(num_eos_basic_results) :: res_helm, d_dlnd_helm, d_dlnT_helm
         double precision, dimension(num_helm_results) :: helm_res 
         integer :: k, ierr
         
         logical, parameter :: basic_flag = .false.
         logical, parameter :: OpalR_flag = .false.
         
         logical, parameter :: PC_flag = .false.
         logical, parameter :: HELM_flag = .false.
         logical, parameter :: standard_flag = .true.
         
         double precision, parameter :: min_lg_OpalR = -14d0, max_lg_OpalR = 14d0
         
         include 'formats.dek'
                     
         ierr = 0
         
         if (PC_flag) then
            call eos_eval_PC(
     >         handle, Z, X, abar, zbar, 
     >         species, chem_id, net_iso, xa,
     >         Rho, lgRho, T, lgT, 
     >         res_pc, d_dlnd_pc, d_dlnT_pc, ierr)
            res = res_pc
            d_dlnd = d_dlnd_pc
            d_dlnT = d_dlnT_pc
         end if
         
         if (HELM_flag) then
            call eos_get_helm_results(
     >         handle, Z, X, abar, zbar, Rho, lgRho, T, lgT, helm_res, ierr)
            call eos_convert_helm_results(
     >         helm_res, Z, X, abar, zbar, Rho, T, .false., res_helm, 
     >         d_dlnd_helm, d_dlnT_helm, ierr) 
            res = res_helm
            d_dlnd = d_dlnd_helm
            d_dlnT = d_dlnT_helm
         end if
         
         if (standard_flag) then
            call eosDT_get(
     >         handle, Z, X, abar, zbar, 
     >         species, chem_id, net_iso, xa,
     >         Rho, lgRho, T, lgT, 
     >         res, d_dlnd, d_dlnT, ierr)
         end if
         
         if (ierr /= 0) then
            write(*,1) 'failed lgRho, lgT', lgRho, lgT
            stop
         end if
         
         call cpu_time(time1)
         plasg = Plasma_Coupling_Parameter(T, Rho, abar, zbar)

         if (ierr == 0) then

            k = 0
            if (is_bad_num(res(i_lnPgas))) then
               write(*,1) 'lgRho', lgRho
               write(*,1) 'lgT', lgT
               write(*,1) 'res(i_lnPgas)', res(i_lnPgas)
               write(*,*)
               res(i_lnPgas) = -99*ln10
            end if
            Pgas = exp(res(i_lnPgas))
            Prad = crad*T**4/3d0
            P = Pgas + Prad
            k = k+1; output_values(i,j,k) = safe_log10(P)
            k = k+1; output_values(i,j,k) = res(i_lnE)/ln10
            k = k+1; output_values(i,j,k) = res(i_lnS)/ln10
            
            if (.true.) then
               k = k+1; output_values(i,j,k) = res(i_grad_ad)
            else
               k = k+1; output_values(i,j,k) = (res_helm(i_grad_ad) - res_pc(i_grad_ad))/res_pc(i_grad_ad)
            end if
            
            if (is_bad_num(res(i_lnE))) then
               write(*,1) 'lgRho', lgRho
               write(*,1) 'lgT', lgT
               write(*,1) 'Z', Z
               write(*,1) 'X', X
               write(*,1) 'abar', abar
               write(*,1) 'zbar', zbar
               write(*,1) 'lnE', res(i_lnE)
               write(*,*)
               stop
            end if
            
            k = k+1; output_values(i,j,k) = d_dlnT(i_grad_ad)
            k = k+1; output_values(i,j,k) = d_dlnd(i_grad_ad)

            k = k+1; output_values(i,j,k) = safe_log10(res(i_cv))
            k = k+1; output_values(i,j,k) = safe_log10(res(i_cp))
            k = k+1; output_values(i,j,k) = res(i_chiRho)
            k = k+1; output_values(i,j,k) = res(i_chiT)
            k = k+1; output_values(i,j,k) = res(i_chiRho)/res(i_chiT)

            k = k+1; output_values(i,j,k) = res(i_gamma1)
            k = k+1; output_values(i,j,k) = res(i_gamma3)
            k = k+1; output_values(i,j,k) = res(i_eta)
            k = k+1; output_values(i,j,k) = d_dlnd(i_eta)
            k = k+1; output_values(i,j,k) = 1 / max(1d-99,d_dlnd(i_eta))

            k = k+1; output_values(i,j,k) = plasg
            
            energy = exp(res(i_lnE))
            S = exp(res(i_lnS))
            
            if (is_bad_num(S)) then
               write(*,1) 'Z', Z
               write(*,1) 'X', X
               write(*,1) 'abar', abar
               write(*,1) 'zbar', zbar
               write(*,1) 'logRho', lgRho
               write(*,1) 'logT', lgT
               write(*,1) 'S', S
               write(*,*)
               stop 'plotter'
            end if
            
            k = k+1; output_values(i,j,k) = res(i_Cv) * T / energy
            k = k+1; output_values(i,j,k) = res(i_dE_dRho) * Rho / energy
            k = k+1; output_values(i,j,k) = res(i_dS_dT) * T / S
            k = k+1; output_values(i,j,k) = res(i_dS_dRho) * Rho / S
            k = k+1; output_values(i,j,k) = eos_theta_e(res(i_eta), d_theta_e_deta)

            k = k+1; output_values(i,j,k) = res(i_lnfree_e)/ln10
            
            k = k+1; output_values(i,j,k) = res(i_lnPgas)/ln10
            k = k+1; output_values(i,j,k) = d_dlnd(i_lnPgas)
            
            dse = T*res(i_dS_dT)/res(i_Cv) - 1d0
            dpe = Rho**2*res(i_dE_dRho)/P + res(i_chiT) - 1d0
            dsp = -Rho**2*res(i_dS_dRho)/(res(i_chiT)*P/T) - 1d0

            k = k+1; output_values(i,j,k) = dse
            k = k+1; output_values(i,j,k) = dpe
            k = k+1; output_values(i,j,k) = dsp

            k = k+1; output_values(i,j,k) = res(i_lnPgas)/ln10 - 4*lgT
         
         end if
         
         info = ierr

      end subroutine Plot_one
      
      
      subroutine Open_Plot_Outfiles(io_first, io_last, io_params, io_rho, io_tmp, dir)
         integer, intent(IN) :: io_first, io_params, io_rho, io_tmp
         integer, intent(OUT) :: io_last
         character (len=256), intent(IN) :: dir
         character (len=256) :: fname
         integer :: io
         
         fname = trim(dir) // '/params.data'
         open(unit=io_params,file=trim(fname))
         
         fname = trim(dir) // '/logRho.data'
         open(unit=io_rho,file=trim(fname))
         
         fname = trim(dir) // '/logT.data'
         open(unit=io_tmp,file=trim(fname))
         
         io = io_first-1
         fname = trim(dir) // '/logP.data'
         io = io+1; open(unit=io,file=trim(fname))  
         fname = trim(dir) // '/logE.data'
         io = io+1; open(unit=io,file=trim(fname))          
         fname = trim(dir) // '/logS.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/grad_ad.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/d_grad_ad_dlnT.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/d_grad_ad_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/log_cv.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/log_cp.data'
         io = io+1; open(unit=io,file=trim(fname))            
         fname = trim(dir) // '/chiRho.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/chiT.data'
         io = io+1; open(unit=io,file=trim(fname))            
         fname = trim(dir) // '/chiRho_div_chiT.data'
         io = io+1; open(unit=io,file=trim(fname))            

         fname = trim(dir) // '/gamma1.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/gamma3.data'
         io = io+1; open(unit=io,file=trim(fname))
         fname = trim(dir) // '/eta.data'
         io = io+1; open(unit=io,file=trim(fname))            
         fname = trim(dir) // '/d_eta_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))            
         fname = trim(dir) // '/d_lnd_d_eta.data'
         io = io+1; open(unit=io,file=trim(fname))            

         fname = trim(dir) // '/plasg.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dlnE_dlnT.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dlnE_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))
                     
         fname = trim(dir) // '/dlnS_dlnT.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         fname = trim(dir) // '/dlnS_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         fname = trim(dir) // '/theta_e.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         fname = trim(dir) // '/log_free_e.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         fname = trim(dir) // '/logPgas.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dlnPgas_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dse.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dpe.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dsp.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/logW.data'
         io = io+1; open(unit=io,file=trim(fname))
         
         io_last = io
      
      end subroutine Open_Plot_Outfiles


         
      
      end module plot_eosDT

