   # eosPT.rb

   load "../../utils/image_plot.rb"

   class Eos_data < Image_data

      attr_accessor :x, :z, :dXC, :dXO

      attr_accessor :logP, :logRho, :logE, :logS
      attr_accessor :grad_ad, :d_grad_ad_dlnT, :d_grad_ad_dlnRho
      attr_accessor :dlnP_dH1, :dlnP_dHe4, :dlnP_dN14
      attr_accessor :chiRho, :d_chiRho_dlnT, :d_chiRho_dlnRho
      attr_accessor :chiT, :d_chiT_dlnT, :d_chiT_dlnRho
      attr_accessor :log_cp, :dlncp_dlnT, :dlncp_dlnRho
      attr_accessor :dlnE_dlnT, :dlnE_dlnRho, :d_dlnE_dlnRho_dlnT, :d_dlnE_dlnRho_dlnRho
      attr_accessor :d_free_e_dlnT, :d_free_e_dlnRho, :free_e
      attr_accessor :mu, :d_mu_dlnT, :d_mu_dlnRho
      attr_accessor :eta, :d_eta_dlnT, :d_eta_dlnRho, :d_lnd_d_eta
      attr_accessor :plasg, :runtime, :theta_e, :log_free_e
      attr_accessor :log_cv, :dlncv_dlnT, :dlncv_dlnRho
      attr_accessor :dlnS_dlnT, :d_dlnS_dlnT_dlnT, :d_dlnS_dlnT_dlnRho
      attr_accessor :dlnS_dlnRho, :d_dlnS_dlnRho_dlnT, :d_dlnS_dlnRho_dlnRho
      attr_accessor :gamma1, :gamma3

      def initialize(data_dir, fyi)

         params = Dvector.read_row(data_dir + '/params.data')
         @z = params[0]
         @x = params[1]
         @dXC = params[2]
         @dXO = params[3]
         puts "z=#{@z}  x=#{@x}"

         read_image_Xs(data_dir, 'logPgas.data', 'log Pgas')
         read_image_Ys(data_dir, 'logT.data', 'log T')

         @logRho = read_image_data(data_dir, 'logRho')
         @logP = read_image_data(data_dir, 'logP')
         @logE = read_image_data(data_dir, 'logE')
         @logS = read_image_data(data_dir, 'logS')

         @grad_ad = read_image_data(data_dir, 'grad_ad')
         @d_grad_ad_dlnT = read_image_data(data_dir, 'd_grad_ad_dlnT')
         @d_grad_ad_dlnRho = read_image_data(data_dir, 'd_grad_ad_dlnRho')

         @log_cv = read_image_data(data_dir, 'log_cv')
         @log_cp = read_image_data(data_dir, 'log_cp')

         @chiRho = read_image_data(data_dir, 'chiRho')
         @chiT = read_image_data(data_dir, 'chiT')

         @gamma1 = read_image_data(data_dir, 'gamma1')
         @gamma3 = read_image_data(data_dir, 'gamma3')

         @eta = read_image_data(data_dir, 'eta')

         @dlnS_dlnT = read_image_data(data_dir, 'dlnS_dlnT')
         @dlnS_dlnRho = read_image_data(data_dir, 'dlnS_dlnRho')
         @dlnE_dlnT = read_image_data(data_dir, 'dlnE_dlnT')
         @dlnE_dlnRho = read_image_data(data_dir, 'dlnE_dlnRho')

         @log_free_e = read_image_data(data_dir, 'log_free_e')

      end

   end # class Eos_data


   class Eos_plot

   include Math
   include Tioga
   include FigureConstants
   include Image_plot

   class Profile_data

      attr_accessor :mass, :radius, :density, :temperature, :pgas, :energy
      attr_accessor :logRho, :logT, :logPgas, :logE

      def initialize(filename)

         ar = [
            @mass = Dvector.new,
            @radius = Dvector.new,
            @density = Dvector.new,
            @temperature = Dvector.new,
            @pgas = Dvector.new,
            @energy = Dvector.new
         ]
         Dvector.read(filename, ar, 4) # data starts on line 4

         @logRho = @density.safe_log10
         @logT = @temperature.safe_log10
         @logPgas = @pgas.safe_log10
         @logE = @energy.safe_log10

      end

   end

   class Ranges_data

      attr_accessor :log_T, :log_P

      def initialize(filename)
         Dvector.read(filename, [
         @log_T = Dvector.new,
         @log_P = Dvector.new
         ])
      end

   end

   class SCVHdata

      attr_accessor :log_rho_min, :log_rho_max, :log_T

      def initialize(filename)
         Dvector.read(filename, [@log_T = Dvector.new, 
         @log_rho_min = Dvector.new, @log_rho_max = Dvector.new])
      end

   end

   class OPALdata

      attr_accessor :log_rho, :log_Tmin, :log_Tmax

      def initialize(filename)
         Dvector.read(filename, [@log_rho = Dvector.new, 
         t6_min = Dvector.new, t6_max = Dvector.new])
         @log_Tmin = t6_min.mul(1e6).safe_log10
         @log_Tmax = t6_max.mul(1e6).safe_log10
      end

   end

   def initialize(data_dir)

      @data_dir = data_dir
      @figure_maker = FigureMaker.default
      t.def_eval_function { |str| eval(str) }
      t.save_dir = 'plot_out'

      t.def_figure('logRho') { logRho }
      t.def_figure('logP') { logP }
      t.def_figure('logE') { logE }
      t.def_figure('logS') { logS }

      t.def_figure('grad_ad') { grad_ad }
      t.def_figure('d_grad_ad_dlnT') { d_grad_ad_dlnT }
      t.def_figure('d_grad_ad_dlnRho') { d_grad_ad_dlnRho }

      t.def_figure('log_cv') { log_cv }
      t.def_figure('log_cp') { log_cp }
      t.def_figure('chiRho') { chiRho }
      t.def_figure('chiT') { chiT }

      t.def_figure('gamma1') { gamma1 }                     
      t.def_figure('gamma3') { gamma3 }

      t.def_figure('log_free_e') { log_free_e }

      t.def_figure('eta') { eta }

      t.def_figure('dlnE_dlnT') { dlnE_dlnT }
      t.def_figure('dlnE_dlnRho') { dlnE_dlnRho }
      t.def_figure('dlnS_dlnT') { dlnS_dlnT }        
      t.def_figure('dlnS_dlnRho') { dlnS_dlnRho }        



      fyi = '../zams_fyi/'

      @test_150_0 = Profile_data.new(fyi +'zams_150.00_plot.data')
      @test_100_0 = Profile_data.new(fyi +'zams_100.00_plot.data')
      @test_10_0 = Profile_data.new(fyi +'zams_10.00_plot.data')
      @test_1_0 = Profile_data.new(fyi +'zams_1.00_plot.data')
      @test_0_1 = Profile_data.new(fyi +'zams_0.10_plot.data')
      @test_0_01 = Profile_data.new(fyi +'zams_0.01_plot.data')
      @test_0_001 = Profile_data.new(fyi +'zams_0.001_plot.data')

      @image_data = Eos_data.new(data_dir, fyi)
      @label_scale = 0.75


      @no_clipping = false #true        

      t.def_enter_page_function { enter_page }    
   end

   def enter_page
      t.yaxis_numeric_label_angle = -90
      t.page_setup(11*72/2,8.5*72/2)
      t.set_frame_sides(0.15,0.85,0.85,0.15) # left, right, top, bottom in page coords  
   end


   def clip_image
      return if @no_clipping == true
      t.move_to_point(0, 4.5)
      #t.append_point_to_path(15,8.2)
      t.append_point_to_path(26,9.9)
      t.append_point_to_path(30,9.9)
      t.append_point_to_path(30, 6)
      t.append_point_to_path(17, 5)
      t.append_point_to_path(5, 2)
      t.append_point_to_path(0, 2)
      t.close_path
      t.clip
   end


   def t
      @figure_maker
   end

   def d
      @image_data
   end

   # EoS plotting methods


   def logOpalR_line(logOpalR)
      logT1 = 3
      logRho1 = logOpalR + 3 * logT1 - 18
      logT2 = 11
      logRho2 = logOpalR + 3 * logT2 - 18
      t.line_width = 4
      t.line_color = Indigo
      puts "#{logOpalR} #{logRho1} #{logT1} #{logRho2} #{logT2}"
      t.stroke_line(logRho1, logT1, logRho2, logT2)
   end

   def do_decorations(title)
      #return
      #logOpalR_line(14)
      #logOpalR_line(-14)
      dx = 3*t.default_text_height_dx
      dy = 0.4*t.default_text_height_dy
      t.line_width = 0.75
      t.stroke_color = BrightBlue
      t.line_type = Line_Type_Solid
      star_clr = Black
      return if @helm_only
      add_test_line(@test_0_001.logPgas, @test_0_001.logT, '$0.001 M_{\odot}$', 1.6*dx, -2*dy)
      add_test_line(@test_0_01.logPgas, @test_0_01.logT, '$0.01 M_{\odot}$', 1.6*dx, -2*dy)
      add_test_line(@test_0_1.logPgas, @test_0_1.logT, '$0.1 M_{\odot}$', dx, dy, star_clr)
      add_test_line(@test_1_0.logPgas, @test_1_0.logT, '$1.0 M_{\odot}$', dx, dy, star_clr)
      add_test_line(@test_10_0.logPgas, @test_10_0.logT, '$10.0 M_{\odot}$', dx, dy, star_clr)
      add_test_line(@test_150_0.logPgas, @test_150_0.logT, 
         '$150 M_{\odot}$', -2*dx, 2*dy, star_clr)
   end

   def add_test_line(xs, ys, txt, dx, dy, clr = Black)
      t.append_points_to_path(xs, ys)
      t.stroke_color = clr
      t.stroke
      #t.show_marker('marker' => Circle, 'Xs' => xs, 'Ys' => ys, 'scale' => 0.3, 'color' => Teal)
      return if txt == nil
      t.show_label('text' => txt, 'x' => xs[0] - 0.2*dx, 'y' => ys[0] - 0.5*dy,
         'color' => clr,
         'scale' => @label_scale, 
         'justification' => CENTERED, 
         'alignment' => ALIGNED_AT_MIDHEIGHT)
   end 

   def show_params(pos = 0.5, shift = 4)
      if d.z >= 0.01
         txt = sprintf('X=%4.2f Zinit=%4.2f', d.x, d.z)
      elsif d.z >= 0.001
         txt = sprintf('X=%4.2f Zinit=%5.3f', d.x, d.z)
      else
         txt = sprintf('X=%4.2f Zinit=%6.4f', d.x, d.z)
      end
      t.show_text('text' => txt, 'side' => BOTTOM, 'pos' => pos, 
      'shift' => shift, 'scale' => 0.8, 'justification' => CENTERED)
   end


   # plot routines


   def logRho
      image_plot('d' => d, 'zs' => d.logRho, 'title' => 'LogRho',
         'z_lower' => nil, 'z_upper' => nil)
         #'z_lower' => -14, 'z_upper' => 25)
   end


   def logP
      image_plot('d' => d, 'zs' => d.logP, 'title' => 'LogP',
         #'z_lower' => nil, 'z_upper' => nil)
         'z_lower' => -1, 'z_upper' => 25)
   end

   def logE
      image_plot('d' => d, 'zs' => d.logE, 'title' => 'logE',
         #'z_lower' => nil, 'z_upper' => nil)
         'z_lower' => 10, 'z_upper' => 19)
   end

   def logS
      image_plot('d' => d, 'zs' => d.logS, 'title' => 'logS',  
         'z_lower' => 6.5, 'z_upper' => 11.5)
   end

   def grad_ad
      image_plot('d' => d, 'zs' => d.grad_ad, 'title' => '$\nabla$ adiabatic', 
         'z_lower' => nil, 'z_upper' => nil)
         #'z_lower' => 0.01, 'z_upper' => 0.47)
   end

   def d_grad_ad_dlnT
      z_lower = -1.8; z_upper = 1.8
      image_plot('d' => d, 'zs' => d.d_grad_ad_dlnT, 'title' => 'd_grad_ad_dlnT', 
         'z_lower' => z_lower, 'z_upper' => z_upper)
   end

   def d_grad_ad_dlnRho
      z_lower = -0.3; z_upper = 0.3
      image_plot('d' => d, 'zs' => d.d_grad_ad_dlnRho, 'title' => 'd_grad_ad_dlnRho', 
         'z_lower' => z_lower, 'z_upper' => z_upper)
   end

   def log_cv
      image_plot('d' => d, 'zs' => d.log_cv, 'title' => 'log_cv',
         'z_lower' => 7, 'z_upper' => 12)
   end

   def log_cp
      image_plot('d' => d, 'zs' => d.log_cp, 'title' => 'log_cp', 
         'z_lower' => 7, 'z_upper' => 15)
   end

   def chiRho
      image_plot('d' => d, 'zs' => d.chiRho, 'title' => 'chiRho', 
         'z_lower' => 0, 'z_upper' => 2.5)
   end

   def chiT
      image_plot('d' => d, 'zs' => d.chiT, 'title' => 'chiT', 
         'z_lower' => 0, 'z_upper' => 5)
   end

   def gamma1
      image_plot('d' => d, 'zs' => d.gamma1, 'title' => 'gamma1', 
         'z_lower' => 0.2, 'z_upper' => 2.9)
   end

   def gamma3
      image_plot('d' => d, 'zs' => d.gamma3, 'title' => 'gamma3',
      'z_lower' => 1.0, 'z_upper' => 1.9)
   end

   def log_free_e
      image_plot('d' => d, 'zs' => d.log_free_e, 'title' => 'log_free_e',
         'z_lower' => -20, 'z_upper' => 0.5)
   end

   def eta        
      image_plot('d' => d, 'zs' => d.eta, 'title' => 'eta', 
         'z_lower' => -100, 'z_upper' => 100)
   end

   def dlnE_dlnT
      image_plot('d' => d, 'zs' => d.dlnE_dlnT, 'title' => 'dlnE_dlnT')
   end

   def dlnE_dlnRho
      image_plot('d' => d, 'zs' => d.dlnE_dlnRho, 'title' => 'dlnE_dlnRho',
         'z_lower' => -2, 'z_upper' => 1.2)
   end

   def dlnS_dlnT
      image_plot('d' => d, 'zs' => d.dlnS_dlnT, 'title' => 'dlnS_dlnT', 
         'z_lower' => 0, 'z_upper' => 2)
   end

   def dlnS_dlnRho
      image_plot('d' => d, 'zs' => d.dlnS_dlnRho, 'title' => 'dlnS_dlnRho', 
         'z_lower' => -1,  'z_upper' => 0)
   end

   def logPgas
      image_plot('d' => d, 'zs' => d.logPgas, 'title' => 'logPgas',  
         'z_lower' => -1, 'z_upper' => 25)
   end

   def dlnPgas_dlnRho
      image_plot('d' => d, 'zs' => d.dlnPgas_dlnRho, 'title' => 'dlnPgas dlnRho',  
         'z_lower' => 0.05, 'z_upper' => 2.5)
   end

   end

   Eos_plot.new('plot_data_PT')
