! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
!
! ***********************************************************************

      module eos_initialize
      implicit none

      contains


      subroutine get_result_names(names)
         use eos_def
         character (len=8) :: names(num_eos_basic_results)
         names(i_lnPgas) = 'lnPgas'  
         names(i_lnE) = 'lnE' ! internal energy per gram
         names(i_lnS) = 'lnS' ! entropy per gram
         names(i_grad_ad) = 'grad_ad' ! dlnT_dlnP at constant S
         names(i_chiRho) = 'chiRho' ! dlnP_dlnRho at constant T      
         names(i_chiT) = 'chiT' ! dlnP_dlnT at constant Rho      
         names(i_Cp) = 'Cp' ! dE_dT at constant P, specific heat at constant pressure     
         names(i_Cv) = 'Cv' ! dE_dT at constant Rho, specific heat at constant volume
         names(i_dE_dRho) = 'dE_dRho' ! at constant T      
         names(i_dS_dT) = 'dS_dT' ! at constant Rho      
         names(i_dS_dRho) = 'dS_dRho'  ! at constant T      
         names(i_mu) = 'mu'  
         names(i_lnfree_e) = 'lnfree_e'       
         names(i_gamma1) = 'gamma1'  ! dlnP_dlnRho at constant S      
         names(i_gamma3) = 'gamma3'  ! gamma3 - 1) = '' dlnT_dlnRho at constant S            
         names(i_eta) = 'eta'  
      end subroutine get_result_names
            
      
      subroutine Init_eos(data_dir, eos_file_prefix, use_cache, ierr)
         use eos_def
         use helm_alloc
         use alert_lib, only: alert
         use eosDT_load_tables, only : eosDT_file_prefix
         use eosPT_load_tables, only : eosPT_file_prefix
         use eosDT_eval, only : theta_e_interp_init
         character(*), intent(IN) :: data_dir, eos_file_prefix
         logical, intent(in) :: use_cache
         integer, intent(OUT) :: ierr ! 0 means AOK.
         
         integer, parameter :: imax = 261, jmax = 101  ! dimensions of our version of helm table
         
         ! helm table lives in eosDT_data
         character (len=256) :: eosDT_data_dir
         
         if (eos_root_is_initialized) return
         
         eosDT_data_dir = trim(data_dir) // '/eosDT_data'

         ierr = 0
         
         call alloc_helm_table(eos_ht, imax, jmax, ierr)
         if (ierr /= 0) then
            call alert(ierr, 'alloc_helm_table failed')
            return
         end if

         call read_helm_table(eos_ht, eosDT_data_dir, ierr)
         if (ierr /= 0) then
            call alert(ierr, 'read_helm_table failed')
            return
         end if

         call eos_def_init
         ! replace defaults from eos_def_init by argument
         eosDT_file_prefix = eos_file_prefix
         eosPT_file_prefix = eos_file_prefix
         
         call theta_e_interp_init(ierr)
         if (ierr /= 0) then
            call alert(ierr, 'theta_e_interp_init failed')
            return
         end if
         
         eos_root_is_initialized = .true.
         use_cache_for_eos = use_cache
         data_dir_for_eos = data_dir
      
      end subroutine Init_eos
      
      
      end module eos_initialize
