! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   This file is part of MESA.
!
!   MESA is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module make_SCVH_plots
      
		use eos_def
		use eos_lib
		use const_def
		use alert_lib
		use chem_def
		use num_lib, only: safe_log10
		use scvh_core
		use helm_opal_scvh_driver, only: get_azbar, setup_eos, data_dir
		
      implicit none

      
      contains
      

      
      subroutine make_SCVH_plot_files
         use utils_lib, only: is_bad_num
         use scvh_core, only: interp_vals, setup_scvh
         
         integer :: which_eos, logT_points, logP_points, io_params, io_logP, io_logT, &
            io_first, io_last, io, num_vals, j, i, k, ierr
         double precision, pointer :: output_values(:,:,:)
         double precision :: &
            X, Z, abar, zbar, logT_max, logT_min, logP_min, logP_max, dlogT, dlogP, &
            logT, T, logPgas, Pgas, logP, logRho, Prad, P
         character (len=256) :: dir
         logical :: only_densities, search_for_SCVH, build_big_tables
         double precision :: &
            compv1_hhe,compv2_hhe,den_hhe,d_den_hhe_dlogP,d_den_hhe_dlogT, &
            ener_hhe,entr_hhe,dddt_cp_hhe,dddp_ct_hhe,dsdt_cp_hhe,dsdp_ct_hhe,dtdp_cs_hhe, &
            compv1_h,compv2_h,den_h,d_den_h_dlogP,d_den_h_dlogT, &
            ener_h,entr_h,dddt_cp_h,dddp_ct_h,dsdt_cp_h,dsdp_ct_h,dtdp_cs_h, &
            compv1_he,compv2_he,den_he,d_den_he_dlogP,d_den_he_dlogT, &
            d_compv1_dlogP, &
            d_compv1_dlogT, &
            d_compv2_dlogP, &
            d_compv2_dlogT, &
            ener_he,entr_he,dddt_cp_he,dddp_ct_he,dsdt_cp_he,dsdp_ct_he,dtdp_cs_he, &
            xnh,dxnh_dlogT,dxnh_dlogP, &
            xnh2,dxnh2_dlogT,dxnh2_dlogP, &
            xnhe,dxnhe_dlogT,dxnhe_dlogP, &
            xnhep,dxnhep_dlogT,dxnhep_dlogP, &
            dpdd, dsdd, dpdt, dedd, dsdt, dedt, &
            xmassh1,xmasshe4,logNe,gamma3,gamma1,grad_ad, &
            dsdd_hhe, dpdt_hhe, dedt_hhe, dsdt_hhe
         double precision, dimension(:,:), pointer :: &
            compv1, &
            compv2, &
            denlog, &
            slog, &
            ulog, &
            dddt_tab, &
            dddp_tab, &
            dsdt_tab, &
            dsdp_tab, &
            dtdp_tab
	      integer, parameter :: io_unit0 = 40
         
         include 'formats.dek'
         
         write(*,*) 'make_SCVH_files'
         
         
         build_big_tables = .false.
         
	      
	      call setup_eos
         
         X = 1d0  ! 0.00d0, 0.20d0, 0.40d0, 0.60d0, 0.80d0
         Z = 1 - X
         

         call get_azbar(X, Z, abar, zbar)
                  
         logT_points = 250
         logP_points = 400
         
	      logT_max = 7d0
	      logT_min = 2.2d0
	      logP_min = 0d0
	      logP_max = 19d0
         
	      logT_max = 4.6d0
	      logT_min = 2.1d0
	      logP_min = -0.6d0
	      logP_max = 8d0
         
	      logT_max = 3.6d0
	      logT_min = 3.4d0
	      logP_min = 11.1d0
	      logP_max = 12.9d0
         
	      logT_max = 5.6d0
	      logT_min = 2.1d0
	      logP_min = 4.5d0
	      logP_max = 15d0
	      
	      
	      
	      if (build_big_tables) then ! full size, high resolution
	         dlogP = 0.05d0
	         dlogT = 0.02d0
	         logP_min = -0.60d0! - 10*dlogP
	         logP_max = 19d0! + 10*dlogP
	         logP_points = (logP_max - logP_min)/dlogP + 1
	         logT_min = 2.10d0! - 10*dlogT
	         logT_max = 7.06d0! + 10*dlogT
	         logT_points = (logT_max - logT_min)/dlogT + 1
	         write(*,*) 'logP_points', logP_points
	         write(*,*) 'logT_points', logT_points
	         allocate( &
               compv1(logP_points,logT_points), &
               compv2(logP_points,logT_points), &
               denlog(logP_points,logT_points), &
               slog(logP_points,logT_points), &
               ulog(logP_points,logT_points), &
               dddt_tab(logP_points,logT_points), &
               dddp_tab(logP_points,logT_points), &
               dsdt_tab(logP_points,logT_points), &
               dsdp_tab(logP_points,logT_points), &
               dtdp_tab(logP_points,logT_points))
	      end if
	      
         
         if (.false.) then ! TESTING
            X = 1
            Z = 0
            logT_points = 2
            logP_points = 2
   	      logT_max = 6.0201d0
   	      logT_min = 6.02d0
   	      logP_min = 0.00d0
   	      logP_max = 0.001d0
	      end if
	      
	      
	      
	      

	      io_params = io_unit0
	      io_logP = io_unit0+1
	      io_logT = io_unit0+2
	      io_first = io_unit0+3
	      
	      dir = 'plot_SCVH_data'
	      
	      write(*,*) 'output to ' // trim(dir)

         call Open_Plot_Outfiles(io_first, io_last, io_params, io_logP, io_logT, dir)
         write(io_params, '(2(f10.6),2(i7))') Z, X, logP_points, logT_points
         close(io_params)
			num_vals  = io_last - io_first + 1
			allocate(output_values(logP_points,logT_points,num_vals))
			
	      dlogT = (logT_max - logT_min)/(logT_points-1)
	      dlogP = (logP_max - logP_min)/(logP_points-1)

	      xmassh1 = X
	      xmasshe4 = 1-xmassh1
         only_densities = .false.
         search_for_SCVH = .false.

         call setup_scvh(data_dir)
      
         do j=1, logT_points
            logT = logT_min + dlogT*(j-1)
            T = 10 ** logT

		      do i=1,logP_points
		         logP = logP_min + dlogP*(i-1)
		         P = 10**logP
               
               call interp_vals(only_densities, search_for_SCVH, &
                  den_h,d_den_h_dlogP,d_den_h_dlogT, &
                  ener_h,entr_h,dddt_cp_h,dddp_ct_h,dsdt_cp_h,dsdp_ct_h,dtdp_cs_h, &
                  den_he,d_den_he_dlogP,d_den_he_dlogT, &
                  ener_he,entr_he,dddt_cp_he,dddp_ct_he,dsdt_cp_he,dsdp_ct_he,dtdp_cs_he, &
                  xnh,dxnh_dlogT,dxnh_dlogP, &
                  xnh2,dxnh2_dlogT,dxnh2_dlogP, &
                  xnhe,dxnhe_dlogT,dxnhe_dlogP, &
                  xnhep,dxnhep_dlogT,dxnhep_dlogP, &
                  logT,logP,P,ierr)			      
			      if (ierr /= 0) stop 'failed in interp_vals'
			      
			      if (X == 1) then !  pure h
   			      compv1_hhe = xnh2
                  d_compv1_dlogP = dxnh2_dlogP
                  d_compv1_dlogT = dxnh2_dlogT
   			      compv2_hhe = xnh
                  d_compv2_dlogP = dxnh_dlogP
                  d_compv2_dlogT = dxnh_dlogT
   			      den_hhe = den_h
   			      ener_hhe = ener_h
   			      entr_hhe = entr_h
   			      dddt_cp_hhe = dddt_cp_h
   			      dddp_ct_hhe = dddp_ct_h
   			      dsdt_cp_hhe = dsdt_cp_h
   			      dsdp_ct_hhe = dsdp_ct_h
   			      dtdp_cs_hhe = dtdp_cs_h
   			   else if (X == 0) then ! pure he
   			      compv1_hhe = xnhe
                  d_compv1_dlogP = dxnhe_dlogP
                  d_compv1_dlogT = dxnhe_dlogT
   			      compv2_hhe = xnhep
                  d_compv2_dlogP = dxnhep_dlogP
                  d_compv2_dlogT = dxnhep_dlogT
   			      den_hhe = den_he
   			      ener_hhe = ener_he
   			      entr_hhe = entr_he
   			      dddt_cp_hhe = dddt_cp_he
   			      dddp_ct_hhe = dddp_ct_he
   			      dsdt_cp_hhe = dsdt_cp_he
   			      dsdp_ct_hhe = dsdp_ct_he
   			      dtdp_cs_hhe = dtdp_cs_he
   			   else
   			      write(*,*) 'only doing X = 0 or X = 1'
   			   end if
			      
			      call check_num(compv1_hhe)
			      call check_num(d_compv1_dlogP)
			      call check_num(d_compv1_dlogT)
			      call check_num(compv2_hhe)
			      call check_num(d_compv2_dlogP)
			      call check_num(d_compv2_dlogT)
			      call check_num(den_hhe)
			      call check_num(ener_hhe)
			      call check_num(entr_hhe)
			      call check_num(dddt_cp_hhe)
			      call check_num(dddp_ct_hhe)
			      call check_num(dsdt_cp_hhe)
			      call check_num(dsdp_ct_hhe)
			      call check_num(dtdp_cs_hhe)

			      k = 0
			      k = k+1; output_values(i,j,k) = safe_log10(den_hhe)
			      k = k+1; output_values(i,j,k) = safe_log10(ener_hhe)
			      k = k+1; output_values(i,j,k) = safe_log10(entr_hhe)
			      k = k+1; output_values(i,j,k) = dddt_cp_hhe
			      k = k+1; output_values(i,j,k) = dddp_ct_hhe
			      k = k+1; output_values(i,j,k) = dsdt_cp_hhe
			      k = k+1; output_values(i,j,k) = dsdp_ct_hhe
			      k = k+1; output_values(i,j,k) = dtdp_cs_hhe
			      k = k+1; output_values(i,j,k) = compv1_hhe
			      k = k+1; output_values(i,j,k) = d_compv1_dlogP
			      k = k+1; output_values(i,j,k) = d_compv1_dlogT
			      k = k+1; output_values(i,j,k) = compv2_hhe
			      k = k+1; output_values(i,j,k) = d_compv2_dlogP
			      k = k+1; output_values(i,j,k) = d_compv2_dlogT
			      
			      dsdd_hhe = dddt_cp_hhe/(den_hhe*den_hhe*dddp_ct_hhe)
			      dpdt_hhe = -den_hhe*den_hhe*dsdd_hhe
               dsdt_hhe = dsdp_ct_hhe * dpdt_hhe + dsdt_cp_hhe
			      dedt_hhe = T * dsdt_hhe
			      
			      gamma3 = 1 + dpdt_hhe / (den_hhe * dedt_hhe)
			      k = k+1; output_values(i,j,k) = gamma3
               grad_ad = dtdp_cs_hhe!*P/T
			      k = k+1; output_values(i,j,k) = grad_ad
               gamma1 = (gamma3 - 1) / grad_ad
			      k = k+1; output_values(i,j,k) = gamma1

			      k = k+1; output_values(i,j,k) = safe_log10(den_hhe) - 2*logT + 12 ! logQ

			      k = k+1; output_values(i,j,k) = logP - 4*logT ! logW




			      k = k+1; output_values(i,j,k) = eval_grad_ad_alt(logT,logP,X)

			      
			      if (build_big_tables) then
                  compv1(i,j) = compv1_hhe
                  compv2(i,j) = compv2_hhe
                  denlog(i,j) = safe_log10(den_hhe)
                  slog(i,j) = safe_log10(entr_hhe)
                  ulog(i,j) = safe_log10(ener_hhe)
                  dddt_tab(i,j) = dddt_cp_hhe
                  dddp_tab(i,j) = dddp_ct_hhe
                  dsdt_tab(i,j) = dsdt_cp_hhe
                  dsdp_tab(i,j) = dsdp_ct_hhe
                  dtdp_tab(i,j) = dtdp_cs_hhe
               end if
            
	         enddo
         
	      enddo
	
!$OMP PARALLEL DO PRIVATE(k)
			do k = 1, num_vals
				write(*,*) k
				write(io_first+k-1,'(e14.6)') output_values(1:logP_points,1:logT_points,k)
			end do
!$OMP END PARALLEL DO

			do i = 1, logT_points
            logT = logT_min + dlogT*(i-1)
            write(io_logT,*) logT
			end do
	      close(io_logT)
      
	      do j=1,logP_points
	         logP = logP_min + dlogP*(j-1)
	         write(io_logP,*) logP
			end do
	      close(io_logP)
	
	      do io=io_first,io_last
	         close(io)
	      end do
	      
	      !if (build_big_tables) call write_big_tables
	
			deallocate(output_values)
			
			contains
			
			subroutine check_num(x)
			   double precision, intent(inout) :: x
			   if (is_bad_num(x)) x = 0
			end subroutine check_num
      
			subroutine show_stuff
			   include 'formats.dek'
            write(*,1) 'T', T
            write(*,1) 'logT', logT
            write(*,1) 'P', P
            write(*,1) 'logP', logP

            write(*,*)
			end subroutine show_stuff
			
			subroutine write_big_tables
            character (len=256) :: fname
            integer :: io
            io = io_first
            fname = 'big_tables.data'
            open(unit=io,file=trim(fname))
            write(*,*) 'write ' // trim(fname)
            do j=1, logT_points
               logT = logT_min + dlogT*(j-1)
               write(io,'(f5.2,i4)') logT, logP_points
   		      do i=1,logP_points
   		         logP = logP_min + dlogP*(i-1)
   		         write(io,'(f6.2,2(1pe17.8),8(0pf14.8))') &
   		            logP, &
                     compv1(i,j), &
                     compv2(i,j), &
                     denlog(i,j), &
                     slog(i,j), &
                     ulog(i,j), &
                     dddt_tab(i,j), &
                     dddp_tab(i,j), &
                     dsdt_tab(i,j), &
                     dsdp_tab(i,j), &
                     dtdp_tab(i,j)
   		      end do
   		   end do
   		   close(io)
			end subroutine write_big_tables

      end subroutine make_SCVH_plot_files


      subroutine Open_Plot_Outfiles(io_first, io_last, io_params, io_logP, io_logT, dir)
         integer, intent(in) :: io_first, io_params, io_logP, io_logT
         integer, intent(out) :: io_last
         character (len=*), intent(in) :: dir
         character (len=256) :: fname
         integer :: io
         
         fname = trim(dir) // '/params.data'
         open(unit=io_params,file=trim(fname))
         
         fname = trim(dir) // '/logP.data'
         open(unit=io_logP,file=trim(fname))
         
         fname = trim(dir) // '/logT.data'
         open(unit=io_logT,file=trim(fname))
         
         io = io_first-1

         fname = trim(dir) // '/log_den_hhe.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/log_ener_hhe.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/log_entr_hhe.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dddt_cp_hhe.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dddp_ct_hhe.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dsdt_cp_hhe.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dsdp_ct_hhe.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dtdp_cs_hhe.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/compv1_hhe.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/d_compv1_dlogP.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/d_compv1_dlogT.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/compv2_hhe.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/d_compv2_dlogP.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/d_compv2_dlogT.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/gamma3.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/grad_ad.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/gamma1.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/logQ.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/logW.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/grad_ad_alt.data'
         io = io+1; open(unit=io,file=trim(fname))

         io_last = io
      
      end subroutine Open_Plot_Outfiles
		
      
      real*8 function eval_grad_ad_alt(logT,logP,X)
         real*8 :: logT,logP,X
         real*8 :: X_H2,X_H,x_He,x_Hep,rho,s,u,drho_dt,drho_dp,ds_dt,ds_dp,grada
         integer :: i_err
         include 'formats.dek'
         i_err = 0
         call macdonald_scvh_eos (logT,logP,x,X_H2,X_H,x_He,x_Hep,rho,s,u, &
                          drho_dt,drho_dp,ds_dt,ds_dp,grada,i_err)
         if (i_err /= 0) then ! happens when off table
            eval_grad_ad_alt = -1
            !write(*,1) 'eval_grad_ad_alt failed', logP, logT, X
         end if
         eval_grad_ad_alt = grada
      end function eval_grad_ad_alt

      end module make_SCVH_plots
