! ***********************************************************************
!
!   Copyright (C) 2009  Bill Paxton
!
!   This file is part of MESA.
!
!   MESA is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module make_QTplots
      
		use eos_def
		use eos_lib
		use const_def
		use alert_lib
		use chem_def
		use num_lib, only: safe_log10
		use helm_opal_scvh_driver
		
      implicit none
      

		logical, parameter :: helm_only = .false.
		logical, parameter :: opal_scvh_only = .false.
		logical, parameter :: opal_only = .false.
		logical, parameter :: scvh_only = .false.
		
		logical, parameter :: search_for_SCVH = .true.
		
		logical, parameter :: include_radiation = .true.

      
      contains
      
      
      subroutine Do_QT_Test
         use utils_lib, only: is_bad_num
         use const_lib
         
         integer :: ierr
         double precision :: &
            X, Z, abar, zbar, logT, T, logPgas, logRho, logQ, &
            Rho, logE, logS, chiRho, chiT, &
            Cp, Cv, dE_dRho, dS_dT, dS_dRho, &
            mu, free_e, gamma1, gamma3, grad_ad, eta, Prad, Pgas, P
         character (len=256) :: dir
	      integer, parameter :: io_unit0 = 40
         
         include 'formats.dek'
         
	      write(*,*) 'Do_Test'
		      
         call const_init
	      
	      call setup_eos

         ierr = 0
         
         X = 0.98d0  ! 0.00d0, 0.20d0, 0.40d0, 0.60d0, 0.80d0
         Z = 0.02d0

         call get_azbar(X, Z, abar, zbar)
         
         !logT = 4.3d0
         !T = 10**logT
                  
		   T = 5250d0
         logT = log10(T)
         
         !logRho = -4d0
         !Rho = 10**logRho
         
         Rho = 2.3713736d-08
         logRho = log10(Rho)
         
         logQ = logRho - 2*logT + 12
		         
	      
         call helm_opal_scvh( &
               helm_only, opal_scvh_only, opal_only, scvh_only, search_for_SCVH, &
					include_radiation, logT, logRho, T, Rho, abar, zbar, X, Z, &
               logPgas, logE, logS, chiRho, chiT, Cp, Cv, dE_dRho, dS_dT, dS_dRho, &
               mu, free_e, gamma1, gamma3, grad_ad, eta, &
               data_dir, ierr)
	      
         write(*,1) 'T', T
         write(*,1) 'logT', logT
         write(*,1) 'Rho', Rho
         write(*,1) 'logRho', logRho
         write(*,1) 'abar', abar
         write(*,1) 'zbar', zbar
         write(*,1) 'X', X
         write(*,1) 'Z', Z
         write(*,1) 'logQ', logQ
         write(*,*)
         
         Prad = crad*T**4/3
         Pgas = 10**logPgas
         P = Pgas + Prad
         
         write(*,1) 'P', P
         write(*,1) 'logP', log10(P)
         write(*,1) 'Pgas', Pgas
         write(*,1) 'logPgas', logPgas
         write(*,1) 'logE', logE
         write(*,1) 'logS', logS
         write(*,1) 'grad_ad', grad_ad
         write(*,1) 'chiRho', chiRho
         write(*,1) 'chiT', chiT
         write(*,1) 'Cp', Cp
         write(*,1) 'Cv', Cv
         write(*,1) 'dE_dRho', dE_dRho
         write(*,1) 'dS_dT', dS_dT
         write(*,1) 'dS_dRho', dS_dRho
         write(*,1) 'mu', mu
         write(*,1) 'lnfree_e', log(free_e)
         write(*,1) 'gamma1', gamma1
         write(*,1) 'gamma3', gamma3
         write(*,1) 'eta', eta

         write(*,*)
         stop 'Do_Test'
			      
      
      end subroutine Do_QT_Test

      
      subroutine make_QTplot_files
         use utils_lib, only: is_bad_num
         
         integer :: which_eos, logT_points, logQ_points, io_params, io_logQ, io_logT, &
            io_first, io_last, io, num_vals, j, i, k, ierr
         double precision, pointer :: output_values(:,:,:)
         double precision :: &
            X, Z, abar, zbar, logT_max, logT_min, logQ_min, logQ_max, dlogT, dlogQ, &
            logT, T, logPgas, Pgas, logQ, logRho, Prad, P, &
            Rho, logE, logS, chiRho, chiT, &
            Cp, Cv, dE_dRho, dS_dT, dS_dRho, &
            mu, free_e, gamma1, gamma3, grad_ad, eta, E, S, logNe
         character (len=256) :: dir
	      integer, parameter :: io_unit0 = 40
         
         include 'formats.dek'
         
         
         write(*,*) 'make_QTplot_files'
	      
	      call setup_eos
         
         X = 0.80d0  ! 0.00d0, 0.20d0, 0.40d0, 0.60d0, 0.80d0
         Z = 0.00d0

         call get_azbar(X, Z, abar, zbar)
                  
         logT_points = 200
         logQ_points = 200

	      ! check scvh
	      logT_max = 4d0
	      logT_min = 3d0
	      logQ_min = 3.5d0
	      logQ_max = 4.9d0
         
	      logT_max = 7.05d0
	      logT_min = 2.1d0
	      logQ_min = -2d0
	      logQ_max = 5.5d0
         
         ! test
	      logT_max = 8.2d0
	      logT_min = 3.2d0
	      logQ_min = -9d0
	      logQ_max = 3d0

	      io_params = io_unit0
	      io_logQ = io_unit0+1
	      io_logT = io_unit0+2
	      io_first = io_unit0+3

	      dir = 'plotQT_data'
         call Open_Plot_Outfiles(io_first, io_last, io_params, io_logQ, io_logT, dir)
         write(io_params, '(2(f10.6),2(i7))') Z, X, logQ_points, logT_points
         close(io_params)
			num_vals  = io_last - io_first + 1
			allocate(output_values(logQ_points,logT_points,num_vals))
			
	      dlogT = (logT_max - logT_min)/(logT_points-1)
	      dlogQ = (logQ_max - logQ_min)/(logQ_points-1)
      
         do j=1, logT_points
            logT = logT_min + dlogT*(j-1)
            T = 10 ** logT

		      do i=1,logQ_points
		         logQ = logQ_min + dlogQ*(i-1)
		         
               logRho = logQ + 2*logT - 12d0
               Rho = 10**logRho
               
               call helm_opal_scvh(helm_only, opal_scvh_only, opal_only, &
                  scvh_only, search_for_SCVH, &
   					include_radiation, logT, logRho, T, Rho, abar, zbar, X, Z, &
                  logPgas, logE, logS, chiRho, chiT, Cp, Cv, dE_dRho, dS_dT, dS_dRho, &
                  mu, free_e, gamma1, gamma3, grad_ad, eta, &
                  data_dir, ierr)
		         if (ierr /= 0) stop 'failed in helm_opal_scvh'
			      
			      
			      if (abs(logQ + 2*logT - 12d0 - logRho) > 1d-6) then
                  write(*,1) 'logQ', logQ
                  write(*,1) 'logT', logT
                  write(*,1) 'logRho', logRho
                  write(*,1) 'logQ + 2*logT - 12d0', logQ + 2*logT - 12d0
                  write(*,*)
                  stop
			      end if
			      
			      call check_num(logPgas)
			      call check_num(logE)
			      call check_num(logS)
			      call check_num(chiRho)
			      call check_num(chiT)
			      call check_num(Cp)
			      call check_num(Cv)
			      call check_num(dE_dRho)
			      call check_num(dS_dT)
			      call check_num(dS_dRho)
			      call check_num(mu)
			      call check_num(free_e)
			      call check_num(gamma1)
			      call check_num(gamma3)
			      call check_num(grad_ad)
			      call check_num(eta)
			      
			      if (.false. .and. is_bad_num(dE_dRho)) then
                  write(*,1) 'logQ', logQ
                  write(*,1) 'logT', logT
                  write(*,1) 'logRho', logRho
                  write(*,1) 'abar', abar
                  write(*,1) 'zbar', zbar
                  write(*,1) 'X', X
                  write(*,1) 'Z', Z
                  write(*,*)
                  write(*,1) 'logPgas', logPgas
                  write(*,1) 'logE', logE
                  write(*,1) 'logS', logS
                  write(*,1) 'chiRho', chiRho
                  write(*,1) 'chiT', chiT
                  write(*,1) 'Cp', Cp
                  write(*,1) 'Cv', Cv
                  write(*,1) 'dE_dRho', dE_dRho
                  write(*,1) 'dS_dT', dS_dT
                  write(*,1) 'dS_dRho', dS_dRho
                  write(*,1) 'mu', mu
                  write(*,1) 'free_e', free_e
                  write(*,1) 'gamma1', gamma1
                  write(*,1) 'gamma3', gamma3
                  write(*,1) 'grad_ad', grad_ad
                  write(*,1) 'eta', eta
                  write(*,*)
			         stop
			      end if
			      
			      Pgas = 10**logPgas
			      Prad = crad*T**4/3
			      P = Pgas + Prad
			      
			      k = 0
			      k = k+1; output_values(i,j,k) = logRho
			      k = k+1; output_values(i,j,k) = logPgas
			      k = k+1; output_values(i,j,k) = safe_log10(P)
			      k = k+1; output_values(i,j,k) = logE
			      k = k+1; output_values(i,j,k) = (10**logS)*amu/kerg
			      k = k+1; output_values(i,j,k) = chiRho
			      k = k+1; output_values(i,j,k) = chiT
			      k = k+1; output_values(i,j,k) = safe_log10(Cp)
			      k = k+1; output_values(i,j,k) = safe_log10(Cv)
			      E = 10**logE
			      S = 10**logS
			      k = k+1; output_values(i,j,k) = dE_dRho*Rho/E
			      k = k+1; output_values(i,j,k) = dS_dT*T/S
			      k = k+1; output_values(i,j,k) = dS_dRho*Rho/S
			      k = k+1; output_values(i,j,k) = mu
			      k = k+1; output_values(i,j,k) = safe_log10(free_e)
			      k = k+1; output_values(i,j,k) = gamma1
			      k = k+1; output_values(i,j,k) = gamma3
			      k = k+1; output_values(i,j,k) = grad_ad
			      k = k+1; output_values(i,j,k) = eta
			      k = k+1; output_values(i,j,k) = logPgas - 4*logT
            
	         enddo
         
	      enddo
	
!$OMP PARALLEL DO PRIVATE(k)
			do k = 1, num_vals
				write(*,*) k
				write(io_first+k-1,'(e14.6)') output_values(1:logQ_points,1:logT_points,k)
			end do
!$OMP END PARALLEL DO

			do i = 1, logT_points
            logT = logT_min + dlogT*(i-1)
            write(io_logT,*) logT
			end do
	      close(io_logT)
      
	      do j=1,logQ_points
	         logQ = logQ_min + dlogQ*(j-1)
	         write(io_logQ,*) logQ
			end do
	      close(io_logQ)
	
	      do io=io_first,io_last
	         close(io)
	      end do
	
			deallocate(output_values)
			
			contains
			
			subroutine check_num(x)
			   double precision, intent(inout) :: x
			   if (is_bad_num(x)) x = 0
			end subroutine check_num
      
      end subroutine make_QTplot_files


      subroutine Open_Plot_Outfiles(io_first, io_last, io_params, io_logQ, io_logT, dir)
         integer, intent(in) :: io_first, io_params, io_logQ, io_logT
         integer, intent(out) :: io_last
         character (len=*), intent(in) :: dir
         character (len=256) :: fname
         integer :: io
         
         fname = trim(dir) // '/params.data'
         open(unit=io_params,file=trim(fname))
         
         fname = trim(dir) // '/logQ.data'
         open(unit=io_logQ,file=trim(fname))
         
         fname = trim(dir) // '/logT.data'
         open(unit=io_logT,file=trim(fname))
         
         io = io_first-1

         fname = trim(dir) // '/logRho.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/logPgas.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/logP.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/logE.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/entropy.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/chiRho.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/chiT.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/logCp.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/logCv.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dlnE_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dlnS_dlnT.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/dlnS_dlnRho.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/mu.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/log_free_e.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/gamma1.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/gamma3.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/grad_ad.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/eta.data'
         io = io+1; open(unit=io,file=trim(fname))

         fname = trim(dir) // '/logW.data'
         io = io+1; open(unit=io,file=trim(fname))

         io_last = io
      
      end subroutine Open_Plot_Outfiles
		


      end module make_QTplots
