      module mod_diff_vels
      
      !use diffusion_lib
      use const_def
      use utils_lib

      implicit none
      
      real*8 :: rho ! mass density
      real*8 :: t ! temperature
      real*8 :: g ! gravity
      real*8 :: tg ! temperature gradient dln T/dr

      integer, parameter :: nion = 14
      real*8 :: f(nion) ! neutral fractions
      real*8 :: xa(nion) ! mass fractions
      real*8 :: zion(nion) ! charge number
      real*8 :: pip(nion) ! dp_i/dp
      real*8 :: w(nion) ! diffusion velocities
      real*8 :: w_expected(nion) ! expected diffusion velocities
            
      
      contains


      subroutine test_diff_vels

         write(*,*) 'test_diff_vels'
         
         call read_args_and_output('difvel1_args&output.txt')
         call difvel1(rho,t,g,tg,f,xa,zion,pip,w)
         call compare_results
         
         call read_args_and_output('difvel2_args&output.txt')
         call difvel2(rho,t,g,tg,f,xa,zion,pip,w)
         call compare_results
         
         call read_args_and_output('difvel3_args&output.txt')
         call difvel3(rho,t,g,tg,f,xa,zion,pip,w)
         call compare_results
         
         write(*,*)
         
      end subroutine test_diff_vels
      
      
      subroutine compare_results
         integer :: i
         real*8 :: atol, rtol, err1, err_sum, err
         include 'formats.dek'
         atol = 1d-12
         rtol = 1d-5
         err_sum = 0
         do i = 1, nion
            err1 = abs(w(i) - w_expected(i))/(atol + rtol*max(abs(w(i)), abs(w_expected(i))))
            err_sum = err_sum + err1**2
            !write(*,2) 'compare', i, err1, w(i) - w_expected(i), w(i), w_expected(i)
         end do
         err = sqrt(err_sum/nion)
         if (err > 1) then
            write(*,*) 'error too large', err
         else
            write(*,*) 'okay within tolerances'
         end if
      end subroutine compare_results
      
      
      subroutine read_args_and_output(fname)
         character (len=*), intent(in) :: fname
         integer :: iounit, ierr
         
         ierr = 0
         write(*,*) 'read ' // trim(fname)

         iounit = alloc_iounit(ierr)
         if (ierr /= 0) stop 1
         
         open(iounit, file=trim(fname), action='read', status='old', iostat=ierr)
         if (ierr /= 0) then
            write(*, *) 'failed to open ' // trim(fname)
            call free_iounit(iounit)
            return
         end if           
                
         call skip_lines(3,iounit,ierr)
         if (ierr /= 0) stop 1
         read(iounit,*,iostat=ierr) rho, t, g, tg
         if (ierr /= 0) stop 1
         
         call skip_lines(2,iounit,ierr)
         if (ierr /= 0) stop 1
         read(iounit,*,iostat=ierr) f
         if (ierr /= 0) stop 1
         
         call skip_lines(2,iounit,ierr)
         if (ierr /= 0) stop 1
         read(iounit,*,iostat=ierr) xa
         if (ierr /= 0) stop 1
         
         call skip_lines(2,iounit,ierr)
         if (ierr /= 0) stop 1
         read(iounit,*,iostat=ierr) zion
         if (ierr /= 0) stop 1
         
         call skip_lines(2,iounit,ierr)
         if (ierr /= 0) stop 1
         read(iounit,*,iostat=ierr) pip
         if (ierr /= 0) stop 1
         
         call skip_lines(5,iounit,ierr)
         if (ierr /= 0) stop 1
         read(iounit,*,iostat=ierr) w_expected
         if (ierr /= 0) stop 1

         close(iounit)
         call free_iounit(iounit)
         
      end subroutine read_args_and_output
      
      
      subroutine skip_lines(n,iounit,ierr)
         integer, intent(in) :: n, iounit
         integer, intent(out) :: ierr
         integer :: i
         ierr = 0
         do i=1,n
            read(iounit, *, iostat=ierr) 
            if (ierr /= 0) then
               close(iounit)
               call free_iounit(iounit)
               return
            end if
         end do
      end subroutine skip_lines
      
      
      

      end module mod_diff_vels


