      subroutine difvel3 (rho,t,g,tg,f,x,zion,pip,w)
      implicit real*8 (a-h,o-z)
      !save



! similar to difvel2 in that it includes solution for residual heat flow vectors
! but groups the isotopes so that only 3 diffusion velocities are calculated


!
! For calculating diffusion velocities, assume H and D have the same velocity,
! 3He, 4He, 7Be and 7Li have the same velocity and all the heavy elements have
! the same velocity
!
! this routine includes thermal diffusion in the calculation of diffusion
! coefficients and settling velocities.
!
! input parameters are:
!
!   rho   mass density
!   t     temperature
!   g     gravity
!   tg    temperature gradient dln T/dr
!   x     mass fractions
!   zion  ionic charges
!   pip   derivative of ion partial pressure w.r.t total pressure
!
! output are the ion diffusion velocities w
!
!
! nion is the number of ionic species. z(i) and a(i) are atomic number
! and atomic mass of species i, respectively.
!
! The order of the variables is 
!
!      1. w_e
!      2 to nion+1. w_ion
!      nion+2 to 2nion+2. r_i
!      2nion+3. eE/m_Hg
!
! The order of the equations is:
!
!      1. charge conservation
!      2 to 4. partial pressure equations
!      5 to 8. residual heat flux equations
!      9. mass conservation 
!
      parameter (ncomp=14,nion=ncomp,nipe=nion+1,nipep=nipe+1,
     1      nipe2=nipe+nipe,neq=nipe2+1,
     2                    nred=3,nipered=nred+1,niperedp=nipered+1,
     3      nipered2=nipered+nipered,neqred=nipered2+1)
      parameter (xdmin=0.0302043d0,third=1.0d0/3.0d0)
      dimension pn(nipe),w(nion),z(nipe),a(nipe),rhs(nipe),
     1   x(nion),zion(nion),pip(nion),f(nion)
      dimension pnred(nipered),wred(nred),zred(nipered),ared(nipered),
     1   xred(nred),zionred(nred),pipred(nred),fred(nred),
     2   rhsred(nipered)
      dimension am(neqred,neqred),bv(neqred),index(neqred)
      dimension d(nipered,nipered),zt1(nipered,nipered),
     1     zt2(nipered,nipered),zt3(nipered,nipered),
     2     dn(nipered,nipered)
      data a / 5.45d-04,1.0d0,2.0d0,3.0d0,4.0d0,7.0d0,7.0d0,12.0d0,
     1         13.0d0,14.0d0,16.0d0,20.0d0,24.0d0,28.0d0,56.0d0/
      data an,cr /6.02217d+23,8.3143d+07/
!
! Hard sphere radii from Hydrogenic approximation
!
      data rhs /0.0d0,6.99d-09,6.99d-09,5.20d-09,5.20d-09,1.11d-08,
     1   8.44d-09,7.68d-09,7.68d-09,6.76d-09,6.98d-09,5.55d-09,9.32d-09,
     2   9.03d-09,9.19d-09/
!
! determine quantities for the reduced set of composition variables.
!
      xred(3)=x(7)+x(8)+x(9)+x(10)+x(11)+x(12)+x(13)+x(14)
      xred(2)=x(3)+x(4)+x(5)+x(6)
      xred(1)=x(1)+x(2)
      ared(1)=a(1)
      rhsred(1)=rhs(1)

      sumxona=0.0d0
      sumxzona=0.0d0
      pipred(1)=0.0d0
      sumxfona=0.0d0
      sumxvona=0.0d0
      do i=1,2
         sumxona =sumxona +x(i)        /a(i+1)
         sumxzona=sumxzona+x(i)*zion(i)/a(i+1)
         sumxfona=sumxfona+x(i)*f   (i)/a(i+1)
         sumxvona=sumxvona+x(i)*rhs(i+1)**3/a(i+1)
         pipred(1)=pipred(1)+pip(i)
      enddo
      ared(2)=xred(1)/sumxona
      rhsred(2)=(sumxvona/sumxona)**third
      zionred(1)=sumxzona/sumxona
      fred(1)   =sumxfona/sumxona
      sumxona=0.0d0
      sumxzona=0.0d0
      pipred(2)=0.0d0
      sumxfona=0.0d0
      sumxvona=0.0d0
      do i=3,6
         sumxona =sumxona +x(i)        /a(i+1)
         sumxzona=sumxzona+x(i)*zion(i)/a(i+1)
         sumxfona=sumxfona+x(i)*f   (i)/a(i+1)
         sumxvona=sumxvona+x(i)*rhs(i+1)**3/a(i+1)
         pipred(2)=pipred(2)+pip(i)
      enddo
      ared(3)=xred(2)/sumxona
      rhsred(3)=(sumxvona/sumxona)**third
      zionred(2)=sumxzona/sumxona
      fred(2)   =sumxfona/sumxona

      sumxona=0.0d0
      sumxzona=0.0d0
      sumxfona=0.0d0
      sumxvona=0.0d0
      pipred(3)=0.0d0
      do i=7,14
         sumxona =sumxona +x(i)        /a(i+1)
         sumxzona=sumxzona+x(i)*zion(i)/a(i+1)
         sumxfona=sumxfona+x(i)*f   (i)/a(i+1)
         sumxvona=sumxvona+x(i)*rhs(i+1)**3/a(i+1)
         pipred(3)=pipred(3)+pip(i)
      enddo
      ared(4)=xred(3)/sumxona
      rhsred(4)=(sumxvona/sumxona)**third
      zionred(3)=sumxzona/sumxona
      fred(3)   =sumxfona/sumxona

!
! tn is the total ion number density, used to find mean ion separation
! tc is the sum over species of nZ^2, used to find the Debye radius
!
      pnred(1)=0.0d0
      zred(1)=-1.0d0
      do i=1,nred
         zred(i+1)=zionred(i)
         pnred(i+1)=xred(i)*an*rho/ared(i+1)
         pnred(1)=pnred(1)+zionred(i)*pnred(i+1)
      enddo
      tn=-pnred(1)
      tc=0.0d0
      do i=1,nipered
         tn=tn+pnred(i)
         tc=tc+pnred(i)*zred(i)**2
      enddo
      b=cr*t/g
      btg=b*tg
!
! calculate debye radius.
!
      deb=sqrt(47.6205d0*t/tc)
!
! calculate mean ion separation.
!
      sep=0.62035d0/tn**third
!
! calculate xd for hydrogen.
!
      xdh=2.3937d+03*t*smax(deb,sep)
      c=4.255d-02/(g*t*sqrt(t))
!
! find modified resistance coefficients for electron-electron collisions.
!
      xd=smax(xdh,xdmin)
      phi=log(log(1.0d0+xd**2))
      dci11=dcir11(phi)
      dci12=dcir12(phi)
      dci13=dcir13(phi)
      dci22=dcir22(phi)
      zt1(1,1)=1.0d0-0.4d0*dci12/dci11
      zt2(1,1)=2.5d0-0.4d0*(5.0d0*dci12-dci13)/dci11
      zt3(1,1)=dci22/dci11
      d(1,1)=dci11*1.651d-02*c*pnred(1)
!
! ditto for electron-ion collisions.
!
      do j=2,nipered
         xd=-smax(xdh/zred(j),xdmin)
         phi=log(log(1.0d0+xd**2))
         dci11=dcia11(phi)
         dci12=dcia12(phi)
         dci13=dcia13(phi)
         dci22=dcia22(phi)
         zt1(1,j)=1.0d0-0.4d0*dci12/dci11
         zt2(1,j)=2.5d0-0.4d0*(5.0d0*dci12-dci13)/dci11
         zt3(1,j)=dci22/dci11
         dci=dci11*2.335d-02*zred(j)**2
         d(1,j)=dci*c*pnred(j)
         d(j,1)=dci*c*pnred(1)
         zt1(j,1)=zt1(1,j)
         zt2(j,1)=zt2(1,j)
         zt3(j,1)=zt3(1,j)
      enddo
!
! ditto for ion-ion collisions.
!
      do i=2,nipered
         do j=i,nipered
            zfac=zred(i)*zred(j)
            xd=smax(xdh/zfac,xdmin)
            phi=log(log(1.0+xd**2))
            dci11=dcir11(phi)
            dci12=dcir12(phi)
            dci13=dcir13(phi)
            dci22=dcir22(phi)
            zt1(i,j)=1.0d0-0.4d0*dci12/dci11
            zt2(i,j)=2.5d0-0.4d0*(5.0d0*dci12-dci13)/dci11
            zt3(i,j)=dci22/dci11
            afac=ared(i)*ared(j)/(ared(i)+ared(j))
            dci=dci11*sqrt(afac)*zfac**2
            d(i,j)=dci*c*pnred(j)
            d(j,i)=dci*c*pnred(i)
            zt1(j,i)=zt1(i,j)
            zt2(j,i)=zt2(i,j)
            zt3(j,i)=zt3(i,j)
         enddo
      enddo
!
! ditto for collisions involving neutrals
!
      c_n=rho/g
      do i=2,nipered
         do j=i,nipered
            d_sym=c_n*sqrt(ared(i)*ared(j)/(ared(i)+ared(j)))*
     1      (6.0d+14*(fred(i-1)*sqrt(zred(j))+fred(j-1)*sqrt(zred(i)))+
     2          3.67d+28*fred(i-1)*fred(j-1)*(rhsred(i)+rhsred(j))**2)
            dn(i,j)=xred(j-1)*d_sym/ared(j)
            dn(j,i)=xred(i-1)*d_sym/ared(i)
         enddo
      enddo
!
! setup matrix to solve for diffusion velocities.
!
!
! begin with partial pressure equations.
!
      do ip=2,nipered
         it=ip+nipered
         am(ip,ip)=0.0d0
         am(ip,it)=0.0d0
         do jp=1,nipered
            jt=jp+nipered
            if (ip.ne.jp) then
               am(ip,jp)=-d(ip,jp)-dn(ip,jp)
               am(ip,ip)=am(ip,ip)+d(ip,jp)+dn(ip,jp)
               afaca=ared(ip)/(ared(ip)+ared(jp))
               am(ip,jt)=zt1(ip,jp)*d(ip,jp)*afaca
               afacb=ared(jp)/(ared(ip)+ared(jp))
               am(ip,it)=am(ip,it)-zt1(ip,jp)*d(ip,jp)*
     1                      afacb
            endif
         enddo
         am(ip,neqred)=-zred(ip)
      enddo
!
! residual heat flux equations.
!
      do it=niperedp,nipered2
         ip=it-nipered
         am(it,ip)=0.0d0
         am(it,it)=-0.4d0*d(ip,ip)*zt3(ip,ip)
         do jt=niperedp,nipered2
            jp=jt-nipered
            if (ip.ne.jp) then
               afaca=ared(jp)/(ared(ip)+ared(jp))
               am(it,jp)=-2.5d0*d(ip,jp)*zt1(ip,jp)*afaca
               am(it,ip)=am(it,ip)-am(it,jp)
               afacb=ared(ip)*ared(jp)/(ared(ip)+ared(jp))**2
               am(it,jt)=d(ip,jp)*afacb*
     1            (3.0d0+zt2(ip,jp)-0.8d0*zt3(ip,jp))
                am(it,it)=am(it,it)-d(ip,jp)*
     1            (3.0d0*ared(ip)**2+zt2(ip,jp)*ared(jp)**2+
     2             0.8d0*zt3(ip,jp)*ared(ip)*ared(jp))/
     3            (ared(ip)+ared(jp))**2
            endif
         enddo
         am(it,neqred)=0.0d0
      enddo
!
! charge and mass conservation equations.
!
      do jp=1,nipered
         jt=jp+nipered
         am(1,jp)=pnred(jp)*zred(jp)/tn
         am(1,jt)=0.0d0
         am(neqred,jp)=pnred(jp)*ared(jp)/tn
         am(neqred,jt)=0.0d0
      enddo
      am(1,neqred)=0.0d0
      am(neqred,neqred)=0.0d0
!
! setup RHS "source" column matrix
!
      bv(1)=0.0d0
      do ip=2,nipered
         it=ip+nipered
         bv(ip)=-ared(ip)+rho*an*pipred(ip-1)/pnred(ip)
      enddo
      do ip=1,nipered
         it=ip+nipered
         bv(it)=btg*2.5d0
      enddo
      bv(neqred)=0.0d0
      call ludcmp (am,neqred,neqred,index,det)
      call lubksb (am,neqred,neqred,index,bv)
!
! bv now contains the solutions to the equations
!
      do i=1,nred
         wred(i)=bv(i+1)
      enddo
      do i=1,2
         w(i)=wred(1)
      enddo
      do i=3,6
         w(i)=wred(2)
      enddo
      do i=7,14
         w(i)=wred(3)
      enddo
      return
      end
