      subroutine difvel1 (rho,t,g,tg,f,x,zion,pip,w)
      implicit real*8 (a-h,o-z)
      !save
!
! this routine excludes thermal diffusion in the calculation of diffusion
! coefficients and settling velocities.

! the residual heat flow vectors rs are assumed to be zero
 
!
! input parameters are:
!
!   rho   mass density
!   t     temperature
!   g     gravity
!   tg    temperature gradient dln T/dr
!   f     neutral fractions
!   x     mass fractions
!   zion  ionic charges
!   pip   derivative of ion partial pressure w.r.t total pressure
!
! output are the ion diffusion velocities w
!
!
! nion is the number of ionic species. z(i) and a(i) are atomic number
! and atomic mass of species i, respectively.
!
! The order of the variables is 
!
!      1. w_e
!      2 to nion+1. w_ion
!      nion+2. eE/m_Hg
!
! The order of the equations is:
!
!      1. charge conservation
!      2 to nion+1. partial pressure equations
!      nion+2. mass conservation 
!
      parameter (ncomp=14,nion=ncomp,nipe=nion+1,nipep=nipe+1,neq=nipep)
      parameter (xdmin=0.0302043d0,third=1.0d0/3.0d0)
      dimension pn(nipe),w(nion),z(nipe),a(nipe),
     1   x(nion),zion(nion),pip(nion),f(nion)
      dimension am(neq,neq),bv(neq),index(neq)
      dimension am_orig(neq,neq),bv_orig(neq)
      dimension d(nipe,nipe),dn(nipe,nipe),rhs(nipe)
      data a / 5.45d-04,1.0d0,2.0d0,3.0d0,4.0d0,7.0d0,7.0d0,12.0d0,
     1         13.0d0,14.0d0,16.0d0,20.0d0,24.0d0,28.0d0,56.0d0/
      data an,cr /6.02217d+23,8.3143d+07/
!
! Hard sphere radii from Hydrogenic approximation
!
      data rhs /0.0d0,6.99d-09,6.99d-09,5.20d-09,5.20d-09,1.11d-08,
     1   8.44d-09,7.68d-09,7.68d-09,6.76d-09,6.98d-09,5.55d-09,9.32d-09,
     2   9.03d-09,9.19d-09/
!
! tn is the total ion number density, used to find mean ion separation
! tc is the sum over species of nZ^2, used to find the Debye radius
!
      pn(1)=0.0d0
      z(1)=-1.0d0
      do i=1,nion
         z(i+1)=zion(i)
         pn(i+1)=x(i)*an*rho/a(i+1)
         pn(1)=pn(1)+zion(i)*pn(i+1)
      enddo
      tn=-pn(1)
      tc=0.0d0
      do i=1,nipe
         tn=tn+pn(i)
         tc=tc+pn(i)*z(i)**2
      enddo
      b=cr*t/g
      btg=b*tg
!
! calculate debye radius.
!
      deb=sqrt(47.6205d0*t/tc)
!
! calculate mean ion separation.
!
      sep=0.62035d0/tn**third
!
! calculate xd for hydrogen.
!
      xdh=2.3937d+03*t*smax(deb,sep)
      c=4.255d-02/(g*t*sqrt(t))
!
! find modified resistance coefficients for electron-electron collisions.
!
      xd=smax(xdh,xdmin)
      phi=log(log(1.0d0+xd**2))
      dci11=dcir11(phi)
      d(1,1)=dci11*1.651d-02*c*pn(1)
      dn(1,1)=0.0d0
!
! ditto for electron-ion collisions.
!
      do j=2,nipe
         xd=-smax(xdh/z(j),xdmin)
         phi=log(log(1.0d0+xd**2))
         dci11=dcia11(phi)
         dci=dci11*2.335d-02*z(j)**2
         d(1,j)=dci*c*pn(j)
         d(j,1)=dci*c*pn(1)
         dn(1,j)=0.0d0
         dn(j,1)=0.0d0
      enddo
!
! ditto for ion-ion collisions.
!
      do i=2,nipe
         do j=i,nipe
            zfac=z(i)*z(j)
            xd=smax(xdh/zfac,xdmin)
            phi=log(log(1.0+xd**2))
            dci11=dcir11(phi)
            dci=dci11*sqrt(a(i)*a(j)/(a(i)+a(j)))*zfac**2
            d(i,j)=dci*c*pn(j)
            d(j,i)=dci*c*pn(i)
         enddo
      enddo
!
! ditto for collisions involving neutrals
!
      c_n=rho/g
      do i=2,nipe
         do j=i,nipe
            d_sym=c_n*sqrt(a(i)*a(j)/(a(i)+a(j)))*
     1         (6.0d+14*(f(i-1)*sqrt(z(j))+f(j-1)*sqrt(z(i)))+
     2          3.67d+28*f(i-1)*f(j-1)*(rhs(i)+rhs(j))**2)
            dn(i,j)=x(j-1)*d_sym/a(j)
            dn(j,i)=x(i-1)*d_sym/a(i)
         enddo
      enddo
!
! setup matrix to solve for diffusion velocities.
!
!
! begin with partial pressure equations.
!
      do ip=2,nipe
         am(ip,ip)=0.0d0
         do jp=1,nipe
            jt=jp+nipe
            if (ip.ne.jp) then
               am(ip,jp)=-d(ip,jp)-dn(ip,jp)
               am(ip,ip)=am(ip,ip)+d(ip,jp)+dn(ip,jp)
            endif
         enddo
         am(ip,neq)=-z(ip)
      enddo
!
! charge and mass conservation equations.
!
      do jp=1,nipe
         am(1,jp)=pn(jp)*z(jp)/tn
         am(neq,jp)=pn(jp)*a(jp)/tn
      enddo
      am(1,neq)=0.0d0
      am(neq,neq)=0.0d0
!
! setup RHS "source" column matrix
!
      bv(1)=0.0d0
      do ip=2,nipe
         it=ip+nipe
         bv(ip)=-a(ip)+rho*an*pip(ip-1)/pn(ip)
      enddo
      bv(neq)=0.0d0
      do i=1,neq
         do j=1,neq
            am_orig(i,j)=am(i,j)
         enddo
         bv_orig(i)=bv(i)
      enddo
      call ludcmp (am,neq,neq,index,det)
      call lubksb (am,neq,neq,index,bv)
      call mprove (am_orig,am,neq,neq,index,bv_orig,bv)
!
! bv now contains the solutions to the equations
!
      do i=1,nion
         w(i)=bv(i+1)
      enddo
      return
      end
