      program test_colors

      use colors_def
      use colors_lib
      
      implicit none
		
      call do_test_colors

      contains


      subroutine do_test_colors

			character (len=256) :: data_dir
			integer :: info
			
			logical, parameter :: do_one = .true.
	!		logical, parameter :: do_one = .false.
			
			data_dir = '../../data'

			call colors_init(data_dir, info)
			
			if (info /= 0) then
				write(*,*) 'colors_init failed during initialization'
				return
			end if

			if (do_one) then
				call do_one_colors
			else
         	call create_plot_files
			end if
			      
      end subroutine do_test_colors 
		
		
      subroutine do_one_colors

			double precision :: log_teff ! log10 of surface temp
			double precision :: log_l ! log10 of luminosity in solar units
			double precision :: mass ! mass in solar units
			double precision :: fe_h ! [fe/h], or as an approximation, log10[z/zsun]
			double precision :: results(n_colors), log_g
			integer :: info, i
			character (len=8) :: vname
			
			double precision, parameter :: solar_expected_results(n_colors) = (/
     >			4.75, -0.12, 0.11, 0.63, 0.36, 0.70, 1.53, 0.34, 
     >			0.83,  0.34, 0.05, 0.05, 0.40, 0.45, 0.45, 0.38 /)	

			logical, parameter :: doing_solar = .true.

			! solar values
			log_teff = log10(5780d0)
			log_l    = 0d0
			mass     = 1d0
			fe_h     = 0d0

         call colors_get(log_teff, log_l, mass, fe_h, results, log_g, info)

         if (info /= 0) then
				stop 'bad return from colors_get'
			end if
			
			write(*,*)
			write(*,*) 'color magnitude results'
			write(*,*)
			write(*,'(6a12)') 'teff', 'log_teff', 'log_l', 'mass', '[fe_h]', 'log_g'
			write(*,'(i12,5f12.2)') floor(10**log_teff + 0.5), log_teff, log_l, mass, fe_h, log_g
			write(*,*)
			
			do i=1,n_colors
				write(*,'(9x,a8,f10.5)') colors_name(i), results(i)
			end do
			write(*,*)
			vname = 'vcolors'
			write(*,'(9x,a8,f10.5)') vname, results(bol)-results(bcv)
			write(*,*)
			
			if (doing_solar) then
			
				do i=1,n_colors
					if (abs(results(i) - solar_expected_results(i)) > 0.02) then
						write(*,*)
						write(*,*) 'warning'
						write(*,'(2(a,f10.5))') 
     >						colors_name(i), results(i), ' but expected ', solar_expected_results(i)
						write(*,*)
					end if
				end do
				
				write(*,*) 'matches expected solar results'
			   write(*,*)
				
			end if
			
		end subroutine do_one_colors


      subroutine create_plot_files

         character (len=256) fname, dir
			integer, parameter :: max_num_masses = 100
			double precision, dimension(max_num_masses) :: mass, logl, logteff
			double precision :: read_junk, log_g, fe_h, results(n_colors)
			integer :: info, i, num_masses, io_unit, ios, iread_junk
			
			fe_h = 0d0
			fname = 'zams_data/z02.log'
			io_unit = 40
         open(unit=io_unit, file=trim(fname), action='read', status='old', iostat=ios)
			if (ios /= 0) then
				write(*,*) 'failed to open the zams data'
				return
			end if
			
			num_masses = 0
			do i = 1, max_num_masses
				read(io_unit,fmt=*,iostat=ios) iread_junk, mass(i), logl(i), read_junk, logteff(i)
				if (ios /= 0) then
					num_masses = i-1
					exit
				end if
			end do
			read_junk = read_junk; iread_junk = iread_junk ! to keep g95 quiet
			
			close(io_unit)

			dir = 'plot_data'
         fname = trim(dir) // '/' // 'colors.data'
         open(unit=io_unit,file=trim(fname))
            
      	do i = 1, num_masses

         	call colors_get(logteff(i), logl(i), mass(i), fe_h, results, log_g, info)
				
				if (info == 0) write(io_unit,'(99f15.8)') mass(i), logl(i), logteff(i), log_g, results

			end do
         
			close(io_unit)
			
			write(*,*) 'finished creating plot files'

      end subroutine create_plot_files


      end program




