# colors.rb

class Colors_data

    attr_accessor :num_pts, :mass, :log_M, :log_L, :log_Teff, :log_g
    attr_accessor :bol, :bcv, :umb, :bmv, :vmr, :vmi, :vmk, :rmi, :vmag

    def initialize(filename)
        Dvector.read(filename, [ # the columns of data in the file
            @mass = Dvector.new,
            @log_L = Dvector.new,
            @log_Teff = Dvector.new,
            @log_g = Dvector.new,
            @bol = Dvector.new,
            @bcv = Dvector.new,
            @umb = Dvector.new,
            @bmv = Dvector.new,
            @vmr = Dvector.new,
            @vmi = Dvector.new,
            @vmk = Dvector.new,
            @rmi = Dvector.new ])
        @num_pts = @mass.length
        # some derived quantities
        @vmag = @bol - @bcv
        @log_M = @mass.log10
    end

end # class Colors_data
    
    
class Colors_plot

    include Math
    include FigureConstants
    
    def initialize(data_dir)
    
        @figure_maker = FigureMaker.default
        t.def_eval_function { |str| eval(str) }
        t.save_dir = 'plot_out'
        
        t.def_figure('vmag') { vmag }
        t.def_figure('umb') { umb }
        t.def_figure('bmv') { bmv }
        t.def_figure('vmr') { vmr }
        t.def_figure('rmi') { rmi }

        t.def_figure('log_g') { log_g }


        @colors_data = Colors_data.new(data_dir + '/colors.data')
        
        @margin = 1

    end
    
    def t
        @figure_maker
    end
    
    def d
        @colors_data
    end
 

    
    def plot_one(ylabel, ys, y_lower_limit = nil, y_upper_limit = nil)
        t.landscape
        if y_lower_limit != nil
            ybottom = y_lower_limit
        else
            ybottom = ys.min
        end
        if y_upper_limit != nil
            ytop = y_upper_limit
        else
            ytop = ys.max
        end        
        ytop = 1e-20 + ybottom if ytop - 1e-20 <= ybottom
        dy = (ytop - ybottom) * 0.05

        t.xlabel = 'Mass ($M_{\odot}$)'
        t.ylabel = ylabel.tr("_", " ")
        t.title = t.ylabel
        xleft = log10(0.08)
        xright = log10(120.0)
        t.xaxis_log_values = true
        t.xaxis_use_fixed_pt = true
        xs = d.log_M
        t.show_plot('left_boundary' => xleft, 'right_boundary' => xright,
            'top_boundary' => ytop+dy, 'bottom_boundary' => ybottom-dy) { t.show_polyline(xs,ys,Blue) }
    end

    # plot routines
    
    def log_g
        plot_one('log_g', d.log_g)
    end
    
    def vmag
        plot_one('vmag', d.vmag)
    end
    
    def umb
        plot_one('umb', d.umb)
    end
    
    def bmv
        plot_one('bmv', d.bmv)
    end
    
    def vmr
        plot_one('vmr', d.vmr)
    end
    
    def vmi
        plot_one('vmi', d.vmi)
    end
    
    def vmk
        plot_one('vmk', d.vmk)
    end
    
    def rmi
        plot_one('rmi', d.rmi)
    end
        
end

Colors_plot.new('plot_data')
