! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   MESA is free software; you can use it and/or modify
!   it under the combined terms and restrictions of the MESA MANIFESTO
!   and the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License,
!   or (at your option) any later version.
!
!   You should have received a copy of the MESA MANIFESTO along with
!   this software; if not, it is available at the mesa website:
!   http://mesa.sourceforge.net/
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!   See the GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
!
! ***********************************************************************

      module colors_lib
		! library for calculating theoretical estimates of magnitudes and colors
		! from Teff, L, M, and [Fe_H].

  		! color magnitude data from Lejeune, Cuisinier, Buser (1998) A&AS 130, 65-75.
  		

		use colors_def
		! the data interface for the library is defined in colors_def
		
      implicit none


		contains ! the procedure interface for the library
		! client programs should only call these routines.
				
		
		subroutine colors_init(data_dir, ierr)
			use mod_colors, only : init_colors
			character (len=*), intent(in) :: data_dir
			integer, intent(out) :: ierr
			call init_colors(data_dir, ierr)			
		end subroutine colors_init
		
		
		subroutine colors_shutdown
			use mod_colors, only : free_colors
			call free_colors		
		end subroutine colors_shutdown
		
		
		subroutine colors_get(log_Teff, log_L, mass, Fe_H, results, log_g, ierr)
			use mod_colors, only : Eval_Colors
			! input
			double precision, intent(in)  :: log_Teff ! log10 of surface temp
			double precision, intent(in)  :: log_L ! log10 of luminosity in solar units
			double precision, intent(in)  :: mass ! mass in solar units
			double precision, intent(in)  :: Fe_H ! [Fe/H]
			! output
			double precision, intent(out) :: results(n_colors)
			double precision, intent(out) :: log_g
			integer, intent(out) :: ierr
			
			call Eval_Colors(log_Teff, log_L, mass, Fe_H, results, log_g, ierr)
			
		end subroutine colors_get
		
		
      end module colors_lib

