! ***********************************************************************
!
!   Copyright (C) 2010  Bill Paxton
!
!   this file is part of mesa.
!
!   mesa is free software; you can redistribute it and/or modify
!   it under the terms of the gnu general library public license as published
!   by the free software foundation; either version 2 of the license, or
!   (at your option) any later version.
!
!   mesa is distributed in the hope that it will be useful, 
!   but without any warranty; without even the implied warranty of
!   merchantability or fitness for a particular purpose.  see the
!   gnu library general public license for more details.
!
!   you should have received a copy of the gnu library general public license
!   along with this software; if not, write to the free software
!   foundation, inc., 59 temple place, suite 330, boston, ma 02111-1307 usa
!
! ***********************************************************************
 
      module extras_support

      use star_lib
      use star_def
      use const_def
      use utils_lib
      use star_adipls_support
      
      implicit none





      contains
      


      integer function adipls_extras_check_model(s, id, id_extra)
         use run_star_support, only: initial_h1, initial_he3, initial_he4
         use run_star_extras, only: extras_check_model
         type (star_info), pointer :: s
         integer, intent(in) :: id, id_extra
         integer :: other_check
         include 'formats.dek'

         if (just_call_my_extras_check_model) then
            adipls_extras_check_model = extras_check_model(s, id, id_extra)
            best_model_chi_square = 0
         else
            adipls_extras_check_model = do_adipls_extras_check_model(s, id, id_extra)
            other_check = extras_check_model(s, id, id_extra)
            if (other_check > adipls_extras_check_model) &
               adipls_extras_check_model = other_check
         end if
         
         adipls_save_mode_info = (s% model_number == save_mode_model_number)
         adipls_el_to_save = el_to_save
         adipls_order_to_save = order_to_save
         adipls_save_mode_filename = save_mode_filename
         
         if (adipls_save_mode_info) then
            call get_one_el_info(s, 0, &
               nu_lower_factor*l0_obs(1), &
               nu_upper_factor*l0_obs(nl0), &
               iscan_factor_l0*nl0, 1, nl0)
            call get_one_el_info(s, 1, &
               nu_lower_factor*l1_obs(1), &
               nu_upper_factor*l1_obs(nl1), &
               iscan_factor_l1*nl1, 1, nl1)
            call get_one_el_info(s, 2, &
               nu_lower_factor*l2_obs(1), &
               nu_upper_factor*l2_obs(nl2), &
               iscan_factor_l2*nl2, 1, nl2)
         end if
         
      end function adipls_extras_check_model

      
      integer function adipls_extras_finish_step(s, id, id_extra)
         use run_star_extras, only: extras_finish_step
         type (star_info), pointer :: s
         integer, intent(in) :: id, id_extra
         adipls_extras_finish_step = extras_finish_step(s, id, id_extra)
         call store_extra_info(s)
         prev_anchor_l0_freq = anchor_l0_freq
         prev_age = s% star_age
      end function adipls_extras_finish_step
      

      subroutine adipls_extras_controls(s, ierr)
         use run_star_support, only: initial_h1, initial_he3, initial_he4, &
            new_mass, relax_initial_mass
         use run_star_extras, only: extras_controls
         type (star_info), pointer :: s
         integer, intent(out) :: ierr
         real(dp) :: X, Y, Z, Z_div_X
         include 'formats.dek'
         ierr = 0
         call extras_controls(s, ierr)
         if (ierr /= 0) return
         
         if (just_call_my_extras_check_model) return
         
         ! overwrite various inlist controls
         
         relax_initial_mass = .true.
         if (next_mass_to_try > 0) then
            new_mass = next_mass_to_try
         else
            new_mass = first_mass
         end if

         if (next_alpha_to_try > 0) then
            s% mixing_length_alpha = next_alpha_to_try
         else
            s% mixing_length_alpha = first_alpha
         end if

         if (next_f_ov_to_try > 0) then
            s% overshoot_f_below_nonburn = next_f_ov_to_try
            s% overshoot_f_above_nonburn = next_f_ov_to_try
            s% overshoot_f_below_nonburn = next_f_ov_to_try
            s% overshoot_f_above_burn_h = next_f_ov_to_try
            s% overshoot_f_below_burn_h = next_f_ov_to_try
            s% overshoot_f_above_burn_he = next_f_ov_to_try
            s% overshoot_f_below_burn_he = next_f_ov_to_try
            s% overshoot_f_above_burn_z = next_f_ov_to_try
            s% overshoot_f_below_burn_z = next_f_ov_to_try
         else
            s% overshoot_f_below_nonburn = first_f_ov
            s% overshoot_f_above_nonburn = first_f_ov
            s% overshoot_f_below_nonburn = first_f_ov
            s% overshoot_f_above_burn_h = first_f_ov
            s% overshoot_f_below_burn_h = first_f_ov
            s% overshoot_f_above_burn_he = first_f_ov
            s% overshoot_f_below_burn_he = first_f_ov
            s% overshoot_f_above_burn_z = first_f_ov
            s% overshoot_f_below_burn_z = first_f_ov
         end if

         if (next_f0_ov_fraction_to_try > 0) then
            s% overshoot_f0_above_nonburn = &
               next_f0_ov_fraction_to_try*s% overshoot_f_above_nonburn
            s% overshoot_f0_below_nonburn = &
               next_f0_ov_fraction_to_try*s% overshoot_f_below_nonburn
            s% overshoot_f0_above_burn_h = &
               next_f0_ov_fraction_to_try*s% overshoot_f_above_burn_h
            s% overshoot_f0_below_burn_h = &
               next_f0_ov_fraction_to_try*s% overshoot_f_below_burn_h
            s% overshoot_f0_above_burn_he = &
               next_f0_ov_fraction_to_try*s% overshoot_f_above_burn_he
            s% overshoot_f0_below_burn_he = &
               next_f0_ov_fraction_to_try*s% overshoot_f_below_burn_he
            s% overshoot_f0_above_burn_z = &
               next_f0_ov_fraction_to_try*s% overshoot_f_above_burn_z
            s% overshoot_f0_below_burn_z = &
               next_f0_ov_fraction_to_try*s% overshoot_f_below_burn_z
         else if (first_f0_ov_fraction >= 0) then
            s% overshoot_f0_above_nonburn = &
               first_f0_ov_fraction*s% overshoot_f_above_nonburn
            s% overshoot_f0_below_nonburn = &
               first_f0_ov_fraction*s% overshoot_f_below_nonburn
            s% overshoot_f0_above_burn_h = &
               first_f0_ov_fraction*s% overshoot_f_above_burn_h
            s% overshoot_f0_below_burn_h = &
               first_f0_ov_fraction*s% overshoot_f_below_burn_h
            s% overshoot_f0_above_burn_he = &
               first_f0_ov_fraction*s% overshoot_f_above_burn_he
            s% overshoot_f0_below_burn_he = &
               first_f0_ov_fraction*s% overshoot_f_below_burn_he
            s% overshoot_f0_above_burn_z = &
               first_f0_ov_fraction*s% overshoot_f_above_burn_z
            s% overshoot_f0_below_burn_z = &
               first_f0_ov_fraction*s% overshoot_f_below_burn_z
         end if

         if (next_Y_to_try > 0) then
            Y = next_Y_to_try
         else
            Y = first_Y
         end if
         
         initial_Y = Y
         if (next_Z_div_X_to_try > 0) then
            Z_div_X = next_Z_div_X_to_try
         else
            Z_div_X = first_Z_div_X
         end if
         
         initial_Z_div_X = Z_div_X
         X = (1 - Y)/(1 + Z_div_X)
         Z = X*Z_div_X
         initial_h1 = X
         initial_he3 = Y_frac_he3*Y
         initial_he4 = Y - initial_he3
      end subroutine adipls_extras_controls
      
      
      integer function adipls_extras_startup(s, id, restart, ierr)
         use run_star_extras, only: extras_startup
         type (star_info), pointer :: s
         integer, intent(in) :: id
         logical, intent(in) :: restart
         integer, intent(out) :: ierr
         ierr = 0
         adipls_extras_startup = extras_startup(s, id, restart, ierr)
         if (.not. restart) then
            call alloc_extra_info(s)
         else ! it is a restart
            call unpack_extra_info(s)
         end if
      end function adipls_extras_startup


      integer function adipls_how_many_extra_log_columns(s, id, id_extra)
         use run_star_extras, only: how_many_extra_log_columns
         type (star_info), pointer :: s
         integer, intent(in) :: id, id_extra
         adipls_how_many_extra_log_columns = how_many_extra_log_columns(s, id, id_extra)
         if (.not. just_call_my_extras_check_model) &
            adipls_how_many_extra_log_columns = &
               adipls_how_many_extra_log_columns + num_extra_log_columns
      end function adipls_how_many_extra_log_columns
      
      
      subroutine adipls_data_for_extra_log_columns(s, id, id_extra, n, names, vals, ierr)
         use run_star_extras, only: how_many_extra_log_columns, data_for_extra_log_columns
         type (star_info), pointer :: s
         integer, intent(in) :: id, id_extra, n
         character (len=maxlen_log_column_name) :: names(n)
         real(dp) :: vals(n)
         integer, intent(out) :: ierr
         integer :: i
         
         include 'formats.dek'
         
         ierr = 0
         call data_for_extra_log_columns(s, id, id_extra, n, names, vals, ierr)
         if (ierr /= 0) return
         if (just_call_my_extras_check_model) return
         
         i = how_many_extra_log_columns(s, id, id_extra)
         
         i = i+1
         names(i) = 'chi_square'
         vals(i) = chi_square
         
         i = i+1
         names(i) = 'avg_delta_nu_obs'
         vals(i) = avg_delta_nu_obs
         
         i = i+1
         names(i) = 'avg_delta_nu_model'
         vals(i) = avg_delta_nu_model
         
         i = i+1
         names(i) = 'correction_r'
         vals(i) = correction_r
         
         i = i+1
         names(i) = 'a_div_r'
         vals(i) = a_div_r
         
         if (i /= num_extra_log_columns) then
            write(*,2) 'i', i
            write(*,2) 'num_extra_log_columns', num_extra_log_columns
            stop 'bad num_extra_log_columns'
         end if
         
      end subroutine adipls_data_for_extra_log_columns

      
      integer function adipls_how_many_extra_profile_columns(s, id, id_extra)
         use run_star_extras, only: how_many_extra_profile_columns
         type (star_info), pointer :: s
         integer, intent(in) :: id, id_extra
         adipls_how_many_extra_profile_columns = &
            how_many_extra_profile_columns(s, id, id_extra)
      end function adipls_how_many_extra_profile_columns
      
      
      subroutine adipls_data_for_extra_profile_columns( &
            s, id, id_extra, n, nz, names, vals, ierr)
         use run_star_extras, only: data_for_extra_profile_columns
         type (star_info), pointer :: s
         integer, intent(in) :: id, id_extra, n, nz
         character (len=maxlen_profile_column_name) :: names(n)
         real(dp) :: vals(nz,n)
         integer, intent(out) :: ierr
         integer :: k
         ierr = 0
         call data_for_extra_profile_columns(s, id, id_extra, n, nz, names, vals, ierr)
      end subroutine adipls_data_for_extra_profile_columns

      
      subroutine adipls_extras_after_evolve(s, id, id_extra, ierr)
         use run_star_extras, only: extras_after_evolve
         type (star_info), pointer :: s
         integer, intent(in) :: id, id_extra
         integer, intent(out) :: ierr
         ierr = 0         
         call extras_after_evolve(s, id, id_extra, ierr)
      end subroutine adipls_extras_after_evolve
      
      
      ! routines for saving and restoring extra data so can do restarts
         
         ! put these defs at the top and delete from the following routines
         !integer, parameter :: extra_info_alloc = 1
         !integer, parameter :: extra_info_get = 2
         !integer, parameter :: extra_info_put = 3
      
      
      subroutine alloc_extra_info(s)
         integer, parameter :: extra_info_alloc = 1
         type (star_info), pointer :: s
         call move_extra_info(s,extra_info_alloc)
      end subroutine alloc_extra_info
      
      
      subroutine unpack_extra_info(s)
         integer, parameter :: extra_info_get = 2
         type (star_info), pointer :: s
         call move_extra_info(s,extra_info_get)
      end subroutine unpack_extra_info
      
      
      subroutine store_extra_info(s)
         integer, parameter :: extra_info_put = 3
         type (star_info), pointer :: s
         call move_extra_info(s,extra_info_put)
      end subroutine store_extra_info
      
      
      subroutine move_extra_info(s,op)
         integer, parameter :: extra_info_alloc = 1
         integer, parameter :: extra_info_get = 2
         integer, parameter :: extra_info_put = 3
         type (star_info), pointer :: s
         integer, intent(in) :: op
         
         integer :: i, j, num_ints, num_dbls, ierr
         
         i = 0
         ! call move_int or move_flg    
         num_ints = i
         
         i = 0
         ! call move_dbl       
         
         num_dbls = i
         
         if (op /= extra_info_alloc) return
         if (num_ints == 0 .and. num_dbls == 0) return
         
         ierr = 0
         call star_alloc_extras(s% id, num_ints, num_dbls, ierr)
         if (ierr /= 0) then
            write(*,*) 'failed in star_alloc_extras'
            write(*,*) 'alloc_extras num_ints', num_ints
            write(*,*) 'alloc_extras num_dbls', num_dbls
            stop 1
         end if
         
         contains
         
         subroutine move_dbl(dbl)
            real(dp) :: dbl
            i = i+1
            select case (op)
            case (extra_info_get)
               dbl = s% extra_work(i)
            case (extra_info_put)
               s% extra_work(i) = dbl
            end select
         end subroutine move_dbl
         
         subroutine move_int(int)
            integer :: int
            i = i+1
            select case (op)
            case (extra_info_get)
               int = s% extra_iwork(i)
            case (extra_info_put)
               s% extra_iwork(i) = int
            end select
         end subroutine move_int
         
         subroutine move_flg(flg)
            logical :: flg
            i = i+1
            select case (op)
            case (extra_info_get)
               flg = (s% extra_iwork(i) /= 0)
            case (extra_info_put)
               if (flg) then
                  s% extra_iwork(i) = 1
               else
                  s% extra_iwork(i) = 0
               end if
            end select
         end subroutine move_flg
      
      end subroutine move_extra_info





      end module extras_support
