! ***********************************************************************
!
!   Copyright (C) 2006, 2007  Bill Paxton
!
!   This file is part of MESA.
!
!   MESA is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Library Public License as published
!   by the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   MESA is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with this software; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
!
! ***********************************************************************

      module alert_lib ! library for dealing with runtime warnings and errors from the code

      ! edit the flags in the alert subroutine to control how it handles warnings and errors
      ! for interactive debuggers, this is a good place for a breakpoint
      
      ! follows the convention that info > 0 for warnings and < 0 for errors
      
      implicit none
      
      character (len=1000) :: alert_message = ''
      integer :: alert_info = 0

      contains
      
      subroutine alert(info, message)
         integer, intent(in) :: info
         character(*), intent(in) :: message
         logical, parameter :: stop_for_warnings = .false.         
         logical, parameter :: stop_for_errors = .false.
         alert_info = info
         if (info > 0) then
            write(alert_message,'(2a)') 'WARNING: ', trim(message)
            if (stop_for_warnings) then
               write(*,'(a)') 'alert message: ' // trim(alert_message)
               write(*,*) ' stopping because of alert'
               stop 1 ! error code
            end if
         end if
         if (info < 0) then
            write(*,'(2a)') 'ERROR: ', trim(message)
            write(alert_message,'(2a)') 'ERROR: ', trim(message)
            if (stop_for_errors) then
               write(*,'(a)') 'alert message: ' // trim(alert_message)
               write(*,*) ' stopping because of alert'
               stop 1 ! error code
            end if
         end if
      end subroutine alert
      
      
      subroutine bug_alert(stop_for_bugs, info, message)
         logical, intent(in) :: stop_for_bugs
         integer, intent(in) :: info
         character(*), intent(in) :: message
         if (stop_for_bugs) then
            write(*,'(a)') 'bug_alert message: ' // trim(message)
            stop 1 ! error code
         end if
         call alert(info,message)
      end subroutine bug_alert
      

      end module alert_lib

