#!/bin/csh
#  script to call  $aprgdir/adiajobs/set-dnl.d.x
if($#argv == 0) then
	$aprgdir/adiajobs/set-dnl.d.x
else if($#argv < 8) then
	echo "Usage: set-dnl.d <case> <input file> <output file> \\"
	echo "       <lmax> <n step> <l step> <scale> <ierr>"
	echo "<case>: type of modes used for input."
	echo "   case = 1: grand summary."
	echo "   case = 2: short summary."
	echo "   case = 3: observed frequencies."
	echo "   case = 4: grand summary, use (uncorrected) eigenfrequency"
	echo "   case = 5: grand summary, use Richardson extrapolated" \
			   "eigenfrequency"
	echo "<n step>: step in order (typically 1)"
	echo "<l step>: step in degree (typically 2)"
	echo "<scale>: determines scaling of difference"
	echo "   scale = 0: No scaling"
	echo "   scale = 1: scale by 3/(2*l+3)"
	echo "   scale = 2: scale by 2/(l+2)"
	echo "<ierr>: if 1, read data with errors" \
		      "(only for observed frequencies)"
	exit(1)
else
	(echo $1; echo $2; echo $3; echo $4; echo $5, $6; echo $7; echo $8) | \
	$aprgdir/adiajobs/set-dnl.d.x
endif
