#!/bin/csh
#  script to call  $aprgdir/adiajobs/mer-sum.d.x
#  with no arguments, prompts
#  otherwise calling sequence is
#   mersum <case> <file1> <file2> <output file> [<diagnostics>]

if($#argv == 0) then
	$aprgdir/adiajobs/mer-sum.d.x
	exit(0)
endif

if($#argv < 4) then
	echo "Usage: mer-sum.d <case> <file1> <file2> <output file> [<diag.>]"
	echo "<case>: type of modes used for input "
	echo "   case = 1: grand summary."
	echo "   case = 2: short summary."
	echo "   case = 3: observed frequencies, without errors."
	echo "   case = 4: observed frequencies, with errors."
	exit(1)
endif

if($#argv == 5) then
	set diag = $5
else
	set diag = 0
endif

(echo $1; echo $2; echo $3; echo $4; echo $diag, ",,,") | \
$aprgdir/adiajobs/mer-sum.d.x
