#!/bin/csh
#  script to call  $aprgdir/adiajobs/mer-amde.d.x
#  with no arguments, prompts
#  otherwise calling sequence is
#   mer-amde.d <case> <file1> <file2> <output file> [<diagnostics>]
#
#  case = 1: full eigenfunction file
#  case = 2: reduced eigenfunction file
#  case = 3: file of kernels for spherically symmetric rotation

if($#argv == 0) then
	$aprgdir/adiajobs/mer-amde.d.x
	exit(0)
endif

if($#argv == 1) then
	echo "calling sequence:"
	echo "mer-amde.d <case> <file1> <file2> <output file> [<diagnostics>]"
	echo "case = 1: full eigenfunction file"
	echo "case = 2: reduced eigenfunction file"
	echo "case = 3: file of kernels for spherically symmetric rotation"
	exit(1)
endif

if($#argv == 5) then
	set diag = $5
else
	set diag = 0
endif

(echo $1; echo $2; echo $3; echo $4; echo $diag, ",,,") | \
$aprgdir/adiajobs/mer-amde.d.x
