% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorize.R
\name{cs_crime}
\alias{cs_crime}
\title{Identify Crimes}
\usage{
cs_crime(.data, var, newVar, crime)
}
\arguments{
\item{.data}{A tibble or data frame}

\item{var}{Name of variable with 5 or 6 digit crime codes}

\item{newVar}{Name of output variable to be created with logical data}

\item{crime}{A string describing the crime type to be identified}
}
\value{
A cope of the object with a logical vector that is \code{TRUE} if the given crime matches
    the category given in the function.
}
\description{
\code{cs_crime} can be used to easily identify
    crimes based on a specific single UCR categories or common groupings. This can be used
    on any police department's data where codes like \code{31111} (robbery with a firearm)
    or \code{142320} (malicious destruction of property) are used to identify crimes.
}
\details{
The categories used here are derived from the U.S. Federal
    Bureau of Investigation's Uniform Crime Reporting codes. Valid inputs for the
    \code{crime} argument are as follows:

\describe{
    \item{\code{"violent"}}{Violent crimes (homicide, rape, aggravated assault, and
        robbery)}
    \item{\code{"property"}}{Property crimes (burglary, larceny, larceny of a motor
        vehicle, and arson)}
    \item{\code{"part 1"}}{All violent and property crimes}
    \item{\code{"homicide"}}{\code{"murder"} is also acceptable as input as is UCR
        code \code{1}}
    \item{\code{"rape"}}{\code{"forcible rape"} is also acceptable as input as is
        UCR code \code{2}}
    \item{\code{"robbery"}}{UCR code \code{3} is also acceptable input}
    \item{\code{"agg assualt"}}{\code{"aggravated assualt"} is also acceptable as
        input as is UCR code \code{4}}
    \item{\code{"burglary"}}{UCR code \code{5} is also acceptable input}
    \item{\code{"larceny-theft"}}{\code{"larceny"} and \code{"theft"} are also
        acceptable inputs as is UCR code \code{6}}
    \item{\code{"mv theft"}}{\code{"motor vehicle theft"}, \code{"motor vehicle
        larceny"}, and \code{"mv larceny"} are also acceptable inputs as input
        as is UCR code \code{7}}
    \item{\code{"arson"}}{UCR code \code{8} is also acceptable input}
    \item{\code{"part 2"}}{All other crimes}
    \item{\code{"assault"}}{\code{"other assaults"} is also acceptable input as
        is UCR code \code{9}}
    \item{\code{"forgery"}}{\code{"forgery and counterfeiting"} is also acceptable
        input as is UCR code \code{10}}
    \item{\code{"fraud"}}{UCR code \code{11} is also acceptable input}
    \item{\code{"embezzlement"}}{UCR code \code{12} is also acceptable input}
    \item{\code{"stolen prop"}}{\code{"stolen property"} is also acceptable input
        as is UCR code \code{13}}
    \item{\code{"vandalism"}}{UCR code \code{14} is also acceptable input}
    \item{\code{"weapons"}}{UCR code \code{15} is also acceptable input}
    \item{\code{"prostitution"}}{\code{"prostitution and commercialized vice"} is
        also acceptable input as is UCR code \code{16}}
    \item{\code{"sex offenses"}}{UCR code \code{17} is also acceptable input}
    \item{\code{"drugs"}}{\code{"drug abuse violations"} is also acceptable input
        as is UCR code \code{18}}
    \item{\code{"gambling"}}{UCR code \code{19} is also acceptable input}
    \item{\code{"family"}}{\code{"offenses against the family and children"} is
        also acceptable input as is UCR code \code{20}}
    \item{\code{"dwi"}}{\code{"driving under the influence"} is also acceptable
        input as is UCR code \code{21}}
    \item{\code{"liquor laws"}}{UCR code \code{22} is also acceptable input}
    \item{\code{"drunkenness"}}{UCR code \code{23} is also acceptable input}
    \item{\code{"discon"}}{\code{"disorderly conduct"} is also acceptable input
        as is UCR code \code{24}}
    \item{\code{"vagrancy"}}{UCR code \code{25} is also acceptable input}
    \item{\code{"other"}}{\code{"all other offenses"} is also acceptable input
        as is UCR code \code{26}}
    \item{\code{"suspicion"}}{UCR code \code{27} is also acceptable input}
    \item{\code{"curfew"}}{\code{"curfew and loitering laws-persons under 18"}
        is also acceptable input as is UCR code \code{28}}
    \item{\code{"runaway"}}{\code{"runaways-persons under 18"} is also acceptable
        input as is UCR code \code{29}}
}
}
\examples{
# load example data
testData <- january2018

# add logical vector for violent crimes
testData <- cs_crime(testData, var = Crime, newVar = violentCrimes, crime = "violent")

}
