import argparse


def add_arguments(parser: argparse.ArgumentParser):
    parser.add_argument('--prefix', type=str, default='')
    parser.add_argument('--restore', type=bool, default=False)
    parser.add_argument('--global_step', type=int, default=None)
    parser.add_argument('--epoch_i', type=int, default=1)
    parser.add_argument('--early_stop_init', type=float, default=0)
    parser.add_argument('--early_stop_option', type=str, default='loss')
    parser.add_argument('--optimizer', type=str, default='sgd')
    parser.add_argument('--train_type', type=str, default='pointer')
    parser.add_argument('--attention_option', type=str, default='bahdanau')
    parser.add_argument('--lr', type=float, default=0.0001)
    parser.add_argument('--batch_size', type=int, default=64)
    parser.add_argument('--init_op', type=str, default='glorot_uniform')

    parser.add_argument('--reverse', type=bool, default=False)

    parser.add_argument('--raw_data_path', type=str, default='')

    parser.add_argument('--source_vocab_rate', type=float, default=1.0)
    parser.add_argument('--target_vocab_rate', type=float, default=1.0)

    parser.add_argument('--bleu_script', type=str, default='')

parser = argparse.ArgumentParser()
add_arguments(parser)
SHELL_ARGS = parser.parse_args()
