import json
import os

import constants

from tensorflow.python.lib.io import file_io


def read_abs_file_to_string(absolute_filename):
    return file_io.read_file_to_string(absolute_filename)


def read_file_to_string(filename):
    absolute_filename = os.path.join(constants.ROOT_DIR, filename)
    return read_abs_file_to_string(absolute_filename)


def write_string_to_abs_file(absolute_filename, string, is_append=False):
    # file_io.write_string_to_file(absolute_filename, string)
    mode = 'a' if is_append else 'w'
    with open(absolute_filename, mode) as fout:
        fout.write(string)


def write_string_to_file(filename, string, is_append=False):
    absolute_filename = os.path.join(constants.ROOT_DIR, filename)
    return write_string_to_abs_file(absolute_filename, string, is_append)


def write_json_to_file(filename, json_item):
    str_item = json.dumps(json_item)
    write_string_to_file(filename, str_item)


def get_files_dirs_in_dir(dir_name):
    files = list()
    dirs = list()
    for item in os.listdir(dir_name):
        if os.path.isdir(os.path.join(dir_name, item)):
            dirs.append(item)
        else:
            files.append(item)

    return files, dirs
