import constants
from utils import file_utils
from utils.shell_args import SHELL_ARGS


def lower_data_set(read_prefix, write_prefix):
    train_source_seqs = file_utils.read_file_to_string(read_prefix + constants.SUFFIX_TRAIN_SOURCE)
    eval_source_seqs = file_utils.read_file_to_string(read_prefix + constants.SUFFIX_EVAL_SOURCE)
    test_source_seqs = file_utils.read_file_to_string(read_prefix + constants.SUFFIX_TEST_SOURCE)

    train_target_seqs = file_utils.read_file_to_string(read_prefix + constants.SUFFIX_TRAIN_TARGET)
    eval_target_seqs = file_utils.read_file_to_string(read_prefix + constants.SUFFIX_EVAL_TARGET)
    test_target_seqs = file_utils.read_file_to_string(read_prefix + constants.SUFFIX_TEST_TARGET)

    file_utils.write_string_to_file(write_prefix + constants.SUFFIX_TRAIN_SOURCE, train_source_seqs.lower())
    file_utils.write_string_to_file(write_prefix + constants.SUFFIX_EVAL_SOURCE, eval_source_seqs.lower())
    file_utils.write_string_to_file(write_prefix + constants.SUFFIX_TEST_SOURCE, test_source_seqs.lower())

    file_utils.write_string_to_file(write_prefix + constants.SUFFIX_TRAIN_TARGET, train_target_seqs.lower())
    file_utils.write_string_to_file(write_prefix + constants.SUFFIX_EVAL_TARGET, eval_target_seqs.lower())
    file_utils.write_string_to_file(write_prefix + constants.SUFFIX_TEST_TARGET, test_target_seqs.lower())


if __name__ == '__main__':
    lower_data_set(SHELL_ARGS.prefix, 'static/data/lower_new_data/lower_new_data')
