import os
import re

from utils import file_utils, word_utils


def get_commit_msg(commit_path):
    commit_msg_path = os.path.join(commit_path, 'commit_msg')
    commit_msg = file_utils.read_abs_file_to_string(commit_msg_path)

    commit_msg = re.sub(r'\s+', ' ', commit_msg)
    commit_msg_sentences = word_utils.split_sentence(commit_msg)
    if len(commit_msg_sentences) <= 0:
        return None
    commit_msg = commit_msg_sentences[0]
    commit_msg = ' '.join(word_utils.word_tokenizer(commit_msg))

    commit_msg = re.sub(r'\.$', '', commit_msg)
    commit_msg = re.sub(r'^\s+', '', commit_msg)

    return commit_msg
